/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.AccountMapType;
import kd.fi.ai.AccountMapTypeEntry;
import kd.fi.ai.AccountMapTypeFieldMapEntry;
import kd.fi.ai.AccountView;
import kd.fi.ai.TreeNodeInfo;
import kd.fi.ai.VchTplAcctFactorMap;
import kd.fi.ai.VchTplAccts;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.ai.enums.AccMapFuzzyMatchStrategyEnum;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.AccGetFromMappingExpHandel;
import kd.fi.ai.mservice.builder.getvaluehandle.AsstFactorHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.dao.BaseDataLoader;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;

public class AccountGetFromMapHandle
extends AbstractGetValueHandle<Object> {
    private VchTplAccts vchTempAccts;
    private Map<String, AbstractGetValueHandle<?>> asstFactorHandles = new HashMap();
    private List<AccGetFromMappingExpHandel> modes = new ArrayList<AccGetFromMappingExpHandel>(2);
    private static final Log log = LogFactory.getLog(AccountGetFromMapHandle.class);
    private boolean aiAutoCheck = false;
    private AccMapFuzzyMatchStrategyEnum strategy;
    private Set<String> skipLeafCheckBD;
    private Map<String, Long> baseDataMap = new HashMap<String, Long>();
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.accSys);
    private String info;

    public Map<String, AbstractGetValueHandle<?>> getAsstFactorHandles() {
        return this.asstFactorHandles;
    }

    public AccountGetFromMapHandle(ISingleTaskContext taskContext, VchTplAccts vchTempAccts) {
        super(taskContext);
        this.vchTempAccts = vchTempAccts;
        this.strategy = FahOptimizeControlPanel.getAccMapStrategy();
        this.skipLeafCheckBD = FahOptimizeControlPanel.getSkipLeafBD();
        this.preCompile();
    }

    public VchTplAccts getVchTempAccts() {
        return this.vchTempAccts;
    }

    @Override
    public void Compile() {
        StringBuilder desc = new StringBuilder();
        for (VchTplAcctFactorMap source : this.vchTempAccts.getFactorMaps()) {
            AbstractGetValueHandle factorHandle;
            if (source.isField() || StringUtils.isNotBlank((CharSequence)source.getSourceFieldKey())) {
                factorHandle = new AsstFactorHandle<Object>(this.taskContext, source.getSourceFieldKey(), null);
                this.asstFactorHandles.put(source.getFactor(), factorHandle);
                desc.append(source.getFactor());
                desc.append("+");
                if (source.getMapping() == 0L) continue;
                this.baseDataMap.put(source.getFactor(), source.getMapping());
                continue;
            }
            factorHandle = new AccGetFromMappingExpHandel(this.taskContext, source);
            this.asstFactorHandles.put(source.getFactor(), factorHandle);
            desc.append(source.getFactor());
            desc.append("+");
            if (source.getMapping() == 0L) continue;
            this.baseDataMap.put(source.getFactor(), source.getMapping());
        }
        this.description = String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u6620\u5c04\u53d6\u503c\u4e3a\uff1a\u201c%1$s\u201d", (String)"AccountGetFromMapHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]), desc.length() > 0 ? desc.substring(0, desc.length() - 1) : "");
        this.info = "\t | \t\t" + this.description + "\n";
        this.modes = this.asstFactorHandles.values().stream().filter(s -> s instanceof AccGetFromMappingExpHandel).map(e -> (AccGetFromMappingExpHandel)e).collect(Collectors.toList());
    }

    @Override
    public List<IVariableMode> getVars() {
        ArrayList<IVariableMode> vars = new ArrayList<IVariableMode>();
        for (AbstractGetValueHandle<?> factorHandle : this.asstFactorHandles.values()) {
            vars.addAll(factorHandle.getVars());
        }
        return vars;
    }

    @Override
    public Long GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        AccountView account;
        IBuildVchContext buildVchContext;
        Object acctId;
        Object factorPK;
        Tuple mdata;
        String fieldKey;
        StringBuilder infoJilu = new StringBuilder();
        boolean firstErrorInfo = true;
        Long qFilterId = BaseDataLoader.getBaseDataByMasterId((String)"ai_accountmaptype", (Long)this.vchTempAccts.getMappingid(), (long)this.taskContext.getBookInfo().getAcctOrgId());
        AccountMapType asstDimMap = BaseDataLoader.loadAccountmaptype((ISingleTaskContext)this.taskContext, (Long)qFilterId);
        List fieldmapentry = asstDimMap.getFieldMapEntrys();
        HashMap<String, String> fieldKeyMap = new HashMap<String, String>(16);
        HashMap<String, String> entityFieldMap = new HashMap<String, String>(16);
        HashMap<String, Long> assistIdMap = new HashMap<String, Long>(5);
        block0: for (AccountMapTypeFieldMapEntry fieldMap : fieldmapentry) {
            String entityid = fieldMap.getEntityid();
            for (VchTplAcctFactorMap source : this.vchTempAccts.getFactorMaps()) {
                if (!entityid.equals(source.getFactor())) continue;
                fieldKeyMap.put(entityid, fieldMap.getFieldkey());
                if ("0".equals(fieldMap.getDataType())) {
                    entityFieldMap.put(fieldMap.getFieldkey(), entityid);
                    continue block0;
                }
                entityFieldMap.put(fieldMap.getFieldkey(), "bos_assistantdata_detail");
                assistIdMap.put(fieldMap.getFieldkey(), Long.parseLong(entityid));
                continue block0;
            }
        }
        if (this.aiAutoCheck || this.taskContext.getShowInfo().booleanValue()) {
            infoJilu.append("\t | \t\t");
            infoJilu.append("prepare mappingid\uff1a");
            infoJilu.append(this.vchTempAccts.getMappingid());
            infoJilu.append("\n");
            infoJilu.append("\t | \t\t");
            infoJilu.append("query permission mappingid\uff1a");
            infoJilu.append(asstDimMap.getId());
            infoJilu.append("\n");
            infoJilu.append("\t | \t\t");
            infoJilu.append(String.format(ResManager.loadKDString((String)"\u79d1\u76ee\u5f71\u54cd\u56e0\u7d20\u6620\u5c04\u5173\u7cfb\uff1a%1$s \uff1b---entityFieldMap\uff1a%2$s\u3002", (String)"AccountGetFromMapHandle_2", (String)"fi-ai-mservice", (Object[])new Object[0]), fieldKeyMap, entityFieldMap));
            infoJilu.append("\n");
        }
        HashMap<String, Object> fieldKeyValue = new HashMap<String, Object>(this.asstFactorHandles.size());
        for (Map.Entry<String, AbstractGetValueHandle<?>> factorEntrySet : this.asstFactorHandles.entrySet()) {
            String factorKey = factorEntrySet.getKey();
            AbstractGetValueHandle<?> handle = factorEntrySet.getValue();
            Object factorValue = handle.GetVchFldValue(fldProperties, sourceRow, extRow);
            fieldKey = (String)fieldKeyMap.get(factorKey);
            if (this.aiAutoCheck || this.taskContext.getShowInfo().booleanValue()) {
                infoJilu.append("\t | \t\t");
                infoJilu.append(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u6620\u5c04\u5173\u7cfb\u7684\u5f71\u54cd\u56e0\u7d20\u503c\uff1a%1$s\uff1b%2$s\uff1b\u901a\u8fc7\u914d\u7f6e\u83b7\u53d6\u7684\u5c5e\u6027\u503c\u4e3a\uff1a%3$s\u3002", (String)"AccountGetFromMapHandle_3", (String)"fi-ai-mservice", (Object[])new Object[0]), factorKey, handle.description, factorValue)).append("\n");
                if (factorValue == null || StringUtils.isBlank(factorValue)) {
                    firstErrorInfo = false;
                    infoJilu.append("\t | \t\t");
                    infoJilu.append("\"!~!~!~!~!~!~!~!~!~!~!~");
                    infoJilu.append(handle.description);
                    infoJilu.append(ResManager.loadKDString((String)"\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u914d\u7f6e\u53d6\u6570\u9519\u8bef\u6216\u8005\u786e\u8ba4\u5355\u636e\u4e0a\u6b64\u5c5e\u6027\u662f\u5426\u5b58\u5728\u6570\u636e\u3002", (String)"AccountGetFromMapHandle_10", (String)"fi-ai-mservice", (Object[])new Object[0]));
                    infoJilu.append("!~!~!~!~!~!~!~!~!~!~!~!\"\n");
                }
            }
            if (this.baseDataMap.containsKey(factorKey)) {
                if (this.aiAutoCheck || this.taskContext.getShowInfo().booleanValue()) {
                    infoJilu.append("\t | \t\t");
                    infoJilu.append(factorKey);
                    infoJilu.append(String.format(ResManager.loadKDString((String)"\u9700\u8981\u91cd\u65b0\u6839\u636e\u6570\u636e\u6620\u5c04\u5173\u7cfb\u53d6\u6570\uff0c\u6570\u636e\u6620\u5c04\u5173\u7cfbid\u4e3a\uff1a%1$s\uff1b\u5f53\u524d\u5f71\u54cd\u56e0\u7d20\u7684\u6570\u636eid\u4e3a\uff1a%2$s\u3002", (String)"AccountGetFromMapHandle_5", (String)"fi-ai-mservice", (Object[])new Object[0]), this.baseDataMap.get(factorKey), factorValue)).append("\n");
                }
                factorValue = BaseDataLoader.loadBaseDataMappingData((IBuildVchContext)this.taskContext.getBuildVchContext(), (Long)this.baseDataMap.get(factorKey), factorValue);
                if (this.aiAutoCheck || this.taskContext.getShowInfo().booleanValue()) {
                    infoJilu.append("\t | \t\t");
                    infoJilu.append(String.format(ResManager.loadKDString((String)"\u91cd\u65b0\u6839\u636e\u6570\u636e\u6620\u5c04\u53d6\u6570\u7684\u7ed3\u679c\u4e3a\uff1a%1$s\uff1a%2$s\u3002", (String)"AccountGetFromMapHandle_7", (String)"fi-ai-mservice", (Object[])new Object[0]), factorKey, factorValue)).append("\n");
                    if (firstErrorInfo && (factorValue == null || StringUtils.isBlank(factorValue))) {
                        firstErrorInfo = false;
                        infoJilu.append("\t | \t\t");
                        infoJilu.append("\"!~!~!~!~!~!~!~!~!~!~!~");
                        infoJilu.append(ResManager.loadKDString((String)"\u6839\u636e\u914d\u7f6e\u7684\u6570\u636e\u6620\u5c04\u5173\u7cfb\u8fdb\u884c\u53d6\u6570\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u6570\u636e\u6620\u5c04\u5173\u7cfb\u914d\u7f6e\u662f\u5426\u5df2\u914d\u7f6e\u5bf9\u5e94\u7684\u6e90\u6570\u636e\u4e0e\u76ee\u6807\u6570\u636e\u7684\u6620\u5c04\u3002", (String)"AccountGetFromMapHandle_11", (String)"fi-ai-mservice", (Object[])new Object[0]));
                        infoJilu.append("!~!~!~!~!~!~!~!~!~!~!~!\"\n");
                    }
                }
            }
            Object originValue = factorValue == null ? Long.valueOf(0L) : factorValue;
            factorValue = BaseDataLoader.isV6015() ? BaseDataLoader.loadAcctItemMasterIDV6015((IBuildVchContext)this.taskContext.getBuildVchContext(), factorValue, (String)((String)entityFieldMap.get(fieldKey)), (long)this.taskContext.getBookInfo().getAcctOrgId(), (Long)((Long)assistIdMap.get(fieldKey))) : BaseDataLoader.loadAcctFactorMasterID((IBuildVchContext)this.taskContext.getBuildVchContext(), factorValue, (String)((String)entityFieldMap.get(fieldKey)), (long)this.taskContext.getBookInfo().getAcctOrgId(), (Long)((Long)assistIdMap.get(fieldKey)));
            if (null == factorValue) {
                factorValue = 0L;
            }
            if (Long.compare(0L, Long.parseLong(factorValue.toString())) == 0) {
                factorValue = originValue;
            }
            if (this.aiAutoCheck || this.taskContext.getShowInfo().booleanValue()) {
                infoJilu.append("\t | \t\t");
                infoJilu.append(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u7684\u6570\u636e\u8fdb\u884c\u8f6c\u6362\uff0c\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u6709\u6743\u9650\u7684\u6570\u636e\u7684masterid\uff1acurrOrgId\uff1a%1$s\uff1b---dataProp\uff1a%2$s\uff1b---NewMasterid\uff1a%3$s\u3002", (String)"AccountGetFromMapHandle_8", (String)"fi-ai-mservice", (Object[])new Object[0]), this.taskContext.getBookInfo().getAcctOrgId(), entityFieldMap.get(fieldKey), factorValue)).append("\n");
                if (firstErrorInfo && (factorValue == null || StringUtils.isBlank(factorValue))) {
                    infoJilu.append("\"!~!~!~!~!~!~!~!~!~!~!~");
                    infoJilu.append(ResManager.loadKDString((String)"\u901a\u8fc7\u914d\u7f6e\u83b7\u53d6\u5230\u7684\u6570\u636e\u8fdb\u884c\u6570\u636e\u91cd\u53d6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8be5\u6570\u636e\u662f\u5426\u662f\u5f53\u524d\u7ec4\u7ec7\u6709\u6743\u9650\u7684\u6570\u636e\uff0c\u6216\u8005\u8be5\u6570\u636e\u4e3a\u5176\u4ed6\u7ec4\u7ec7\u79c1\u6709\u6570\u636e\uff0c\u6216\u8005\u672a\u5206\u914d\u7ed9\u5f53\u524d\u7ec4\u7ec7\uff0c\u6216\u8005\u8be5\u6761\u6570\u636e\u4e0d\u5b58\u5728masterid\u3002", (String)"AccountGetFromMapHandle_12", (String)"fi-ai-mservice", (Object[])new Object[0]));
                    infoJilu.append("!~!~!~!~!~!~!~!~!~!~!~!\"\n");
                }
            }
            fieldKeyValue.put(fieldKey, factorValue);
        }
        if (this.aiAutoCheck || this.taskContext.getShowInfo().booleanValue()) {
            infoJilu.append("\t | \t\t");
            infoJilu.append(String.format(ResManager.loadKDString((String)"\u7ecf\u8fc7\u8f6c\u6362\u83b7\u53d6\u7684\u5f71\u54cd\u56e0\u7d20\u7ed3\u679c\uff1a%1$s\u3002", (String)"AccountGetFromMapHandle_9", (String)"fi-ai-mservice", (Object[])new Object[0]), fieldKeyValue));
            infoJilu.append("\n");
            infoJilu.append("\t | \t\t");
            infoJilu.append("\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\u00a8\n");
            this.info = this.info + infoJilu;
        }
        for (AccountMapTypeEntry entry : asstDimMap.getEntrys()) {
            boolean match = false;
            for (Map.Entry fieldEntrySet : fieldKeyValue.entrySet()) {
                fieldKey = (String)fieldEntrySet.getKey();
                mdata = (Tuple)entry.getMapData().get(fieldKey);
                if (mdata != null && (match = (factorPK = mdata.item1).equals(fieldEntrySet.getValue()))) continue;
                break;
            }
            if (!match || entry.getAccountid() == null || entry.getAccountid() == 0L) continue;
            acctId = entry.getAccountid();
            buildVchContext = this.taskContext.getBuildVchContext();
            account = BaseDataLoader.loadAccount((IBuildVchContext)buildVchContext, (Long)acctId);
            if (account.getAcctTableId() != this.taskContext.getBookInfo().getAccountTableId()) continue;
            if (this.aiAutoCheck || this.taskContext.getShowInfo().booleanValue()) {
                infoJilu.append("\n").append("\t | \t\t");
                infoJilu.append(String.format(ResManager.loadKDString((String)"\u7cbe\u786e\u5339\u914d\u7ed3\u679c\u4e3a\uff1a\u201c%1$s\u201d", (String)"AccountGetFromMapHandle_13", (String)"fi-ai-mservice", (Object[])new Object[0]), entry.getAccountid()));
                this.info = this.info + infoJilu;
            }
            return entry.getAccountid();
        }
        for (AccountMapTypeEntry entry : asstDimMap.getEntrys()) {
            boolean match = false;
            for (Map.Entry fieldEntrySet : fieldKeyValue.entrySet()) {
                fieldKey = (String)fieldEntrySet.getKey();
                mdata = (ThreeTuple)entry.getMapData().get(fieldKey);
                if (mdata == null) break;
                factorPK = mdata.item1;
                if (factorPK instanceof Long && ((Long)factorPK).compareTo(0L) == 0 || (match = factorPK.equals(fieldEntrySet.getValue()))) continue;
                Boolean isLeaf = (Boolean)mdata.item2;
                if (!(isLeaf.booleanValue() && !this.skipLeafCheckBD.contains(entityFieldMap.get(fieldKey)) || fieldKey.startsWith("asstfactor"))) {
                    match = this.matchParent(fieldKeyMap, fieldKey, fieldKeyValue, factorPK, (String)mdata.item3, assistIdMap);
                }
                if (match) continue;
                break;
            }
            if (!match || entry.getAccountid() == null || entry.getAccountid() == 0L) continue;
            acctId = entry.getAccountid();
            buildVchContext = this.taskContext.getBuildVchContext();
            account = BaseDataLoader.loadAccount((IBuildVchContext)buildVchContext, (Long)acctId);
            if (account.getAcctTableId() != this.taskContext.getBookInfo().getAccountTableId()) continue;
            if (this.aiAutoCheck || this.taskContext.getShowInfo().booleanValue()) {
                infoJilu.append("\n").append("\t | \t\t");
                infoJilu.append(String.format(ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d\u7ed3\u679c\u4e3a\uff1a\u201c%1$s\u201d", (String)"AccountGetFromMapHandle_14", (String)"fi-ai-mservice", (Object[])new Object[0]), entry.getAccountid()));
                this.info = this.info + infoJilu;
            }
            return entry.getAccountid();
        }
        if (null != asstDimMap.getDefaultAccount()) {
            if (this.aiAutoCheck || this.taskContext.getShowInfo().booleanValue()) {
                infoJilu.append("\n").append("\t | \t\t");
                infoJilu.append(String.format(ResManager.loadKDString((String)"\u9ed8\u8ba4\u79d1\u76ee\u4e3a\uff1a\u201c%1$s\u201d", (String)"AccountGetFromMapHandle_15", (String)"fi-ai-mservice", (Object[])new Object[0]), asstDimMap.getDefaultAccount()));
                this.info = this.info + infoJilu;
            }
            if (this.taskContext.getShowInfo().booleanValue()) {
                log.info(this.info);
            }
            return asstDimMap.getDefaultAccount();
        }
        return null;
    }

    private boolean matchParent(Map<String, String> fieldKeyMap, String fieldKey, Map<String, Object> fieldKeyValue, Object factorPK, String longNumber, Map<String, Long> assistIdMap) {
        for (Map.Entry<String, String> field : fieldKeyMap.entrySet()) {
            String entityKey;
            boolean containParent;
            if (!Objects.equals(fieldKey, field.getValue()) || !(containParent = BaseDataLoader.entityHasParent((ISingleTaskContext)this.taskContext, (String)(entityKey = field.getKey())))) continue;
            Long bizId = (Long)fieldKeyValue.get(fieldKey);
            if (bizId == null || bizId == 0L) {
                return false;
            }
            boolean containLongNumber = BaseDataLoader.entityHasLongNumber((ISingleTaskContext)this.taskContext, (String)entityKey);
            if (containLongNumber && AccMapFuzzyMatchStrategyEnum.LONG_NUMBER == this.strategy) {
                String subLongNumber = BaseDataLoader.loadAcctMapLongNumber((ISingleTaskContext)this.taskContext, (String)entityKey, (Long)bizId, (Long)assistIdMap.get(fieldKey));
                return subLongNumber.startsWith(longNumber);
            }
            if (!containLongNumber && AccMapFuzzyMatchStrategyEnum.LONG_NUMBER == this.strategy || AccMapFuzzyMatchStrategyEnum.TABLE_CACHE == this.strategy) {
                Map allData = BaseDataLoader.loadAllBaseDataTree((String)entityKey);
                if (allData != null) {
                    TreeNodeInfo bizNodeInfo = (TreeNodeInfo)allData.get(bizId);
                    HashSet<Long> parentIds = new HashSet<Long>();
                    this.loadParentIds(bizNodeInfo.getParentid(), allData, parentIds);
                    TreeNodeInfo facNodeInfo = (TreeNodeInfo)allData.get(factorPK);
                    if (!parentIds.contains(facNodeInfo.getMasterid())) continue;
                    return true;
                }
                HashSet allNodes = new HashSet(BaseDataLoader.loadBaseDataSubs((IBuildVchContext)this.taskContext.getBuildVchContext(), (String)entityKey, (Object)factorPK));
                if (allNodes.isEmpty() || !allNodes.contains(fieldKeyValue.get(fieldKey))) continue;
                return true;
            }
            HashSet allNodes = new HashSet(BaseDataLoader.loadBaseDataSubs((IBuildVchContext)this.taskContext.getBuildVchContext(), (String)entityKey, (Object)factorPK));
            if (allNodes.isEmpty() || !allNodes.contains(fieldKeyValue.get(fieldKey))) continue;
            return true;
        }
        return false;
    }

    private void loadParentIds(Long parentID, Map<Long, TreeNodeInfo> allData, Set<Long> parentIds) {
        if (parentID == 0L) {
            return;
        }
        TreeNodeInfo parentInfo = allData.get(parentID);
        parentIds.add(parentInfo.getMasterid());
        this.loadParentIds(parentInfo.getParentid(), allData, parentIds);
    }

    private boolean containParent(String entityKey) {
        Map treeEntityMap = this.taskContext.getTreeEntityMap();
        if (treeEntityMap.containsKey(entityKey)) {
            return (Boolean)treeEntityMap.get(entityKey);
        }
        Boolean isTree = this.isTreeEntity(entityKey);
        treeEntityMap.put(entityKey, isTree);
        return isTree;
    }

    private Boolean isTreeEntity(String entityKey) {
        Boolean contain = false;
        String dataCache = this.cache.get(entityKey + "_entityType");
        if (dataCache != null) {
            contain = Boolean.valueOf(dataCache);
        } else {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityKey);
            if (type.getAllFields().containsKey("parent")) {
                contain = StringUtils.isNotEmpty((CharSequence)type.getProperty("parent").getAlias());
            }
            this.cache.put(entityKey + "_entityType", contain + "");
        }
        return contain;
    }

    private void preCompile() {
        this.Compile();
    }

    public List<AccGetFromMappingExpHandel> getAccGetFromMappingExpHandel() {
        return this.modes;
    }

    public String getInfo() {
        return this.info;
    }

    public boolean isAiAutoCheck() {
        return this.aiAutoCheck;
    }

    public void setAiAutoCheck(boolean aiAutoCheck) {
        this.aiAutoCheck = aiAutoCheck;
    }

    public Map<String, Long> getBaseDataMap() {
        return this.baseDataMap;
    }
}

