/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.VchTplAgrs;
import kd.fi.ai.VchTplAgrss;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConditionMode;
import kd.fi.ai.mservice.builder.getvaluemode.ConstMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;

public class AsstStrDirectoryGetHandle
extends AbstractGetValueHandle<String> {
    private VchTplAgrss vchTplAgrss;
    private List<Tuple<IGetValueMode<Boolean>, String>> rules = new ArrayList<Tuple<IGetValueMode<Boolean>, String>>();
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private static Map<String, String> asstvalueCache = new HashMap<String, String>(4);

    public AsstStrDirectoryGetHandle(ISingleTaskContext taskContext, VchTplAgrss vchTplAgrss) {
        super(taskContext);
        this.vchTplAgrss = vchTplAgrss;
        this.preCompile();
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    @Override
    public void Compile() {
        StringBuilder sBuilder = new StringBuilder();
        int seq = 1;
        for (VchTplAgrs item : this.vchTplAgrss.getItems()) {
            String logMessage;
            IGetValueMode<Boolean> condition;
            String dcStr = item.getAsstName();
            if (item.getFilterSet().getFilterCondition() != null) {
                item.getFilterSet().setExpression(item.getFilterSet().buildFullFormula(this.taskContext.getSrcEntityType()));
                item.getFilterSet().setFilterCondition(null);
            }
            if (StringUtils.isBlank((CharSequence)item.getFilterSet().getExpression())) {
                condition = new ConstMode<Boolean>(true);
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u65e0\u6761\u4ef6\u53d6\u6838\u7b97\u7ef4\u5ea6\u503c{1}", (String)"AsstStrDirectoryGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, dcStr);
                sBuilder.append(logMessage).append("; ");
            } else {
                condition = new ConditionMode(this.taskContext, item.getFilterSet().getExpression());
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u53d6\u503c\u6761\u4ef6\uff1a{1}\uff0c\u6ee1\u8db3\u6761\u4ef6\u53d6\u6838\u7b97\u7ef4\u5ea6\u503c\uff1a{2}", (String)"AsstStrDirectoryGetHandle_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, item.getFilterSet().getExpression(), dcStr);
                sBuilder.append(logMessage).append("; ");
            }
            Tuple rule = new Tuple(condition, (Object)String.valueOf(item.getAsstid()));
            this.rules.add((Tuple<IGetValueMode<Boolean>, String>)rule);
            this.vars.addAll(condition.getVars());
            ++seq;
        }
        this.description = sBuilder.toString();
    }

    @Override
    public String GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        String asst = "";
        for (Tuple<IGetValueMode<Boolean>, String> ruleItem : this.rules) {
            if (!((Boolean)((IGetValueMode)ruleItem.item1).GetValue(fldProperties, sourceRow, extRow)).booleanValue()) continue;
            if (asstvalueCache.containsKey(ruleItem.item2)) {
                return asstvalueCache.get(ruleItem.item2);
            }
            asst = (String)ruleItem.item2;
            asstvalueCache.put(asst, asst);
            return asst;
        }
        return asst;
    }

    private void preCompile() {
        this.Compile();
    }
}

