/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.fi.ai.ComAssistData;
import kd.fi.ai.ComAssistResultDataCol;
import kd.fi.ai.CommonAssistItem;
import kd.fi.ai.VchComAssistEntryInfo;
import kd.fi.ai.VchTplComAssist;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.compiler.ComAssistCompiler;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class ComAssistHandle
extends AbstractGetValueHandle<ComAssistResultDataCol> {
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private VchTplComAssist vchTplComAssist;
    private Map<CommonAssistItem, ComAssistCompiler> comAssistCompilers = new HashMap<CommonAssistItem, ComAssistCompiler>();

    public ComAssistHandle(ISingleTaskContext taskContext, VchTplComAssist vchTplComAssist) {
        super(taskContext);
        this.vchTplComAssist = vchTplComAssist;
        this.preCompile();
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    @Override
    public void Compile() {
        List itemClassMaps = this.vchTplComAssist.getItemClassMaps();
        for (VchComAssistEntryInfo vcinfo : itemClassMaps) {
            CommonAssistItem comAssist = vcinfo.getComAssist();
            ComAssistCompiler comAssistCompiler = new ComAssistCompiler(this.taskContext, vcinfo);
            this.comAssistCompilers.put(comAssist, comAssistCompiler);
            comAssistCompiler.Compolier();
            this.vars.addAll(comAssistCompiler.getSelectedFields().values());
        }
    }

    @Override
    public ComAssistResultDataCol GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        ComAssistResultDataCol crd = new ComAssistResultDataCol();
        for (Map.Entry<CommonAssistItem, ComAssistCompiler> entrySet : this.comAssistCompilers.entrySet()) {
            CommonAssistItem assistItem = entrySet.getKey();
            ComAssistCompiler compiler = entrySet.getValue();
            Object result = compiler.getGetItemHandle().GetVchFldValue(fldProperties, sourceRow, extRow);
            if (StringUtils.isNotBlank(result)) {
                String baseEntityKey = assistItem.getValuesource().toString();
                DynamicProperty masteridProp = null;
                Long asstypeId = 0L;
                if (assistItem.getValuesourcetype().equals("2")) {
                    baseEntityKey = "bos_assistantdata_detail";
                    asstypeId = Long.parseLong(assistItem.getValuesource().toString());
                }
                if (baseEntityKey != null) {
                    MainEntityType entityType = this.taskContext.getBaseDateEntityTypeCache().computeIfAbsent(baseEntityKey, key -> EntityMetadataCache.getDataEntityType((String)key));
                    masteridProp = (DynamicProperty)ThreadCache.get((Object)(baseEntityKey + "masteridProperty"), () -> entityType.getProperty("masterid"));
                }
                if (result instanceof DynamicObject) {
                    result = Long.parseLong(((DynamicObject)result).getPkValue().toString());
                } else if (result instanceof String) {
                    result = Long.parseLong(result.toString());
                }
                if (masteridProp != null) {
                    try {
                        Object masterid = BaseDataLoader.loadAcctItemMasterID((IBuildVchContext)this.taskContext.getBuildVchContext(), result, (String)baseEntityKey, (long)this.taskContext.getBookInfo().getAcctOrgId(), (Long)asstypeId);
                        if (masterid instanceof Long && (Long)masterid != 0L || masterid instanceof String && StringUtils.isNotEmpty((CharSequence)((String)masterid))) {
                            result = masterid;
                        }
                        if (masterid == null || (Long)masterid == 0L) {
                            this.writeReportDetail(sourceRow.getLong("id"), VoucherCheckItem.AcctItem, VoucherErrLevel.Warning, baseEntityKey + ":" + result);
                            result = null;
                        }
                    }
                    catch (Exception e) {
                        this.writeReportDetail(sourceRow.getLong("id"), VoucherCheckItem.AcctItem, VoucherErrLevel.Warning, baseEntityKey + ":" + result);
                        result = null;
                    }
                }
            }
            ComAssistData cad = new ComAssistData(assistItem.getSeq(), assistItem.getValuesource().toString(), result);
            crd.getResult().add(cad);
        }
        return crd;
    }

    private void preCompile() {
        this.Compile();
    }

    public Map<CommonAssistItem, ComAssistCompiler> getComAssistCompilers() {
        return this.comAssistCompilers;
    }
}

