/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.VchTplDc;
import kd.fi.ai.VchTplDcs;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConditionMode;
import kd.fi.ai.mservice.builder.getvaluemode.ConstMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;

public class DCDirectoryGetHandle
extends AbstractGetValueHandle<Integer> {
    private VchTplDcs vchDcs;
    private List<Tuple<IGetValueMode<Boolean>, String>> rules = new ArrayList<Tuple<IGetValueMode<Boolean>, String>>();
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private static Map<String, Integer> dcvalueCache = new HashMap<String, Integer>(4);
    private List<IGetValueMode<Boolean>> modes = new ArrayList<IGetValueMode<Boolean>>(2);

    public DCDirectoryGetHandle(ISingleTaskContext taskContext, VchTplDcs vchDcs) {
        super(taskContext);
        this.vchDcs = vchDcs;
        this.preCompile();
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    private String getDcDesc(String dc) {
        String desc = ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u5411\u5f85\u5b9a", (String)"DCDirectoryGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dc)) {
            desc = ResManager.loadKDString((String)"\u501f\u8d37\u65b9\u5411\u5f85\u5b9a", (String)"DCDirectoryGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
        } else if (dc.equals("1")) {
            desc = ResManager.loadKDString((String)"\u501f\u5165", (String)"DCDirectoryGetHandle_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
        } else if (dc.equals("-1")) {
            desc = ResManager.loadKDString((String)"\u8d37\u51fa", (String)"DCDirectoryGetHandle_2", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        return desc;
    }

    @Override
    public void Compile() {
        StringBuilder sBuilder = new StringBuilder();
        int seq = 1;
        for (VchTplDc item : this.vchDcs.getItems()) {
            String logMessage;
            IGetValueMode<Boolean> condition;
            String dcStr = this.getDcDesc(item.getDc());
            if (item.getFilterSet().getFilterCondition() != null) {
                item.getFilterSet().setExpression(item.getFilterSet().buildFullFormula(this.taskContext.getSrcEntityType()));
                item.getFilterSet().setFilterCondition(null);
            }
            if (StringUtils.isBlank((CharSequence)item.getFilterSet().getExpression())) {
                condition = new ConstMode<Boolean>(true);
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u65e0\u6761\u4ef6\u53d6\u501f\u8d37\u65b9\u5411{1}", (String)"DCDirectoryGetHandle_3", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, dcStr);
                sBuilder.append(logMessage).append("; ");
            } else {
                condition = new ConditionMode(this.taskContext, item.getFilterSet().getExpression());
                logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u53d6\u503c\u6761\u4ef6\uff1a{1}\uff0c\u6ee1\u8db3\u6761\u4ef6\u53d6\u501f\u8d37\u65b9\u5411\uff1a{2}", (String)"DCDirectoryGetHandle_4", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, seq, item.getFilterSet().getExpression(), dcStr);
                sBuilder.append(logMessage).append("; ");
            }
            Tuple rule = new Tuple(condition, (Object)item.getDc());
            this.rules.add((Tuple<IGetValueMode<Boolean>, String>)rule);
            this.vars.addAll(condition.getVars());
            ++seq;
        }
        this.modes = this.rules.stream().map(t -> (IGetValueMode)t.item1).collect(Collectors.toList());
        this.description = sBuilder.toString();
    }

    @Override
    public Integer GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        Integer dc = 99;
        for (Tuple<IGetValueMode<Boolean>, String> ruleItem : this.rules) {
            if (!((Boolean)((IGetValueMode)ruleItem.item1).GetValue(fldProperties, sourceRow, extRow)).booleanValue()) continue;
            if (dcvalueCache.containsKey(ruleItem.item2)) {
                return dcvalueCache.get(ruleItem.item2);
            }
            dc = Integer.valueOf((String)ruleItem.item2);
            dcvalueCache.put((String)ruleItem.item2, dc);
            return dc;
        }
        return dc;
    }

    private void preCompile() {
        this.Compile();
    }

    public List<IGetValueMode<Boolean>> getConditionModes() {
        return this.modes;
    }
}

