/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConstMode;
import kd.fi.ai.mservice.builder.getvaluemode.FormulaMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;

public class FormulaGetHandle<T>
extends AbstractGetValueHandle<T> {
    protected String formula;
    protected T defValue;
    protected IGetValueMode<T> valueMode;

    public FormulaGetHandle(ISingleTaskContext taskContext, String formula, T defValue) {
        super(taskContext);
        this.formula = formula;
        this.defValue = defValue;
        this.preCompile();
    }

    public void matchFunction(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        if (this.valueMode instanceof FormulaMode) {
            FormulaMode formualModel = (FormulaMode)this.valueMode;
            formualModel.matchBatchFunction(fldProperties, sourceRow);
        }
    }

    public IGetValueMode<T> getValueMode() {
        return this.valueMode;
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.valueMode.getVars();
    }

    @Override
    public void Compile() {
        if (StringUtils.isBlank((CharSequence)this.formula)) {
            this.valueMode = new ConstMode<T>(this.defValue);
            this.description = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u8868\u8fbe\u5f0f", (String)"FormulaGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
        } else {
            this.valueMode = new FormulaMode(this.taskContext, this.formula);
            this.description = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u8868\u8fbe\u5f0f\u7684\u503c\u4e3a\uff1a%s", (String)"FormulaGetHandle_1", (String)"fi-ai-mservice", (Object[])new Object[0]), this.formula);
        }
    }

    @Override
    public T GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        T value = this.valueMode.GetValue(fldProperties, sourceRow, extRow);
        return value;
    }

    private void preCompile() {
        this.Compile();
    }

    public String getFormula() {
        return this.formula;
    }
}

