/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.DapLocalCache;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.CashFlowItem;
import kd.fi.ai.VchSupDataMapping;
import kd.fi.ai.VchTplCashflow;
import kd.fi.ai.VchTplSuppcfitem;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.FormulaGetHandle;
import kd.fi.ai.mservice.builder.getvaluehandle.VchFlexMappingGetHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConditionMode;
import kd.fi.ai.mservice.builder.getvaluemode.ConstMode;
import kd.fi.ai.mservice.builder.getvaluemode.FormulaMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class SuppcfitemGetHandle
extends FormulaGetHandle<Long> {
    private VchTplCashflow cashflowConfig;
    private List<Tuple<IGetValueMode<Boolean>, List<Long>>> rules = new ArrayList<Tuple<IGetValueMode<Boolean>, List<Long>>>();
    private List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private VchFlexMappingGetHandle flexMappingGetHandle;
    private Date bookDate;

    public SuppcfitemGetHandle(ISingleTaskContext taskContext, VchTplCashflow cashflowConfig) {
        super(taskContext, cashflowConfig.getSourcefield(), 0L);
        this.cashflowConfig = cashflowConfig;
        this.preCashflowCompile();
    }

    @Override
    public List<IVariableMode> getVars() {
        if (this.flexMappingGetHandle != null) {
            return this.flexMappingGetHandle.getVars();
        }
        return this.vars.isEmpty() ? super.getVars() : this.vars;
    }

    public void cashflowCompile() {
        if ("fix".equalsIgnoreCase(this.cashflowConfig.getSourcetype())) {
            List items = this.cashflowConfig.getVchFixSuppcfData();
            StringBuilder sBuilder = new StringBuilder();
            if (items.isEmpty()) {
                if (this.cashflowConfig.getSuppcfid() > 0L) {
                    this.valueMode = new ConstMode<Long>(this.cashflowConfig.getSuppcfid());
                }
                this.description = ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u53d6\u56fa\u5b9a\u503c", (String)"SuppcfitemGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
            } else {
                int seq = 1;
                for (VchTplSuppcfitem item : items) {
                    String logMessage;
                    IGetValueMode<Boolean> condition;
                    String dcStr = item.getSuppcfitemName();
                    if (item.getFilterSet().getFilterCondition() != null) {
                        item.getFilterSet().setExpression(item.getFilterSet().buildFullFormula(this.taskContext.getSrcEntityType()));
                        item.getFilterSet().setFilterCondition(null);
                    }
                    if (StringUtils.isBlank((CharSequence)item.getFilterSet().getExpression())) {
                        condition = new ConstMode<Boolean>(Boolean.TRUE);
                        logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u65e0\u6761\u4ef6\u53d6\u8865\u5145\u8d44\u6599{1}", (String)"SuppcfitemGetHandle_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
                        logMessage = MessageFormat.format(logMessage, seq, dcStr);
                        sBuilder.append(logMessage).append("; ");
                    } else {
                        condition = new ConditionMode(this.taskContext, item.getFilterSet().getExpression());
                        logMessage = ResManager.loadKDString((String)"\u7b2c{0}\u6761\u89c4\u5219\uff0c\u53d6\u503c\u6761\u4ef6\uff1a{1}\uff0c\u6ee1\u8db3\u6761\u4ef6\u53d6\u8865\u5145\u8d44\u6599\uff1a{2}", (String)"SuppcfitemGetHandle_2", (String)"fi-ai-mservice", (Object[])new Object[0]);
                        logMessage = MessageFormat.format(logMessage, seq, item.getFilterSet().getExpression(), dcStr);
                        sBuilder.append(logMessage).append("; ");
                    }
                    ArrayList<Long> list = new ArrayList<Long>();
                    list.add(item.getSuppcfitemId());
                    Tuple rule = new Tuple(condition, list);
                    this.rules.add((Tuple<IGetValueMode<Boolean>, List<Long>>)rule);
                    this.vars.addAll(condition.getVars());
                    ++seq;
                }
                this.description = sBuilder.toString();
            }
        } else if ("mapping".equalsIgnoreCase(this.cashflowConfig.getSourcetype())) {
            List vchsupDatas = this.cashflowConfig.getVchSupDataMapping();
            if (null != vchsupDatas && !vchsupDatas.isEmpty()) {
                StringBuilder builder = new StringBuilder("GetMappingBaseData('");
                int row = 0;
                for (VchSupDataMapping vchSupData : vchsupDatas) {
                    String currentBillId;
                    String factorEnKey = vchSupData.getFactorkey();
                    String string = currentBillId = vchSupData.isField() ? vchSupData.getFactorsource() + ".id" : vchSupData.getExpkey();
                    if (row < 1) {
                        builder.append(factorEnKey).append("',").append(currentBillId).append(",'','id','").append(this.cashflowConfig.getSupmappingid()).append("'");
                    } else {
                        builder.append(",'").append(factorEnKey).append("',").append(currentBillId);
                    }
                    ++row;
                }
                builder.append(")");
                this.valueMode = new FormulaMode(this.taskContext, builder.toString());
                this.description = String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u53d6\u6620\u5c04\u503c\uff1a%s", (String)"SuppcfitemGetHandle_3", (String)"fi-ai-mservice", (Object[])new Object[0]), this.formula);
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)this.cashflowConfig.getSupexp())) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("GetMappingBaseData(\"\", ").append(this.cashflowConfig.getSupexp()).append(", \"\", \"").append("id").append("\", \"").append(this.cashflowConfig.getSupmappingid()).append("\")");
                this.valueMode = new FormulaMode(this.taskContext, sBuilder.toString());
                this.description = String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u53d6\u6620\u5c04\u503c\uff1a%s", (String)"SuppcfitemGetHandle_3", (String)"fi-ai-mservice", (Object[])new Object[0]), this.formula);
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)this.cashflowConfig.getSupsourcefield())) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append("GetMappingBaseData(\"\", ").append(this.cashflowConfig.getSupsourcefield()).append(".id, \"\", \"").append("id").append("\", \"").append(this.cashflowConfig.getSupmappingid()).append("\")");
                this.valueMode = new FormulaMode(this.taskContext, sBuilder.toString());
                this.description = String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u53d6\u6620\u5c04\u503c\uff1a%s", (String)"SuppcfitemGetHandle_3", (String)"fi-ai-mservice", (Object[])new Object[0]), this.formula);
                return;
            }
            this.valueMode = new ConstMode<Long>(0L);
            this.description = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u73b0\u91d1\u6d41\u91cf\u6620\u5c04\u6765\u6e90", (String)"SuppcfitemGetHandle_4", (String)"fi-ai-mservice", (Object[])new Object[0]);
        } else if ("exp".equalsIgnoreCase(this.cashflowConfig.getSourcetype())) {
            this.valueMode = new FormulaMode(this.taskContext, this.cashflowConfig.getSupexp());
            this.description = String.format(ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u53d6\u6620\u5c04\u503c\uff1a%s", (String)"SuppcfitemGetHandle_3", (String)"fi-ai-mservice", (Object[])new Object[0]), this.cashflowConfig.getSupdescription());
        } else if (this.cashflowConfig.getFlexSupMappingid() != 0L) {
            this.flexMappingGetHandle = new VchFlexMappingGetHandle(this.taskContext, this.cashflowConfig.getSupFlexMapping(), this.cashflowConfig.getFlexSupMappingid(), VchFlexMappingGetHandle.FlexMappingType.SUPCASHFLOW);
        }
    }

    @Override
    public Long GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        long acctOrgID = this.taskContext.getBookInfo().getAcctOrgId();
        if ("mapping".equalsIgnoreCase(this.cashflowConfig.getSourcetype()) || "fix".equalsIgnoreCase(this.cashflowConfig.getSourcetype()) && this.cashflowConfig.getVchFixSuppcfData().isEmpty()) {
            Long cashflowitem = 0L;
            Object fldValue = super.GetVchFldValue(fldProperties, sourceRow, extRow);
            cashflowitem = fldValue == null || fldValue instanceof String && StringUtils.isBlank(fldValue) ? Long.valueOf(0L) : this.getVersionValueForID((Long)fldValue);
            return cashflowitem;
        }
        if ("fix".equalsIgnoreCase(this.cashflowConfig.getSourcetype()) && !this.cashflowConfig.getVchFixSuppcfData().isEmpty()) {
            for (Tuple<IGetValueMode<Boolean>, List<Long>> ruleItem : this.rules) {
                if (!((Boolean)((IGetValueMode)ruleItem.item1).GetValue(fldProperties, sourceRow, extRow)).booleanValue()) continue;
                return this.getValueForID((Long)((List)ruleItem.item2).get(0));
            }
            return 0L;
        }
        if ("exp".equalsIgnoreCase(this.cashflowConfig.getSourcetype())) {
            Object number = super.GetVchFldValue(fldProperties, sourceRow, extRow);
            long cashId = 0L;
            if (number != null) {
                CashFlowItem cfi;
                if (number instanceof Long) {
                    cashId = this.getVersionValueForID(Long.parseLong(number.toString()));
                }
                if (number instanceof String && StringUtils.isNotEmpty((CharSequence)number.toString()) && (cfi = BaseDataLoader.loadCashFlowItemByNumAndOrg((IBuildVchContext)this.taskContext.getBuildVchContext(), (String)String.valueOf(number), (Long)acctOrgID)) != null && cfi.isSupItem()) {
                    cashId = cfi.getId();
                }
            }
            return cashId;
        }
        if (this.cashflowConfig.getFlexSupMappingid() != 0L) {
            Long cfId = 0L;
            Object getVchFldValue = this.flexMappingGetHandle.GetVchFldValue(fldProperties, sourceRow, extRow, this.bookDate);
            if (getVchFldValue != null) {
                cfId = this.getVersionValueForID(Long.parseLong(getVchFldValue.toString()));
            }
            return cfId;
        }
        return 0L;
    }

    public Long GetVchSuppCFValue() {
        if (this.cashflowConfig.getSuppcfitemid() != 0L) {
            this.getValueForID(this.cashflowConfig.getSuppcfitemid());
        }
        return this.cashflowConfig.getSuppcfitemid();
    }

    private Long getValueForID(long cashitemId) {
        DynamicObject cashitem;
        if (cashitemId == 0L) {
            return 0L;
        }
        long acctOrgID = this.taskContext.getBookInfo().getAcctOrgId();
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_BASEDATAFILED, (Object[])new Object[]{"CfItemNumberCache", cashitemId});
        String cfNum = (String)DapLocalCache.get((LocalCacheKey)cacheKey, String.class);
        if (StringUtils.isBlank((CharSequence)cfNum) && cashitemId != 0L && (cashitem = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_cashflowitem", (String)"number", (QFilter[])new QFilter("id", "=", (Object)cashitemId).toArray())) != null) {
            cfNum = cashitem.getString("number");
            DapLocalCache.put((LocalCacheKey)cacheKey, (Object)cfNum);
        }
        CashFlowItem cfi = null;
        if (cfNum != null) {
            cfi = BaseDataLoader.loadCashFlowItemByNumAndOrg((IBuildVchContext)this.taskContext.getBuildVchContext(), (String)cfNum, (Long)acctOrgID);
        }
        return cfi != null && cfi.isSupItem() ? cfi.getId() : Long.valueOf(0L);
    }

    private Long getVersionValueForID(long cashItemId) {
        if (cashItemId == 0L) {
            return 0L;
        }
        CashFlowItem cfi = BaseDataLoader.loadVersionCashFlowItemById((IBuildVchContext)this.taskContext.getBuildVchContext(), (long)cashItemId);
        return cfi != null && cfi.isSupItem() ? cfi.getId() : 0L;
    }

    private void preCashflowCompile() {
        this.cashflowCompile();
    }

    public void setBookDate(Date bookDate) {
        this.bookDate = bookDate;
    }
}

