/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluehandle;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchFormulaFilterset;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.getvaluehandle.VchFormulaConditionGetValueHandle;
import kd.fi.ai.mservice.builder.getvaluemode.ConstMode;
import kd.fi.ai.mservice.builder.getvaluemode.FormulaMode;
import kd.fi.ai.mservice.builder.getvaluemode.IGetValueMode;

public class VchExpireDateGetHandle
extends VchFormulaConditionGetValueHandle<Date> {
    private VchExpireDate expireDate;
    protected IGetValueMode<Date> valueMode;

    public VchExpireDateGetHandle(ISingleTaskContext taskContext, VchExpireDate expireDate) {
        super(taskContext, (VchFormulaFilterset)expireDate);
        this.expireDate = expireDate;
        this.expireDateCompile();
    }

    private void expireDateCompile() {
        if ("fix".equalsIgnoreCase(this.expireDate.getSourcetype()) && this.expireDate.getConstDate() != null && StringUtils.isEmpty((CharSequence)this.expireDate.getExp())) {
            this.valueMode = new ConstMode<Date>(this.expireDate.getConstDate());
            this.description = ResManager.loadKDString((String)"\u53d6\u503c\u65b9\u5f0f\u4e3a\u56fa\u5b9a\u503c", (String)"VchExpireDateGetHandle_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
        } else if (this.expireDate.ifNewDate()) {
            Date now = VchExpireDate.getNowByUserTimeZone();
            this.valueMode = new ConstMode<Date>(now);
            this.description = VchExpireDate.newDateAlias();
        } else if (this.expireDate.ifLastDate()) {
            this.valueMode = new ConstMode<Date>(this.taskContext.getBookInfo().getCurrentPeriodEndDate());
            this.description = VchExpireDate.lastDateAlias();
        } else if ("exp".equalsIgnoreCase(this.expireDate.getSourcetype()) && StringUtils.isNotBlank((CharSequence)this.expireDate.getExp())) {
            this.valueMode = new FormulaMode<Date>(this.taskContext, this.expireDate.getExp());
            this.description = String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u53d6\u503c\u4e3a\uff1a\u201c%s\u201d", (String)"VchExpireDateGetHandle_1", (String)"fi-ai-mservice", (Object[])new Object[0]), this.expireDate.getDateName());
        }
        if (this.valueMode != null) {
            this.getVars().addAll(this.valueMode.getVars());
        }
    }

    @Override
    public Date GetVchFldValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        Date obj = null;
        if (this.valueMode != null) {
            obj = this.valueMode.GetValue(fldProperties, sourceRow, extRow);
        }
        if (obj == null) {
            obj = super.GetVchFldValue(fldProperties, sourceRow, extRow);
        }
        SimpleDateFormat sdf = (SimpleDateFormat)ThreadCache.get((Object)"SimpleDateFormat-yyyy-MM-dd", () -> new SimpleDateFormat("yyyy-MM-dd"));
        Date date = null;
        if (obj instanceof String) {
            try {
                date = sdf.parse(obj + "");
            }
            catch (ParseException e) {
                throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
            }
        } else {
            date = obj instanceof Date ? obj : (Date)super.GetVchFldValue(fldProperties, sourceRow, extRow);
        }
        if (date != null) {
            try {
                date = sdf.parse(sdf.format(date));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return date;
    }
}

