/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.getvaluemode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BatchFuncParser;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FunCall;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.function.Function;
import kd.fi.ai.mservice.builder.getvaluemode.FormulaMode;
import kd.fi.ai.mservice.builder.getvaluemode.FormulaVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.mservice.builder.getvaluemode.Token;

public class DynamicTextMode
extends FormulaMode<String> {
    public DynamicTextMode(ISingleTaskContext taskContext, String dynamicText) {
        super(taskContext, dynamicText);
    }

    @Override
    public String GetValue(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.vars.size());
        for (IVariableMode var : this.vars) {
            SourceBillFieldMode varMode;
            IDataEntityProperty prop;
            Object value = this.GetSingleFieldValue(fldProperties, sourceRow, extRow, var);
            if (value != null && var instanceof SourceBillFieldMode && (prop = (varMode = (SourceBillFieldMode)var).getSourceField()) instanceof ComboProp && !(prop instanceof ItemClassTypeProp)) {
                ComboProp comboProp = (ComboProp)prop;
                value = comboProp.getItemByName(value.toString());
            }
            ctx.put(var.getVar(), value);
        }
        String value = this.parse(ctx);
        return value;
    }

    protected Map<String, Object> getVarValues(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.vars.size());
        for (IVariableMode var : this.vars) {
            ctx.put(var.getVar(), this.GetSingleFieldValue(fldProperties, sourceRow, extRow, var));
        }
        return ctx;
    }

    @Override
    protected void CompileFormula(String formula) {
        this.formula = formula;
        String[] varStrings = this.extractVariables();
        MainEntityType mainEntityType = this.taskContext.getSrcEntityType();
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            for (int i = 0; i < keyItems.length; ++i) {
                if (keyItems[i] == null) continue;
                keyItems[i] = keyItems[i].trim();
            }
            IVariableMode var = this.buildVarMode(mainEntityType, varString.trim(), keyItems);
            this.vars.add(var);
            if (!(var instanceof FormulaVariableMode)) continue;
            FormulaVariableMode fv = (FormulaVariableMode)var;
            this.vars.addAll(fv.getMode().getVars());
        }
    }

    private String toFormula(String formula, Map<String, Object> varValues) {
        String[] varStrings;
        for (String varStr : varStrings = this.extractVariableFromCache(formula)) {
            Object val;
            Function fun;
            Expr expr;
            if (StringUtils.isBlank((CharSequence)varStr) || !((expr = this.parseFormula(varStr)) instanceof FunCall)) continue;
            FunCall fc = (FunCall)expr;
            if (Function.isBatchFunction((String)fc.getName())) {
                fun = this.toFunction(fc, varValues, true);
                if (fun == null || fun.isHasInnerFunction()) continue;
                val = this.taskContext.getBatchFunValues().get(fun);
                formula = formula.replace("{" + varStr + "}", val == null ? "" : val.toString());
                continue;
            }
            if (!Function.isBosBatchFunction((String)fc.getName())) continue;
            fun = this.toBatchFuncRunParam(fc, varValues);
            if (!this.taskContext.getBosBatchFunValues().containsKey(fun)) continue;
            val = this.taskContext.getBosBatchFunValues().get(fun);
            formula = formula.replace("{" + varStr + "}", val == null ? "" : val.toString());
        }
        return formula;
    }

    private String[] extractVariableFromCache(String formula) {
        return (String[])ThreadCache.get((Object)("FormulaVarStrings:" + formula), () -> this.extractVariables());
    }

    @Override
    public void matchBatchFunction(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        if (this.formula.indexOf("(") == -1) {
            return;
        }
        this.expContext.setActiveRow(sourceRow);
        this.expContext.setFldProperties(fldProperties);
        this.taskContext.addBatchFunVars(this.getFunctions());
        this.getBosFunctions(new BatchFuncParser());
    }

    private Set<Function> getFunctions() {
        String[] varStrings = this.extractVariableFromCache(this.formula);
        Map<String, Object> varValues = this.getVarValues(this.expContext);
        HashSet<Function> funSet = new HashSet<Function>(varValues.size());
        for (String varStr : varStrings) {
            Expr expr;
            if (StringUtils.isBlank((CharSequence)varStr) || !((expr = this.parseFormula(varStr)) instanceof FunCall)) continue;
            funSet.addAll(this.getFunctions(expr, varValues));
        }
        return funSet;
    }

    private Set<BatchFuncRunParam> getBosFunctions(BatchFuncParser batchFuncParser) {
        String[] varStrings = this.extractVariableFromCache(this.formula);
        Map<String, Object> varValues = this.getVarValues(this.expContext);
        HashSet<BatchFuncRunParam> funSet = new HashSet<BatchFuncRunParam>(varValues.size());
        for (String varStr : varStrings) {
            if (StringUtils.isBlank((CharSequence)varStr)) continue;
            Expr expr = this.parseFormula(varStr);
            BOSExpression expression = (BOSExpression)ThreadCache.get((Object)("BOSExpression" + varStr), () -> new BOSExpression(varStr));
            if (!(expr instanceof FunCall)) continue;
            this.taskContext.addBosBatchFunVars(batchFuncParser.preCall(expression, (ExpressionContext)this.expContext, this.funcLib));
        }
        return funSet;
    }

    private String[] extractVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        int len = this.formula.length();
        Token token = Token.Text;
        for (int pos = 0; pos < len; ++pos) {
            char c = this.formula.charAt(pos);
            switch (c) {
                case '{': {
                    boolean condition = pos + 1 < len && this.formula.charAt(pos + 1) == '{';
                    Token token2 = token = condition ? Token.Escape : Token.Variable;
                }
            }
            if (token != Token.Variable) continue;
            int endIndex = this.formula.indexOf(125, pos + 1);
            if (endIndex == -1) break;
            String variableName = this.formula.substring(pos + 1, endIndex);
            variables.add(variableName);
            pos = endIndex;
            token = Token.Text;
        }
        return variables.toArray(new String[variables.size()]);
    }

    private String parse(Map<String, Object> ctx) {
        String formula = this.toFormula(this.formula, ctx);
        int len = formula.length();
        StringBuilder sb = new StringBuilder(len + len / 2);
        Token token = Token.Text;
        for (int pos = 0; pos < len; ++pos) {
            char c = formula.charAt(pos);
            switch (c) {
                case '{': {
                    boolean condition = pos + 1 < len && formula.charAt(pos + 1) == '{';
                    Token token2 = token = condition ? Token.Escape : Token.Variable;
                }
            }
            if (token == Token.Text) {
                sb.append(formula.charAt(pos));
                continue;
            }
            if (token == Token.Escape) {
                sb.append('{');
                token = Token.Text;
                ++pos;
                continue;
            }
            if (token != Token.Variable) continue;
            int endIndex = formula.indexOf(125, pos + 1);
            if (endIndex == -1) {
                sb.append(formula.substring(pos));
                break;
            }
            String variableName = formula.substring(pos + 1, endIndex);
            if (ctx.containsKey(variableName)) {
                Object variableValue = ctx.get(variableName);
                String sValue = this.FormatValue(variableValue);
                sb.append(sValue);
            } else if (StringUtils.isNotBlank((CharSequence)variableName)) {
                sb.append('{').append(variableName).append(']');
            }
            pos = endIndex;
            token = Token.Text;
        }
        return sb.toString();
    }

    private String FormatValue(Object variableValue) {
        String sValue;
        if (variableValue == null) {
            return "";
        }
        if (variableValue instanceof BigDecimal) {
            BigDecimal dValue = new BigDecimal(variableValue.toString());
            sValue = dValue.toString();
        } else {
            sValue = variableValue.toString();
        }
        return sValue;
    }
}

