/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.plugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.fa.business.util.FiBillParamUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.builder.plugin.AbstractBuildVchPlugin;
import kd.fi.ai.builder.plugin.events.BuildBillFilterEventArgs;
import kd.fi.ai.builder.plugin.events.ValidateVoucherEventArgs;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;

public abstract class AbstractFaBillBVPlugin
extends AbstractBuildVchPlugin {
    public static final String CLOUD_ID_FIN = "83bfebc8000002ac";
    public static final String APP_ID_FA = "83bfebc800001aac";
    public static final String PARAM_KEY_CURPERIOD_SPLIT = "split.currentperiod.enable";

    public void validataVoucher(ValidateVoucherEventArgs e) {
        BizVoucher bizVoucher = e.getBizVoucher();
        List entries = bizVoucher.getEntryRows();
        HashMap<String, BigDecimal> entryTemp = new HashMap<String, BigDecimal>(entries.size());
        for (Object entry : entries) {
            long accountId = entry.getAccountId();
            String key = accountId + "-" + entry.getAssgrpId();
            int dcDirectory = entry.getDcDirectory();
            BigDecimal localAmount = entry.getLocalAmount();
            if (localAmount == null) continue;
            localAmount = localAmount.multiply(new BigDecimal(dcDirectory));
            BigDecimal amount = (BigDecimal)entryTemp.get(key);
            amount = amount == null ? localAmount : amount.add(localAmount);
            entryTemp.put(key, amount);
        }
        boolean needVoucher = false;
        for (BigDecimal amount : entryTemp.values()) {
            if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
            needVoucher = true;
            break;
        }
        if (!needVoucher) {
            e.setValid(false);
            e.setErrorMsg(this.getErrorMsg());
            e.setErrorLevel(VoucherErrLevel.Error);
            String billNumber = bizVoucher.getSourceBill();
            long billId = bizVoucher.getSourceBillId();
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)billNumber, (String)"voucherflag", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
            if (bills != null && bills.length == 1) {
                bills[0].set("voucherflag", (Object)"A");
                SaveServiceHelper.save((DynamicObject[])bills);
            }
        }
    }

    public void BuildBillFilter(BuildBillFilterEventArgs e) {
        String entityNumber = e.getTplContext().getSourceBill().getEntityNumber();
        List plugFilters = e.getPlugFilters();
        boolean finHasOriginalData = FiBillParamUtil.getBooleanValue((String)CLOUD_ID_FIN, (String)APP_ID_FA, (String)PARAM_KEY_CURPERIOD_SPLIT, null);
        if ("fa_card_fin".equalsIgnoreCase(entityNumber)) {
            if (finHasOriginalData) {
                plugFilters.add(new QFilter("originaldata", "=", (Object)true));
            } else {
                plugFilters.add(QFilter.of((String)"endperiod.id = 99999999999", (Object[])new Object[0]));
            }
        }
    }

    abstract String getErrorMsg();
}

