/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singlebillaction;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.ComAssistResultDataCol;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.dap.DapConfig;
import kd.fi.ai.mservice.builder.buildresult.BizVchEntryGroupKey;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.BizVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.compiler.SelectedCustEntity;
import kd.fi.ai.mservice.builder.compiler.SelectedSourceEntity;
import kd.fi.ai.mservice.builder.compiler.SetValueHelper;
import kd.fi.ai.mservice.builder.compiler.TplEntryCompiler;
import kd.fi.ai.mservice.builder.compiler.TplGroupCompiler;
import kd.fi.ai.mservice.builder.singlebillaction.AbstractSingleBillAction;

public class BuildVoucherEntry
extends AbstractSingleBillAction {
    private static Log logger = LogFactory.getLog(BuildVoucherEntry.class);

    public BuildVoucherEntry(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6784\u5efa\u4e1a\u52a1\u51ed\u8bc1\u5206\u5f55", (String)"BuildVoucherEntry_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        TplGroupCompiler tplGroupCompiler = this.billResult.getTplGroupCompiler();
        if (this.taskContext.getShowInfo().booleanValue()) {
            logger.info("--DAP--\u7f16\u8bd1\u6a21\u677f\u7684\u884c\u6570\uff1a{}", (Object)tplGroupCompiler.getTplEntryCompilers().size());
        }
        int errorsize = 0;
        for (TplEntryCompiler tplEntryCompiler : tplGroupCompiler.getTplEntryCompilers()) {
            if (tplEntryCompiler.isCompileError()) {
                ++errorsize;
                continue;
            }
            boolean continueGenerate = true;
            continueGenerate = this.DoOneVchEntry(tplEntryCompiler);
            if (continueGenerate) continue;
            break;
        }
        if (this.taskContext.getShowInfo().booleanValue()) {
            logger.info("--DAP--\u7f16\u8bd1\u6a21\u677f\u9519\u8bef\u7684\u884c\u6570\uff1a{}", (Object)errorsize);
        }
    }

    private boolean DoOneVchEntry(TplEntryCompiler tplEntryCompiler) {
        int seq;
        if (!tplEntryCompiler.getVchTempEntry().getIsuse().booleanValue()) {
            return true;
        }
        if (tplEntryCompiler.getSelectedSourceEntity() == null) {
            return false;
        }
        String entityName = tplEntryCompiler.getSourceEntityKey(tplEntryCompiler, this.taskResult.getTplCompiler().getVchTemplate());
        SelectedSourceEntity selectedEntity = this.billResult.getTaskResult().getSelectedEntities().get(entityName);
        if (selectedEntity == null) {
            return true;
        }
        SelectedCustEntity custEntity = null;
        if (tplEntryCompiler.getSelectedCustEntity() != null) {
            custEntity = selectedEntity.getSelectedCustEntities().get(tplEntryCompiler.getSelectedCustEntity().getEntityKey());
        }
        List<Object> sourceRows = new ArrayList(16);
        if (!"null".equals(tplEntryCompiler.getBillName()) && StringUtils.isNotEmpty((CharSequence)tplEntryCompiler.getBillName()) && !Objects.equals(this.taskContext.getSrcEntityType().getName(), tplEntryCompiler.getBillName())) {
            List<Long> list = this.taskResult.getSecondBillId().get(this.billContext.getSrcBillId());
            if (list != null && !list.isEmpty()) {
                for (Long id : list) {
                    if (selectedEntity.getSourceRows().get(id) == null) continue;
                    sourceRows.addAll((Collection<Object>)selectedEntity.getSourceRows().get(id));
                }
            }
        } else {
            sourceRows = selectedEntity.getSourceRows().get(this.billContext.getSrcBillId());
        }
        if (sourceRows == null || sourceRows.size() == 0) {
            if (this.taskContext.getShowInfo().booleanValue()) {
                logger.info("--DAP--\u5f53\u524d\u51ed\u8bc1\u6a21\u677f\u5206\u5f55\uff0c\u65e0\u76f8\u5173\u6e90\u5355\u6570\u636e\u884c\uff0c\u7565\u8fc7");
            }
            String logMessage = ResManager.loadKDString((String)"\u5f53\u524d\u51ed\u8bc1\u6a21\u677f\u5206\u5f55\uff0c\u65e0\u76f8\u5173\u6e90\u5355\u6570\u636e\u884c\uff0c\u7565\u8fc7", (String)"BuildVoucherEntry_4", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.WriteInfoLog(logMessage);
            return true;
        }
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>();
        fldProperties.putAll(selectedEntity.getFldProperties());
        ArrayList<BizVoucherEntry> entryRows = new ArrayList<BizVoucherEntry>();
        String mainEntityName = this.taskContext.getSrcEntityType().getExtendName();
        boolean isEvent = this.taskContext.getTemplate().isEvent();
        String entityname = selectedEntity.getEntityType().getName();
        HashSet<String> set = new HashSet<String>();
        if (custEntity == null) {
            seq = 0;
            int index = 0;
            for (DynamicObject dynamicObject : sourceRows) {
                if (!isEvent) {
                    BizVoucherEntry entryRow;
                    String entryId = "";
                    entryId = !mainEntityName.equals(entityname) ? selectedEntity.getEntryPKProperty().getValueFast((Object)dynamicObject) + "" : dynamicObject.getString("id");
                    if (set.contains(entryId) || (entryRow = this.CreateEntryRow(tplEntryCompiler, fldProperties, dynamicObject, null, seq, entryId)) == null) continue;
                    entryRows.add(entryRow);
                    ++seq;
                    set.add(entryRow.getUniqueKey());
                    continue;
                }
                BizVoucherEntry entryRow = this.CreateEntryRow(tplEntryCompiler, fldProperties, dynamicObject, null, seq, dynamicObject.get("id").toString() + entityname + index);
                if (entryRow != null) {
                    entryRows.add(entryRow);
                    ++seq;
                }
                ++index;
            }
        } else {
            fldProperties.putAll(custEntity.getFldProperties());
            seq = 0;
            for (DynamicObject dynamicObject : sourceRows) {
                String string = (String)selectedEntity.getEntryPKProperty().getValueFast((Object)dynamicObject);
                List<DynamicObject> extRows = custEntity.getSourceRows().get(string);
                for (DynamicObject extRow : extRows) {
                    BizVoucherEntry entryRow = this.CreateEntryRow(tplEntryCompiler, fldProperties, dynamicObject, extRow, seq, string);
                    if (entryRow == null) continue;
                    entryRows.add(entryRow);
                    ++seq;
                }
            }
        }
        ArrayList<BizVoucherEntry> afterGroupRows = new ArrayList<BizVoucherEntry>();
        afterGroupRows.addAll(entryRows);
        this.billResult.getNewBizVoucher().getEntryRows().addAll(afterGroupRows);
        return true;
    }

    private BizVoucherEntry CreateEntryRow(TplEntryCompiler tplEntryCompiler, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, DynamicObject extRow, int seq, String entryId) {
        boolean delaybuildevent;
        if (!((Boolean)tplEntryCompiler.getCheckFilterHandle().GetVchFldValue((Map)fldProperties, sourceRow, extRow)).booleanValue()) {
            return null;
        }
        SetValueHelper setValueHelper = this.billResult.getTaskResult().getSetValueHelper();
        TplGroupCompiler tplGroupCompiler = this.billResult.getTplGroupCompiler();
        BizVoucher voucherHeader = this.billResult.getNewBizVoucher();
        BizVoucherEntry voucherEntryRow = new BizVoucherEntry();
        voucherEntryRow.setUniqueKey(entryId);
        voucherEntryRow.setSeq(seq);
        voucherEntryRow.setTplEntryId(tplEntryCompiler.getVchTempEntry().getId());
        voucherEntryRow.setTplEntrySeq(tplEntryCompiler.getVchTempEntry().getSeq());
        voucherEntryRow.setAutomatic(true);
        voucherEntryRow.setBookId(voucherHeader.getBookId());
        voucherEntryRow.setPeriodId(voucherHeader.getPeriodId());
        setValueHelper.getAccoutHandle().SetEntryFieldValue(this.billContext, this.billResult, tplGroupCompiler, tplEntryCompiler, voucherHeader, voucherEntryRow, fldProperties, sourceRow, extRow);
        setValueHelper.getAmountHandle().SetEntryFieldValue(this.billContext, this.billResult, tplGroupCompiler, tplEntryCompiler, voucherHeader, voucherEntryRow, fldProperties, sourceRow, extRow);
        DapConfig dapConfig = this.taskContext.getDapConfig();
        boolean bl = delaybuildevent = dapConfig != null ? dapConfig.isDelaybuildevent() : false;
        if (this.taskContext.getTemplate().isBuildbizvoucher() && this.taskContext.isEnableBizVoucherByOrg().booleanValue() && (!delaybuildevent || this.taskContext.isBuildBizvoucherFromMidle())) {
            setValueHelper.getBizAssistSetHandle().SetEntryFieldValue(this.billContext, this.billResult, tplGroupCompiler, tplEntryCompiler, voucherHeader, voucherEntryRow, fldProperties, sourceRow, extRow);
        }
        setValueHelper.getExplanationHandle().SetEntryFieldValue(this.billContext, this.billResult, tplGroupCompiler, tplEntryCompiler, voucherHeader, voucherEntryRow, fldProperties, sourceRow, extRow);
        setValueHelper.getSetEntryExpandValueHandle().SetEntryFieldValue(this.billContext, this.billResult, tplGroupCompiler, tplEntryCompiler, voucherHeader, voucherEntryRow, fldProperties, sourceRow, extRow);
        ComAssistResultDataCol comAssist = tplEntryCompiler.getComAssistHandle().GetVchFldValue(fldProperties, sourceRow, extRow);
        voucherEntryRow.setComAssist(comAssist);
        String entityName = tplEntryCompiler.getSourceEntityKey(tplEntryCompiler, this.taskResult.getTplCompiler().getVchTemplate());
        SelectedSourceEntity selectedEntity = this.billResult.getTaskResult().getSelectedEntities().get(entityName);
        Long entryPK = null;
        entryPK = this.taskContext.getTemplate().getEventClassId() == 0L ? (Long)selectedEntity.getEntryPKProperty().getValue((Object)sourceRow) : Long.valueOf(sourceRow.getLong("id"));
        voucherEntryRow.setSourceBillEntryID(entryPK);
        voucherEntryRow.setNeedMerge(tplEntryCompiler.getVchTempEntry().isNeedMerge());
        if (!voucherEntryRow.isNeedMerge()) {
            voucherEntryRow.setTmpGuid(UUID.randomUUID().toString());
        }
        voucherEntryRow.setAutoBal(tplEntryCompiler.getVchTempEntry().isAutoBal());
        return voucherEntryRow;
    }

    private List<BizVoucherEntry> MergeVchEntryRows(List<BizVoucherEntry> sources) {
        ArrayList<BizVoucherEntry> afterGroupRows = new ArrayList<BizVoucherEntry>();
        HashMap<BizVchEntryGroupKey, ArrayList<BizVoucherEntry>> groups = new HashMap<BizVchEntryGroupKey, ArrayList<BizVoucherEntry>>();
        for (BizVoucherEntry bizVoucherEntry : sources) {
            BizVchEntryGroupKey groupKey = bizVoucherEntry.getGroupRegion();
            ArrayList<BizVoucherEntry> groupValue = (ArrayList<BizVoucherEntry>)groups.get(groupKey);
            if (groupValue == null) {
                groupValue = new ArrayList<BizVoucherEntry>();
                groups.put(groupKey, groupValue);
            }
            groupValue.add(bizVoucherEntry);
        }
        for (Map.Entry entry : groups.entrySet()) {
            List groupRows = (List)entry.getValue();
            if (groupRows.size() == 1) {
                afterGroupRows.add((BizVoucherEntry)groupRows.get(0));
                continue;
            }
            BizVoucherEntry totalRow = (BizVoucherEntry)groupRows.get(0);
            BigDecimal oriAmount = new BigDecimal(0);
            BigDecimal localAmount = new BigDecimal(0);
            BigDecimal qty = new BigDecimal(0);
            for (BizVoucherEntry row : groupRows) {
                oriAmount = oriAmount.add(row.getOriAmount());
                localAmount = localAmount.add(row.getLocalAmount());
                qty = qty.add(row.getQty());
            }
            totalRow.setOriAmount(oriAmount);
            totalRow.setLocalAmount(localAmount);
            totalRow.setQty(qty);
            afterGroupRows.add(totalRow);
        }
        return afterGroupRows;
    }
}

