/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singlebillaction;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.DapLocalCache;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.fi.ai.AccountView;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.builder.plugin.events.ValidateVoucherEventArgs;
import kd.fi.ai.enums.GLAccountCurrencyEnum;
import kd.fi.ai.enums.ZeroAmountSysParamEnum;
import kd.fi.ai.mservice.builder.buildresult.BizVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.compiler.TplCompiler;
import kd.fi.ai.mservice.builder.compiler.TplEntryCompiler;
import kd.fi.ai.mservice.builder.helper.BuildHelper;
import kd.fi.ai.mservice.builder.singlebillaction.AbstractSingleBillAction;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class CheckVoucherEntry
extends AbstractSingleBillAction {
    private TplCompiler tplCompiler;

    public CheckVoucherEntry(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        Object message;
        super.DoAction();
        this.tplCompiler = this.taskResult.getTplCompiler();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u5f00\u59cb\u68c0\u67e5\u751f\u6210\u7684\u51ed\u8bc1\u5206\u5f55\u884c\uff0c\u662f\u5426\u5408\u6cd5", (String)"CheckVoucherEntry_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        ArrayList<BizVoucherEntry> errRows = new ArrayList<BizVoucherEntry>();
        boolean isGenVch = false;
        List vchEntryRows = this.billResult.getNewBizVoucher().getEntryRows();
        for (BizVoucherEntry vchEntryRow : vchEntryRows) {
            TplEntryCompiler tplEntryCompiler = this.tplCompiler.getTplEntryCompilers().get(vchEntryRow.getTplEntryId());
            if (tplEntryCompiler == null) continue;
            if (vchEntryRow.getAccountId() != 0L) {
                AccountView loadAccount = BaseDataLoader.loadAccount((IBuildVchContext)this.taskContext.getBuildVchContext(), (Long)vchEntryRow.getAccountId());
                if (loadAccount.isBudgetType()) {
                    String errMessage = MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55[{0}]\u83b7\u53d6[{1}]\u79d1\u76ee\u51fa\u9519\uff1a\u4e0d\u5141\u8bb8\u83b7\u53d6\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u3002", (String)"CheckVoucherEntry_11", (String)"fi-ai-mservice", (Object[])new Object[0]), tplEntryCompiler.getVchTempEntry().getSeq(), loadAccount.getNumber());
                    this.WriteReportDetail(VoucherCheckItem.Account, VoucherErrLevel.Error, errMessage);
                    this.WriteWarnLog(errMessage);
                    this.billResult.setSkipBuildBizVch(true);
                    this.billResult.setSkipBuildGLVch(true);
                    break;
                }
                if (!loadAccount.isIsqty()) {
                    vchEntryRow.setUnitId(0L);
                    vchEntryRow.setQty(BigDecimal.ZERO);
                    vchEntryRow.setPrice(BigDecimal.ZERO);
                }
                isGenVch = true;
            }
            if (!this.CheckAcct(tplEntryCompiler, vchEntryRow)) {
                errRows.add(vchEntryRow);
                continue;
            }
            if (ZeroAmountSysParamEnum.ALWAYS_GENERATE != this.taskContext.getZeroAmountGenEntryParam() && !this.CheckAmount(tplEntryCompiler, vchEntryRow, this.taskContext.getZeroAmountGenEntryParam())) {
                errRows.add(vchEntryRow);
                continue;
            }
            if (vchEntryRow.isAutoBal() && BuildHelper.isEquals(vchEntryRow.getLocalDebit(), BigDecimal.ZERO) && BuildHelper.isEquals(vchEntryRow.getLocalCredit(), BigDecimal.ZERO)) {
                errRows.add(vchEntryRow);
                continue;
            }
            if (!this.CheckRateAndDC(tplEntryCompiler, vchEntryRow, errRows)) {
                this.billResult.setSkipBuildBizVch(true);
                this.billResult.setSkipBuildGLVch(true);
                break;
            }
            if (!this.CheckAccountDistribute(tplEntryCompiler, vchEntryRow.getAccountId())) {
                vchEntryRow.setAccountId(0L);
                vchEntryRow.setAcctItemsContext("");
            }
            if (!this.CheckAccountId(tplEntryCompiler, vchEntryRow.getAccountId())) {
                this.billResult.setSkipBuildBizVch(true);
                this.billResult.setSkipBuildGLVch(true);
                break;
            }
            if (!this.CheckCurrency(tplEntryCompiler, vchEntryRow.getOriCurrencyId())) {
                this.billResult.setSkipBuildBizVch(true);
                this.billResult.setSkipBuildGLVch(true);
                break;
            }
            if (!this.CheckAccountAndCurrency(tplEntryCompiler, vchEntryRow.getAccountId(), vchEntryRow.getOriCurrencyId())) {
                this.billResult.setSkipBuildBizVch(true);
                this.billResult.setSkipBuildGLVch(true);
                break;
            }
            if (this.CheckAccountIsEnable(tplEntryCompiler, vchEntryRow.getAccountId())) continue;
            this.billResult.setSkipBuildBizVch(true);
            this.billResult.setSkipBuildGLVch(true);
            break;
        }
        if (!isGenVch) {
            vchEntryRows.clear();
        }
        if (errRows.size() > 0) {
            message = MessageFormat.format(ResManager.loadKDString((String)"\u5171\u68c0\u67e5\u51fa{0}\u884c\u5206\u5f55\u65e0\u6548\uff0c\u9700\u8981\u5220\u9664", (String)"CheckVoucherEntry_1", (String)"fi-ai-mservice", (Object[])new Object[0]), errRows.size());
            this.WriteReportDetail(VoucherCheckItem.Other, VoucherErrLevel.Warning, (String)message);
            this.WriteWarnLog((String)message);
        }
        for (BizVoucherEntry errRow : errRows) {
            vchEntryRows.remove(errRow);
        }
        if (vchEntryRows.size() == 0) {
            this.billResult.setSkipBuildBizVch(true);
            this.billResult.setSkipBuildGLVch(true);
            message = ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6210\u4e00\u6761\u51ed\u8bc1\u5206\u5f55\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u5206\u5f55\u914d\u7f6e\u3002", (String)"CheckVoucherEntry_2", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.WriteReportDetail(VoucherCheckItem.Other, VoucherErrLevel.Error, (String)message);
            this.WriteWarnLog((String)message);
            return;
        }
        if (!this.CheckDebitAndCredit(vchEntryRows)) {
            this.billResult.setSkipBuildBizVch(true);
            this.billResult.setSkipBuildGLVch(true);
            message = ResManager.loadKDString((String)"\u751f\u6210\u7684\u51ed\u8bc1\u5206\u5f55\uff0c\u501f\u8d37\u4e0d\u5e73\u8861\uff0c\u68c0\u67e5\u4e0d\u901a\u8fc7\u3002", (String)"CheckVoucherEntry_3", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.WriteReportDetail(VoucherCheckItem.Other, VoucherErrLevel.Warning, (String)message);
            this.WriteWarnLog((String)message);
            return;
        }
        if (!this.CheckNoItemAccountEntry(vchEntryRows)) {
            this.billResult.setExStatus(true);
            this.billResult.setSkipBuildGLVch(true);
            message = ResManager.loadKDString((String)"\u5206\u5f55\u6709\u5fc5\u5f55\u7684\u6838\u7b97\u7ef4\u5ea6\u672a\u8d4b\u503c\uff0c\u4e1a\u52a1\u51ed\u8bc1\u5f02\u5e38\uff0c\u4e0d\u80fd\u5408\u5e76\u4e3a\u603b\u8d26\u51ed\u8bc1\u3002", (String)"CheckVoucherEntry_4", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.WriteReportDetail(VoucherCheckItem.Other, VoucherErrLevel.Warning, (String)message);
            this.WriteWarnLog((String)message);
            return;
        }
        ValidateVoucherEventArgs event = new ValidateVoucherEventArgs(this.billResult.getNewBizVoucher());
        this.taskContext.getPlugProxy().fireValidataVoucher(event);
        if (!event.isValid()) {
            this.billResult.setExStatus(true);
            this.billResult.setSkipBuildGLVch(true);
            this.WriteReportDetail(VoucherCheckItem.Other, event.getErrorLevel(), event.getErrorMsg());
            this.WriteWarnLog(event.getErrorMsg());
            return;
        }
    }

    private void CheckAccountUnitGroup(TplEntryCompiler tplEntryCompiler) {
    }

    private boolean CheckIsSameUnitGroup(TplEntryCompiler tplEntryCompiler, int unitGroupType) {
        return true;
    }

    private boolean CheckRateAndDC(TplEntryCompiler tplEntry, BizVoucherEntry bizVchEntryRow, List<BizVoucherEntry> errRows) {
        if (this.taskContext.getBookInfo().getCyId() != bizVchEntryRow.getOriCurrencyId() && BuildHelper.isEquals(bizVchEntryRow.getLocalExchangeRate(), BigDecimal.ZERO) && !bizVchEntryRow.isAutoBal()) {
            errRows.add(bizVchEntryRow);
            LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.ACCOUNT_BOOK_VERSION, (Object[])new Object[]{"dap-check-rate-dc"});
            String errormessage = (String)DapLocalCache.get((LocalCacheKey)cacheKey, String.class);
            if (errormessage == null) {
                errormessage = ResManager.loadKDString((String)"\u5206\u5f55[{0}]\u83b7\u53d6\u6c47\u7387\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u914d\u7f6e\u3002", (String)"CheckVoucherEntry_6", (String)"fi-ai-mservice", (Object[])new Object[0]);
                DapLocalCache.put((LocalCacheKey)cacheKey, (Object)errormessage);
            }
            String errMessage = MessageFormat.format(errormessage, tplEntry.getVchTempEntry().getSeq());
            this.WriteReportDetail(VoucherCheckItem.Rate, VoucherErrLevel.Error, errMessage);
            this.WriteWarnLog(errMessage);
            return false;
        }
        return true;
    }

    private boolean CheckCurrency(TplEntryCompiler tplEntryCompiler, long currencyId) {
        if (currencyId == 0L) {
            LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.ACCOUNT_BOOK_VERSION, (Object[])new Object[]{"dap-check-currency"});
            String errormessage = (String)DapLocalCache.get((LocalCacheKey)cacheKey, String.class);
            if (errormessage == null) {
                errormessage = ResManager.loadKDString((String)"\u5206\u5f55[{0}]\u83b7\u53d6\u5e01\u79cd\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u914d\u7f6e", (String)"CheckVoucherEntry_12", (String)"fi-ai-mservice", (Object[])new Object[0]);
                DapLocalCache.put((LocalCacheKey)cacheKey, (Object)errormessage);
            }
            String errMessage = MessageFormat.format(errormessage, tplEntryCompiler.getVchTempEntry().getSeq());
            this.WriteReportDetail(VoucherCheckItem.Currency, VoucherErrLevel.Error, errMessage);
            this.WriteWarnLog(errMessage);
            return false;
        }
        return true;
    }

    private boolean CheckAccountAndCurrency(TplEntryCompiler tplEntryCompiler, long accountId, long currencyId) {
        AccountView account = BaseDataLoader.loadAccount((IBuildVchContext)this.context, (Long)accountId);
        String acctCurrency = account.getAcctCurrency();
        if (GLAccountCurrencyEnum.DES_CURRENCY.getValue().equals(acctCurrency) && currencyId != this.taskContext.getBookInfo().getCyId() && !account.getAcctCurrencySet().contains(currencyId)) {
            LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.ACCOUNT_BOOK_VERSION, (Object[])new Object[]{"dap-check-account-currency"});
            String errormessage = (String)DapLocalCache.get((LocalCacheKey)cacheKey, String.class);
            if (errormessage == null) {
                errormessage = ResManager.loadKDString((String)"\u5206\u5f55[{0}]\u5e01\u79cd\u4e0e\u79d1\u76ee\u6838\u7b97\u5e01\u79cd\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u914d\u7f6e\u3002", (String)"CheckVoucherEntry_8", (String)"fi-ai-mservice", (Object[])new Object[0]);
                DapLocalCache.put((LocalCacheKey)cacheKey, (Object)errormessage);
            }
            String errMessage = MessageFormat.format(errormessage, tplEntryCompiler.getVchTempEntry().getSeq());
            this.WriteReportDetail(VoucherCheckItem.AccountAndCurrency, VoucherErrLevel.Error, errMessage);
            this.WriteWarnLog(errMessage);
            return false;
        }
        return true;
    }

    private boolean CheckAccountDistribute(TplEntryCompiler tplEntryCompiler, long accountId) {
        return true;
    }

    private boolean CheckAccountId(TplEntryCompiler tplEntryCompiler, long accountId) {
        return true;
    }

    private boolean CheckAmount(TplEntryCompiler tplEntryCompiler, BizVoucherEntry vchEntryRow, ZeroAmountSysParamEnum dealParam) {
        boolean isAmount;
        boolean isQty = true;
        switch (dealParam) {
            case ALWAYS_NOT_GENERATE: {
                break;
            }
            case ZERO_AMOUNT_NON_ZERO_QUANTITY: {
                isQty = BuildHelper.isEquals(vchEntryRow.getQty(), BigDecimal.ZERO);
            }
        }
        boolean bl = isAmount = BuildHelper.isEquals(vchEntryRow.getLocalDebit(), BigDecimal.ZERO) && BuildHelper.isEquals(vchEntryRow.getLocalCredit(), BigDecimal.ZERO);
        if (isAmount && isQty) {
            String reportError = dealParam == ZeroAmountSysParamEnum.ALWAYS_NOT_GENERATE ? String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u7b2c\u201c%1$s\u201d\u884c\u5206\u5f55\u672c\u4f4d\u5e01\u91d1\u989d\u4e3a0\uff0c\u6839\u636e\u7cfb\u7edf\u53c2\u6570\u91d1\u989d\u4e3a0\u4e0d\u751f\u6210\u5206\u5f55\u3002", (String)"CheckVoucherEntry_15", (String)"fi-ai-mservice", (Object[])new Object[0]), tplEntryCompiler.getVchTempEntry().getSeq()) : String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u7b2c\u201c%1$s\u201d\u884c\u5206\u5f55\u83b7\u53d6\u672c\u4f4d\u5e01\u91d1\u989d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u914d\u7f6e\u3002", (String)"CheckVoucherEntry_13", (String)"fi-ai-mservice", (Object[])new Object[0]), tplEntryCompiler.getVchTempEntry().getSeq());
            this.WriteReportDetail(VoucherCheckItem.Amount, VoucherErrLevel.Warning, reportError);
            this.WriteWarnLog(reportError);
            LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.ACCOUNT_BOOK_VERSION, (Object[])new Object[]{"dap-check-amount"});
            String errorMessage = (String)DapLocalCache.get((LocalCacheKey)cacheKey, String.class);
            if (errorMessage == null) {
                DapLocalCache.put((LocalCacheKey)cacheKey, (Object)reportError);
            }
            return false;
        }
        return true;
    }

    private boolean CheckAcct(TplEntryCompiler tplEntryCompiler, BizVoucherEntry vchEntryRow) {
        Long acct = vchEntryRow.getAccountId();
        if (acct > 0L) {
            return true;
        }
        Boolean flag = this.taskContext.isVoucherByAcct();
        return flag;
    }

    private boolean CheckDebitAndCredit(List<BizVoucherEntry> vchEntryRows) {
        return true;
    }

    private boolean CheckNoItemAccountEntry(List<BizVoucherEntry> vchEntryRows) {
        return true;
    }

    private boolean CheckAccountIsEnable(TplEntryCompiler tplEntryCompiler, long accountId) {
        AccountView loadAccount = BaseDataLoader.loadAccount((IBuildVchContext)this.context, (Long)accountId);
        if (loadAccount != null && accountId != 0L && !loadAccount.isEnable()) {
            String errMessage = MessageFormat.format(ResManager.loadKDString((String)"\u5206\u5f55[{0}][{1}]\u79d1\u76ee\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u914d\u7f6e", (String)"CheckVoucherEntry_14", (String)"fi-ai-mservice", (Object[])new Object[0]), tplEntryCompiler.getVchTempEntry().getSeq(), loadAccount.getNumber());
            this.WriteReportDetail(VoucherCheckItem.Amount, VoucherErrLevel.Error, errMessage);
            this.WriteWarnLog(errMessage);
            return false;
        }
        return true;
    }
}

