/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singlebillaction;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.cache.CacheKey;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.LocalCacheHelper;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.context.BuildVchContext;
import kd.fi.ai.mservice.builder.singlebillaction.AbstractSingleBillAction;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.DateUtil;
import kd.fi.bd.business.service.book.OpenedPeriodService;
import kd.fi.v2.fah.utils.StringUtils;

public class CheckVoucherHeader
extends AbstractSingleBillAction {
    public CheckVoucherHeader(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        BizVoucher vch = this.billResult.getNewBizVoucher();
        if (!this.checkVchHead(vch)) {
            this.billResult.setSkipBuildBizVch(true);
            this.billResult.setSkipBuildGLVch(true);
            this.billResult.setExStatus(true);
        }
    }

    private boolean checkVchHead(BizVoucher vch) {
        return this.checkVchTypeId(vch) && this.checkBizDate(vch) && this.checkPeriod(vch) && this.checkCustomkey(vch) && this.checkHisPeriod(vch);
    }

    private boolean checkHisPeriod(BizVoucher vch) {
        if (this.taskContext.isBuildBizvoucherFromMidle() || this.taskContext.isVchTemplatePreVoucher()) {
            return true;
        }
        AcctBookInfo bookInfo = this.taskContext.getBookInfo();
        Date currentPeriodBeginDate = bookInfo.getCurrentPeriodBeginDate();
        HashSet periodIds = new HashSet(OpenedPeriodService.getOpenedPeriodIds((long)bookInfo.getAcctOrgId(), (long)bookInfo.getBookTypeId()));
        if (periodIds.contains(vch.getPeriodId())) {
            return true;
        }
        Date bookedDate = vch.getBookedDate();
        BuildVchContext context = (BuildVchContext)this.taskContext.getBuildVchContext();
        String pageId = context.getScheme().getPageId();
        if (currentPeriodBeginDate.after(bookedDate) && StringUtils.isBlank((String)pageId)) {
            String msg = ResManager.loadKDString((String)"\u4e0d\u80fd\u751f\u6210\u5df2\u7ed3\u8d26\u671f\u95f4\u7684\u51ed\u8bc1\u3002", (String)"CheckVoucherHeader_8", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.WriteReportDetail(VoucherCheckItem.VoucherType, VoucherErrLevel.Error, msg);
            return false;
        }
        return true;
    }

    private boolean checkCustomkey(BizVoucher vch) {
        if (!this.taskContext.isBuildBizvoucherFromMidle()) {
            Map customKey = this.taskContext.getCustomKey();
            Set customkeyCol = this.taskContext.getDulipyCustomkeyCol();
            String opr = this.taskContext.getOpr();
            String customkey = DapBuildVoucherCommonUtil.getCustomKey((BizVoucher)vch, (Map)customKey, (String)opr);
            Long orgId = 0L;
            Long booktypeId = 0L;
            CacheKey k = CacheKey.getCacheKey((CacheModule)CacheModule.aiBuildVchWizard, (Object[])new Object[]{"checkcustomkey", vch.getBookId()});
            String booktypeAndorg = (String)LocalCacheHelper.get((CacheKey)k, String.class);
            if (booktypeAndorg != null) {
                String[] split = booktypeAndorg.split("-");
                booktypeId = Long.parseLong(split[0]);
                orgId = Long.parseLong(split[1]);
            } else {
                AcctBookInfo acctBookInfo = (AcctBookInfo)this.context.getBooks().get(vch.getBookId());
                if (acctBookInfo != null) {
                    orgId = acctBookInfo.getAcctOrgId();
                    booktypeId = acctBookInfo.getBookTypeId();
                    String value = booktypeId + "-" + orgId;
                    LocalCacheHelper.put((CacheKey)k, (Object)value);
                }
            }
            String dulipyCustomKey = DapBuildVoucherCommonUtil.getParseDulipyCustomKey((String)vch.getSourceBill(), (Long)vch.getSourceBillId(), (Long)booktypeId, (Long)orgId, (String)this.taskContext.getReOper(), (String)customkey);
            if (customkeyCol.contains(dulipyCustomKey)) {
                String msg = ResManager.loadKDString((String)"\u5df2\u751f\u6210\u81ea\u5b9a\u4e49\u7ec4\u5408\u6761\u4ef6\u76f8\u540c\u7684\u51ed\u8bc1\uff0c\u65e0\u6cd5\u91cd\u590d\u751f\u6210\u3002\uff08\u7ec4\u5408\u6761\u4ef6\uff1a\u4e1a\u52a1\u5355\u636e+\u4e1a\u52a1\u5355\u636eID+\u8d26\u7c3f+\u5173\u8054\u64cd\u4f5c+\u81ea\u5b9a\u4e49\u6807\u8bc6\uff09", (String)"CheckVoucherHeader_6", (String)"fi-ai-mservice", (Object[])new Object[0]);
                this.WriteReportDetail(VoucherCheckItem.Other, VoucherErrLevel.Error, msg);
                return false;
            }
        }
        return true;
    }

    private boolean checkPeriod(BizVoucher vch) {
        AcctBookInfo bookInfo = this.taskContext.getBookInfo();
        if (!bookInfo.isEnable()) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u5df2\u7981\u7528\u8d26\u7c3f\u7684\u51ed\u8bc1\u3002", (String)"CheckVoucherHeader_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.WriteReportDetail(VoucherCheckItem.VoucherType, VoucherErrLevel.Error, msg);
            return false;
        }
        return true;
    }

    private boolean checkBizDate(BizVoucher vch) {
        Date bizDate = vch.getBizDate();
        Date bookDate = vch.getBookedDate();
        SimpleDateFormat sdf = DateUtil.getShortFormat();
        try {
            if (this.taskContext.getShortDataCache().containsKey(bizDate)) {
                bizDate = (Date)this.taskContext.getShortDataCache().get(bizDate);
            } else {
                bizDate = sdf.parse(sdf.format(bizDate));
                this.taskContext.getShortDataCache().put(vch.getBizDate(), bizDate);
            }
            if (this.taskContext.getShortDataCache().containsKey(bookDate)) {
                bookDate = (Date)this.taskContext.getShortDataCache().get(bookDate);
            } else {
                bookDate = sdf.parse(sdf.format(bookDate));
                this.taskContext.getShortDataCache().put(vch.getBookedDate(), bookDate);
            }
            if (bizDate.after(bookDate)) {
                String msg = ResManager.loadKDString((String)"\u51ed\u8bc1\u4e1a\u52a1\u65e5\u671f\u4e0d\u5f97\u665a\u4e8e\u8bb0\u8d26\u65e5\u671f\u3002", (String)"CheckVoucherHeader_2", (String)"fi-ai-mservice", (Object[])new Object[0]);
                this.WriteReportDetail(VoucherCheckItem.VoucherType, VoucherErrLevel.Error, msg);
                return false;
            }
        }
        catch (ParseException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u6216\u8bb0\u8d26\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38\u201c%s\u201d\u3002", (String)"CheckVoucherHeader_3", (String)"fi-ai-mservice", (Object[])new Object[0]), e.getMessage());
            this.WriteReportDetail(VoucherCheckItem.VoucherType, VoucherErrLevel.Error, msg);
            return false;
        }
        return true;
    }

    private boolean checkVchTypeId(BizVoucher vch) {
        if (vch.getVchTypeId() == 0L) {
            String logMessage = ResManager.loadKDString((String)"\u51ed\u8bc1\u7c7b\u578b\u672a\u83b7\u53d6\u5230\u503c\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u6a21\u677f\u914d\u7f6e\u3002", (String)"CheckVoucherHeader_4", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.WriteWarnLog(logMessage);
            this.WriteReportDetail(VoucherCheckItem.VoucherType, VoucherErrLevel.Error, logMessage);
            return false;
        }
        return true;
    }
}

