/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singlebillaction;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.ai.VchTplEntryMergeOption;
import kd.fi.ai.builder.ISingleBillContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.BizVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntryGroupKey;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherGroupKey;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleBillResult;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.singlebillaction.AbstractSingleBillAction;
import kd.fi.ai.mservice.builder.singlebillaction.UnionGLVoucherHelper;

public class MergeToGLVoucher
extends AbstractSingleBillAction {
    private UnionGLVoucherHelper unionHelper;
    private Map<GLVoucherGroupKey, GLVoucher> glVouchers;
    private Map<GLVoucher, Map<GLVoucherEntryGroupKey, GLVoucherEntry>> glVchEntryRows;

    public MergeToGLVoucher(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
        this.glVouchers = taskResult.getNewGLVouchers();
        this.glVchEntryRows = taskResult.getNewGLVchEntryRows();
        VchTplEntryMergeOption entryMergeOption = taskContext.getTemplate().getEntryMergeOption();
        this.unionHelper = new UnionGLVoucherHelper(taskContext.getBookInfo(), entryMergeOption);
    }

    @Override
    public void Do(ISingleBillContext billContext, SingleBillResult billResult) {
        this.billContext = billContext;
        this.billResult = billResult;
        if (!this.billResult.isSkipBuildGLVch()) {
            this.DoAction();
        }
    }

    @Override
    protected void DoAction() {
        BizVoucher bizVoucher = null;
        bizVoucher = !this.billResult.isSkipBuildBizVch() ? this.billResult.getNewBizVoucher() : this.billResult.getHistBizVoucher();
        if (bizVoucher == null) {
            return;
        }
        this.WriteInfoLog(ResManager.loadKDString((String)"\u5c06\u4e1a\u52a1\u51ed\u8bc1\u5408\u5e76\u81f3\u603b\u8d26\u51ed\u8bc1", (String)"MergeToGLVoucher_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        this.MergeBizVoucher(bizVoucher);
    }

    private void MergeBizVoucher(BizVoucher bizVoucher) {
        DynamicObject sourceRow;
        if (!this.CanMergeToGlVoucher(bizVoucher)) {
            return;
        }
        GLVoucher glVoucher = null;
        Map<String, DynamicProperty> fldProperties = this.billResult.getFirstRowProps();
        GLVoucherGroupKey headRegion = this.CreateHeadGroupKey(fldProperties, sourceRow = this.billResult.getFirstRow(), bizVoucher);
        if (!this.glVouchers.containsKey(headRegion)) {
            glVoucher = this.CreateGLVoucher(bizVoucher);
            glVoucher.setGroupKey(headRegion);
            this.glVouchers.put(headRegion, glVoucher);
            this.glVchEntryRows.put(glVoucher, new HashMap());
        } else {
            glVoucher = this.glVouchers.get(headRegion);
            this.MergeHead(glVoucher, bizVoucher);
        }
        this.MergeVchEntryRows(glVoucher, bizVoucher);
    }

    private void MergeVchEntryRows(GLVoucher glVoucher, BizVoucher bizVoucher) {
        int oldGLRows = glVoucher.getEntryRows().size();
        Map<GLVoucherEntryGroupKey, GLVoucherEntry> dctGLVoucherRows = this.glVchEntryRows.get(glVoucher);
        if (!this.taskContext.getBookInfo().isMergeEntryRow()) {
            for (BizVoucherEntry bizVchEntryRow : bizVoucher.getEntryRows()) {
                GLVoucherEntry glVchEntryRow = this.CreateGLVoucherRow(bizVchEntryRow);
                glVchEntryRow.setForgid(bizVoucher.getOrgId());
                glVchEntryRow.setFperiodid(bizVoucher.getPeriodId());
                glVchEntryRow.setSourceBillNo(bizVoucher.getSourceBillNo());
                glVchEntryRow.setTplEntrySeq(bizVchEntryRow.getTplEntrySeq());
                glVoucher.getEntryRows().add(glVchEntryRow);
            }
        } else {
            for (BizVoucherEntry bizVchEntryRow : bizVoucher.getEntryRows()) {
                GLVoucherEntryGroupKey entryGroupKey = this.unionHelper.CreateEntryGroupKey((IVoucher<?>)bizVoucher, (IVoucherEntry)bizVchEntryRow);
                GLVoucherEntry glVchEntryRow = null;
                if (!dctGLVoucherRows.containsKey(entryGroupKey) || !bizVchEntryRow.isNeedMerge()) {
                    glVchEntryRow = this.CreateGLVoucherRow(bizVchEntryRow);
                    glVchEntryRow.setForgid(bizVoucher.getOrgId());
                    glVchEntryRow.setFperiodid(bizVoucher.getPeriodId());
                    glVchEntryRow.setSourceBillNo(bizVoucher.getSourceBillNo());
                    glVchEntryRow.setTplEntrySeq(bizVchEntryRow.getTplEntrySeq());
                    glVchEntryRow.setAccountId(bizVchEntryRow.getAccountId());
                    glVoucher.getEntryRows().add(glVchEntryRow);
                    dctGLVoucherRows.put(entryGroupKey, glVchEntryRow);
                    continue;
                }
                glVchEntryRow = dctGLVoucherRows.get(entryGroupKey);
                this.MergeVchEntryRow(glVoucher, glVchEntryRow, bizVchEntryRow);
            }
        }
    }

    private boolean CanMergeToGlVoucher(BizVoucher bizVoucher) {
        boolean exStatus = bizVoucher.isError();
        long glVoucherId = bizVoucher.getGlVoucherId();
        if (exStatus) {
            String logMessage = ResManager.loadKDString((String)"\u5b58\u5728\u5f02\u5e38\u7684\u4e1a\u52a1\u51ed\u8bc1\uff0c\u65e0\u6cd5\u751f\u6210\u603b\u8d26\u51ed\u8bc1\u3002", (String)"MergeToGLVoucher_4", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.WriteWarnLog(logMessage);
            this.WriteReportDetail(VoucherCheckItem.Other, VoucherErrLevel.Warning, logMessage);
            return false;
        }
        if (glVoucherId > 0L) {
            String logMessage = ResManager.loadKDString((String)"\u4e1a\u52a1\u51ed\u8bc1\u5df2\u751f\u6210\u603b\u8d26\u51ed\u8bc1\uff0c\u65e0\u9700\u91cd\u65b0\u751f\u6210\u3002", (String)"MergeToGLVoucher_5", (String)"fi-ai-mservice", (Object[])new Object[0]);
            this.WriteReportDetail(VoucherCheckItem.Other, VoucherErrLevel.Warning, logMessage);
            this.WriteInfoLog(logMessage);
            return false;
        }
        return true;
    }

    private GLVoucherGroupKey CreateHeadGroupKey(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, BizVoucher bizVoucher) {
        Object unionFieldValue = this.taskResult.getSourceBillCompiler().getUnionKeyGetHandle().GetVchFldValue((Map)fldProperties, sourceRow, (DynamicObject)null);
        GLVoucherGroupKey groupKey = new GLVoucherGroupKey(bizVoucher.getBookId(), bizVoucher.getVchTypeId(), Long.valueOf(bizVoucher.getPeriodId()), (String)unionFieldValue);
        return groupKey;
    }

    private GLVoucher CreateGLVoucher(BizVoucher bizVoucher) {
        GLVoucher glVoucher = new GLVoucher();
        glVoucher.setTmpGuid(UUID.randomUUID().toString());
        this.taskResult.getBizGroupToGlMap().put(bizVoucher.getTmpGuid(), glVoucher.getTmpGuid());
        glVoucher.setBillStatus("A");
        glVoucher.setVchTypeId(bizVoucher.getVchTypeId());
        glVoucher.setBookId(this.taskContext.getBookInfo().getBookId());
        glVoucher.setBookTypeId(this.taskContext.getBookInfo().getBookTypeId());
        glVoucher.setOrgId(this.taskContext.getBookInfo().getAcctOrgId());
        glVoucher.setLocalcur(bizVoucher.getLocalCurrencyId());
        glVoucher.setSourceType("4");
        glVoucher.setSourceSys(bizVoucher.getSourceSys());
        glVoucher.setSourceBill(bizVoucher.getSourceBill());
        glVoucher.setAttachment(bizVoucher.getAttachment());
        glVoucher.setPeriodId(bizVoucher.getPeriodId());
        glVoucher.setBizDate(bizVoucher.getBizDate());
        glVoucher.setBookedDate(bizVoucher.getBookedDate());
        glVoucher.setSourceBillId(bizVoucher.getSourceBillId());
        glVoucher.setSourceBillNo(bizVoucher.getSourceBillNo());
        glVoucher.setCashier(bizVoucher.getCashier().longValue());
        glVoucher.setCheckstatus(bizVoucher.getCheckstatus());
        glVoucher.setExpandFieldValue(bizVoucher.getExpandFieldValue());
        Date now = TimeServiceHelper.now();
        glVoucher.setCreateTime(now);
        glVoucher.setCreatorId(bizVoucher.getCreatorId());
        glVoucher.setModifierId(bizVoucher.getModifierId());
        glVoucher.setModifyTime(now);
        String description = bizVoucher.getDescription();
        if (null == description) {
            description = "";
        }
        glVoucher.setDescription(description);
        glVoucher.setIssubmit(Boolean.valueOf(this.taskContext.getTemplate().isSubmit()));
        glVoucher.setTemplateId(bizVoucher.getTemplateId());
        glVoucher.setUnionType(this.taskContext.getTemplate().getUnionType());
        glVoucher.setBookCyId(bizVoucher.getBookCyId());
        return glVoucher;
    }

    private GLVoucherEntry CreateGLVoucherRow(BizVoucherEntry bizVchEntryRow) {
        GLVoucherEntry glVchEntryRow = new GLVoucherEntry();
        glVchEntryRow.setTmpGuid(bizVchEntryRow.getTmpGuid());
        glVchEntryRow.setSeq(bizVchEntryRow.getSeq());
        glVchEntryRow.setDescription(bizVchEntryRow.getDescription());
        glVchEntryRow.setAccountId(bizVchEntryRow.getAccountId());
        glVchEntryRow.setCashAcct(bizVchEntryRow.isCashAcct());
        glVchEntryRow.setAssgrpId(bizVchEntryRow.getAssgrpId());
        glVchEntryRow.setOriCurrencyId(bizVchEntryRow.getOriCurrencyId());
        glVchEntryRow.setLocalExchangeRate(bizVchEntryRow.getLocalExchangeRate());
        glVchEntryRow.setOriDebit(bizVchEntryRow.getOriDebit());
        glVchEntryRow.setOriCredit(bizVchEntryRow.getOriCredit());
        glVchEntryRow.setLocalDebit(bizVchEntryRow.getLocalDebit());
        glVchEntryRow.setLocalCredit(bizVchEntryRow.getLocalCredit());
        glVchEntryRow.setComAssist(bizVchEntryRow.getComAssist());
        long bookCurrencyId = this.taskContext.getBookInfo().getCyId();
        if (bizVchEntryRow.getOriCurrencyId() == bookCurrencyId) {
            glVchEntryRow.setLocalExchangeRate(new BigDecimal(1));
            glVchEntryRow.setOriDebit(glVchEntryRow.getLocalDebit());
            glVchEntryRow.setOriCredit(glVchEntryRow.getLocalCredit());
        }
        glVchEntryRow.setDcDirectory(bizVchEntryRow.getDcDirectory());
        glVchEntryRow.setQty(bizVchEntryRow.getQty());
        glVchEntryRow.setUnitId(bizVchEntryRow.getUnitId());
        glVchEntryRow.setPrice(bizVchEntryRow.getPrice());
        glVchEntryRow.setMaincfitemID(bizVchEntryRow.getMaincfitemID());
        glVchEntryRow.setSupcfitemID(bizVchEntryRow.getSupcfitemID());
        glVchEntryRow.setMaincfamount(bizVchEntryRow.getMaincfamount());
        glVchEntryRow.setSupcfamount(bizVchEntryRow.getSupcfamount());
        glVchEntryRow.setMaincfassgrp(bizVchEntryRow.getMaincfassgrp());
        glVchEntryRow.setExpireDate(bizVchEntryRow.getExpireDate());
        glVchEntryRow.setBusinessNum(bizVchEntryRow.getBusinessNum());
        glVchEntryRow.setExpandFieldValue(bizVchEntryRow.getExpandFieldValue());
        return glVchEntryRow;
    }

    private void MergeHead(GLVoucher glVoucher, BizVoucher bizVoucher) {
        this.WriteInfoLog(ResManager.loadKDString((String)"\u5408\u5e76\u4e1a\u52a1\u51ed\u8bc1\u5934\u5b57\u6bb5", (String)"MergeToGLVoucher_6", (String)"fi-ai-mservice", (Object[])new Object[0]));
        this.taskResult.getBizGroupToGlMap().put(bizVoucher.getTmpGuid(), glVoucher.getTmpGuid());
        this.unionHelper.MergeHead((IVoucher<?>)glVoucher, (IVoucher<?>)bizVoucher);
    }

    private void MergeVchEntryRow(GLVoucher glVoucher, GLVoucherEntry glVchEntryRow, BizVoucherEntry bizVchEntryRow) {
        this.unionHelper.MergeVchEntryRow((IVoucher<?>)glVoucher, (IVoucherEntry)glVchEntryRow, (IVoucherEntry)bizVchEntryRow);
    }
}

