/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singlebillaction;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.VchTplEntryMergeOption;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntryGroupKey;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.singlebillaction.IGetExplanation;
import kd.fi.ai.mservice.builder.singlebillaction.IGetLocalRate;
import kd.fi.ai.mservice.builder.singlebillaction.IGetPrice;
import kd.fi.ai.mservice.builder.singlebillaction.IMergeDc;
import kd.fi.ai.mservice.builder.singlebillaction.IMergeExplanation;
import kd.fi.ai.mservice.builder.singlebillaction.IMergeLocalRate;
import kd.fi.ai.mservice.builder.singlebillaction.IMergePrice;
import kd.fi.ai.util.ContextUtil;
import kd.fi.bd.rate.RateServiceHelper;

public class UnionGLVoucherHelper {
    private AcctBookInfo bookInfo;
    private IGetExplanation getExplanation;
    private IGetLocalRate getLocalExchangeRate;
    private IGetPrice getPrice;
    private IMergeExplanation mergeExplanation;
    private IMergeLocalRate mergeLocalRate;
    private IMergePrice mergePrice;
    private IMergeDc mergeDc;
    private VchTplEntryMergeOption entryMergeOption;

    public UnionGLVoucherHelper(AcctBookInfo bookInfo, VchTplEntryMergeOption entryMergeOption) {
        this.bookInfo = bookInfo;
        this.entryMergeOption = entryMergeOption;
        if (entryMergeOption == null) {
            this.entryMergeOption = new VchTplEntryMergeOption();
        }
        this.BuildGetExplanation();
        this.BuildGetLocalExchangeRate();
        this.BuildGetPrice();
        this.BuildMergeExplanation();
        this.BuildMergeLocalRate(bookInfo.getExchangeTableID());
        this.BuildMergePrice();
        this.buildMergeDc();
    }

    public GLVoucherEntryGroupKey CreateEntryGroupKey(IVoucher<?> voucher, IVoucherEntry entryRow) {
        GLVoucherEntryGroupKey groupKey = new GLVoucherEntryGroupKey(entryRow.getTmpGuid(), this.GetExplanation(entryRow), entryRow.getAccountId(), entryRow.getAssgrpId(), entryRow.getOriCurrencyId(), entryRow.getRateType(), this.GetLocalExchangeRate(entryRow), entryRow.getDcDirectory(), voucher.getTplGroupId(), entryRow.getUnitId(), this.GetPrice(entryRow), entryRow.getMaincfitemID(), entryRow.getSupcfitemID(), this.entryMergeOption, entryRow.getComAssist());
        return groupKey;
    }

    public void MergeHead(IVoucher<?> oldVoucher, IVoucher<?> newVoucher) {
        Date newTime;
        Date oldTime = oldVoucher.getBookedDate();
        if (oldTime.compareTo(newTime = newVoucher.getBookedDate()) > 0) {
            newTime = oldTime;
        }
        if ("c".equals(oldVoucher.getCheckstatus()) && !"c".equals(newVoucher.getCheckstatus())) {
            oldVoucher.setCheckstatus(newVoucher.getCheckstatus());
            oldVoucher.setCashier(0L);
        } else if (!Objects.equals(oldVoucher.getCashier(), ContextUtil.getUserId())) {
            oldVoucher.setCashier(ContextUtil.getUserId());
        }
        if (!"c".equals(oldVoucher.getCheckstatus())) {
            oldVoucher.setCashier(0L);
        }
        oldVoucher.setBookedDate(newTime);
        if (!"1".equals(newVoucher.getAttachmentType())) {
            int newAttachment = oldVoucher.getAttachment() + newVoucher.getAttachment();
            oldVoucher.setAttachment(newAttachment);
        }
        if (oldVoucher instanceof GLVoucher && newVoucher instanceof GLVoucher) {
            GLVoucher og = (GLVoucher)oldVoucher;
            GLVoucher ng = (GLVoucher)newVoucher;
            if (ng.isPreSaveEntry()) {
                og.setPreSaveEntry(true);
            }
            if (ng.isHasCashAcct()) {
                og.setHasCashAcct(true);
            }
            if (ng.isHasNcNpAcct()) {
                og.setHasNcNpAcct(true);
            }
            if (ng.isHasSyAcct()) {
                og.setHasSyAcct(true);
            }
        }
    }

    public void MergeVchEntryRow(IVoucher<?> oldVoucher, IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
        int expUnionType = Integer.parseInt(this.bookInfo.getExplanationUnionType());
        if (expUnionType != 2) {
            this.MergeExplanation(oldEntryRow, newEntryRow);
        }
        BigDecimal oldOriDebit = oldEntryRow.getOriDebit();
        BigDecimal oldOriCredit = oldEntryRow.getOriCredit();
        BigDecimal oldLocalDebit = oldEntryRow.getLocalDebit();
        BigDecimal oldLocalCredit = oldEntryRow.getLocalCredit();
        BigDecimal oldMainCf = oldEntryRow.getMaincfamount();
        BigDecimal oldSupCf = oldEntryRow.getSupcfamount();
        BigDecimal newOriDebit = oldOriDebit.add(newEntryRow.getOriDebit());
        BigDecimal newOriCredit = oldOriCredit.add(newEntryRow.getOriCredit());
        BigDecimal newLocalDebit = oldLocalDebit.add(newEntryRow.getLocalDebit());
        BigDecimal newLocalCredit = oldLocalCredit.add(newEntryRow.getLocalCredit());
        if (oldMainCf != null) {
            BigDecimal newMainCf = oldMainCf.add(newEntryRow.getMaincfamount());
            oldEntryRow.setMaincfamount(newMainCf);
        }
        if (oldSupCf != null) {
            BigDecimal newSupCf = oldSupCf.add(newEntryRow.getSupcfamount());
            oldEntryRow.setSupcfamount(newSupCf);
        }
        oldEntryRow.setOriDebit(newOriDebit);
        oldEntryRow.setOriCredit(newOriCredit);
        oldEntryRow.setLocalDebit(newLocalDebit);
        oldEntryRow.setLocalCredit(newLocalCredit);
        if (oldEntryRow.getDcDirectory() == newEntryRow.getDcDirectory()) {
            BigDecimal oldQty = oldEntryRow.getQty();
            BigDecimal newQty = oldQty.add(newEntryRow.getQty());
            oldEntryRow.setQty(newQty);
        }
        this.mergeDc.Merge(oldEntryRow, newEntryRow);
        this.MergeLocalRate(oldVoucher, oldEntryRow, newEntryRow);
        this.MergePrice(oldEntryRow, newEntryRow);
    }

    private String GetExplanation(IVoucherEntry entryRow) {
        String explanation = this.getExplanation.GetValue(entryRow);
        return explanation;
    }

    private BigDecimal GetLocalExchangeRate(IVoucherEntry entryRow) {
        BigDecimal rate = this.getLocalExchangeRate.GetValue(entryRow);
        return rate;
    }

    private BigDecimal GetPrice(IVoucherEntry entryRow) {
        BigDecimal price = this.getPrice.GetValue(entryRow);
        return price;
    }

    private boolean MergeExplanation(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
        boolean mergeSuccess = this.mergeExplanation.Merge(oldEntryRow, newEntryRow);
        return mergeSuccess;
    }

    private boolean MergeLocalRate(IVoucher<?> oldVoucher, IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
        boolean mergeSuccess = this.mergeLocalRate.Merge(oldVoucher, oldEntryRow, newEntryRow);
        return mergeSuccess;
    }

    private boolean MergePrice(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
        boolean mergeSuccess = this.mergePrice.Merge(oldEntryRow, newEntryRow);
        return mergeSuccess;
    }

    private void BuildGetExplanation() {
        this.getExplanation = this.entryMergeOption.isDescriptionMerge() ? new IGetExplanation(){

            @Override
            public String GetValue(IVoucherEntry entryRow) {
                return "";
            }
        } : new IGetExplanation(){

            @Override
            public String GetValue(IVoucherEntry entryRow) {
                return entryRow.getDescription();
            }
        };
    }

    private void BuildGetLocalExchangeRate() {
        this.getLocalExchangeRate = this.entryMergeOption.isExchangeRateMerge() ? new IGetLocalRate(){

            @Override
            public BigDecimal GetValue(IVoucherEntry entryRow) {
                return new BigDecimal(Integer.toString(9999));
            }
        } : new IGetLocalRate(){

            @Override
            public BigDecimal GetValue(IVoucherEntry entryRow) {
                return entryRow.getLocalExchangeRate();
            }
        };
    }

    private void BuildGetPrice() {
        this.getPrice = this.entryMergeOption.isPriceMerge() ? new IGetPrice(){

            @Override
            public BigDecimal GetValue(IVoucherEntry entryRow) {
                return new BigDecimal(Integer.toString(9999));
            }
        } : new IGetPrice(){

            @Override
            public BigDecimal GetValue(IVoucherEntry entryRow) {
                return entryRow.getPrice();
            }
        };
    }

    private void BuildMergeExplanation() {
        if (!this.entryMergeOption.isDescriptionMerge()) {
            this.mergeExplanation = new IMergeExplanation(){

                @Override
                public boolean Merge(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                    return true;
                }
            };
            return;
        }
        int expUnionType = Integer.parseInt(this.bookInfo.getExplanationUnionType());
        switch (expUnionType) {
            case 0: {
                this.mergeExplanation = new IMergeExplanation(){

                    @Override
                    public boolean Merge(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                        String explanation = UnionGLVoucherHelper.this.bookInfo.getConstExplanation();
                        oldEntryRow.setDescription(explanation);
                        return true;
                    }
                };
                break;
            }
            case 3: {
                this.mergeExplanation = new IMergeExplanation(){

                    @Override
                    public boolean Merge(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                        String oldExp = oldEntryRow.getDescription();
                        if (oldExp.length() >= 1000) {
                            return true;
                        }
                        String newExp = newEntryRow.getDescription();
                        String explanation = MessageFormat.format("{0};{1}", oldExp, newExp);
                        if (explanation.length() > 1000) {
                            explanation = explanation.substring(0, 997) + "...";
                        }
                        oldEntryRow.setDescription(explanation);
                        return true;
                    }
                };
                break;
            }
            case 2: {
                this.mergeExplanation = new IMergeExplanation(){

                    @Override
                    public boolean Merge(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                        String explanation = newEntryRow.getDescription();
                        oldEntryRow.setDescription(explanation);
                        return true;
                    }
                };
                break;
            }
            default: {
                this.mergeExplanation = new IMergeExplanation(){

                    @Override
                    public boolean Merge(IVoucherEntry glVoucherEntry, IVoucherEntry bizVoucherEntry) {
                        return true;
                    }
                };
            }
        }
    }

    private void BuildMergeLocalRate(final Long rateTableId) {
        this.mergeLocalRate = !this.entryMergeOption.isExchangeRateMerge() ? new IMergeLocalRate(){

            @Override
            public boolean Merge(IVoucher<?> voucher, IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                return true;
            }
        } : new IMergeLocalRate(){

            @Override
            public boolean Merge(IVoucher<?> voucher, IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                BigDecimal oriAmount = oldEntryRow.getOriDebit().add(oldEntryRow.getOriCredit());
                BigDecimal localAmount = oldEntryRow.getLocalDebit().add(oldEntryRow.getLocalCredit());
                if (oriAmount.compareTo(BigDecimal.ZERO) == 0) {
                    oldEntryRow.setLocalCredit(BigDecimal.ZERO);
                    oldEntryRow.setLocalDebit(BigDecimal.ZERO);
                    oldEntryRow.setLocalExchangeRate(BigDecimal.ZERO);
                    return false;
                }
                int precision = RateServiceHelper.getExchangeRate((Long)oldEntryRow.getOriCurrencyId(), (Long)voucher.getBookCyId(), (Long)rateTableId, (Date)voucher.getBookedDate()).getPrecision();
                BigDecimal calRate = RateServiceHelper.getRateType((long)oldEntryRow.getOriCurrencyId(), (long)voucher.getBookCyId(), (Date)voucher.getBookedDate()).getRateCalculator().calRate(oriAmount, localAmount, precision);
                oldEntryRow.setLocalExchangeRate(calRate);
                return true;
            }
        };
    }

    private void BuildMergePrice() {
        if (!this.entryMergeOption.isPriceMerge()) {
            this.mergePrice = new IMergePrice(){

                @Override
                public boolean Merge(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                    return true;
                }
            };
        } else {
            final HashMap currencyMap = new HashMap();
            this.mergePrice = new IMergePrice(){

                @Override
                public boolean Merge(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                    BigDecimal oriAmount = oldEntryRow.getOriDebit().add(oldEntryRow.getOriCredit());
                    BigDecimal qty = oldEntryRow.getQty();
                    if (qty.compareTo(BigDecimal.ZERO) == 0) {
                        oldEntryRow.setPrice(BigDecimal.ZERO);
                    } else {
                        DynamicObject curr = (DynamicObject)currencyMap.get(oldEntryRow.getOriCurrencyId());
                        if (curr == null) {
                            curr = BusinessDataServiceHelper.loadSingleFromCache((Object)oldEntryRow.getOriCurrencyId(), (String)"bd_currency", (String)"amtprecision,priceprecision");
                            currencyMap.put(oldEntryRow.getOriCurrencyId(), curr);
                        }
                        BigDecimal price = oriAmount.divide(qty, curr == null ? 4 : curr.getInt("priceprecision"), RoundingMode.HALF_UP);
                        oldEntryRow.setPrice(price);
                    }
                    return true;
                }
            };
        }
    }

    private void buildMergeDc() {
        this.mergeDc = !this.entryMergeOption.isDcMerge() ? new IMergeDc(){

            @Override
            public boolean Merge(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                return true;
            }
        } : new IMergeDc(){

            @Override
            public boolean Merge(IVoucherEntry oldEntryRow, IVoucherEntry newEntryRow) {
                if (oldEntryRow.getDcDirectory() != newEntryRow.getDcDirectory()) {
                    BigDecimal oldQty = oldEntryRow.getQty();
                    BigDecimal newQty = newEntryRow.getQty();
                    BigDecimal qtyBalance = oldQty.multiply(new BigDecimal(oldEntryRow.getDcDirectory())).add(newQty.multiply(new BigDecimal(newEntryRow.getDcDirectory())));
                    if (oldEntryRow.getOriCredit().compareTo(oldEntryRow.getOriDebit()) > 0) {
                        oldEntryRow.setDcDirectory(-1);
                        oldEntryRow.setOriCredit(oldEntryRow.getOriCredit().subtract(oldEntryRow.getOriDebit()));
                        oldEntryRow.setOriDebit(BigDecimal.ZERO);
                        oldEntryRow.setLocalCredit(oldEntryRow.getLocalCredit().subtract(oldEntryRow.getLocalDebit()));
                        oldEntryRow.setLocalDebit(BigDecimal.ZERO);
                        oldEntryRow.setQty(qtyBalance.negate());
                    } else {
                        oldEntryRow.setDcDirectory(1);
                        oldEntryRow.setOriDebit(oldEntryRow.getOriDebit().subtract(oldEntryRow.getOriCredit()));
                        oldEntryRow.setOriCredit(BigDecimal.ZERO);
                        oldEntryRow.setLocalDebit(oldEntryRow.getLocalDebit().subtract(oldEntryRow.getLocalCredit()));
                        oldEntryRow.setLocalCredit(BigDecimal.ZERO);
                        oldEntryRow.setQty(qtyBalance);
                    }
                }
                return true;
            }
        };
    }
}

