/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singlebillaction;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ai.AccountView;
import kd.fi.ai.ExchangeRate;
import kd.fi.ai.VchTplBizGroup;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.enums.GLAccountCurrencyEnum;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.BizVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.helper.BuildHelper;
import kd.fi.ai.mservice.builder.singlebillaction.AbstractSingleBillAction;
import kd.fi.ai.mservice.builder.singlebillaction.IAutoCalAmount;
import kd.fi.ai.mservice.dao.BaseDataLoader;

public class UpdateAmount
extends AbstractSingleBillAction {
    private int localAmountDigits = 2;
    private static final Log logger = LogFactory.getLog(UpdateAmount.class);
    private BigDecimal debitAmountTotal = BigDecimal.ZERO;
    private BigDecimal creditAmountTotal = BigDecimal.ZERO;
    private BigDecimal debitAmountOri = BigDecimal.ZERO;
    private BigDecimal creditAmountOri = BigDecimal.ZERO;
    private boolean isSameOriCurrency = true;
    private IAutoCalAmount autoCalService = this.CreateAutoCalService();

    public UpdateAmount(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
        long localCurrencyId = this.taskContext.getBookInfo().getCyId();
        this.localAmountDigits = this.context.GetAmountDigits(localCurrencyId);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        this.debitAmountTotal = BigDecimal.ZERO;
        this.creditAmountTotal = BigDecimal.ZERO;
        this.debitAmountOri = BigDecimal.ZERO;
        this.creditAmountOri = BigDecimal.ZERO;
        this.isSameOriCurrency = true;
        boolean exchange = true;
        BizVoucher bizVoucher = this.billResult.getNewBizVoucher();
        List entryRows = bizVoucher.getEntryRows();
        entryRows.sort((o1, o2) -> {
            if (o1.getDcDirectory() == 99 && o2.getDcDirectory() != 99) {
                return 1;
            }
            if (o1.getDcDirectory() == 99 && o2.getDcDirectory() == 99) {
                return 0;
            }
            if (o1.getDcDirectory() != 99 && o2.getDcDirectory() == 99) {
                return -1;
            }
            return 0;
        });
        BizVoucherEntry autoBalRow = null;
        int autoRowIndex = -1;
        for (int i = 0; i < entryRows.size(); ++i) {
            BizVoucherEntry entryRow = (BizVoucherEntry)entryRows.get(i);
            if (!entryRow.isAutoBal()) continue;
            autoBalRow = entryRow;
            autoRowIndex = i;
            break;
        }
        if (autoBalRow != null && autoRowIndex >= 0) {
            entryRows.remove(autoRowIndex);
            entryRows.add(autoBalRow);
        }
        Long oriCurrency = null;
        for (BizVoucherEntry entryRow : entryRows) {
            long localCy;
            AccountView account;
            String acctCurrency;
            exchange = this.autoCalService.AutoCal(entryRow);
            if (entryRow.getAutoCalRate().booleanValue() && entryRow.getOriCurrencyId() != this.taskContext.getBookInfo().getCyId() && BuildHelper.isEquals(entryRow.getLocalExchangeRate(), BigDecimal.ONE)) {
                String errMsg = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6c47\u7387\u503c\uff0c\u8bf7\u5148\u7ef4\u62a4\u6c47\u7387\u3002", (String)"UpdateAmount_0", (String)"fi-ai-mservice", (Object[])new Object[0]);
                this.WriteReportDetail(VoucherCheckItem.Rate, VoucherErrLevel.Error, errMsg);
                this.WriteWarnLog(errMsg);
                exchange = false;
            }
            long oriCy = entryRow.getOriCurrencyId();
            long accountId = entryRow.getAccountId();
            if (oriCy != 0L && accountId != 0L && ((acctCurrency = (account = BaseDataLoader.loadAccount((IBuildVchContext)this.context, (Long)accountId)).getAcctCurrency()) == null || GLAccountCurrencyEnum.NO_CURRENCY.getValue().equals(acctCurrency)) && oriCy != (localCy = this.taskContext.getBookInfo().getCyId())) {
                entryRow.setOriCurrencyId(localCy);
                entryRow.setLocalExchangeRate(BigDecimal.ONE);
                entryRow.setOriAmount(entryRow.getLocalAmount());
            }
            if (oriCurrency == null) {
                oriCurrency = entryRow.getOriCurrencyId();
            } else if (this.isSameOriCurrency) {
                boolean bl = this.isSameOriCurrency = oriCurrency.longValue() == entryRow.getOriCurrencyId();
            }
            if (!exchange) {
                this.billResult.setSkipBuildBizVch(true);
                this.billResult.setSkipBuildGLVch(true);
                break;
            }
            this.CalRateByCurrency(entryRow);
            this.CalDebitOrCredit(entryRow);
            this.handleRatePrecision(entryRow);
            if (BuildHelper.isEquals(entryRow.getLocalExchangeRate(), BigDecimal.ONE) && entryRow.getLocalAmount().compareTo(entryRow.getOriAmount()) != 0) {
                this.WirateAmountNotEqual();
            }
            long bookCurrencyId = this.taskContext.getBookInfo().getCyId();
            if (entryRow.getOriCurrencyId() != bookCurrencyId) continue;
            entryRow.setLocalExchangeRate(new BigDecimal(1));
            entryRow.setOriDebit(entryRow.getLocalDebit());
            entryRow.setOriCredit(entryRow.getLocalCredit());
        }
        this.handleAutoCal();
    }

    private void handleRatePrecision(BizVoucherEntry entryRow) {
        ExchangeRate rate = BaseDataLoader.loadExchangeRateEntity((IBuildVchContext)this.context, (long)this.taskContext.getBookInfo().getExchangeTableID(), (long)entryRow.getOriCurrencyId(), (long)this.taskContext.getBookInfo().getCyId(), (Date)this.billResult.getNewBizVoucher().getBookedDate());
        Integer ratePrecision = rate.getPrecision();
        BigDecimal exchangeRate = entryRow.getLocalExchangeRate();
        int scale = exchangeRate.scale();
        if (ratePrecision <= scale) {
            exchangeRate = exchangeRate.setScale((int)ratePrecision, RoundingMode.HALF_UP);
            entryRow.setLocalExchangeRate(exchangeRate);
        }
    }

    private void handleAutoCal() {
        BizVoucher bizVoucher = this.billResult.getNewBizVoucher();
        if (bizVoucher == null) {
            return;
        }
        List entrys = bizVoucher.getEntryRows();
        if (entrys == null || entrys.size() < 2) {
            return;
        }
        boolean hasAutoBal = false;
        BizVoucherEntry autoDirEntryRow = (BizVoucherEntry)entrys.get(entrys.size() - 1);
        if (autoDirEntryRow.isAutoBal()) {
            hasAutoBal = true;
        } else {
            autoDirEntryRow = null;
        }
        Boolean isDebit = null;
        if (!hasAutoBal && this.creditAmountOri.compareTo(this.debitAmountOri) == 0) {
            BizVoucherEntry maxCreditEntry = null;
            BizVoucherEntry maxDebitEntry = null;
            BigDecimal maxCreditLocalAmount = BigDecimal.ZERO;
            BigDecimal maxDebitLocalAmount = BigDecimal.ZERO;
            for (BizVoucherEntry entryRow : bizVoucher.getEntryRows()) {
                if (entryRow.isAutoBal() || !entryRow.getAutoCalLocalAmount().booleanValue() || entryRow.getLocalAmount() == null) continue;
                if (entryRow.getDcDirectory() == -1 && entryRow.getLocalAmount().compareTo(maxCreditLocalAmount) > 0) {
                    maxCreditEntry = entryRow;
                    maxCreditLocalAmount = entryRow.getLocalAmount();
                    continue;
                }
                if (entryRow.getDcDirectory() != 1 || entryRow.getLocalAmount().compareTo(maxDebitLocalAmount) <= 0) continue;
                maxDebitEntry = entryRow;
                maxDebitLocalAmount = entryRow.getLocalAmount();
            }
            if (!(maxCreditEntry == null && maxDebitEntry == null || hasAutoBal || this.creditAmountOri.compareTo(this.debitAmountOri) != 0)) {
                if (maxCreditEntry != null && maxDebitEntry != null) {
                    isDebit = maxDebitLocalAmount.compareTo(maxCreditLocalAmount) > 0;
                } else if (maxCreditEntry != null) {
                    isDebit = false;
                } else if (maxDebitEntry != null) {
                    isDebit = true;
                }
                if (isDebit != null) {
                    BizVoucherEntry bizVoucherEntry = autoDirEntryRow = isDebit != false ? maxDebitEntry : maxCreditEntry;
                }
            }
        }
        if (autoDirEntryRow == null) {
            return;
        }
        int direction = autoDirEntryRow.getDcDirectory();
        BigDecimal needUnCal = BigDecimal.ONE;
        if (autoDirEntryRow.getDcDirectory() == 99) {
            if (isDebit == null) {
                if (this.debitAmountTotal.compareTo(this.creditAmountTotal) > 0) {
                    if (autoDirEntryRow.getLocalAmount().signum() >= 0) {
                        autoDirEntryRow.setDcDirectory(-1);
                    } else {
                        autoDirEntryRow.setDcDirectory(1);
                    }
                } else if (this.debitAmountTotal.compareTo(this.creditAmountTotal) < 0) {
                    if (autoDirEntryRow.getLocalAmount().signum() >= 0) {
                        autoDirEntryRow.setDcDirectory(1);
                    } else {
                        autoDirEntryRow.setDcDirectory(-1);
                    }
                }
            } else {
                autoDirEntryRow.setDcDirectory(isDebit != false ? 1 : -1);
            }
        } else if (isDebit != null && (isDebit.booleanValue() && direction == -1 || !isDebit.booleanValue() && direction == 1)) {
            needUnCal = new BigDecimal(-1);
        }
        if (autoDirEntryRow.getDcDirectory() == 1) {
            this.handleAutoCal(autoDirEntryRow, hasAutoBal, true, needUnCal);
            autoDirEntryRow.setOriDebit(autoDirEntryRow.getOriAmount());
            autoDirEntryRow.setLocalDebit(autoDirEntryRow.getLocalAmount());
            this.debitAmountTotal = this.debitAmountTotal.add(autoDirEntryRow.getLocalAmount());
            this.debitAmountOri = this.debitAmountOri.add(autoDirEntryRow.getOriAmount());
            autoDirEntryRow.setOriCredit(BigDecimal.ZERO);
            autoDirEntryRow.setLocalCredit(BigDecimal.ZERO);
        } else if (autoDirEntryRow.getDcDirectory() == -1) {
            this.handleAutoCal(autoDirEntryRow, hasAutoBal, false, needUnCal);
            autoDirEntryRow.setOriCredit(autoDirEntryRow.getOriAmount());
            autoDirEntryRow.setLocalCredit(autoDirEntryRow.getLocalAmount());
            this.creditAmountTotal = this.creditAmountTotal.add(autoDirEntryRow.getLocalAmount());
            this.creditAmountOri = this.creditAmountOri.add(autoDirEntryRow.getOriAmount());
            autoDirEntryRow.setOriDebit(BigDecimal.ZERO);
            autoDirEntryRow.setLocalDebit(BigDecimal.ZERO);
        }
        if (!BuildHelper.isEquals(autoDirEntryRow.getOriAmount(), BigDecimal.ZERO) && !BuildHelper.isEquals(autoDirEntryRow.getLocalAmount(), BigDecimal.ZERO) && BuildHelper.isEquals(autoDirEntryRow.getLocalExchangeRate(), BigDecimal.ZERO)) {
            ExchangeRate changeRate = BaseDataLoader.loadExchangeRateEntity((IBuildVchContext)this.context, (long)this.taskContext.getBookInfo().getExchangeTableID(), (long)autoDirEntryRow.getOriCurrencyId(), (long)this.taskContext.getBookInfo().getCyId(), (Date)this.billResult.getNewBizVoucher().getBookedDate());
            BigDecimal calRate = changeRate.getRateType().getRateCalculator().calRate(autoDirEntryRow.getOriAmount(), autoDirEntryRow.getLocalAmount(), changeRate.getPrecision().intValue());
            if (this.taskContext.getShowInfo().booleanValue()) {
                logger.info("--DAP--UpdateAmount-40-rate:" + calRate + ";LocalAmount:" + autoDirEntryRow.getLocalAmount() + ";OriAmount:" + autoDirEntryRow.getOriAmount() + ";Precision:" + this.getRateDigits());
            }
            autoDirEntryRow.setLocalExchangeRate(calRate);
            this.handleRatePrecision(autoDirEntryRow);
        }
    }

    private Map<String, Boolean> getTplEntryMap() {
        HashMap<String, Boolean> tplEntryMap = new HashMap<String, Boolean>();
        MainEntityType srcMainET = EntityMetadataCache.getDataEntityType((String)this.billContext.getTaskContext().getTemplate().getSourceBill());
        ArrayList<DynamicProperty> amountProps = new ArrayList<DynamicProperty>();
        this.searchAmountProps((IDataEntityType)srcMainET, amountProps);
        HashSet<String> amountFieldList = new HashSet<String>(amountProps.size());
        for (DynamicProperty prop : amountProps) {
            amountFieldList.add(prop.getName());
        }
        List groups = this.billContext.getTaskContext().getTemplate().getBizGroups();
        for (VchTplBizGroup group : groups) {
            List tplEntrts = group.getVchEntrys();
            for (VchTplEntry entry : tplEntrts) {
                tplEntryMap.put(entry.getId(), amountFieldList.contains(entry.getOriAmountSet()));
            }
        }
        return tplEntryMap;
    }

    private void handleAutoCal(BizVoucherEntry entryRow, boolean hasAutoBal, boolean isDebit, BigDecimal unCalAmount) {
        long oriCurrencyId = entryRow.getOriCurrencyId();
        int oriAmountDigits = this.context.GetAmountDigits(oriCurrencyId);
        if (this.isSameOriCurrency) {
            BigDecimal localAmount = isDebit ? this.creditAmountTotal.subtract(this.debitAmountTotal) : this.debitAmountTotal.subtract(this.creditAmountTotal);
            localAmount = hasAutoBal ? localAmount : localAmount.add(entryRow.getLocalAmount());
            entryRow.setLocalAmount(localAmount.multiply(unCalAmount));
            BigDecimal oriAmount = isDebit ? this.creditAmountOri.subtract(this.debitAmountOri) : this.debitAmountOri.subtract(this.creditAmountOri);
            oriAmount = hasAutoBal ? oriAmount : oriAmount.add(entryRow.getOriAmount());
            entryRow.setOriAmount(oriAmount.multiply(unCalAmount));
        } else {
            BigDecimal localAmount = isDebit ? this.creditAmountTotal.subtract(this.debitAmountTotal) : this.debitAmountTotal.subtract(this.creditAmountTotal);
            localAmount = hasAutoBal ? localAmount : localAmount.add(entryRow.getLocalAmount());
            entryRow.setLocalAmount(localAmount.multiply(unCalAmount));
            if (entryRow.getOriAmount() == null || BigDecimal.ZERO.compareTo(entryRow.getOriAmount()) == 0) {
                BigDecimal oriAmount = localAmount.divide(entryRow.getLocalExchangeRate(), oriAmountDigits, RoundingMode.HALF_UP);
                entryRow.setOriAmount(oriAmount.multiply(unCalAmount));
            }
        }
        this.setScale(entryRow, oriAmountDigits);
    }

    private void searchAmountProps(IDataEntityType entityType, List<DynamicProperty> amountProps) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (prop instanceof EntryProp) {
                this.searchAmountProps(((EntryProp)prop).getItemType(), amountProps);
                continue;
            }
            if (!(prop instanceof AmountProp) || prop.getAlias() == null) continue;
            amountProps.add((DynamicProperty)((AmountProp)prop));
        }
    }

    private void CalRateByCurrency(BizVoucherEntry entryRow) {
        if (entryRow.getOriCurrencyId() == this.taskContext.getBookInfo().getCyId()) {
            entryRow.setLocalExchangeRate(new BigDecimal(1));
        }
    }

    private void CalDebitOrCredit(BizVoucherEntry entryRow) {
        if (entryRow.getDcDirectory() == 99 && !entryRow.isAutoBal()) {
            if (this.debitAmountTotal.compareTo(this.creditAmountTotal) > 0) {
                if (entryRow.getLocalAmount().signum() >= 0) {
                    entryRow.setDcDirectory(-1);
                } else {
                    entryRow.setDcDirectory(1);
                }
            } else if (this.debitAmountTotal.compareTo(this.creditAmountTotal) < 0) {
                if (entryRow.getLocalAmount().signum() >= 0) {
                    entryRow.setDcDirectory(1);
                } else {
                    entryRow.setDcDirectory(-1);
                }
            } else {
                entryRow.setDcDirectory(1);
            }
        }
        if (entryRow.getDcDirectory() == 1) {
            entryRow.setOriDebit(entryRow.getOriAmount());
            entryRow.setLocalDebit(entryRow.getLocalAmount());
            this.debitAmountTotal = this.debitAmountTotal.add(entryRow.getLocalAmount());
            this.debitAmountOri = this.debitAmountOri.add(entryRow.getOriAmount());
            entryRow.setOriCredit(BigDecimal.ZERO);
            entryRow.setLocalCredit(BigDecimal.ZERO);
        } else if (entryRow.getDcDirectory() == -1) {
            entryRow.setOriCredit(entryRow.getOriAmount());
            entryRow.setLocalCredit(entryRow.getLocalAmount());
            this.creditAmountTotal = this.creditAmountTotal.add(entryRow.getLocalAmount());
            this.creditAmountOri = this.creditAmountOri.add(entryRow.getOriAmount());
            entryRow.setOriDebit(BigDecimal.ZERO);
            entryRow.setLocalDebit(BigDecimal.ZERO);
        }
    }

    private IAutoCalAmount CreateAutoCalService() {
        IAutoCalAmount autoCalService = new IAutoCalAmount(){

            @Override
            public boolean AutoCal(BizVoucherEntry entryRow) {
                boolean exchange = UpdateAmount.this.UpdateAmountForUnKnown(entryRow);
                return exchange;
            }
        };
        return autoCalService;
    }

    private boolean UpdateAmountForUnKnown(BizVoucherEntry entryRow) {
        BigDecimal rate;
        long oriCurrencyId = entryRow.getOriCurrencyId();
        int oriAmountDigits = this.context.GetAmountDigits(oriCurrencyId);
        Date bookedDate = this.billResult.getNewBizVoucher().getBookedDate();
        if (this.taskContext.getShowInfo().booleanValue()) {
            logger.info("--DAP--UpdateAmount--startUpdateAmountForUnKnown----oriCurrencyId:" + oriCurrencyId);
        }
        ExchangeRate eRate = BaseDataLoader.loadExchangeRateEntity((IBuildVchContext)this.context, (long)this.taskContext.getBookInfo().getExchangeTableID(), (long)oriCurrencyId, (long)this.taskContext.getBookInfo().getCyId(), (Date)bookedDate);
        if (entryRow.getAutoCalRate().booleanValue()) {
            BigDecimal bigDecimal = rate = eRate.getRate() != null ? eRate.getRate() : new BigDecimal(0);
            if (this.taskContext.getShowInfo().booleanValue()) {
                logger.info("--DAP--UpdateAmount-31-rate:" + rate + ";LocalAmount:" + entryRow.getLocalAmount() + ";OriAmount:" + entryRow.getOriAmount() + ";Precision:" + eRate.getPrecision());
            }
            entryRow.setLocalExchangeRate(rate);
            this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u81ea\u52a8\u8ba1\u7b97\u6c47\u7387\uff08\u53d6\u6c47\u7387\uff09\uff1a%s\u3002", (String)"UpdateAmount_1", (String)"fi-ai-mservice", (Object[])new Object[0]), rate.toString()));
        }
        if (entryRow.getLocalAmount().compareTo(BigDecimal.ZERO) != 0 && entryRow.getLocalExchangeRate() == null) {
            this.WriteReportDetail(VoucherCheckItem.Amount, VoucherErrLevel.Error, ResManager.loadKDString((String)"\u6c47\u7387\u53d6\u503c\u4e3a\u7a7a\u3002", (String)"UpdateAmount_2", (String)"fi-ai-mservice", (Object[])new Object[0]));
            return false;
        }
        if (entryRow.getLocalAmount().compareTo(BigDecimal.ZERO) == 0 && entryRow.getLocalExchangeRate() == null) {
            entryRow.setLocalExchangeRate(BigDecimal.ZERO);
        }
        if (entryRow.getOriAmount() == null) {
            this.WriteReportDetail(VoucherCheckItem.Amount, VoucherErrLevel.Error, ResManager.loadKDString((String)"\u539f\u5e01\u53d6\u503c\u4e3a\u7a7a\u3002", (String)"UpdateAmount_3", (String)"fi-ai-mservice", (Object[])new Object[0]));
            return false;
        }
        if (entryRow.getLocalAmount() == null) {
            this.WriteReportDetail(VoucherCheckItem.Amount, VoucherErrLevel.Error, ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u53d6\u503c\u4e3a\u7a7a\u3002", (String)"UpdateAmount_4", (String)"fi-ai-mservice", (Object[])new Object[0]));
            return false;
        }
        if (!BuildHelper.isEquals(entryRow.getLocalExchangeRate(), BigDecimal.ZERO)) {
            if (entryRow.getAutoCalOriAmount().booleanValue() && entryRow.getAutoCalLocalAmount().booleanValue()) {
                if (!entryRow.isAutoBal()) {
                    this.WriteReportDetail(VoucherCheckItem.Amount, VoucherErrLevel.Error, ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d\u3001\u672c\u4f4d\u5e01\u91d1\u989d\uff0c\u4e0d\u80fd\u540c\u65f6\u8bbe\u7f6e\u4e3a\u81ea\u52a8\u8ba1\u7b97\u3002", (String)"UpdateAmount_5", (String)"fi-ai-mservice", (Object[])new Object[0]));
                    this.WriteWarnLog(ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d\u3001\u672c\u4f4d\u5e01\u91d1\u989d\uff0c\u4e0d\u80fd\u540c\u65f6\u8bbe\u7f6e\u4e3a\u81ea\u52a8\u8ba1\u7b97\u3002", (String)"UpdateAmount_5", (String)"fi-ai-mservice", (Object[])new Object[0]));
                    return false;
                }
            } else if (entryRow.getAutoCalOriAmount().booleanValue()) {
                rate = eRate.getRate() != null ? eRate.getRate() : new BigDecimal(0);
                BigDecimal oriAmount = eRate.getRateType().getRateCalculator().calOriAmount(entryRow.getLocalExchangeRate(), entryRow.getLocalAmount(), oriAmountDigits);
                BigDecimal bigDecimal = oriAmount = oriAmount != null ? oriAmount : new BigDecimal(0);
                if (this.taskContext.getShowInfo().booleanValue()) {
                    logger.info("--DAP--UpdateAmount-32-rate:" + rate + ";LocalAmount:" + entryRow.getLocalAmount() + ";OriAmount:" + entryRow.getOriAmount() + ";Precision:" + eRate.getPrecision() + ";neworiAmount" + oriAmount + ";localrate:" + entryRow.getLocalExchangeRate());
                }
                entryRow.setOriAmount(oriAmount);
                String logMessage = ResManager.loadKDString((String)"\u81ea\u52a8\u8ba1\u7b97\u539f\u5e01\u91d1\u989d\uff1a\u8bb0\u8d26\u672c\u4f4d\u5e01{0} / \u6c47\u7387 {1} = {2}", (String)"UpdateAmount_7", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, entryRow.getLocalAmount().toString(), entryRow.getLocalExchangeRate().toString(), oriAmount.toString());
                this.WriteInfoLog(logMessage);
            } else if (entryRow.getAutoCalLocalAmount().booleanValue()) {
                rate = eRate.getRate() != null ? eRate.getRate() : new BigDecimal(0);
                BigDecimal localAmount = eRate.getRateType().getRateCalculator().calLocAmount(entryRow.getLocalExchangeRate(), entryRow.getOriAmount(), this.localAmountDigits);
                BigDecimal bigDecimal = localAmount = localAmount != null ? localAmount : new BigDecimal(0);
                if (this.taskContext.getShowInfo().booleanValue()) {
                    logger.info("--DAP--UpdateAmount-33-rate:" + rate + ";LocalAmount:" + entryRow.getLocalAmount() + ";OriAmount:" + entryRow.getOriAmount() + ";Precision:" + eRate.getPrecision() + ";newlocalAmount" + localAmount + ";LocalExchangeRate" + entryRow.getLocalExchangeRate());
                }
                entryRow.setLocalAmount(localAmount);
                String logMessage = ResManager.loadKDString((String)"\u81ea\u52a8\u8ba1\u7b97\u8bb0\u8d26\u672c\u4f4d\u5e01\uff1a\u539f\u5e01\u91d1\u989d{0} * \u6c47\u7387 {1} = {2}", (String)"UpdateAmount_8", (String)"fi-ai-mservice", (Object[])new Object[0]);
                logMessage = MessageFormat.format(logMessage, entryRow.getOriAmount().toString(), entryRow.getLocalExchangeRate().toString(), localAmount.toString());
                this.WriteInfoLog(logMessage);
            }
        }
        this.setScale(entryRow, oriAmountDigits);
        if (BuildHelper.isEquals(entryRow.getLocalExchangeRate(), BigDecimal.ZERO) && !BuildHelper.isEquals(entryRow.getOriAmount(), BigDecimal.ZERO)) {
            BigDecimal calRate = eRate.getRateType().getRateCalculator().calRate(entryRow.getOriAmount(), entryRow.getLocalAmount(), this.getRateDigits());
            BigDecimal bigDecimal = calRate = calRate != null ? calRate : new BigDecimal(0);
            if (this.taskContext.getShowInfo().booleanValue()) {
                logger.info("--DAP--UpdateAmount-34-rate:" + calRate + ";LocalAmount:" + entryRow.getLocalAmount() + ";OriAmount:" + entryRow.getOriAmount() + ";Precision:" + eRate.getPrecision() + ";newRateDigits" + this.getRateDigits());
            }
            entryRow.setLocalExchangeRate(calRate);
            String logMessage = ResManager.loadKDString((String)"\u5012\u7b97\u6c47\u7387\uff1a\u8bb0\u8d26\u672c\u4f4d\u5e01\u91d1\u989d{0} / \u539f\u5e01\u91d1\u989d {1} = {2}", (String)"UpdateAmount_9", (String)"fi-ai-mservice", (Object[])new Object[0]);
            logMessage = MessageFormat.format(logMessage, entryRow.getLocalAmount().toString(), entryRow.getOriAmount().toString(), entryRow.getLocalExchangeRate().toString());
            this.WriteInfoLog(logMessage);
        }
        return true;
    }

    private int getRateDigits() {
        return 4;
    }

    private void setScale(BizVoucherEntry entryRow, int oriAmountDigits) {
        entryRow.setOriAmount(entryRow.getOriAmount().setScale(oriAmountDigits, RoundingMode.HALF_UP));
        entryRow.setLocalAmount(entryRow.getLocalAmount().setScale(this.localAmountDigits, RoundingMode.HALF_UP));
    }

    private void WriteGetRateFailLog(long rateType, long currencyFromId, long currencyTo, Date bookedDate) {
        this.billResult.setSkipBuildBizVch(true);
        this.billResult.setSkipBuildGLVch(true);
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u6c47\u7387\u4fe1\u606f\uff0c\u53ef\u80fd\u539f\u56e0\uff1a%1$s1\u3001\u6c47\u7387\u4f53\u7cfb\u4e2d\u4e0d\u5b58\u5728\u76f8\u5e94\u6c47\u7387\uff1b%1$s2\u3001\u6c47\u7387\u4f53\u7cfb\u4e2d\u7684\u6c47\u7387\u672a\u5ba1\u6838\uff1b%1$s3\u3001\u6c47\u7387\u8f6c\u6362\u65f6\u672a\u627e\u5230\u5bf9\u5e94\u4e2d\u95f4\u5e01\uff0c\u5bfc\u81f4\u6c47\u7387\u8f6c\u6362\u4e0d\u6210\u529f\u3002", (String)"UpdateAmount_18", (String)"fi-ai-mservice", (Object[])new Object[0]), "\r\n"));
        this.WriteReportDetail(VoucherCheckItem.Rate, VoucherErrLevel.Error, sBuilder.toString());
        this.WriteWarnLog(sBuilder.toString());
    }

    private void WirateAmountNotEqual() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d\u4e58\u4ee5\u6c47\u7387\u4e0d\u7b49\u4e8e\u672c\u4f4d\u5e01\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u3002", (String)"UpdateAmount_22", (String)"fi-ai-mservice", (Object[])new Object[0]));
        this.WriteReportDetail(VoucherCheckItem.Amount, VoucherErrLevel.Warning, sBuilder.toString());
        this.WriteWarnLog(sBuilder.toString());
    }
}

