/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletaskaction;

import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.VarcharProp;
import kd.bos.ext.fi.ai.dap.customfilter.RelationBillCustomFilterImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.mservice.builder.buildresult.BizVoucher;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.singletaskaction.AbstractSingleTaskAction;
import kd.fi.ai.mservice.util.BuildVoucherUtils;
import kd.fi.ai.util.AiCommonFieldUtils;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.v2.fah.services.dto.FailLockRelationBill;

public class LoadBizVoucherByBillIdAction
extends AbstractSingleTaskAction {
    private MainEntityType srcEntityType;
    private static Log log = LogFactory.getLog(LoadBizVoucherByBillIdAction.class);
    private static final String REBILL_MAXSIZE = "rebillmaxsize";

    public LoadBizVoucherByBillIdAction(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u52a0\u8f7d\u6e90\u5355\u5df2\u7ecf\u751f\u6210\u597d\u7684\u4e1a\u52a1\u51ed\u8bc1", (String)"LoadBizVoucherByBillIdAction_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        this.taskResult.getCustomKey().putAll(this.taskContext.getCustomKey());
        this.taskResult.getRelationshipSourcebillcol().addAll(this.taskContext.getTemplate().getRelationshipSourcebillcol());
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info("--DAP--this.taskResult.getCustomKey().size:" + this.taskResult.getCustomKey().size());
        }
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info("--DAP--this.taskResult.getCustomKey():" + this.taskResult.getCustomKey());
        }
        this.srcEntityType = this.taskContext.getSrcEntityType();
        List<Long> bizVoucherIds = this.LoadBizVoucherIds();
        Map<Object, List<BizVoucher>> histBizVouchers = this.taskResult.getHistBizVouchers();
        if (bizVoucherIds.size() > 0) {
            if (this.taskContext.getShowInfo().booleanValue()) {
                log.info("\u52a0\u8f7d\u8bfb\u53d6\u6240\u9009\u6e90\u5355\uff0c\u5f53\u524d\u8d26\u7c3f\u3001\u671f\u95f4\uff0c\u5df2\u7ecf\u751f\u6210\u7684\u4e1a\u52a1\u51ed\u8bc1\u5185\u7801\uff1a{}", bizVoucherIds);
            }
            IDataEntityType bizVoucherType = OrmUtils.getDataEntityType(BizVoucher.class);
            Object[] bizVouchers = BusinessDataServiceHelper.load((Object[])bizVoucherIds.toArray(), (IDataEntityType)bizVoucherType);
            ArrayList<BizVoucher> notNeedDeleteBizvoucher = new ArrayList<BizVoucher>();
            HashSet<Long> voucherIds = new HashSet<Long>(bizVouchers.length);
            List exsitVoucheIds = new ArrayList(bizVouchers.length);
            for (Object item : bizVouchers) {
                voucherIds.add(((BizVoucher)item).getGlVoucherId());
            }
            exsitVoucheIds = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter("id", "in", voucherIds).toArray(), null, (int)-1);
            ArrayList<Long> needDeleteBizVoucherIds = new ArrayList<Long>();
            HashSet exsitVoucherIdSet = new HashSet(exsitVoucheIds);
            for (Object item : bizVouchers) {
                BizVoucher bizVoucher = (BizVoucher)item;
                Long glVoucherId = bizVoucher.getGlVoucherId();
                if (glVoucherId > 0L && !exsitVoucherIdSet.contains(glVoucherId)) {
                    needDeleteBizVoucherIds.add(bizVoucher.getId());
                    continue;
                }
                if (this.taskContext.isBuildBizvoucherFromMidle()) continue;
                notNeedDeleteBizvoucher.add(bizVoucher);
            }
            try (TXHandle h = TX.requiresNew();){
                try {
                    DeleteServiceHelper.delete((IDataEntityType)bizVoucherType, (Object[])needDeleteBizVoucherIds.toArray());
                }
                catch (Exception e) {
                    h.markRollback();
                    log.info("DeleteServiceHelper.delete,{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
            for (BizVoucher bizVoucher : notNeedDeleteBizvoucher) {
                bizVoucher.setTmpGuid(UUID.randomUUID().toString());
                Object billId = this.taskResult.getSrcBillIdGetHandle().GetBillId(bizVoucher);
                List<BizVoucher> billBizs = histBizVouchers.get(billId);
                if (billBizs == null) {
                    billBizs = new ArrayList<BizVoucher>();
                    histBizVouchers.put(billId, billBizs);
                }
                billBizs.add(bizVoucher);
            }
        }
        HashMap<Long, Set<Long>> batchSecond = new HashMap<Long, Set<Long>>();
        for (Object billId : this.taskContext.getSrcBillIds()) {
            if (this.taskResult.getHistBizVouchers().containsKey(billId)) {
                List<BizVoucher> billBizs = histBizVouchers.get(billId);
                if (this.needRebuild(billBizs)) {
                    this.taskResult.getSrcBillIdsNeedBuild().add(billId);
                    for (BizVoucher bv : billBizs) {
                        this.taskResult.getDelBizVoucherIds().add(bv.getId());
                    }
                }
            } else {
                this.taskResult.getSrcBillIdsNeedBuild().add(billId);
            }
            if (!this.taskResult.getSrcBillIdsNeedBuild().contains(billId)) continue;
            if (StringUtils.isNotBlank((CharSequence)this.taskContext.getTemplate().getRelationshipSourcebill()) && StringUtils.isBlank((CharSequence)this.taskContext.getTemplate().getSourceField())) {
                this.getRelationBill(billId, batchSecond);
            }
            if (this.taskContext.getTemplate().getRelationshipSourcebillcol() == null || this.taskContext.getTemplate().getRelationshipSourcebillcol().size() <= 0 || !this.taskContext.getTemplate().getSourceAndTargetFieldcol().isEmpty()) continue;
            this.getRelationBills(billId, batchSecond);
        }
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info(ResManager.loadKDString((String)"\u9700\u8981\u751f\u6210\u51ed\u8bc1\u7684\u6e90\u5355\u96c6\u5408\uff1a{}", (String)"LoadBizVoucherByBillIdAction_11", (String)"fi-ai-mservice", (Object[])new Object[0]), this.taskResult.getSrcBillIdsNeedBuild());
        }
        if (!batchSecond.isEmpty()) {
            HashMap bscol = new HashMap();
            batchSecond.entrySet().stream().forEach(f -> bscol.put(f.getKey(), new ArrayList((Collection)f.getValue())));
            this.taskResult.getSecondBillId().putAll(bscol);
        }
        if (StringUtils.isNotBlank((CharSequence)this.taskContext.getTemplate().getSourceField()) && StringUtils.isNotBlank((CharSequence)this.taskContext.getTemplate().getTargetField())) {
            this.getCommonField(this.taskResult.getSrcBillIdsNeedBuild());
        }
        if (this.taskContext.getTemplate().getSourceAndTargetFieldcol() != null && this.taskContext.getTemplate().getSourceAndTargetFieldcol().size() > 0) {
            this.getReCommonField(this.taskResult.getSrcBillIdsNeedBuild());
        }
        if (!this.taskResult.getSecondBillId().isEmpty()) {
            this.putSecondBillcol(this.taskResult.getSecondBillId());
        }
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info(ResManager.loadKDString((String)"\u9700\u8981\u751f\u6210\u51ed\u8bc1\u7684\u5173\u8054\u5355\u636e\u96c6\u5408\uff1a{}", (String)"LoadBizVoucherByBillIdAction_12", (String)"fi-ai-mservice", (Object[])new Object[0]), this.taskResult.getSecondBillId().values());
        }
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info(ResManager.loadKDString((String)"\u9700\u8981\u751f\u6210\u51ed\u8bc1\u7684\u5173\u8054\u5355\u636e\u96c6\u5408\u5927\u5c0f\uff1a{}", (String)"LoadBizVoucherByBillIdAction_13", (String)"fi-ai-mservice", (Object[])new Object[0]), (Object)this.taskResult.getSecondBillId().size());
        }
        String message = ResManager.loadKDString((String)"\u5171\u6709{0}\u5f20\u6e90\u5355\uff0c\u5df2\u751f\u6210{1}\u5f20\u4e1a\u52a1\u51ed\u8bc1\uff08\u5176\u4e2d{2}\u5f20\u9700\u8981\u91cd\u65b0\u751f\u6210\uff09\uff0c\u672c\u6b21\u9700\u8981\u5904\u7406{3}\u5f20\u6e90\u5355", (String)"LoadBizVoucherByBillIdAction_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
        message = MessageFormat.format(message, this.taskContext.getSrcBillIds().size(), this.taskResult.getHistBizVouchers().size(), this.taskResult.getDelBizVoucherIds().size(), this.taskResult.getSrcBillIdsNeedBuild().size());
        this.WriteInfoLog(message);
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info("--DAP--" + message);
        }
    }

    private List<Long> LoadBizVoucherIds() {
        String idString;
        StringBuilder sqlReadBDInfo = new StringBuilder();
        sqlReadBDInfo.append("select fid from t_ai_bizvoucher ");
        sqlReadBDInfo.append("where fbookid = ? and fsourcebill = ? ");
        Object[] params = new Object[]{this.taskContext.getBookInfo().getBookId(), this.taskContext.getSourceBill().getEntityNumber()};
        if (this.srcEntityType.getPrimaryKey() instanceof VarcharProp) {
            idString = StringUtils.join((Object[])this.taskContext.getSrcBillIds().toArray(), (String)"','");
            sqlReadBDInfo.append(" and fstrsourcebillid in ('").append(idString).append("')");
        } else {
            idString = StringUtils.join((Object[])this.taskContext.getSrcBillIds().toArray(), (String)",");
            sqlReadBDInfo.append(" and fsourcebillid in (").append(idString).append(")");
        }
        List bizVoucherIds = (List)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)sqlReadBDInfo.toString(), (Object[])params, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet reader) throws Exception {
                ArrayList<Long> rows = new ArrayList<Long>(1000);
                while (reader.next()) {
                    Long bizVoucherId = reader.getLong("fid");
                    rows.add(bizVoucherId);
                }
                return rows;
            }
        });
        return bizVoucherIds;
    }

    private boolean needRebuild(List<BizVoucher> bizVouchers) {
        if (this.taskContext.getSourceBill().isMultiDap()) {
            if (!this.taskContext.getSourceBill().isIgnoreTemplateUnique()) {
                for (BizVoucher bv : bizVouchers) {
                    if (bv.getGlVoucherId() <= 0L || !bv.getTemplateId().equalsIgnoreCase(this.taskContext.getTemplate().getId())) continue;
                    return false;
                }
            }
            return true;
        }
        BizVoucher bizVoucher = bizVouchers.get(0);
        boolean reBuild = false;
        long glVoucherId = bizVoucher.getGlVoucherId();
        boolean exStatus = bizVoucher.isError();
        boolean autoCoverExBizVch = true;
        if (glVoucherId == 0L && exStatus && autoCoverExBizVch) {
            reBuild = true;
        }
        return reBuild;
    }

    private void getRelationBill(Object billId, Map<Long, Set<Long>> batchSecond) {
        Map sourceBill = BFTrackerServiceHelper.findSourceBills((String)this.taskContext.getTemplate().getSourceBill(), (Long[])new Long[]{Long.valueOf(billId + "")});
        Set secondIds = null;
        if (!sourceBill.isEmpty()) {
            secondIds = (Set)sourceBill.get(this.taskContext.getTemplate().getRelationshipSourcebill());
        }
        if (secondIds == null) {
            sourceBill = BFTrackerServiceHelper.findTargetBills((String)this.taskContext.getTemplate().getSourceBill(), (Long[])new Long[]{Long.valueOf(billId + "")});
            secondIds = (Set)sourceBill.get(this.taskContext.getTemplate().getRelationshipSourcebill());
        }
        batchSecond.put(Long.parseLong(billId.toString()), secondIds);
        if (secondIds == null) {
            Map otherUpInfo = null;
            for (Map.Entry entry : sourceBill.entrySet()) {
                HashSet setCol;
                String key = (String)entry.getKey();
                otherUpInfo = BFTrackerServiceHelper.findSourceBills((String)key, (Long[])((HashSet)entry.getValue()).toArray(new Long[0]));
                if (otherUpInfo.isEmpty()) continue;
                secondIds = (Set)sourceBill.get(this.taskContext.getTemplate().getRelationshipSourcebill());
                Set<Long> setValue = batchSecond.get(Long.parseLong(billId.toString()));
                HashSet hashSet = setCol = setValue != null ? (HashSet)setValue : new HashSet();
                if (secondIds != null) {
                    setCol.addAll(secondIds);
                }
                batchSecond.put(Long.parseLong(billId.toString()), setCol);
            }
        }
    }

    private void getRelationBills(Object billId, Map<Long, Set<Long>> batchSecond) {
        List relationshipSourcebillcol = this.taskContext.getTemplate().getRelationshipSourcebillcol();
        Map sourceBill = BFTrackerServiceHelper.findSourceBills((String)this.taskContext.getTemplate().getSourceBill(), (Long[])new Long[]{Long.valueOf(billId + "")});
        HashSet secondIds = new HashSet();
        if (!sourceBill.isEmpty()) {
            for (String relationbill : relationshipSourcebillcol) {
                if (sourceBill.get(relationbill) == null) continue;
                secondIds.addAll((Collection)sourceBill.get(relationbill));
            }
        }
        if (!(sourceBill = BFTrackerServiceHelper.findTargetBills((String)this.taskContext.getTemplate().getSourceBill(), (Long[])new Long[]{Long.valueOf(billId + "")})).isEmpty()) {
            for (String relationbill : relationshipSourcebillcol) {
                if (sourceBill.get(relationbill) == null) continue;
                secondIds.addAll((Collection)sourceBill.get(relationbill));
            }
        }
        batchSecond.put(Long.parseLong(billId.toString()), secondIds);
        if (secondIds.isEmpty()) {
            Map otherUpInfo = null;
            for (Map.Entry entry : sourceBill.entrySet()) {
                String key = (String)entry.getKey();
                otherUpInfo = BFTrackerServiceHelper.findSourceBills((String)key, (Long[])((HashSet)entry.getValue()).toArray(new Long[0]));
                if (otherUpInfo.isEmpty()) continue;
                for (String relationbill : relationshipSourcebillcol) {
                    if (sourceBill.get(relationbill) == null) continue;
                    secondIds.addAll((Collection)sourceBill.get(relationbill));
                }
                Set<Long> setValue = batchSecond.get(Long.parseLong(billId.toString()));
                HashSet setCol = setValue != null ? (HashSet)setValue : new HashSet();
                setCol.addAll(secondIds);
                batchSecond.put(Long.parseLong(billId.toString()), setCol);
            }
        }
    }

    private void putSecondBillcol(Map<Object, List<Long>> secondBillId) {
        List relationshipSourcebillcol = this.taskContext.getTemplate().getRelationshipSourcebillcol();
        String relationshipSourcebill = this.taskContext.getTemplate().getRelationshipSourcebill();
        if (relationshipSourcebill != null && !relationshipSourcebill.equals("") && !relationshipSourcebill.equals(" ")) {
            relationshipSourcebillcol.add(relationshipSourcebill);
        }
        Map multiRelationGroupMap = AiCommonFieldUtils.multiRelationGroupMap(secondBillId, (List)relationshipSourcebillcol);
        HashMap<Object, List> onlyGetDataCol = new HashMap<Object, List>(16);
        HashMap<Object, List<Long>> secondBillVoucherId = new HashMap<Object, List<Long>>(16);
        HashMap buildVchIds = new HashMap();
        for (Map.Entry mrg : multiRelationGroupMap.entrySet()) {
            String string = (String)mrg.getKey();
            Map localBuildVchIds = AiCommonFieldUtils.getBuildVchIds((String)string, new ArrayList((Collection)mrg.getValue()));
            buildVchIds.putAll(localBuildVchIds);
            List voucherIds = secondBillVoucherId.computeIfAbsent(string + "-voucher", m -> new ArrayList(8));
            if (localBuildVchIds.isEmpty()) continue;
            for (List bv : localBuildVchIds.values()) {
                if (bv.isEmpty()) continue;
                onlyGetDataCol.computeIfAbsent("gl_voucher", m -> new ArrayList(8)).addAll(bv);
                voucherIds.addAll(bv);
            }
        }
        this.taskResult.setSecondBillVoucherId(secondBillVoucherId);
        ArrayList<String> billtypeCol = new ArrayList<String>(multiRelationGroupMap.size());
        Throwable throwable = null;
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.builder.singletaskaction.LoadBizVoucherByBillIdAction", (String)"ai_dapconfig", (String)"onlygetdata,billentity,billentity.id", (QFilter[])new QFilter("billentity", "in", multiRelationGroupMap.keySet()).toArray(), null);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Boolean isonlygetdata = false;
                try {
                    Object ogd = row.get("onlygetdata");
                    isonlygetdata = StringUtils.isNotBlank((Object)ogd) ? (Boolean)ogd : false;
                }
                catch (Exception e) {
                    isonlygetdata = false;
                }
                if (!isonlygetdata.booleanValue()) continue;
                Object object = row.get("billentity.id");
                onlyGetDataCol.put(object, new ArrayList((Collection)multiRelationGroupMap.get(object)));
                billtypeCol.add(object.toString());
            }
        }
        catch (Throwable iterator) {
            Throwable throwable2 = iterator;
            throw iterator;
        }
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info("--DAP--onlyGetDataCol:" + onlyGetDataCol + ";size:" + onlyGetDataCol.size());
        }
        this.taskResult.getOnlygetDataIds().putAll(onlyGetDataCol);
        for (Object e : billtypeCol) {
            multiRelationGroupMap.remove(e);
        }
        Map<Long, Set<Long>> batchTryLockData = BuildVoucherUtils.batchRequireLockData_mutext(this.taskContext, secondBillId, multiRelationGroupMap);
        Long l = this.taskContext.getBookInfo().getBookTypeId();
        this.generateLockFailedReport(batchTryLockData, secondBillId, multiRelationGroupMap);
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info("--DAP--batchTryLockData:" + batchTryLockData + ";billtypes:" + relationshipSourcebillcol + ";booktype:" + l);
        }
        Map checkNeedBuildVoucherBillStatus = AiCommonFieldUtils.checkNeedBuildVoucherBillStatus(batchTryLockData, (List)relationshipSourcebillcol, (Long)l, (!this.taskContext.isBuildBizvoucherFromMidle() ? 1 : 0) != 0);
        HashMap rebillCol = new HashMap(secondBillId.size());
        HashSet allonlygetdatacol = new HashSet(8);
        for (List list : onlyGetDataCol.values()) {
            allonlygetdatacol.addAll(list);
        }
        for (Map.Entry entry : secondBillId.entrySet()) {
            List reids = (List)entry.getValue();
            Object id = entry.getKey();
            List<Long> checkSuccBill = checkNeedBuildVoucherBillStatus.get(id) != null ? (List)checkNeedBuildVoucherBillStatus.get(id) : new ArrayList(8);
            for (Long ri : reids) {
                if (allonlygetdatacol.contains(ri)) {
                    checkSuccBill.add(ri);
                }
                if (!buildVchIds.containsKey(ri)) continue;
                checkSuccBill.addAll((Collection)buildVchIds.get(ri));
            }
            if (checkSuccBill.isEmpty()) continue;
            rebillCol.put(id, checkSuccBill);
        }
        this.taskResult.getSecondBillId().clear();
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info("--DAP--rebillCol.size:" + rebillCol.size() + ";rebillCol:" + rebillCol);
        }
        this.taskResult.getSecondBillId().putAll(rebillCol);
    }

    private void generateLockFailedReport(Map<Long, Set<Long>> batchTryLockData, Map<Object, List<Long>> secondBillId, Map<String, Set<Long>> multiRelationGroupMap) {
        HashMap<String, List> failReBillTypeToReId = new HashMap<String, List>();
        HashMap<Object, List> failMainIdToReId = new HashMap<Object, List>();
        batchTryLockData.forEach((mainId, reIds) -> {
            if (reIds.size() < ((List)secondBillId.get(mainId)).size()) {
                HashSet failLockReIds = new HashSet((Collection)secondBillId.get(mainId));
                failLockReIds.removeAll((Collection<?>)reIds);
                for (Long failLockReId : failLockReIds) {
                    List reBillTypes = multiRelationGroupMap.entrySet().stream().filter(c -> ((Set)c.getValue()).contains(failLockReId)).map(Map.Entry::getKey).collect(Collectors.toList());
                    for (String reBillType : reBillTypes) {
                        failReBillTypeToReId.computeIfAbsent(reBillType, k -> new LinkedList()).add(failLockReId);
                        failMainIdToReId.computeIfAbsent(mainId, k -> new LinkedList()).add(new FailLockRelationBill(failLockReId, reBillType));
                    }
                }
            }
        });
        HashMap failBillToBillNo = new HashMap();
        failReBillTypeToReId.forEach((reBillType, failLockReIds) -> {
            String pkKey = EntityMetadataCache.getDataEntityType((String)reBillType).getPrimaryKey().getName();
            String billNoKey = DapBuildVoucherCommonUtil.getBillNoFormBill((String)reBillType);
            try (DataSet rows = QueryServiceHelper.queryDataSet((String)"", (String)reBillType, (String)(pkKey + "," + billNoKey), (QFilter[])new QFilter[]{new QFilter(pkKey, "in", failLockReIds)}, null);){
                rows.forEach(row -> failBillToBillNo.computeIfAbsent(new FailLockRelationBill(row.getLong(pkKey), reBillType), k -> row.getString(billNoKey)));
            }
        });
        failMainIdToReId.forEach((mainId, failReBills) -> {
            HashMap<String, List> failBillToNum = new HashMap<String, List>();
            failReBills.forEach(failReBill -> failBillToNum.computeIfAbsent(failReBill.getBillType(), k -> new LinkedList()).add(failBillToBillNo.get(failReBill)));
            failBillToNum.forEach((reBillType, failBillNos) -> {
                String reBillName = EntityMetadataCache.getDataEntityType((String)reBillType).getDisplayName().toString();
                this.context.getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), mainId, null, this.taskContext.getTemplate() == null ? null : this.taskContext.getTemplate().getId(), VoucherCheckItem.AcctItem, VoucherErrLevel.Warning, String.format(ResManager.loadKDString((String)"\u5173\u8054\u5355%1$s\u201c%2$s\u201d\u52a0\u9501\u5931\u8d25\uff0c\u8be6\u7ec6\u4fe1\u606f\u8bf7\u67e5\u770b\u5173\u8054\u5355\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u3002", (String)"LoadBizVoucherByBillIdAction_2", (String)"fi-ai-mservice", (Object[])new Object[0]), reBillName, StringUtils.join((Object[])failBillNos.toArray(), (char)',')), this.taskContext.getBuildType(), this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "");
            });
        });
    }

    private void getCommonField(HashSet<Object> billIds) {
        String sourceF = this.taskContext.getTemplate().getSourceField();
        String targetF = this.taskContext.getTemplate().getTargetField();
        HashMap<Object, List> sourceFieldInfo = new HashMap<Object, List>();
        DynamicObjectCollection sourceField = QueryServiceHelper.query((String)this.taskContext.getTemplate().getSourceBill(), (String)("id," + sourceF), (QFilter[])new QFilter("id", "in", billIds).toArray());
        for (DynamicObject field : sourceField) {
            List list = sourceFieldInfo.computeIfAbsent(field.get(sourceF), k -> new ArrayList());
            list.add(field.getLong("id"));
        }
        HashMap<Object, List> targetFieldInfo = new HashMap<Object, List>();
        DynamicObjectCollection targetField = QueryServiceHelper.query((String)this.taskContext.getTemplate().getRelationshipSourcebill(), (String)("id," + targetF), (QFilter[])new QFilter(targetF, "in", sourceFieldInfo.keySet()).toArray());
        for (DynamicObject field : targetField) {
            List list = targetFieldInfo.computeIfAbsent(field.get(targetF), k -> new ArrayList());
            list.add(field.getLong("id"));
        }
        for (Map.Entry entry : sourceFieldInfo.entrySet()) {
            if (targetFieldInfo.get(entry.getKey()) == null) continue;
            for (Long id : (List)entry.getValue()) {
                this.taskResult.getSecondBillId().put(id, (List<Long>)targetFieldInfo.get(entry.getKey()));
            }
        }
    }

    private void getReCommonField(HashSet<Object> billIds) {
        String sourceBill = this.taskContext.getTemplate().getSourceBill();
        HashMap sourceAndTargetFieldMap = new HashMap(8);
        this.taskContext.getTemplate().getSourceAndTargetFieldcol().entrySet().stream().filter(f -> !((String)f.getKey()).equalsIgnoreCase("str") && f.getValue() != null).forEach(m -> {
            Map fieldMap = (Map)SerializationUtils.fromJsonString((String)((String)m.getValue()), Map.class);
            String key_str = fieldMap.entrySet().stream().filter(f -> StringUtils.containsIgnoreCase((CharSequence)sourceBill, (CharSequence)f.getKey().toString())).findFirst().get().getValue().toString();
            Map.Entry value = fieldMap.entrySet().stream().filter(f -> !StringUtils.containsIgnoreCase((CharSequence)sourceBill, (CharSequence)f.getKey().toString())).findFirst().get();
            Tuple valueData = new Tuple((Object)value.getKey().toString(), (Object)value.getValue().toString().split("-")[1]);
            String newKey = key_str.split("-")[1];
            sourceAndTargetFieldMap.computeIfAbsent(newKey, v -> new ArrayList()).add(valueData);
        });
        Set sourceFieldSet = sourceAndTargetFieldMap.keySet().stream().collect(Collectors.toSet());
        sourceFieldSet.add("id");
        HashMap targetFieldMap = new HashMap(billIds.size());
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.builder.singletaskaction.LoadBizVoucherByBillIdAction", (String)sourceBill, (String)StringUtils.join((Object[])sourceFieldSet.toArray(), (String)","), (QFilter[])new QFilter("id", "in", billIds).toArray(), null);){
            for (Row row : queryDataSet) {
                Long id = row.getLong("id");
                sourceAndTargetFieldMap.entrySet().forEach(f -> {
                    Object data = row.get((String)f.getKey());
                    List new_key = (List)f.getValue();
                    for (Tuple data_key : new_key) {
                        targetFieldMap.computeIfAbsent(data_key, v -> new HashMap()).put(id, data);
                    }
                });
            }
        }
        int maxSize = Integer.parseInt(SysParamConfig.get((String)REBILL_MAXSIZE, (String)"100000"));
        HashMap result = new HashMap();
        for (Map.Entry entry : targetFieldMap.entrySet()) {
            String tarBillName = (String)((Tuple)entry.getKey()).item1;
            String tarField = (String)((Tuple)entry.getKey()).item2;
            Map valueMap = (Map)entry.getValue();
            QFilter qFilter = new QFilter(tarField, "in", valueMap.values());
            QFilter relationBillCustomFilter = new RelationBillCustomFilterImpl().getRelationBillCustomFilter(tarBillName);
            if (relationBillCustomFilter != null) {
                qFilter.and(relationBillCustomFilter);
            }
            String queryField = "id," + tarField;
            if (tarField.equals("id")) {
                queryField = tarField;
            }
            DynamicObjectCollection queryResult = this.queryData(tarBillName, queryField, qFilter);
            for (DynamicObject data : queryResult) {
                Long tId = data.getLong("id");
                Object tarFieldValue = data.get(tarField);
                valueMap.entrySet().stream().filter(f -> f.getValue().equals(tarFieldValue)).forEach(kdata -> {
                    Long key = (Long)kdata.getKey();
                    List valueList = result.computeIfAbsent(key, v -> new ArrayList());
                    if (valueList.size() < maxSize) {
                        valueList.add(tId);
                    }
                });
            }
        }
        this.taskResult.getSecondBillId().putAll(result);
    }

    private DynamicObjectCollection queryData(String billName, String selector, QFilter qfilter) {
        return QueryServiceHelper.query((String)billName, (String)selector, (QFilter[])qfilter.toArray());
    }
}

