/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletaskaction;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.dap.DapConfig;
import kd.fi.ai.event.DataSourceFactory;
import kd.fi.ai.event.PkEntryPkPair;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.compiler.SelectedSourceEntity;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.mservice.builder.singletaskaction.AbstractSingleTaskAction;
import kd.fi.v2.fah.utils.StringUtils;

public class LoadSouceBillRowsAction
extends AbstractSingleTaskAction {
    private static final Log log = LogFactory.getLog(LoadSouceBillRowsAction.class);

    public LoadSouceBillRowsAction(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u6309\u6240\u9009\u4e3b\u5206\u5f55\uff0c\u52a0\u8f7d\u672c\u6279\u6b21\u9700\u8981\u5904\u7406\u7684\u6e90\u5355\u6570\u636e\u884c", (String)"LoadSouceBillRowsAction_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        if (this.taskContext.getShowInfo().booleanValue()) {
            log.info("\u6309\u6240\u9009\u4e3b\u5206\u5f55\uff0c\u52a0\u8f7d\u672c\u6279\u6b21\u9700\u8981\u5904\u7406\u7684\u6e90\u5355\u6570\u636e\u884c{}", (Object)this.taskResult.getSelectedEntities().size());
        }
        for (Map.Entry<String, SelectedSourceEntity> srcEntityItem : this.taskResult.getSelectedEntities().entrySet()) {
            SelectedSourceEntity sourceEntity = srcEntityItem.getValue();
            HashSet<Object> entryIds = new HashSet<Object>();
            Map<Object, List<DynamicObject>> sourceRows = this.LoadSourceRows(sourceEntity, entryIds);
            if (this.taskResult.isSkipNextAction()) {
                return;
            }
            if (this.taskContext.getShowInfo().booleanValue()) {
                log.info("--DAP--sourceRows\u7684\u884c\u6570\uff1a{}", (Object)sourceRows.size());
            }
            sourceEntity.getSourceRows().putAll(sourceRows);
            Map<Object, Integer> attachmentCounts = this.taskContext.getGroupEntryName() != null ? this.taskContext.getAttachs() : this.queryAttachmentCounts(sourceEntity);
            this.taskContext.getAttachmentCount().putAll(attachmentCounts);
            String entityMessage = ResManager.loadKDString((String)"\u52a0\u8f7d\u4e3b\u5206\u5f55 - {0}\uff0c\u6210\u529f\u8bfb\u53d6{1}\u884c", (String)"LoadSouceBillRowsAction_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
            entityMessage = MessageFormat.format(entityMessage, sourceEntity.getEntityType().getDisplayName().toString(), sourceRows.size());
            this.WriteInfoLog(entityMessage);
            if (!this.taskContext.getShowInfo().booleanValue()) continue;
            log.info("--DAP--" + entityMessage);
        }
    }

    private Map<Object, Integer> queryAttachmentCounts(SelectedSourceEntity sourceEntity) {
        HashMap<Object, Integer> atts = new HashMap<Object, Integer>();
        Set array = sourceEntity.getSrcBillIds().stream().map(e -> e.toString()).collect(Collectors.toSet());
        QFilter billIdsFilter = new QFilter("finterid", "in", array);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ai-attachmentcount", (String)"bos_attachment", (String)"id,finterid", (QFilter[])new QFilter[]{billIdsFilter}, null).groupBy(new String[]{"finterid"}).count("ct").finish();){
            for (Row row : ds) {
                atts.put(row.getString("finterid"), row.getInteger("ct"));
            }
        }
        return atts;
    }

    private Map<Object, List<DynamicObject>> LoadSourceRows(SelectedSourceEntity sourceEntity, HashSet<Object> entryIds) {
        Throwable dsn3;
        DataSet dsn2;
        MainEntityType mainEntityType = this.taskContext.getSrcEntityType();
        ISimpleProperty pkProperty = mainEntityType.getPrimaryKey();
        String pkPropName = pkProperty.getName();
        QFilter billIdsFilter = new QFilter(pkPropName, "in", (Object)sourceEntity.getSrcBillIds().toArray());
        DynamicObjectCollection rows = null;
        DapConfig cfg = this.taskContext.getSourceBill().getConfig();
        int topSize = this.taskContext.getParallelEntryJoinResultMaxSize() + 1;
        if (sourceEntity.getEntityType() instanceof EntryType && cfg.isEntrysum()) {
            if (this.taskContext.getTemplate().getEventClassId() == 0L) {
                dsn2 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.taskContext.getSourceBill().getEntityNumber(), (String)sourceEntity.getSelectString(), (QFilter[])new QFilter[]{billIdsFilter}, null, (int)topSize);
                Throwable throwable = null;
                try {
                    rows = this.getEntryRow(sourceEntity, dsn2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dsn2 != null) {
                        if (throwable != null) {
                            try {
                                dsn2.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            dsn2.close();
                        }
                    }
                }
            }
        } else if (sourceEntity.getEntityType() instanceof EntryType && this.taskContext.getGroupEntryName() != null && sourceEntity.getEntityType().getName().equalsIgnoreCase(this.taskContext.getGroupEntryName())) {
            Throwable billIdFilter;
            if (this.taskContext.getTemplate().getEventClassId() != 0L) {
                rows = this.getEventSource(sourceEntity);
            } else if (this.taskContext.getSrcBillIds().size() == 1) {
                QFilter entryIdFilter = new QFilter(sourceEntity.getEntityType().getName() + "." + sourceEntity.getEntityType().getPrimaryKey().getName(), "in", (Object)this.taskContext.getEntryIds());
                billIdFilter = new QFilter(pkPropName, "=", this.taskContext.getSrcBillIds().get(0));
                dsn3 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.taskContext.getSourceBill().getEntityNumber(), (String)sourceEntity.getSelectString(), (QFilter[])new QFilter[]{billIdFilter, entryIdFilter}, null, (int)topSize);
                Object object = null;
                try {
                    rows = ORM.create().toPlainDynamicObjectCollection((DataSet)dsn3);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dsn3 != null) {
                        if (object != null) {
                            try {
                                dsn3.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            dsn3.close();
                        }
                    }
                }
            } else {
                dsn2 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)this.taskContext.getSourceBill().getEntityNumber(), (String)sourceEntity.getSelectString(), (QFilter[])new QFilter[]{billIdsFilter}, null, (int)topSize);
                billIdFilter = null;
                try {
                    rows = ORM.create().toPlainDynamicObjectCollection(dsn2);
                }
                catch (Throwable dsn3) {
                    billIdFilter = dsn3;
                    throw dsn3;
                }
                finally {
                    if (dsn2 != null) {
                        if (billIdFilter != null) {
                            try {
                                dsn2.close();
                            }
                            catch (Throwable dsn3) {
                                billIdFilter.addSuppressed(dsn3);
                            }
                        } else {
                            dsn2.close();
                        }
                    }
                }
            }
        } else if (this.taskContext.getTemplate().getEventClassId() != 0L) {
            rows = this.getEventSource(sourceEntity);
        } else {
            IDataEntityType type = this.getSourceEntityType((IDataEntityType)sourceEntity.getEntityType());
            dsn3 = null;
            try (DataSet dsn4 = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)type.getName(), (String)sourceEntity.getSelectString(), (QFilter[])new QFilter[]{billIdsFilter}, null, (int)topSize);){
                rows = ORM.create().toPlainDynamicObjectCollection(dsn4);
                if (this.taskContext.getShowInfo().booleanValue()) {
                    log.info("-----\u53d6\u6570-----{}-----SELECTOR----{}", (Object)rows, (Object)sourceEntity.getSelectString());
                }
            }
            catch (Throwable throwable) {
                dsn3 = throwable;
                throw throwable;
            }
        }
        if (rows != null && rows.size() > this.taskContext.getParallelEntryJoinResultMaxSize()) {
            this.saveErrorReport((EntityType)mainEntityType, sourceEntity.getEntityType(), sourceEntity.getFldAlias().keySet());
            return new HashMap<Object, List<DynamicObject>>(2);
        }
        HashMap<Object, List<DynamicObject>> sourceRows = new HashMap<Object, List<DynamicObject>>();
        if (rows != null && rows.size() > 0) {
            DynamicObjectType dType = rows.getDynamicObjectType();
            this.BuildSourceRowPropsDictory(sourceEntity, dType);
            DynamicProperty pkProp = sourceEntity.getFldProperties().get(pkPropName);
            for (DynamicObject row : rows) {
                Object billId = pkProp.getValueFast((Object)row);
                if (!sourceRows.containsKey(billId)) {
                    sourceRows.put(billId, new ArrayList());
                }
                List billRows = (List)sourceRows.get(billId);
                billRows.add(row);
            }
        }
        return sourceRows;
    }

    private void BuildSourceRowPropsDictory(SelectedSourceEntity sourceEntity, DynamicObjectType dType) {
        for (Map.Entry<String, String> fldAliasItem : sourceEntity.getFldAlias().entrySet()) {
            String var = fldAliasItem.getKey();
            String alias = fldAliasItem.getValue();
            DynamicProperty property = dType.getProperty(alias);
            sourceEntity.getFldProperties().put(var, property);
        }
        String entryPKPropName = sourceEntity.getEntryPKPropName();
        String entryPKPropAlias = sourceEntity.getFldAlias().get(entryPKPropName);
        DynamicProperty entryPKProp = dType.getProperty(entryPKPropAlias);
        sourceEntity.setEntryPKProperty(entryPKProp);
    }

    private DynamicObjectCollection getEventSource(SelectedSourceEntity sourceEntity) {
        List taskInfos = this.context.getProgresser().getTaskInfos();
        this.context.getProgresser().getCurrTaskInfo().getEventInfo();
        HashSet<Object> srcBillIds = sourceEntity.getSrcBillIds();
        PkEntryPkPair eventInfo = this.context.getProgresser().getCurrTaskInfo().getEventInfo();
        if (eventInfo instanceof Map) {
            Map event = (Map)eventInfo;
            String pk = "";
            Object entryPk = null;
            if (event.containsKey("pk")) {
                pk = event.get("pk");
            }
            if (event.containsKey("entryPk")) {
                entryPk = event.get("entryPk");
            }
            eventInfo = new PkEntryPkPair((Object)pk, entryPk);
        } else if (eventInfo instanceof Collection) {
            List eventList = (List)eventInfo;
            eventInfo = new HashSet(eventList);
        }
        DynamicObjectCollection rows = DataSourceFactory.getDataSource().getEventObjectCollection((Object)this.taskContext.getTemplate().getEventClassId(), eventInfo, sourceEntity.getSelectString());
        log.info("-----\u53d6\u6570EVENT-----{}-----SELECTOR----{}", (Object)rows, (Object)sourceEntity.getSelectString());
        return rows;
    }

    private DynamicObjectCollection getEntryRow(SelectedSourceEntity sourceEntity, DataSet dsn) {
        ArrayList<String> groupFieldVarAlias = new ArrayList<String>(sourceEntity.getSumFields().size() + sourceEntity.getGroupFields().size());
        groupFieldVarAlias.add(this.taskContext.getSrcEntityType().getPrimaryKey().getName());
        for (SourceBillFieldMode mode : sourceEntity.getGroupFields().values()) {
            groupFieldVarAlias.add(sourceEntity.getFldAlias().get(mode.getVar()));
        }
        GroupbyDataSet g = dsn.groupBy(groupFieldVarAlias.toArray(new String[groupFieldVarAlias.size()]));
        for (SourceBillFieldMode mode : sourceEntity.getSumFields().values()) {
            g = g.sum(sourceEntity.getFldAlias().get(mode.getVar()));
            groupFieldVarAlias.add(sourceEntity.getFldAlias().get(mode.getVar()));
        }
        if (this.taskContext.getTemplate().getEventClassId() == 0L) {
            groupFieldVarAlias.add("0l " + sourceEntity.getFldAlias().get(sourceEntity.getEntryPKPropName()));
        }
        DynamicObjectCollection rows = ORM.create().toPlainDynamicObjectCollection(g.finish().select(groupFieldVarAlias.toArray(new String[groupFieldVarAlias.size()])));
        return rows;
    }

    private String[] getFieldNameList(Map<String, SourceBillFieldMode> fields) {
        ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
        for (Map.Entry<String, SourceBillFieldMode> fen : fields.entrySet()) {
            fieldNames.add(fen.getValue().getVar());
        }
        return fieldNames.toArray(new String[0]);
    }

    private IDataEntityType getSourceEntityType(IDataEntityType sourceEntity) {
        return sourceEntity.getParent() == null ? sourceEntity : this.getSourceEntityType(sourceEntity.getParent());
    }

    private void saveErrorReport(EntityType entityType, EntityType entryType, Collection<String> entryField) {
        String billName = entityType.getDisplayName().toString();
        HashSet<String> entryNames = new HashSet<String>(8);
        Map allFields = ((BillEntityType)entityType).getAllFields();
        for (String f : entryField) {
            IDataEntityType parent;
            IDataEntityProperty property = (IDataEntityProperty)allFields.get(f);
            if (property == null || !((parent = property.getParent()) instanceof EntryType)) continue;
            entryNames.add(parent.getDisplayName().toString());
        }
        String errMsg = String.format(ResManager.loadKDString((String)"\u540c\u4e00\u884c\u89c4\u5219\u6d89\u53ca\u201c%1$s\u201d\u591a\u4e2a\u5206\u5f55\u5bf9\u8c61\u201c%2$s\u201d\uff08\u4e3b\u5206\u5f55\uff1a%3$s\uff09\uff0c\u8bf7\u8c03\u6574\u89c4\u5219\uff0c\u51cf\u5c11\u6216\u907f\u514d\u591a\u4e2a\u5e73\u884c\u5206\u5f55\u51fa\u73b0\u5728\u4e00\u884c\u51ed\u8bc1\u89c4\u5219\u4e2d\u3002", (String)"LoadSouceBillRowsAction_2", (String)"fi-ai-mservice", (Object[])new Object[0]), billName, StringUtils.join((Object[])entryNames.toArray(), (String)"\uff0c"), entryType.getDisplayName());
        this.taskResult.setSkipNextAction(true);
        this.context.getReporter().AddErrorReport(this.taskContext.getBookInfo(), this.taskContext.getSourceBill(), (Object)0L, null, this.taskContext.getTemplate() == null ? null : this.taskContext.getTemplate().getId(), VoucherCheckItem.Bill, VoucherErrLevel.Error, errMsg, this.taskContext.getBuildType(), this.taskContext.getBookInfo().getBuildVoucherType().getValue() + "");
        this.context.getReporter().SaveReoprt("gl");
    }
}

