/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletaskaction;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.fi.ai.builder.BuildVoucherType;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.builder.plugin.events.PlugCustEntity;
import kd.fi.ai.builder.plugin.events.PlugCustField;
import kd.fi.ai.mservice.builder.buildresult.SingleTaskResult;
import kd.fi.ai.mservice.builder.compiler.SelectedCustEntity;
import kd.fi.ai.mservice.builder.compiler.SelectedSourceEntity;
import kd.fi.ai.mservice.builder.compiler.TplEntryCompiler;
import kd.fi.ai.mservice.builder.compiler.TplGroupCompiler;
import kd.fi.ai.mservice.builder.getvaluemode.CustFieldMode;
import kd.fi.ai.mservice.builder.getvaluemode.IVariableMode;
import kd.fi.ai.mservice.builder.getvaluemode.SourceBillFieldMode;
import kd.fi.ai.mservice.builder.helper.BuildHelper;
import kd.fi.ai.mservice.builder.singletaskaction.AbstractSingleTaskAction;

public class SelectSourceEntityAction
extends AbstractSingleTaskAction {
    private MainEntityType srcEntityType;

    public SelectSourceEntityAction(ISingleTaskContext taskContext, SingleTaskResult taskResult) {
        super(taskContext, taskResult);
    }

    @Override
    protected void DoAction() {
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u5206\u6790\u51ed\u8bc1\u6a21\u677f\uff0c\u786e\u5b9a\u9700\u8981\u52a0\u8f7d\u7684\u6e90\u5355\u4e3b\u5206\u5f55\uff0c\u4ee5\u53ca\u63d2\u4ef6\u8981\u6c42\u52a0\u8f7d\u7684\u6269\u5c55\u5b9e\u4f53", (String)"SelectSourceEntityAction_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        this.srcEntityType = this.taskContext.getSrcEntityType();
        this.addMainEntityType();
        if (this.taskResult.getTplCompiler() != null) {
            this.addTplEntrysSelectedEntity();
        }
        for (Map.Entry<String, SelectedSourceEntity> selectedEntityItem : this.taskResult.getSelectedEntities().entrySet()) {
            Map<String, IVariableMode> keyFields;
            SelectedSourceEntity sourceEntity = selectedEntityItem.getValue();
            if (selectedEntityItem.getKey().startsWith("multi")) {
                Map<String, Map<String, IVariableMode>> srcbillSelectedFields = this.taskResult.getReSourcebillCompiler().getSrcbillSelectedFields();
                List relationshipSourcebillcol = this.taskResult.getTplCompiler().getVchTemplate().getRelationshipSourcebillcol();
                if (selectedEntityItem.getKey().contains("voucher")) {
                    this.AddVarsToFldList(sourceEntity.getSelectedFields(), srcbillSelectedFields.get("gl_voucher"));
                } else {
                    for (String string : relationshipSourcebillcol) {
                        if (!selectedEntityItem.getKey().contains(string)) continue;
                        this.AddVarsToFldList(sourceEntity.getSelectedFields(), srcbillSelectedFields.get(string));
                    }
                }
            } else if (!sourceEntity.isSecond()) {
                keyFields = this.taskResult.getSourceBillCompiler().getSelectedFields();
                this.AddVarsToFldList(sourceEntity.getSelectedFields(), keyFields);
            } else {
                keyFields = this.taskResult.getSecondSourceBillCompiler().getSelectedFields();
                this.AddVarsToFldList(sourceEntity.getSelectedFields(), keyFields);
            }
            if (this.taskResult.getTplCompiler() != null) {
                Map<String, IVariableMode> tplHeadFields = this.taskResult.getTplCompiler().getSelectedFields();
                if (!sourceEntity.isSecond() && !selectedEntityItem.getKey().startsWith("multi")) {
                    if (sourceEntity.getEntityType() instanceof EntryType) {
                        HashMap<String, IVariableMode> realHeadFields = new HashMap<String, IVariableMode>();
                        for (Map.Entry entry : tplHeadFields.entrySet()) {
                            String key = (String)entry.getKey();
                            if (key.contains(".")) {
                                key = key.substring(0, key.indexOf("."));
                            }
                            if (this.srcEntityType.getProperty(key) == null) continue;
                            realHeadFields.put((String)entry.getKey(), (IVariableMode)entry.getValue());
                        }
                        this.AddVarsToFldList(sourceEntity.getSelectedFields(), realHeadFields);
                    } else {
                        this.AddVarsToFldList(sourceEntity.getSelectedFields(), tplHeadFields);
                    }
                }
                for (TplGroupCompiler tplGroupCompiler : this.taskResult.getTplCompiler().getTplGroupCompilers()) {
                    this.AddVarsToFldList(sourceEntity.getSelectedFields(), tplGroupCompiler.getSelectedFields());
                }
            }
            this.BuildSelectString(selectedEntityItem.getValue());
        }
    }

    private void addMainEntityType() {
        if (!this.taskResult.getTplCompiler().getVchTemplate().isEvent() && !Objects.equals(this.srcEntityType.getName(), this.taskResult.getTplCompiler().getVchTemplate().getSourceBill())) {
            return;
        }
        SelectedSourceEntity mainEntity = new SelectedSourceEntity();
        mainEntity.setEntityType((EntityType)this.srcEntityType);
        if (this.taskContext.getBookInfo().getBuildVoucherType() == BuildVoucherType.OnlyGLVoucher) {
            BuildHelper.AddRange(mainEntity.getSrcBillIds(), this.taskResult.getHistBizVouchers().keySet());
        } else {
            BuildHelper.AddRange(mainEntity.getSrcBillIds(), this.taskContext.getSrcBillIds());
        }
        this.taskResult.getSelectedEntities().put(mainEntity.getEntityType().getName(), mainEntity);
    }

    private void addTplEntrysSelectedEntity() {
        for (TplGroupCompiler tplGroupCompiler : this.taskResult.getTplCompiler().getTplGroupCompilers()) {
            for (TplEntryCompiler tplEntryCompiler : tplGroupCompiler.getTplEntryCompilers()) {
                if (tplEntryCompiler.isCompileError()) continue;
                this.addTplEntrySelectedEntity(tplEntryCompiler);
            }
        }
    }

    private void addTplEntrySelectedEntity(TplEntryCompiler tplEntryCompiler) {
        if (!tplEntryCompiler.getVchTempEntry().getIsuse().booleanValue()) {
            return;
        }
        EntityType entity = tplEntryCompiler.getSelectedSourceEntity();
        if (entity == null) {
            return;
        }
        String billName = tplEntryCompiler.getSourceEntityKey(tplEntryCompiler, this.taskResult.getTplCompiler().getVchTemplate());
        String relationshipSourcebill = this.taskResult.getTplCompiler().getVchTemplate().getRelationshipSourcebill();
        PlugCustEntity custEntity = tplEntryCompiler.getSelectedCustEntity();
        SelectedSourceEntity selectedSourceEntity = null;
        SelectedCustEntity selectedCustEntity = null;
        if (!this.taskResult.getSelectedEntities().containsKey(billName)) {
            selectedSourceEntity = new SelectedSourceEntity();
            selectedSourceEntity.setEntityType(entity);
            if (StringUtils.isNotEmpty((CharSequence)relationshipSourcebill) && StringUtils.isNotEmpty((CharSequence)tplEntryCompiler.getBillName()) && Objects.equals(tplEntryCompiler.getBillName(), relationshipSourcebill)) {
                selectedSourceEntity.setSecond(true);
            }
            this.taskResult.getSelectedEntities().put(billName, selectedSourceEntity);
        } else {
            selectedSourceEntity = this.taskResult.getSelectedEntities().get(billName);
        }
        if (custEntity != null) {
            if (!selectedSourceEntity.getSelectedCustEntities().containsKey(custEntity.getEntityKey())) {
                selectedCustEntity = new SelectedCustEntity();
                selectedCustEntity.setCustEntity(custEntity);
                selectedSourceEntity.getSelectedCustEntities().put(custEntity.getEntityKey(), selectedCustEntity);
            } else {
                selectedCustEntity = selectedSourceEntity.getSelectedCustEntities().get(custEntity.getEntityKey());
            }
        }
        for (Map.Entry<String, IVariableMode> fldItem : tplEntryCompiler.getSelectedFields().entrySet()) {
            if (!(fldItem.getValue() instanceof SourceBillFieldMode)) continue;
            selectedSourceEntity.getSelectedFields().put(fldItem.getKey(), (SourceBillFieldMode)fldItem.getValue());
        }
        if ((StringUtils.isNotEmpty((CharSequence)tplEntryCompiler.getBillName()) || StringUtils.isNotEmpty((CharSequence)tplEntryCompiler.getVchTempEntry().getBelongSources())) && !Objects.equals(this.srcEntityType.getName(), tplEntryCompiler.getBillName())) {
            HashSet<Object> secondIds = new HashSet<Object>();
            if (this.taskResult.getSecondBillVoucherId().containsKey(tplEntryCompiler.getVchTempEntry().getBelongSources())) {
                secondIds.addAll((Collection)this.taskResult.getSecondBillVoucherId().get(tplEntryCompiler.getVchTempEntry().getBelongSources()));
            } else {
                for (List list : this.taskResult.getSecondBillId().values()) {
                    secondIds.addAll(list);
                }
            }
            BuildHelper.AddRange(selectedSourceEntity.getSrcBillIds(), secondIds);
        } else {
            BuildHelper.AddRange(selectedSourceEntity.getSrcBillIds(), this.taskResult.getSrcBillIdsNeedBuild());
        }
        if (this.taskContext.getSourceBill().getConfig().isEntrysum()) {
            for (Map.Entry<String, IVariableMode> fldItem : tplEntryCompiler.getGroupFields().entrySet()) {
                if (!(fldItem.getValue() instanceof SourceBillFieldMode)) continue;
                selectedSourceEntity.getGroupFields().put(fldItem.getKey(), (SourceBillFieldMode)fldItem.getValue());
            }
            for (Map.Entry<String, IVariableMode> fldItem : tplEntryCompiler.getSumFields().entrySet()) {
                if (!(fldItem.getValue() instanceof SourceBillFieldMode)) continue;
                selectedSourceEntity.getSumFields().put(fldItem.getKey(), (SourceBillFieldMode)fldItem.getValue());
            }
        }
    }

    private void BuildSelectString(SelectedSourceEntity selectedSourceEntity) {
        ArrayList<String> selectFldStrings = new ArrayList<String>(10);
        int fldIndex = 0;
        MainEntityType mainEntityType = this.taskContext.getSrcEntityType();
        String pkPropName = mainEntityType.getPrimaryKey().getName();
        if (!selectedSourceEntity.getFldAlias().containsKey(pkPropName)) {
            selectedSourceEntity.getFldAlias().put(pkPropName, pkPropName);
            selectFldStrings.add(pkPropName);
            ++fldIndex;
        }
        if (this.taskContext.getTemplate().getEventClassId() == 0L) {
            String entryPKPropName = selectedSourceEntity.getEntryPKPropName();
            if (!selectedSourceEntity.getFldAlias().containsKey(entryPKPropName)) {
                String string = "f" + Integer.toString(fldIndex);
                selectedSourceEntity.getFldAlias().put(entryPKPropName, string);
                if (selectedSourceEntity.getEntityType() instanceof SubEntryType) {
                    selectFldStrings.add(selectedSourceEntity.getEntityType().getParent().getName() + "." + (String)entryPKPropName + " " + string);
                } else {
                    selectFldStrings.add((String)entryPKPropName + " " + string);
                }
                ++fldIndex;
            }
            ++fldIndex;
        }
        for (Map.Entry entry : selectedSourceEntity.getSelectedFields().entrySet()) {
            SourceBillFieldMode fldMode = (SourceBillFieldMode)entry.getValue();
            String var = fldMode.getVar();
            if (selectedSourceEntity.getFldAlias().containsKey(var)) continue;
            String fldAlias = "f" + Integer.toString(fldIndex);
            String selectFldString = fldMode.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            selectedSourceEntity.getFldAlias().put(var, fldAlias);
            ++fldIndex;
        }
        String selectString = StringUtils.join((Object[])selectFldStrings.toArray(new Object[selectFldStrings.size()]), (String)",");
        selectedSourceEntity.setSelectString(selectString);
        String string2 = ResManager.loadKDString((String)"\u4e3b\u5206\u5f55\uff1a{0}\uff1b\u9700\u8981\u8bfb\u53d6\u7684\u5b57\u6bb5\uff1a{1}", (String)"SelectSourceEntityAction_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
        string2 = MessageFormat.format(string2, selectedSourceEntity.getEntityType().getDisplayName().toString(), selectString);
        this.WriteInfoLog(string2);
        for (Map.Entry<String, SelectedCustEntity> custEntityItem : selectedSourceEntity.getSelectedCustEntities().entrySet()) {
            this.BuildCustSelectString(custEntityItem.getValue(), fldIndex);
        }
    }

    private void BuildCustSelectString(SelectedCustEntity selectedCustEntity, int fldIndex) {
        ArrayList<String> selectFldStrings = new ArrayList<String>();
        PlugCustEntity custEntity = selectedCustEntity.getCustEntity();
        String custEntityKey = selectedCustEntity.getCustEntity().getEntityKey();
        selectedCustEntity.getFldAlias().put(custEntity.getPkFieldName(), "f" + Integer.toString(fldIndex));
        selectFldStrings.add(custEntity.getPkFieldName() + " f" + Integer.toString(fldIndex));
        selectedCustEntity.getFldAlias().put(custEntity.getFkFieldName(), "f" + Integer.toString(++fldIndex));
        selectFldStrings.add(custEntity.getFkFieldName() + " f" + Integer.toString(fldIndex));
        ++fldIndex;
        for (Map.Entry custFldItem : this.taskContext.getCustFields().entrySet()) {
            PlugCustField custField = (PlugCustField)custFldItem.getValue();
            if (!custField.getEntityKey().equalsIgnoreCase(custEntityKey)) continue;
            CustFieldMode custFieldMode = new CustFieldMode(custField.getKey(), new String[]{custField.getKey()}, custField);
            selectedCustEntity.getSelectedFields().put(custField.getKey(), custFieldMode);
            String fldAlias = "f" + Integer.toString(fldIndex);
            selectedCustEntity.getFldAlias().put(custField.getKey(), fldAlias);
            String selectFldString = custField.getFieldName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            ++fldIndex;
        }
        String selectString = StringUtils.join((Object[])selectFldStrings.toArray(), (String)",");
        selectedCustEntity.setSelectString(selectString);
        String message = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b9e\u4f53\uff1a{0}\uff1b\u9700\u8981\u8bfb\u53d6\u7684\u5b57\u6bb5\uff1a{1}", (String)"SelectSourceEntityAction_2", (String)"fi-ai-mservice", (Object[])new Object[0]);
        MessageFormat.format(message, selectedCustEntity.getCustEntity().getEntityCaption(), selectString);
        this.WriteInfoLog(message);
    }

    private void AddVarsToFldList(Map<String, SourceBillFieldMode> selectedFields, Map<String, IVariableMode> vars) {
        for (Map.Entry<String, IVariableMode> varItem : vars.entrySet()) {
            if (!(varItem.getValue() instanceof SourceBillFieldMode)) continue;
            selectedFields.put(varItem.getKey(), (SourceBillFieldMode)varItem.getValue());
        }
    }
}

