/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.singletplaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.builder.BuildVoucherType;
import kd.fi.ai.builder.IBuildVchProgresser;
import kd.fi.ai.builder.SingleTaskInfo;
import kd.fi.ai.event.DataSourceFactory;
import kd.fi.ai.event.PkEntryPkPair;
import kd.fi.ai.mservice.builder.singletplaction.AbstractSingleTemplateAction;

public class SplitTaskAction
extends AbstractSingleTemplateAction {
    private IBuildVchProgresser progresser;

    @Override
    protected void DoAction() {
        super.DoAction();
        this.WriteInfoLog(ResManager.loadKDString((String)"\u5f00\u59cb\u5bf9\u5f85\u5904\u7406\u6570\u636e\uff0c\u5212\u5206\u6279\u6b21\uff0c\u6bcf\u6279500 \u5f20\u6e90\u5355", (String)"SplitTaskAction_0", (String)"fi-ai-mservice", (Object[])new Object[0]));
        this.progresser = this.templateContext.getBuildVchContext().getProgresser();
        if (this.templateContext.getVchTemplate().getEventClassId() != 0L) {
            if (this.templateContext.getBook().getBuildVoucherType() == BuildVoucherType.OnlyGLVoucher) {
                this.splitEventHistBizVchIds();
            } else {
                this.splitSrcEventIds();
            }
        } else if (this.templateContext.getBook().getBuildVoucherType() == BuildVoucherType.OnlyGLVoucher) {
            this.SplitHistBizVchIds();
        } else if (this.templateResult.getGroupEntryName() != null) {
            this.splitSrcBillIdByEntry();
        } else {
            this.SplitSrcBillIds();
        }
    }

    private void splitEventHistBizVchIds() {
        this.progresser.AddBizVoucherIds(this.templateContext.getBook(), this.templateContext.getSourceBill(), this.templateResult.getHistBizVoucherIds());
        this.progresser.AddBillIds(this.templateContext.getBook(), this.templateContext.getSourceBill(), this.templateContext.getVchTemplate(), this.templateResult.getSrcBillIds());
        List batchEvtEntry = DataSourceFactory.getDataSource().batchEvtEntry((Object)this.templateContext.getVchTemplate().getEventClassId(), new HashSet<Object>(this.templateResult.getSrcBillIds()));
        HashMap<Object, Long> billidAndBizvoucherid = new HashMap<Object, Long>(this.templateResult.getSrcBillIds().size());
        DataSet ds = QueryServiceHelper.queryDataSet((String)"splitEventHistBizVchIds", (String)"ai_bizvoucher", (String)"sourcebillid,id", (QFilter[])new QFilter[]{new QFilter("id", "in", this.templateResult.getHistBizVoucherIds()), new QFilter("sourcebillid", "in", this.templateResult.getSrcBillIds())}, null);
        Object object = null;
        try {
            for (Row row : ds) {
                billidAndBizvoucherid.put(row.get("sourcebillid"), row.getLong("id"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        int batchSeq = 0;
        for (Object obj : batchEvtEntry) {
            ++batchSeq;
            String taskId = UUID.randomUUID().toString();
            SingleTaskInfo taskInfo = new SingleTaskInfo();
            if (obj instanceof PkEntryPkPair) {
                // empty if block
            }
            taskInfo.setBookId(this.templateContext.getBook().getBookId());
            taskInfo.setEntityNumber(this.templateContext.getSourceBill().getEntityNumber());
            taskInfo.setTemplateId(this.templateContext.getVchTemplate().getId());
            if (obj instanceof PkEntryPkPair) {
                PkEntryPkPair entry = (PkEntryPkPair)obj;
                taskInfo.getHistBizVoucherIds().add(billidAndBizvoucherid.get(entry.getPk()));
            } else if (obj instanceof Collection) {
                Collection oc = (Collection)obj;
                taskInfo.getSrcBillIds().addAll(oc);
            } else {
                taskInfo.getSrcBillIds().addAll(this.templateResult.getSrcBillIds());
            }
            taskInfo.setTaskId(taskId);
            taskInfo.setEventInfo(obj);
            this.progresser.addTaskInfo(taskInfo);
        }
        this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u5212\u5206\u51fa\u7684\u6279\u6b21\u6570\uff1a%s", (String)"SplitTaskAction_1", (String)"fi-ai-mservice", (Object[])new Object[0]), Integer.toString(batchSeq)));
    }

    private void splitSrcBillIdByEntry() {
        this.progresser.AddBillIds(this.templateContext.getBook(), this.templateContext.getSourceBill(), this.templateContext.getVchTemplate(), this.templateResult.getSrcBillIds());
        Map<Object, List<Long>> billEntryIDs = this.templateResult.getBillEntryIds();
        Set<Map.Entry<Object, List<Long>>> billEntrySet = billEntryIDs.entrySet();
        Map<Object, Integer> atts = this.queryBillAttachments(billEntryIDs.keySet());
        SingleTaskInfo taskInfo = null;
        int i = 0;
        for (Map.Entry<Object, List<Long>> e : billEntrySet) {
            Object billid = e.getKey();
            List<Long> entryids = e.getValue();
            int entrySize = entryids.size();
            if (entrySize >= 2000) {
                i = 0;
                for (Long entryid : entryids) {
                    if (i % 2000 == 0) {
                        i = 0;
                        taskInfo = new SingleTaskInfo();
                        taskInfo.setBookId(this.templateContext.getBook().getBookId());
                        taskInfo.setEntityNumber(this.templateContext.getSourceBill().getEntityNumber());
                        taskInfo.setTemplateId(this.templateContext.getVchTemplate().getId());
                        taskInfo.setTaskId(UUID.randomUUID().toString());
                        taskInfo.setGroupEntryName(this.templateResult.getGroupEntryName());
                        taskInfo.setAttachs(atts);
                        taskInfo.getSrcBillIds().add(billid);
                        this.progresser.addTaskInfo(taskInfo);
                    }
                    if (taskInfo != null) {
                        taskInfo.getEntryIds().add(entryid);
                    }
                    ++i;
                }
                taskInfo = null;
                continue;
            }
            if (taskInfo == null || 2000 - i < entrySize) {
                i = 0;
                taskInfo = new SingleTaskInfo();
                taskInfo.setBookId(this.templateContext.getBook().getBookId());
                taskInfo.setEntityNumber(this.templateContext.getSourceBill().getEntityNumber());
                taskInfo.setTemplateId(this.templateContext.getVchTemplate().getId());
                taskInfo.setTaskId(UUID.randomUUID().toString());
                taskInfo.setGroupEntryName(this.templateResult.getGroupEntryName());
                taskInfo.setAttachs(atts);
                this.progresser.addTaskInfo(taskInfo);
            }
            taskInfo.getSrcBillIds().add(billid);
            for (Long entryid : entryids) {
                taskInfo.getEntryIds().add(entryid);
                ++i;
            }
        }
    }

    private Map<Object, Integer> queryBillAttachments(Set<Object> billids) {
        int billsize = billids.size();
        HashMap<Object, Integer> at = new HashMap<Object, Integer>();
        if (billsize > 10000) {
            HashSet<String> cache = new HashSet<String>(10000);
            int i = 0;
            for (Object billid : billids) {
                cache.add(String.valueOf(billid));
                if (++i % 10000 != 0 && i != billsize) continue;
                QFilter billIdsFilter = new QFilter("finterid", "in", cache);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ai-attachmentcount", (String)"bos_attachment", (String)"id,finterid", (QFilter[])new QFilter[]{billIdsFilter}, null).groupBy(new String[]{"finterid"}).count("ct").finish();){
                    while (ds.hasNext()) {
                        Row row = ds.next();
                        at.put(row.get("finterid"), row.getInteger("ct"));
                    }
                }
                cache.clear();
            }
        } else {
            HashSet<String> strIds = new HashSet<String>(billids.size());
            for (Object billid : billids) {
                strIds.add(String.valueOf(billid));
            }
            QFilter billIdsFilter = new QFilter("finterid", "in", strIds);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"ai-attachmentcount", (String)"bos_attachment", (String)"id,finterid", (QFilter[])new QFilter[]{billIdsFilter}, null).groupBy(new String[]{"finterid"}).count("ct").finish();){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    at.put(row.get("finterid"), row.getInteger("ct"));
                }
            }
        }
        return at;
    }

    private void SplitSrcBillIds() {
        this.progresser.AddBillIds(this.templateContext.getBook(), this.templateContext.getSourceBill(), this.templateContext.getVchTemplate(), this.templateResult.getSrcBillIds());
        int batchSeq = 0;
        List<Object> currBatchBillIds = this.GetBatchSourceBillIds(batchSeq);
        while (currBatchBillIds.size() > 0) {
            String taskId = UUID.randomUUID().toString();
            SingleTaskInfo taskInfo = new SingleTaskInfo();
            taskInfo.setBookId(this.templateContext.getBook().getBookId());
            taskInfo.setEntityNumber(this.templateContext.getSourceBill().getEntityNumber());
            taskInfo.setTemplateId(this.templateContext.getVchTemplate().getId());
            taskInfo.getSrcBillIds().addAll(currBatchBillIds);
            taskInfo.setTaskId(taskId);
            this.progresser.addTaskInfo(taskInfo);
            currBatchBillIds = this.GetBatchSourceBillIds(++batchSeq);
        }
        this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u5212\u5206\u51fa\u7684\u6279\u6b21\u6570\uff1a%s", (String)"SplitTaskAction_1", (String)"fi-ai-mservice", (Object[])new Object[0]), Integer.toString(batchSeq)));
    }

    private void SplitHistBizVchIds() {
        this.progresser.AddBizVoucherIds(this.templateContext.getBook(), this.templateContext.getSourceBill(), this.templateResult.getHistBizVoucherIds());
        int batchSeq = 0;
        List<Long> currBatchVchIds = this.GetBatchIds(this.templateResult.getHistBizVoucherIds(), batchSeq);
        while (currBatchVchIds.size() > 0) {
            String taskId = UUID.randomUUID().toString();
            SingleTaskInfo taskInfo = new SingleTaskInfo();
            taskInfo.setBookId(this.templateContext.getBook().getBookId());
            taskInfo.setEntityNumber(this.templateContext.getSourceBill().getEntityNumber());
            taskInfo.getHistBizVoucherIds().addAll(currBatchVchIds);
            taskInfo.setTaskId(taskId);
            taskInfo.setTemplateId(this.templateContext.getVchTemplate().getId());
            this.progresser.addTaskInfo(taskInfo);
            currBatchVchIds = this.GetBatchIds(this.templateResult.getHistBizVoucherIds(), ++batchSeq);
        }
        this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u5212\u5206\u51fa\u7684\u6279\u6b21\u6570\uff1a%s", (String)"SplitTaskAction_1", (String)"fi-ai-mservice", (Object[])new Object[0]), Integer.toString(batchSeq)));
    }

    private List<Object> GetBatchSourceBillIds(int batchSeq) {
        ArrayList<Object> currBatchBillIds = new ArrayList<Object>();
        int beginSeq = batchSeq * 1000;
        int endSeq = (batchSeq + 1) * 1000 - 1;
        for (int i = beginSeq; i <= endSeq && i < this.templateResult.getSrcBillIds().size(); ++i) {
            currBatchBillIds.add(this.templateResult.getSrcBillIds().get(i));
        }
        return currBatchBillIds;
    }

    private List<Long> GetBatchIds(List<Long> list, int batchSeq) {
        ArrayList<Long> currBatchds = new ArrayList<Long>();
        int beginSeq = batchSeq * 1000;
        int endSeq = (batchSeq + 1) * 1000 - 1;
        for (int i = beginSeq; i <= endSeq && i < list.size(); ++i) {
            currBatchds.add(list.get(i));
        }
        return currBatchds;
    }

    private void splitSrcEventIds() {
        this.progresser.AddBillIds(this.templateContext.getBook(), this.templateContext.getSourceBill(), this.templateContext.getVchTemplate(), this.templateResult.getSrcBillIds());
        List batchEvtEntry = DataSourceFactory.getDataSource().batchEvtEntry((Object)this.templateContext.getVchTemplate().getEventClassId(), new HashSet<Object>(this.templateResult.getSrcBillIds()));
        int batchSeq = 0;
        for (Object obj : batchEvtEntry) {
            ++batchSeq;
            String taskId = UUID.randomUUID().toString();
            SingleTaskInfo taskInfo = new SingleTaskInfo();
            if (obj instanceof PkEntryPkPair) {
                // empty if block
            }
            taskInfo.setBookId(this.templateContext.getBook().getBookId());
            taskInfo.setEntityNumber(this.templateContext.getSourceBill().getEntityNumber());
            taskInfo.setTemplateId(this.templateContext.getVchTemplate().getId());
            if (obj instanceof PkEntryPkPair) {
                PkEntryPkPair entry = (PkEntryPkPair)obj;
                taskInfo.getSrcBillIds().add(entry.getPk());
            } else if (obj instanceof Collection) {
                Collection oc = (Collection)obj;
                taskInfo.getSrcBillIds().addAll(oc);
            } else {
                taskInfo.getSrcBillIds().addAll(this.templateResult.getSrcBillIds());
            }
            taskInfo.setTaskId(taskId);
            taskInfo.setEventInfo(obj);
            this.progresser.addTaskInfo(taskInfo);
        }
        this.WriteInfoLog(String.format(ResManager.loadKDString((String)"\u5212\u5206\u51fa\u7684\u6279\u6b21\u6570\uff1a%s", (String)"SplitTaskAction_1", (String)"fi-ai-mservice", (Object[])new Object[0]), Integer.toString(batchSeq)));
    }
}

