/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.fi.ai.service.DapQueryDataService;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.v2.fah.dao.FahAiTrackerDao;

public class DapQueryDataServiceImpl
implements DapQueryDataService {
    public Set<String> getCanBuildVoucherBillNames() {
        HashSet<String> billTypes = new HashSet<String>(16);
        String sql = "select distinct fbillentity from t_ai_dapconfig where fisdap = '1'";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.mservice.service.DapQueryDataServiceImpl", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            for (Row row : queryDataSet) {
                String billType = row.getString("fbillentity");
                billTypes.add(billType);
            }
        }
        return billTypes;
    }

    public Map<Long, Set<Long>> getVoucherInfofromBill(String billName, Collection<Long> ids) {
        if (billName == null || null == ids || ids.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(ids.size());
        List splitSet = DapBuildVoucherCommonUtil.splitCollection(ids, (int)1000);
        for (Collection idSet : splitSet) {
            Map voucherIdBillIds = FahAiTrackerDao.getVoucherIdAndBillIdsByTracker((String)billName, (Collection)idSet);
            for (Map.Entry entry : voucherIdBillIds.entrySet()) {
                result.computeIfAbsent((Long)entry.getKey(), (Function<Long, Set<Long>>)((Function<Long, Set>)k -> new HashSet())).addAll((Collection)entry.getValue());
            }
        }
        return result;
    }

    public Map<String, Set<Long>> getSourceBillInfoByVchId(Long vchId) {
        return FahAiTrackerDao.getBillTypeAndIdsByVoucherId((Long)vchId);
    }

    public Map<String, Set<Long>> getSourceBillInfoByVchIdSet(Collection<Long> vchIds) {
        if (null == vchIds || vchIds.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(vchIds.size());
        List splitSet = DapBuildVoucherCommonUtil.splitCollection(vchIds, (int)1000);
        for (Collection idSet : splitSet) {
            Map billTypeAndBillIds = FahAiTrackerDao.getBillTypeAndIdsByVoucherIdSet((Collection)idSet);
            for (Map.Entry entry : billTypeAndBillIds.entrySet()) {
                result.computeIfAbsent((String)entry.getKey(), (Function<String, Set<Long>>)((Function<String, Set>)k -> new HashSet())).addAll((Collection)entry.getValue());
            }
        }
        return result;
    }

    public BillToVchRelationDto getBillToVchRelationDtoByVchIDSet(Collection<Long> voucherIds) {
        if (null == voucherIds || voucherIds.isEmpty()) {
            return new BillToVchRelationDto();
        }
        return this.getBillToVchReDtoByBillTypeVchIDSet(null, voucherIds);
    }

    public BillToVchRelationDto getBillToVchReDtoByBillTypeVchIDSet(String billType, Collection<Long> voucherIds) {
        if (null == voucherIds || voucherIds.isEmpty()) {
            return new BillToVchRelationDto();
        }
        BillToVchRelationDto billToVchRelationDto = new BillToVchRelationDto();
        HashMap<String, List> listMap = new HashMap<String, List>(voucherIds.size());
        List splitSet = DapBuildVoucherCommonUtil.splitCollection(voucherIds, (int)1000);
        for (Collection idSet : splitSet) {
            Map billInfo = FahAiTrackerDao.getBillToVchRelationDtoByVchIDSet((String)billType, (Collection)idSet);
            for (Map.Entry entry : billInfo.entrySet()) {
                listMap.computeIfAbsent((String)entry.getKey(), k -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }
        billToVchRelationDto.setDatas(listMap);
        return billToVchRelationDto;
    }

    public BillToVchRelationDto getBillToVchReDtoByBillTypeAndIds(String billType, Collection<Long> billIds) {
        if (null == billIds || billIds.isEmpty()) {
            return new BillToVchRelationDto();
        }
        BillToVchRelationDto billToVchRelationDto = new BillToVchRelationDto();
        HashMap<String, List> listMap = new HashMap<String, List>(billIds.size());
        List splitSet = DapBuildVoucherCommonUtil.splitCollection(billIds, (int)1000);
        for (Collection idSet : splitSet) {
            Map billInfo = FahAiTrackerDao.getBillToVchReDtoByBillTypeAndIds((String)billType, (Collection)idSet);
            for (Map.Entry entry : billInfo.entrySet()) {
                listMap.computeIfAbsent((String)entry.getKey(), k -> new ArrayList()).addAll((Collection)entry.getValue());
            }
        }
        billToVchRelationDto.setDatas(listMap);
        return billToVchRelationDto;
    }
}

