/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.ai.AcctBook;
import kd.fi.ai.GenVoucherMemoryMergeTask;
import kd.fi.ai.GenerateVoucherResult;
import kd.fi.ai.SingleSplitAcctBook;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.builder.GLVoucherUnionType;
import kd.fi.ai.builder.SourceBillInfo;
import kd.fi.ai.builder.VoucherCheckItem;
import kd.fi.ai.builder.VoucherErrLevel;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.ai.dap.DapBookHelper;
import kd.fi.ai.dap.DapCache;
import kd.fi.ai.dap.DapConfig;
import kd.fi.ai.dap.DapWriteAndBlackOpSetUtil;
import kd.fi.ai.event.DataSourceFactory;
import kd.fi.ai.event.PkEntryPkPair;
import kd.fi.ai.exception.DapException;
import kd.fi.ai.mservice.builder.BuildVchScheme;
import kd.fi.ai.mservice.builder.BuildVchServiceImpl;
import kd.fi.ai.mservice.builder.SelectedAcctBook;
import kd.fi.ai.mservice.builder.SelectedSourceBill;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.reporter.BuildVchReportUtils;
import kd.fi.ai.mservice.builder.reporter.BuildVchReporter;
import kd.fi.ai.mservice.builder.reporter.DapReportUtil;
import kd.fi.ai.mservice.service.helper.SelectTemplateUtil;
import kd.fi.ai.mservice.service.helper.SortTemplateDy;
import kd.fi.ai.mservice.service.helper.VchTemplateMainData;
import kd.fi.ai.mservice.util.BuildVoucherUtils;
import kd.fi.ai.operation.AutoBuildVchSchemeHelper;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.EventVchTemplateUtil;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.service.voucher.TempVoucherService;
import kd.fi.bd.util.filter.QFilterBuilder;
import org.apache.commons.collections4.ListUtils;

public class GenerateVoucherProcess {
    private static Log logger = LogFactory.getLog(GenerateVoucherProcess.class);
    private Map<Long, Set<AcctBook>> acctOrg2acctOrgCache = new HashMap<Long, Set<AcctBook>>();
    private Map<String, Set<AcctBook>> bizBook2AcctBookCache = new HashMap<String, Set<AcctBook>>();
    private Map<Long, VchTemplateMainData> vchtemplateDataCache = new HashMap<Long, VchTemplateMainData>();
    private DapBookHelper bookHelper;
    private Map<Long, String> orgNameCache = new HashMap<Long, String>();
    private String billTypeKey;
    private Set<Long> billids;
    private boolean onTime;
    private String paramJson;
    private boolean iep;
    private BuildVchScheme defScheme;
    private String onTimeOperateKey = null;
    private String opr = null;
    private String buildType = null;
    private Long eventClass = 0L;
    private String BuildVoucherType = "0";
    private boolean multiDap = false;
    private boolean vchtemplatePrevoucher = false;
    private boolean ignoreTemplateUnique = false;
    private String mergeCode = null;
    private String previewPageid = null;
    private boolean isBizGenGlVch = false;
    private boolean hasReOper = false;
    private boolean ignoreBillStatus = false;
    private boolean openalltemplate = false;
    private boolean isSingleBill = false;
    private GenVoucherMemoryMergeTask gvMemory;
    private Map<Object, List<Object>> tempSelect = new HashMap<Object, List<Object>>(8);
    private boolean preBuild = false;
    private boolean buildBizvoucherFromMidle = false;

    public GenerateVoucherProcess(String billTypeKey, Set<Long> billids, boolean onTime, String paramJson, boolean iep, BuildVchScheme defScheme, String opr, String buildType, GenVoucherMemoryMergeTask gvMemory, Long eventClass) {
        this.billTypeKey = billTypeKey;
        this.billids = billids;
        this.onTime = onTime;
        this.paramJson = paramJson;
        this.iep = iep;
        this.defScheme = defScheme;
        this.buildType = defScheme != null && defScheme.getBuildType() != null ? defScheme.getBuildType() : buildType;
        this.opr = defScheme != null && defScheme.getOpr() != null ? defScheme.getOpr() : opr;
        this.gvMemory = gvMemory;
        this.eventClass = eventClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateVoucher() {
        this.acctOrg2acctOrgCache.clear();
        this.bizBook2AcctBookCache.clear();
        this.orgNameCache.clear();
        Date start = new Date();
        this.initGenVoucherParams();
        String errorMessage = null;
        String message = this.ckeckHasOpenIsDap();
        if (message != null) {
            return message;
        }
        List<VchTemplateMainData> vchTemData = this.getVchtemplateDataFromTaskInfo();
        if (vchTemData.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5f53\u524d\u7ec4\u7ec7\u4e0b\u7684\u51ed\u8bc1\u6a21\u677f\u53ca\u51ed\u8bc1\u6a21\u677f\u7684\u9002\u7528\u6761\u4ef6\u3002", (String)"GenerateVoucherProcess_20", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        vchTemData.stream().forEach(f -> this.vchtemplateDataCache.put(f.getTemId(), (VchTemplateMainData)f));
        HashMap<SingleSplitAcctBook, Set<Long>> acctBookWithOperBillGroup = new HashMap<SingleSplitAcctBook, Set<Long>>();
        String spliterror = this.startToSplitTaskGroup(acctBookWithOperBillGroup, vchTemData);
        if (spliterror != null) {
            return spliterror;
        }
        boolean singleBillNotHasBuild = false;
        int schemaCount = 0;
        ArrayList<Long> tpids = new ArrayList<Long>(2);
        try {
            List bvResult;
            ArrayList<GenerateVoucherResult> buildVoucherResult = new ArrayList<GenerateVoucherResult>(acctBookWithOperBillGroup.size());
            this.gvMemory.setSingle_currAcctBookSize(acctBookWithOperBillGroup.size());
            int gv_index = 0;
            for (Map.Entry entry : acctBookWithOperBillGroup.entrySet()) {
                SingleSplitAcctBook bookData = (SingleSplitAcctBook)entry.getKey();
                Set billids = (Set)entry.getValue();
                logger.info("--DAP--\u5f00\u59cb\u6267\u884c\u672c\u6279\u6b21\u4efb\u52a1\uff0c\u4efb\u52a1\u53c2\u6570\uff1abooktype:" + bookData.getBookTypeID() + ";orgfield:" + bookData.getBizOrgField() + ";oper:" + bookData.getOper() + ";orgId:" + bookData.getAcctOrgID() + "bookId:" + bookData.getBookID() + ";vchtemplateId:" + bookData.getVchtemplateId() + ";biliids.length:" + billids.size());
                GenerateVoucherResult gvResult = new GenerateVoucherResult(bookData, new ArrayList(billids), this.billTypeKey, this.BuildVoucherType);
                buildVoucherResult.add(gvResult);
                BuildVchScheme scheme = AutoBuildVchSchemeHelper.buildScheme(bookData.getVchtemplate(), this.billTypeKey, bookData, billids, this.multiDap, this.ignoreTemplateUnique, this.mergeCode, this.eventClass, this.previewPageid, this.buildType, bookData.getOper(), this.BuildVoucherType, this.isBizGenGlVch, this.vchtemplateDataCache.get(bookData.getVchtemplateId()));
                tpids.add(bookData.getVchtemplateId());
                if (scheme != null) {
                    ++schemaCount;
                    scheme.setPreBuild(this.preBuild);
                    scheme.setBuildBizvoucherFromMidle(this.buildBizvoucherFromMidle);
                    scheme.setCurr_succIds_cacheKey(gvResult.getCurr_succIds_cacheKey());
                    scheme.setOnTimeOperateKey(this.getOnTimeOperateKey());
                    scheme.setOpr(this.opr);
                    scheme.setBuildType(this.buildType);
                    scheme.setReoper(bookData.getOper());
                    scheme.setIgnorebillstatus(this.ignoreBillStatus);
                    if (this.multiDap) {
                        this.setBilltypeAndcustomKey(scheme, this.billTypeKey);
                    }
                    if (this.defScheme != null) {
                        SelectedAcctBook s = (SelectedAcctBook)this.defScheme.getSelectedBooks().get(0);
                        ((SelectedAcctBook)scheme.getSelectedBooks().get(0)).setBuildVoucherType(s.getBuildVoucherType());
                        SelectedSourceBill b = (SelectedSourceBill)s.getSelectedSourceBills().get(0);
                        SelectedSourceBill realB = (SelectedSourceBill)((SelectedAcctBook)scheme.getSelectedBooks().get(0)).getSelectedSourceBills().get(0);
                        realB.setUnionFields(b.getUnionFields());
                        realB.setUnionType(b.getUnionType());
                        if (this.preBuild) {
                            realB.setUnionFields(null);
                            realB.setUnionType(GLVoucherUnionType.Single);
                        }
                    }
                    if (this.isSingleBill && !this.multiDap) {
                        if (!this.buildBizvoucherFromMidle && QueryServiceHelper.exists((String)"ai_daptracker", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", (Object)billids), new QFilter("org", "=", (Object)bookData.getAcctOrgID()), new QFilter("booktype", "=", (Object)bookData.getBookTypeID()), new QFilter("reoper", "=", (Object)bookData.getOper()), new QFilter("billtype", "=", (Object)this.billTypeKey)})) continue;
                        singleBillNotHasBuild = true;
                    }
                    List<BuildVchScheme> splitScheme = this.splitScheme(scheme);
                    for (BuildVchScheme schema : splitScheme) {
                        schema.setGvMemory(this.gvMemory);
                        if (this.previewPageid != null) {
                            logger.info("--DAP--previewPageid:" + this.previewPageid + ", vchtemplatePrevoucher:" + this.vchtemplatePrevoucher);
                            schema.setPageId(this.previewPageid);
                            schema.setVchTemplatePreVoucher(this.vchtemplatePrevoucher);
                            DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.accSys);
                            if (cache.get(this.previewPageid + "_perviewvoucher") != null) {
                                String string = null;
                                return string;
                            }
                        }
                        BuildVchServiceImpl buildVchService = new BuildVchServiceImpl();
                        try {
                            schema.setBizBook2AcctBookCache(this.bizBook2AcctBookCache);
                            schema.setAcctOrg2acctOrgCache(this.acctOrg2acctOrgCache);
                            buildVchService.BuildVoucher(schema);
                            gvResult.setThisBookBuildStatus(Boolean.valueOf(true));
                        }
                        catch (Exception e) {
                            if (e instanceof DapException) {
                                DapException de = (DapException)e;
                                ArrayList asList = new ArrayList();
                                for (SelectedAcctBook selectedBooks : schema.getSelectedBooks()) {
                                    for (SelectedSourceBill selectedSourceBills : selectedBooks.getSelectedSourceBills()) {
                                        asList.addAll(selectedSourceBills.getBillIds());
                                    }
                                }
                                Boolean ec = this.eventClass != 0L;
                                String massage = de.getMassage() != null ? de.getMassage() + de.getMessage() : de.getMessage();
                                DapVoucherUtil.generateExceptionReport((Exception)de, (String)this.billTypeKey, asList, (String)massage, (Object)de.getTemplateid(), (Object)de.getBookid(), (Boolean)ec, (Object)de.getExceptionstack(), (Date)start);
                                continue;
                            }
                            DapVoucherUtil.generateNewExceptionReport((Exception)e, (String)this.billTypeKey, (String)ResManager.loadKDString((String)"\u51ed\u8bc1\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u3002", (String)"GenerateVoucherProcess_4", (String)"fi-ai-mservice", (Object[])new Object[0]), null, null);
                        }
                    }
                }
                gvResult.taskToEnd();
                this.gvMemory.currAcctBookToDone(++gv_index);
            }
            if (!singleBillNotHasBuild && schemaCount > 0 && this.isSingleBill && !this.multiDap && !this.iep) {
                errorMessage = ResManager.loadKDString((String)"\u5355\u636e\u5728\u6240\u6709\u59d4\u6258\u6838\u7b97\u8d26\u7c3f\u4e0b\u90fd\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"GenerateVoucherProcess_11", (String)"fi-ai-mservice", (Object[])new Object[0]);
            }
            if ((bvResult = buildVoucherResult.stream().filter(f -> f.getHasDaptrackerBillCol().size() > 0).collect(Collectors.toList())).isEmpty() && errorMessage != null) {
                String string = errorMessage;
                return string;
            }
            this.deleteFailBuildReport(buildVoucherResult, start);
            if (buildVoucherResult.stream().filter(v -> v.getMultiFailsBillIds().size() > 0).count() > 0L) {
                this.insertMultiBuildReport(buildVoucherResult, start);
            }
            this.buildErrorReport(buildVoucherResult, start);
            String string = SysParamConfig.get((String)"sortSavedVoucherNumber");
            if (null != string) {
                this.sortVoucherNo(buildVoucherResult);
            }
            logger.info("--DAP--\u6267\u884c\u751f\u6210\u51ed\u8bc1\u5b8c\u6bd5\uff1a\u672c\u6b21\u751f\u6210\u51ed\u8bc1\u5171\u62c6\u5206\u4e86" + schemaCount + "\u4e2a\u65b9\u6848\uff0c\u5171\u6267\u884c\u4e86" + this.billids.size() + "\u5f20\u5355\u636e\u3002");
        }
        catch (Exception e) {
            ArrayList<Long> ids = new ArrayList<Long>(this.billids);
            Boolean ec = this.eventClass != 0L;
            errorMessage = e.getMessage() != null && e.getMessage().length() > 5 && e.getMessage().length() < 50 ? e.getMessage() : ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5f02\u5e38\u3002", (String)"GenerateVoucherProcess_5", (String)"fi-ai-mservice", (Object[])new Object[0]);
            try (TXHandle tXHandle = TX.requiresNew();){
                try {
                    DapVoucherUtil.generateExceptionReport((Exception)e, (String)this.billTypeKey, ids, (String)e.getMessage(), null, null, (Boolean)ec, null, (Date)start);
                    if (!this.buildBizvoucherFromMidle) {
                        BuildVoucherUtils.rebackCurrTaskBuildVoucherData(this.billids, start, this.billTypeKey);
                    }
                }
                catch (Throwable t) {
                    tXHandle.markRollback();
                }
            }
        }
        finally {
            if (this.isBizGenGlVch && !this.buildBizvoucherFromMidle) {
                this.needDelFailBizVoucher(this.billids);
            }
            if (this.preBuild) {
                tpids.forEach(id -> DapCache.clearTemplateCache((Long)id));
            }
        }
        return errorMessage;
    }

    private void sortVoucherNo(List<GenerateVoucherResult> buildVoucherResult) {
        if (buildVoucherResult.size() <= 1) {
            return;
        }
        HashMap<Long, GLVoucher> allVouchers = new HashMap<Long, GLVoucher>(8);
        for (GenerateVoucherResult re : buildVoucherResult) {
            List stv = re.getSavedTempVoucher();
            if (stv == null) continue;
            for (Object gv : stv) {
                GLVoucher g2 = (GLVoucher)gv;
                g2.getEntryRows().clear();
                allVouchers.put(g2.getId(), g2);
            }
        }
        if (allVouchers.size() == 0) {
            return;
        }
        List pks = QueryServiceHelper.queryPrimaryKeys((String)"gl_voucher", (QFilter[])new QFilter("id", "in", allVouchers.keySet()).toArray(), null, (int)-1);
        allVouchers.keySet().retainAll(pks);
        if (allVouchers.size() == 0) {
            return;
        }
        HashMap<String, List> gp = new HashMap<String, List>(2);
        for (GLVoucher v : allVouchers.values()) {
            gp.computeIfAbsent(v.getSourceBill() + v.getBookId() + v.getPeriodId() + v.getVchTypeId(), k -> new ArrayList(4)).add(v);
        }
        for (List l : gp.values()) {
            if (l.size() <= 1) continue;
            List nums = l.stream().map(g -> g.getNumber()).collect(Collectors.toList());
            nums.sort(Comparator.naturalOrder());
            l.sort(new Comparator<GLVoucher>(){

                @Override
                public int compare(GLVoucher xVch, GLVoucher yVch) {
                    return xVch.getSourceBillNo().compareTo(yVch.getSourceBillNo());
                }
            });
            ArrayList<Object[]> params = new ArrayList<Object[]>(2);
            ArrayList<Long> glvoucherids = new ArrayList<Long>(1);
            for (int i = 0; i < l.size(); ++i) {
                GLVoucher v = (GLVoucher)l.get(i);
                if (v.getNumber().equals(nums.get(i))) continue;
                params.add(new Object[]{nums.get(i), v.getId()});
                glvoucherids.add(v.getId());
            }
            if (params.size() <= 0) continue;
            TXHandle x = TX.required();
            Throwable throwable = null;
            try {
                HintCondition hintOrg = new HintCondition("forgid", "=", (Object)((GLVoucher)l.get(0)).getOrgId());
                HintCondition hintPeroid = new HintCondition("fperiodid", "=", (Object)((GLVoucher)l.get(0)).getPeriodId());
                ShardingHintContext ctx = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{hintOrg, hintPeroid}).prepareShardingIndex();
                Object object = null;
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)"update t_gl_voucher set fnumber = ? where fid = ? ;", params);
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ctx != null) {
                        if (object != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object).addSuppressed(throwable3);
                            }
                        } else {
                            ctx.close();
                        }
                    }
                }
                DB.executeBatch((DBRoute)DBRoute.of((String)"ai"), (String)"update t_ai_buildreport set fglvoucherno = ? where fglvoucherid = ? ;", params);
                List<DynamicObject> list = BuildVchReportUtils.queryNewVchbuildReportByGlvoucherIds(glvoucherids);
                for (DynamicObject object2 : list) {
                    params.stream().filter(param -> param[1].equals(object2.get("glvoucher"))).forEach(param -> {
                        object2.set("glvoucher", param[1]);
                        object2.set("glvoucherno", param[0]);
                    });
                }
                if (list.isEmpty()) continue;
                LogORM logORM = LogORM.create();
                logORM.update(list);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (x == null) continue;
                if (throwable != null) {
                    try {
                        x.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                x.close();
            }
        }
    }

    private String ckeckHasOpenIsDap() {
        Boolean isDap;
        QFilter qf = new QFilter("isdap", "=", (Object)Character.valueOf('1'));
        qf.and(new QFilter("billentity", "=", (Object)("ai_event".equals(this.billTypeKey) ? "ai_eventclass" : this.billTypeKey)));
        if (this.eventClass != 0L) {
            qf.and(new QFilter("eventclass", "=", (Object)this.eventClass));
        }
        if (!(isDap = Boolean.valueOf(QueryServiceHelper.exists((String)"ai_dapconfig", (QFilter[])qf.toArray()))).booleanValue()) {
            if (this.eventClass == 0L) {
                return ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7c7b\u578b\u7684\u3010\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u3011\u6309\u94ae\u672a\u52fe\u9009\uff0c\u8bf7\u524d\u5f80\u51ed\u8bc1\u6a21\u677f\u5217\u8868\u8bbe\u7f6e\u3002", (String)"GenerateVoucherProcess_17", (String)"fi-ai-mservice", (Object[])new Object[0]);
            }
            return ResManager.loadKDString((String)"\u8be5\u5916\u90e8\u6570\u636e\u7c7b\u578b\u7684\u3010\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u3011\u6309\u94ae\u672a\u52fe\u9009\uff0c\u8bf7\u524d\u5f80\u51ed\u8bc1\u6a21\u677f\u5217\u8868\u8bbe\u7f6e\u3002", (String)"GenerateVoucherProcess_18", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        return null;
    }

    private int insertMultiBuildReport(List<GenerateVoucherResult> buildVoucherResult, Date start) {
        IOperateInfo oi;
        Object allErrorOrValidateInfo;
        List successPkIds;
        TXHandle x;
        DynamicObjectCollection doCol;
        QFilter qFilter_date;
        QFilter qFilter_sid;
        Object ids2;
        Object succData;
        HashSet has_save_voucher_col = new HashSet(8);
        HashSet wait_merge_voucher_col = new HashSet(8);
        HashSet has_save_bizvoucher_col = new HashSet(8);
        HashMap<Long, Map> allTaskFailBills = new HashMap<Long, Map>(8);
        HashMap<Long, Map> allTaskSuccBills = new HashMap<Long, Map>(8);
        for (GenerateVoucherResult generateVoucherResult : buildVoucherResult) {
            has_save_voucher_col.addAll(generateVoucherResult.getHas_save_voucher_col());
            wait_merge_voucher_col.addAll(generateVoucherResult.getWait_merge_voucher_col());
            has_save_bizvoucher_col.addAll(generateVoucherResult.getHas_save_bizvoucher_col());
            Long l = generateVoucherResult.getAcctBook().getAcctOrgID();
            Long bookTypeID = generateVoucherResult.getAcctBook().getBookTypeID();
            allTaskFailBills.computeIfAbsent(l, v -> new HashMap()).computeIfAbsent(bookTypeID, v -> new HashSet()).addAll(generateVoucherResult.getMultiFailsBillIds());
            allTaskSuccBills.computeIfAbsent(l, v -> new HashMap()).computeIfAbsent(bookTypeID, v -> new HashSet()).addAll(generateVoucherResult.getHasDaptrackerBillCol());
        }
        HashSet failBillIds = new HashSet(8);
        for (Map.Entry entry : allTaskFailBills.entrySet()) {
            Long currOrgId = (Long)entry.getKey();
            Map failData = (Map)entry.getValue();
            succData = (Map)allTaskSuccBills.get(currOrgId);
            HashSet bookTypeIds = new HashSet(failData.keySet());
            bookTypeIds.addAll(succData.keySet());
            for (Map.Entry entry2 : succData.entrySet()) {
                Long btid = (Long)entry2.getKey();
                ids2 = (Set)entry2.getValue();
                HashSet allfailids = new HashSet(16);
                for (Long bt : bookTypeIds) {
                    if (bt.equals(btid)) continue;
                    allfailids.addAll((Collection)failData.get(bt));
                }
                allfailids.retainAll((Collection<?>)ids2);
                failBillIds.addAll(allfailids);
            }
        }
        logger.info("\u751f\u6210\u51ed\u8bc1\u6709\u8fc7\u5931\u8d25\u7684id" + failBillIds);
        QFilter qFilter = new QFilter("createtime", ">=", (Object)start);
        QFilter qFilter2 = new QFilter("buildstate", "=", (Object)"0");
        QFilter idFilter = new QFilter("fsourcebillid", "in", failBillIds);
        TXHandle x2 = TX.requiresNew();
        succData = null;
        try {
            DeleteServiceHelper.delete((String)"ai_buildreport", (QFilter[])new QFilter[]{qFilter2, idFilter, qFilter});
        }
        catch (Throwable bookTypeIds) {
            succData = bookTypeIds;
            throw bookTypeIds;
        }
        finally {
            if (x2 != null) {
                if (succData != null) {
                    try {
                        x2.close();
                    }
                    catch (Throwable bookTypeIds) {
                        ((Throwable)succData).addSuppressed(bookTypeIds);
                    }
                } else {
                    x2.close();
                }
            }
        }
        has_save_voucher_col.retainAll(failBillIds);
        wait_merge_voucher_col.retainAll(failBillIds);
        has_save_bizvoucher_col.retainAll(failBillIds);
        if (!has_save_voucher_col.isEmpty()) {
            HashSet<Long> voucherids = new HashSet<Long>(8);
            qFilter_sid = new QFilter("sourcebillid", "in", has_save_voucher_col);
            qFilter_date = new QFilter("createdate", ">", (Object)start);
            doCol = QueryServiceHelper.query((String)"ai_daptracker", (String)"voucherid", (QFilter[])new QFilter[]{qFilter_sid, qFilter_date});
            for (DynamicObject data : doCol) {
                voucherids.add(data.getLong("voucherid"));
            }
            logger.info("\u9700\u8981\u5220\u9664\u6210\u529f\u7684\u51ed\u8bc1" + voucherids);
            if (!voucherids.isEmpty()) {
                OperationResult operationResult;
                Object var16_25 = null;
                x = TX.requiresNew();
                ids2 = null;
                try {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue("isTcc", "true");
                    operateOption.setVariableValue("mechanism", "true");
                    operateOption.setVariableValue("ishasright", String.valueOf(true));
                    operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])voucherids.toArray(), (OperateOption)operateOption);
                }
                catch (Throwable operateOption) {
                    ids2 = operateOption;
                    throw operateOption;
                }
                finally {
                    if (x != null) {
                        if (ids2 != null) {
                            try {
                                x.close();
                            }
                            catch (Throwable operateOption) {
                                ((Throwable)ids2).addSuppressed(operateOption);
                            }
                        } else {
                            x.close();
                        }
                    }
                }
                if (operationResult != null) {
                    successPkIds = operationResult.getSuccessPkIds();
                    logger.info("\u6267\u884c\u5220\u9664\u7684\u51ed\u8bc1\u6210\u529f\u7ed3\u679c\uff1asize:" + successPkIds.size() + ";successPkIds:" + successPkIds);
                    logger.info("\u5220\u9664\u51ed\u8bc1\u7684\u5931\u8d25\u4fe1\u606f" + operationResult.getMessage() + "----" + operationResult.getValidateResult().getMessage() + "----" + (operationResult.getAllErrorInfo().size() > 0 ? ((OperateErrorInfo)operationResult.getAllErrorInfo().get(0)).getMessage() : null));
                    allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                    HashSet<Object> ids3 = new HashSet<Object>(16);
                    Iterator iterator = allErrorOrValidateInfo.iterator();
                    while (iterator.hasNext()) {
                        oi = (IOperateInfo)iterator.next();
                        ids3.add(oi.getPkValue());
                    }
                    if (!ids3.isEmpty()) {
                        int size = DeleteServiceHelper.delete((String)"gl_voucher", (QFilter[])new QFilter("id", "in", ids3).toArray());
                        TempVoucherService.deleteByIds((Long[])ids3.toArray(new Long[0]));
                        logger.info(String.format("\u901a\u8fc7\u6570\u636e\u5e93\u5220\u9664\u7684\u8bb0\u5f55\u6709---%s---\u6761", size));
                        String joinIds = QFilterBuilder.buildSQLParamHolder((int)ids3.size());
                        logger.info("\u5f00\u59cb\u5220\u9664\u5931\u8d25\u7684\u4e1a\u52a1\u51ed\u8bc1");
                        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucherentry where fid in (select fid from t_ai_bizvoucher where fglvoucherid in " + joinIds + ")"), (Object[])ids3.toArray());
                        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucher where fglvoucherid in " + joinIds), (Object[])ids3.toArray());
                        logger.info("\u5f00\u59cb\u5220\u9664\u5931\u8d25\u7684DAP\u5173\u7cfb");
                        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptrackerentry where fid in (select fid from t_ai_daptracker where fvoucherid in " + joinIds + ")"), (Object[])ids3.toArray());
                        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptracker where fvoucherid in " + joinIds), (Object[])ids3.toArray());
                        logger.info(String.format("\u603b\u8bb0\u5f55\u6709---%s---\u6761", ids3.size()));
                    }
                }
            }
        }
        if (!wait_merge_voucher_col.isEmpty()) {
            Set need_del_vids = this.gvMemory.getTrackersNotToSave().stream().filter(f -> wait_merge_voucher_col.contains(f.get("sourcebillid"))).map(m -> m.getLong("voucherid")).collect(Collectors.toSet());
            this.gvMemory.addNeed_del_gl_id(need_del_vids);
        }
        if (!has_save_bizvoucher_col.isEmpty()) {
            HashSet<Long> bizvoucherids = new HashSet<Long>(8);
            qFilter_sid = new QFilter("sourcebillid", "in", has_save_bizvoucher_col);
            qFilter_date = new QFilter("createtime", ">", (Object)start);
            doCol = QueryServiceHelper.query((String)"ai_bizvoucher", (String)"id,sourcebillid", (QFilter[])new QFilter[]{qFilter_sid, qFilter_date});
            for (DynamicObject data : doCol) {
                bizvoucherids.add(data.getLong("id"));
            }
            logger.info("\u9700\u8981\u5220\u9664\u6210\u529f\u7684\u4e1a\u52a1\u51ed\u8bc1" + bizvoucherids);
            if (!bizvoucherids.isEmpty()) {
                OperationResult operationResult;
                Object var16_29 = null;
                x = TX.requiresNew();
                allErrorOrValidateInfo = null;
                try {
                    operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"ai_bizvoucher", (Object[])bizvoucherids.toArray(), (OperateOption)OperateOption.create());
                }
                catch (Throwable ids3) {
                    allErrorOrValidateInfo = ids3;
                    throw ids3;
                }
                finally {
                    if (x != null) {
                        if (allErrorOrValidateInfo != null) {
                            try {
                                x.close();
                            }
                            catch (Throwable ids3) {
                                ((Throwable)allErrorOrValidateInfo).addSuppressed(ids3);
                            }
                        } else {
                            x.close();
                        }
                    }
                }
                if (operationResult != null) {
                    successPkIds = operationResult.getSuccessPkIds();
                    logger.info("\u6267\u884c\u5220\u9664\u7684\u51ed\u8bc1\u6210\u529f\u7ed3\u679c\uff1asize:" + successPkIds.size() + ";successPkIds:" + successPkIds);
                    logger.info("\u5220\u9664\u51ed\u8bc1\u7684\u5931\u8d25\u4fe1\u606f" + operationResult.getMessage() + "----" + operationResult.getValidateResult().getMessage() + "----" + (operationResult.getAllErrorInfo().size() > 0 ? ((OperateErrorInfo)operationResult.getAllErrorInfo().get(0)).getMessage() : null));
                    allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                    HashSet<Object> ids = new HashSet<Object>(16);
                    Iterator size = allErrorOrValidateInfo.iterator();
                    while (size.hasNext()) {
                        oi = (IOperateInfo)size.next();
                        ids.add(oi.getPkValue());
                    }
                    if (!ids.isEmpty()) {
                        String joinIds = QFilterBuilder.buildSQLParamHolder((int)ids.size());
                        logger.info("\u5f00\u59cb\u5220\u9664\u5931\u8d25\u7684\u4e1a\u52a1\u51ed\u8bc1");
                        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucherentry where fid in (select fid from t_ai_bizvoucher where fglvoucherid in " + joinIds + ")"), (Object[])ids.toArray());
                        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucher where fglvoucherid in " + joinIds), (Object[])ids.toArray());
                    }
                }
            }
        }
        if (!failBillIds.isEmpty()) {
            BuildVchReporter reporter = new BuildVchReporter();
            String billType = buildVoucherResult.get(0).getBillType();
            SourceBillInfo billInfo = new SourceBillInfo();
            billInfo.setEntityNumber(billType);
            String billno = this.eventClass != 0L ? "number" : DapBuildVoucherCommonUtil.getBillNoFormBill((String)billType);
            String string = "id," + billno;
            HashMap<Object, String> idAndNo = new HashMap<Object, String>(this.billids.size());
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.fi.ai.DapVoucherUtil", (String)billType, (String)string, (QFilter[])new QFilter("id", "in", this.billids).toArray(), null);
            Object object = null;
            try {
                for (Row row : queryDataSet) {
                    Object id = row.get("id");
                    String no = row.getString(billno);
                    idAndNo.put(id, no);
                }
            }
            catch (Throwable iterator) {
                object = iterator;
                throw iterator;
            }
            finally {
                if (queryDataSet != null) {
                    if (object != null) {
                        try {
                            queryDataSet.close();
                        }
                        catch (Throwable iterator) {
                            ((Throwable)object).addSuppressed(iterator);
                        }
                    } else {
                        queryDataSet.close();
                    }
                }
            }
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u591a\u8d26\u7c3f\u673a\u5236\u51ed\u8bc1\u9700\u540c\u65f6\u751f\u6210\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u8bbe\u7f6e\u6216\u8005\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u3002", (String)"GenerateVoucherProcess_7", (String)"fi-ai-mservice", (Object[])new Object[0]);
            for (Long id : failBillIds) {
                reporter.AddErrorReport(null, billInfo, id, (String)idAndNo.get(id), null, VoucherCheckItem.Bill, VoucherErrLevel.Error, msg, this.buildType, this.BuildVoucherType);
            }
            reporter.SaveReoprt("gl");
        }
        return failBillIds.size();
    }

    private int deleteFailBuildReport(List<GenerateVoucherResult> buildVoucherResult, Date start) {
        HashSet neeDel = new HashSet(8);
        for (GenerateVoucherResult gvr : buildVoucherResult) {
            HashSet del = new HashSet();
            del.addAll(gvr.getHasDaptrackerBillCol());
            del.removeAll(gvr.getMultiBookNeedSuccessIds());
            neeDel.addAll(del);
        }
        QFilter timeFilter = new QFilter("createtime", ">=", (Object)start);
        QFilter stateFilter = new QFilter("buildstate", "=", (Object)"1");
        QFilter idFilter = new QFilter("fsourcebillid", "in", neeDel);
        try (TXHandle x = TX.requiresNew();){
            DeleteServiceHelper.delete((String)"ai_buildreport", (QFilter[])new QFilter[]{stateFilter, idFilter, timeFilter});
        }
        return neeDel.size();
    }

    private void initGenVoucherParams() {
        this.bookHelper = new DapBookHelper(this.bizBook2AcctBookCache, this.acctOrg2acctOrgCache);
        logger.info("--DAP--paramJson:" + this.paramJson);
        Map params = null;
        Map preOrSelect = null;
        if (StringUtils.isNotBlank((CharSequence)this.paramJson)) {
            params = (Map)SerializationUtils.fromJsonString((String)this.paramJson, Map.class);
            preOrSelect = (Map)SerializationUtils.fromJsonString((String)this.paramJson, Map.class);
            String opParams = (String)params.get("parameter");
            if (StringUtils.isNotBlank((CharSequence)opParams)) {
                params = (Map)SerializationUtils.fromJsonString((String)opParams, Map.class);
            }
        }
        if (params != null && params.get("multidap") != null) {
            this.multiDap = (Boolean)params.get("multidap");
        } else if (preOrSelect != null && preOrSelect.get("multidap") != null) {
            this.multiDap = (Boolean)preOrSelect.get("multidap");
        }
        if (params != null && params.get("vchtemplateprevoucher") != null) {
            this.vchtemplatePrevoucher = true;
        }
        if (preOrSelect != null && preOrSelect.get("ignoretemplateunique") != null) {
            this.ignoreTemplateUnique = true;
        }
        if (preOrSelect != null && preOrSelect.get("mergeCode") != null) {
            this.mergeCode = (String)preOrSelect.get("mergeCode");
        }
        if (preOrSelect != null && preOrSelect.get("previewpageid") != null) {
            this.previewPageid = (String)preOrSelect.get("previewpageid");
        }
        if (preOrSelect != null && preOrSelect.get("isBizGenerateVoucher") != null) {
            this.isBizGenGlVch = Boolean.parseBoolean(preOrSelect.get("isBizGenerateVoucher").toString());
        }
        if (!DapWriteAndBlackOpSetUtil.getBuildVoucherOptFromBill((String)this.billTypeKey).isEmpty()) {
            this.hasReOper = true;
        }
        if (preOrSelect != null && preOrSelect.get("ignorebillstatus") != null) {
            this.ignoreBillStatus = Boolean.parseBoolean(preOrSelect.get("ignorebillstatus").toString());
        }
        if (preOrSelect != null && preOrSelect.get("openalltemplate") != null && !this.multiDap) {
            this.openalltemplate = Boolean.parseBoolean(preOrSelect.get("openalltemplate").toString());
        }
        if (preOrSelect != null && preOrSelect.get("tempInfo") != null) {
            this.tempSelect = (Map)SerializationUtils.fromJsonString((String)(preOrSelect.get("tempInfo") + ""), Map.class);
        }
        if (this.billids.size() == 1) {
            this.isSingleBill = true;
        }
        if (preOrSelect != null && preOrSelect.get("preBuild") != null) {
            this.preBuild = true;
            this.BuildVoucherType = "4";
        }
        if (preOrSelect != null && preOrSelect.get("buildBizvoucherFromMidle") != null) {
            this.buildBizvoucherFromMidle = true;
        }
        logger.info("--DAP--initGenVoucherParams--multidap:" + this.multiDap + ";ignoretemplateunique:" + this.ignoreTemplateUnique + ";isBizGenGlVch:" + this.isBizGenGlVch + ";ignorebillstatus:" + this.ignoreBillStatus + ";hasReOper:" + this.hasReOper + ";billsize:" + this.billids.size() + ";billtype:" + this.billTypeKey + ";BuildVoucherType:" + this.BuildVoucherType + ";iep:" + this.iep + ";previewPageid:" + this.previewPageid + ";openalltemplate:" + this.openalltemplate);
    }

    private void needDelFailBizVoucher(Set<Long> ids) {
        if (ids.isEmpty()) {
            return;
        }
        HashSet<Long> needDel = new HashSet<Long>(ids.size());
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.service.GenerateVoucherProcess", (String)"ai_bizvoucher", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", ids), new QFilter("glvoucherid", "=", (Object)0L), new QFilter("sourcebill", "=", (Object)this.billTypeKey)}, null);){
            for (Row row : queryDataSet) {
                Long id = row.getLong("id");
                needDel.add(id);
            }
        }
        if (!needDel.isEmpty()) {
            OperationServiceHelper.executeOperate((String)"delete", (String)"ai_bizvoucher", (Object[])needDel.toArray(), (OperateOption)OperateOption.create());
        }
    }

    private void buildErrorReport(List<GenerateVoucherResult> buildVoucherResult, Date start) {
        if (buildVoucherResult.isEmpty()) {
            return;
        }
        HashSet<Long> failBillId = new HashSet<Long>(this.billids);
        HashSet hasSuccessBillId = new HashSet(8);
        for (GenerateVoucherResult gvr : buildVoucherResult) {
            hasSuccessBillId.addAll(gvr.getHasDaptrackerBillCol());
        }
        failBillId.removeAll(hasSuccessBillId);
        if (!failBillId.isEmpty()) {
            BuildVchReporter reporter = new BuildVchReporter();
            SourceBillInfo billInfo = new SourceBillInfo();
            billInfo.setEntityNumber(this.billTypeKey);
            String billno = this.eventClass != 0L ? "number" : DapBuildVoucherCommonUtil.getBillNoFormBill((String)this.billTypeKey);
            String selectcol = "id," + billno;
            HashMap<Object, String> idAndNo = new HashMap<Object, String>(this.billids.size());
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.fi.ai.DapVoucherUtil", (String)this.billTypeKey, (String)selectcol, (QFilter[])new QFilter("id", "in", failBillId).toArray(), null);
            Object object = null;
            try {
                for (Row row : queryDataSet) {
                    Object id = row.get("id");
                    String no = row.getString(billno);
                    idAndNo.put(id, no);
                }
            }
            catch (Throwable iterator) {
                object = iterator;
                throw iterator;
            }
            finally {
                if (queryDataSet != null) {
                    if (object != null) {
                        try {
                            queryDataSet.close();
                        }
                        catch (Throwable iterator) {
                            ((Throwable)object).addSuppressed(iterator);
                        }
                    } else {
                        queryDataSet.close();
                    }
                }
            }
            HashSet<Long> hasBuild = new HashSet<Long>(8);
            DataSet queryDataSet2 = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.fi.ai.DapVoucherUtil", (String)"ai_buildreport", (String)"id,fsourcebillid", (QFilter[])new QFilter[]{new QFilter("fsourcebillid", "in", failBillId), new QFilter("createtime", ">=", (Object)start)}, null);
            Object iterator = null;
            try {
                for (Row row : queryDataSet2) {
                    hasBuild.add(row.getLong("fsourcebillid"));
                }
            }
            catch (Throwable iterator2) {
                iterator = iterator2;
                throw iterator2;
            }
            finally {
                if (queryDataSet2 != null) {
                    if (iterator != null) {
                        try {
                            queryDataSet2.close();
                        }
                        catch (Throwable iterator2) {
                            ((Throwable)iterator).addSuppressed(iterator2);
                        }
                    } else {
                        queryDataSet2.close();
                    }
                }
            }
            Collections.reverse(buildVoucherResult);
            for (GenerateVoucherResult gve : buildVoucherResult) {
                String msg = gve.getAcctBookErrorMessage();
                logger.info("getAcctBookErrorMessage:" + msg);
                if (msg == null) continue;
                List sids = gve.getBillIds();
                for (Long billid : sids) {
                    if (hasBuild.contains(billid) || !failBillId.contains(billid)) continue;
                    reporter.AddErrorReport(null, billInfo, billid, (String)idAndNo.get(billid), null, VoucherCheckItem.Bill, VoucherErrLevel.Error, msg, this.buildType, this.BuildVoucherType);
                }
            }
            reporter.SaveReoprt("gl");
        }
    }

    private void loadBillOrgAndBookType(String billTypeKey, Set<Long> billids, Map<AcctBook, Set<Long>> acctBookBillGroup, List<String> orgPropNames, String bookPropName, String bookTypePropName, Long eventClass) {
        String[] pops;
        StringBuilder selector = new StringBuilder();
        String billno = eventClass != 0L ? "number" : DapBuildVoucherCommonUtil.getBillNoFormBill((String)billTypeKey);
        selector.append("id,");
        selector.append(billno);
        boolean eventEntryOrg = false;
        HashSet<String> dupilyProCol = new HashSet<String>(8);
        for (String orgPropName : orgPropNames) {
            MainEntityType eventMeta;
            selector.append(",");
            selector.append(orgPropName);
            String[] pops2 = orgPropName.split("\\.");
            if (pops2.length > 1) {
                for (int i = 0; i < pops2.length - 1; ++i) {
                    StringBuilder currprop = new StringBuilder();
                    if (i > 0) {
                        for (int j = 0; j < i; ++j) {
                            currprop.append(pops2[j]);
                            currprop.append(".");
                        }
                    }
                    currprop.append(pops2[i]);
                    currprop.append(".id");
                    String curop = currprop.toString();
                    if (!dupilyProCol.add(curop)) continue;
                    selector.append(",");
                    selector.append(curop);
                }
                if (eventClass == 0L) continue;
                eventEntryOrg = true;
                continue;
            }
            if (eventClass == 0L || (eventMeta = EntityMetadataCache.getDataEntityType((String)billTypeKey)).getProperty(orgPropName) != null) continue;
            eventEntryOrg = true;
        }
        if (StringUtils.isNotBlank((CharSequence)bookPropName)) {
            selector.append(",");
            selector.append(bookPropName);
            pops = bookPropName.split("\\.");
            if (pops.length > 1) {
                for (int i = 0; i < pops.length - 1; ++i) {
                    selector.append(",");
                    if (i > 0) {
                        for (int j = 0; j < i; ++j) {
                            selector.append(pops[j]);
                            selector.append(".");
                        }
                    }
                    selector.append(pops[i]);
                    selector.append(".id");
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)bookTypePropName)) {
            selector.append(",");
            selector.append(bookTypePropName);
            pops = bookTypePropName.split("\\.");
            if (pops.length > 1) {
                for (int i = 0; i < pops.length - 1; ++i) {
                    selector.append(",");
                    if (i > 0) {
                        for (int j = 0; j < i; ++j) {
                            selector.append(pops[j]);
                            selector.append(".");
                        }
                    }
                    selector.append(pops[i]);
                    selector.append(".id");
                }
            }
        }
        List keyLists = ListUtils.partition(new ArrayList<Long>(billids), (int)1000);
        ArrayList<DapReportUtil.ReportData> reports = new ArrayList<DapReportUtil.ReportData>();
        logger.info("##############selector#########" + selector + "########orgPropNames#######" + orgPropNames);
        for (List ids : keyLists) {
            DynamicObjectCollection bills = null;
            if (eventEntryOrg) {
                List batchEvtEntry = DataSourceFactory.getDataSource().batchEvtEntry((Object)eventClass, new HashSet(ids));
                for (Object eventInfo : batchEvtEntry) {
                    DynamicObjectCollection rows;
                    if (eventInfo instanceof Map) {
                        Map event = (Map)eventInfo;
                        String pk = "";
                        Object entryPk = null;
                        if (event.containsKey("pk")) {
                            pk = event.get("pk");
                        }
                        if (event.containsKey("entryPk")) {
                            entryPk = event.get("entryPk");
                        }
                        eventInfo = new PkEntryPkPair((Object)pk, entryPk);
                    } else if (eventInfo instanceof Collection) {
                        Collection eic = (Collection)eventInfo;
                        eventInfo = new HashSet(eic);
                    }
                    if ((rows = DataSourceFactory.getDataSource().getEventObjectCollection((Object)eventClass, eventInfo, selector.toString())).isEmpty()) continue;
                    this.loadBookBatch(billTypeKey, acctBookBillGroup, orgPropNames, bookPropName, bookTypePropName, billno, reports, rows, eventClass);
                }
                continue;
            }
            bills = QueryServiceHelper.query((String)billTypeKey, (String)selector.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
            this.loadBookBatch(billTypeKey, acctBookBillGroup, orgPropNames, bookPropName, bookTypePropName, billno, reports, bills, 0L);
        }
        if (reports.size() > 0) {
            DapReportUtil.saveReport(reports.toArray(new DapReportUtil.ReportData[0]), this.buildType, this.BuildVoucherType);
        }
    }

    private void loadBookBatch(String billTypeKey, Map<AcctBook, Set<Long>> acctBookBillGroup, List<String> orgPropNames, String bookPropName, String bookTypePropName, String billno, List<DapReportUtil.ReportData> reports, DynamicObjectCollection bills, long eventClassID) {
        for (DynamicObject bill : bills) {
            DapBookHelper.BilBookResult result = this.bookHelper.getSingleBillAcctBook(billTypeKey, orgPropNames, bookPropName, bookTypePropName, bill, eventClassID);
            Set<AcctBook> books = result.getAcctBooks();
            for (AcctBook book : books) {
                if (acctBookBillGroup.containsKey(book)) {
                    acctBookBillGroup.get(book).add(bill.getLong("id"));
                    continue;
                }
                HashSet<Long> billIdSet = new HashSet<Long>();
                billIdSet.add(bill.getLong("id"));
                acctBookBillGroup.put(book, billIdSet);
            }
            if (books.size() == 0 && result.isNoOrg()) {
                DapReportUtil.ReportData rep = new DapReportUtil.ReportData();
                SourceBillInfo billInfo = new SourceBillInfo();
                billInfo.setEntityNumber(billTypeKey);
                rep.setSourceBill(billInfo);
                rep.setSourceBillId(bill.getLong("id"));
                String billNumber = "";
                try {
                    billNumber = bill.getString(billno);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                rep.setSourceBillNo(billNumber);
                rep.setVchTemplateID("0");
                rep.setCheckItem(VoucherCheckItem.Other);
                rep.setErrLevel(VoucherErrLevel.Error);
                rep.setErrMessage(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u201c%s\u201d\u4e1a\u52a1\u5355\u5143\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u6240\u6709\u51ed\u8bc1\u6a21\u677f\u4e1a\u52a1\u5355\u5143\u914d\u7f6e\u3002", (String)"GenerateVoucherProcess_8", (String)"fi-ai-mservice", (Object[])new Object[0]), bill.getString(billno)));
                reports.add(rep);
            }
            if (books.size() != 0 || result.getNoBookOrgs().size() <= 0) continue;
            Set<Long> orgs = result.getNoBookOrgs();
            for (Long orgid : orgs) {
                String orgName = "";
                if (this.orgNameCache.containsKey(orgid)) {
                    orgName = this.orgNameCache.get(orgid);
                } else {
                    DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org", (String)"id,name");
                    orgName = org.getString("name");
                    this.orgNameCache.put(orgid, orgName);
                }
                DapReportUtil.ReportData rep = new DapReportUtil.ReportData();
                SourceBillInfo billInfo = new SourceBillInfo();
                billInfo.setEntityNumber(billTypeKey);
                rep.setSourceBill(billInfo);
                rep.setSourceBillId(bill.getLong("id"));
                String billNumber = "";
                try {
                    billNumber = bill.getString(billno);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                rep.setSourceBillNo(billNumber);
                rep.setVchTemplateID("0");
                rep.setCheckItem(VoucherCheckItem.Other);
                rep.setErrLevel(VoucherErrLevel.Error);
                String mesg = ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u5355\u5143[%s]\u5bf9\u5e94\u4f1a\u8ba1\u8d26\u7c3f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u603b\u8d26\u4f1a\u8ba1\u8d26\u7c3f\u4e0e\u4e1a\u52a1\u8d26\u7c3f\u914d\u7f6e\uff0c\u6216\u68c0\u67e5\u6838\u7b97\u4f53\u7cfb\u53ca\u8bb0\u8d26\u8303\u56f4\u8bbe\u7f6e\u3002", (String)"GenerateVoucherProcess_10", (String)"fi-ai-mservice", (Object[])new Object[0]);
                rep.setErrMessage(String.format(mesg, orgName));
                reports.add(rep);
            }
        }
    }

    public String getOnTimeOperateKey() {
        return this.onTimeOperateKey;
    }

    public void setOnTimeOperateKey(String onTimeOperateKey) {
        this.onTimeOperateKey = onTimeOperateKey;
    }

    private void setBilltypeAndcustomKey(BuildVchScheme scheme, String billType) {
        if (StringUtils.isBlank((CharSequence)billType)) {
            return;
        }
        Map billtypeAndCustomkey = scheme.getBilltypeAndCustomkey();
        if (billtypeAndCustomkey.get(billType) != null && !((Map)billtypeAndCustomkey.get(billType)).isEmpty()) {
            return;
        }
        String entityName = billType.equals("ai_event") ? "ai_eventclass" : billType;
        logger.info("--DAP--start To Get CustomuniqueKey:" + entityName);
        String sql = "select fcustomuniquekey as ck from t_ai_dapconfig where fbillentity = '" + entityName + "'";
        ArrayList<String> bill = new ArrayList<String>();
        ArrayList<String> voucher = new ArrayList<String>();
        ArrayList<String> customuniquekey = new ArrayList<String>();
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.mservice.service.GenerateVoucherProcess", (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            for (Row row : queryDataSet) {
                String cks = row.getString("ck");
                if (!StringUtils.isNotBlank((CharSequence)cks)) continue;
                String ckrs = cks.replaceAll(" ", "");
                String[] split = ckrs.split("&&");
                int index = 1;
                for (String s : split) {
                    if (s.startsWith("$")) {
                        String replace = s.replace("$", "");
                        voucher.add(replace);
                        customuniquekey.add(index + "-" + replace);
                    } else {
                        bill.add(s);
                        customuniquekey.add(index + "-" + s);
                    }
                    ++index;
                }
            }
        }
        logger.info("--DAP--getCustomUniqueKeyValue: --bill:" + bill + ";voucher:" + voucher + ";customuniquekey:" + customuniquekey);
        HashMap<String, ArrayList<String>> customKeyMap = new HashMap<String, ArrayList<String>>(2);
        customKeyMap.put("bill", bill);
        customKeyMap.put("voucher", voucher);
        customKeyMap.put("customuniquekey", customuniquekey);
        billtypeAndCustomkey.put(billType, customKeyMap);
    }

    private void mergeBookAndOperBill(Map<AcctBook, Set<Long>> acctBookBillGroup, Map<SingleSplitAcctBook, Set<Long>> acctBookWithOperBillGroup, Set<Long> billids2) {
        Map splitReloperAndBilltype = DapWriteAndBlackOpSetUtil.splitReloperAndBilltype((String)this.billTypeKey, new HashSet<Long>(billids2));
        for (Map.Entry<AcctBook, Set<Long>> next : acctBookBillGroup.entrySet()) {
            AcctBook key = next.getKey();
            Set<Long> value = next.getValue();
            for (Map.Entry sr : splitReloperAndBilltype.entrySet()) {
                String oper = (String)sr.getKey();
                Set ids = (Set)sr.getValue();
                SingleSplitAcctBook abwo = new SingleSplitAcctBook(key, oper);
                HashSet<Long> newIds = new HashSet<Long>(value);
                newIds.retainAll(ids);
                acctBookWithOperBillGroup.put(abwo, newIds);
            }
        }
    }

    public String getBuildVoucherType() {
        return this.BuildVoucherType;
    }

    public void setBuildVoucherType(String buildVoucherType) {
        this.BuildVoucherType = buildVoucherType;
    }

    private List<VchTemplateMainData> getVchtemplateDataFromTaskInfo() {
        List vchTemplates;
        List<Object> result = new ArrayList(8);
        if (!this.tempSelect.isEmpty()) {
            List selectIds = this.tempSelect.entrySet().iterator().next().getValue().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
            vchTemplates = DapCache.getTemplateByCacheThenSelectByIds(selectIds);
            result = vchTemplates.stream().map(m -> new VchTemplateMainData((VCHTemplate)m, this.billids, this.billTypeKey)).collect(Collectors.toList());
        } else {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>();
            filterList.add(new QFilter("enable", "!=", (Object)"0"));
            if (this.eventClass != 0L) {
                filterList.add(new QFilter("eventclass", "=", (Object)this.eventClass));
                filterList.add(new QFilter("fsourcebill", "=", (Object)"ai_eventclass"));
            } else {
                QFilter billTypeFilter = new QFilter("fsourcebill", "=", (Object)this.billTypeKey);
                DynamicObject dapConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"ai_dapconfig", (String)"parentbill.id", (QFilter[])new QFilter("billentity.id", "=", (Object)this.billTypeKey).toArray());
                if (dapConfig != null && StringUtils.isNotEmpty((CharSequence)dapConfig.getString("parentbill.id"))) {
                    billTypeFilter.or(new QFilter("fsourcebill", "=", (Object)dapConfig.getString("parentbill.id")));
                }
                filterList.add(billTypeFilter);
            }
            if (this.onTimeOperateKey != null) {
                filterList.add(new QFilter("oper", "=", (Object)this.onTimeOperateKey));
            }
            vchTemplates = DapCache.getTemplateByFilters(filterList);
            result = vchTemplates.stream().map(m -> new VchTemplateMainData((VCHTemplate)m, this.billids, this.billTypeKey)).collect(Collectors.toList());
            result = SelectTemplateUtil.matchTemplate(result, this.billTypeKey, this.billids);
        }
        result = result.stream().filter(f -> !f.getMatchSourcebillid().isEmpty()).collect(Collectors.toList());
        for (VchTemplateMainData vt : result) {
            logger.info("--DAP--vchtemplatematchresult---vchid:" + vt.getTemId() + ";matchid:" + vt.getMatchSourcebillid());
        }
        return result;
    }

    private String startToSplitTaskGroup(Map<SingleSplitAcctBook, Set<Long>> acctBookWithOperBillGroup, List<VchTemplateMainData> vchTemData) {
        List<String> bizOrgFileCol = vchTemData.stream().map(v -> v.getBizOrgField()).distinct().collect(Collectors.toList());
        HashMap<AcctBook, Set<Long>> acctBookBillGroup = new HashMap<AcctBook, Set<Long>>();
        DapConfig cg = null;
        cg = this.eventClass != 0L ? DapCache.getDapConfigCache((String)"ai_eventclass", (long)this.eventClass) : DapCache.getDapConfigCache((String)this.billTypeKey);
        String billBookTypeField = DapCache.getBillBookTypeField((String)this.billTypeKey);
        String billBookField = DapCache.getBillBookField((String)this.billTypeKey);
        if (cg != null && bizOrgFileCol.size() > 0) {
            logger.info("--DAP--############\u5f00\u59cb\u52a0\u8f7d\u8d26\u7c3fMAP\u4fe1\u606f###########orgFile ===" + bizOrgFileCol);
            this.loadBillOrgAndBookType(this.billTypeKey, this.billids, acctBookBillGroup, bizOrgFileCol, billBookField, billBookTypeField, this.eventClass);
            this.mergeBookAndOperBill(acctBookBillGroup, acctBookWithOperBillGroup, this.billids);
            String error = this.dipliVchtemAndAcctBookOper(acctBookWithOperBillGroup, vchTemData);
            logger.info("--DAP--############\u53d6\u5f97\u8d26\u7c3f\u4fe1\u606f" + acctBookWithOperBillGroup.size() + "##############");
            if (error != null) {
                return error;
            }
        } else {
            String orgFieldsStr = bizOrgFileCol != null ? bizOrgFileCol.toString() : "";
            logger.info("NoConfig:billTypeKey=" + this.billTypeKey + ",cg=" + cg + ",bizOrgFields=" + orgFieldsStr);
            return ResManager.loadKDString((String)"\u83b7\u53d6\u5355\u636e\u7684DAP\u914d\u7f6e\u5931\u8d25\uff0c\u5355\u636e\u672a\u5f00\u542f\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u5148\u5f00\u542f\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u914d\u7f6e\u3002", (String)"GenerateVoucherProcess_19", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        logger.info("--DAP--\u4e1a\u52a1\u8d26\u7c3f\u548c\u4f1a\u8ba1\u8d26\u7c3f\u7f13\u5b58bizBook2AcctBookCache\uff1a" + this.bizBook2AcctBookCache);
        return null;
    }

    private String dipliVchtemAndAcctBookOper(Map<SingleSplitAcctBook, Set<Long>> acctBookWithOperBillGroup, List<VchTemplateMainData> vchTemData) {
        HashSet allBookTypeId = new HashSet(8);
        Set allOrgId = acctBookWithOperBillGroup.keySet().stream().map(m -> m.getAcctOrgID()).collect(Collectors.toSet());
        vchTemData.stream().forEach(f -> allBookTypeId.addAll(f.getBookTypeIds()));
        HashMap<String, Long> bookIdCache = new HashMap<String, Long>(8);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)GenerateVoucherProcess.class.getName(), (String)"gl_accountbook", (String)"id,org.id org,bookstype.id booktype", (QFilter[])new QFilter[]{new QFilter("org.id", "in", allOrgId), new QFilter("bookstype.id", "in", allBookTypeId)}, null);){
            for (Row row : queryDataSet) {
                String key = row.getString("org") + row.getString("booktype");
                bookIdCache.put(key, row.getLong("id"));
            }
        }
        Long schemaOrgId = 0L;
        Long schemaBooktypeId = 0L;
        Long schemaBookId = 0L;
        if (this.defScheme != null) {
            long schemeBookID = ((SelectedAcctBook)this.defScheme.getSelectedBooks().get(0)).getBookId();
            DynamicObject dyoBook = BusinessDataServiceHelper.loadSingle((String)"gl_accountbook", (String)"id,org.id,bookstype.id,bookstype.name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeBookID)});
            if (dyoBook == null) {
                String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"GenerateVoucherProcess_13", (String)"fi-ai-mservice", (Object[])new Object[0]);
                return msg;
            }
            schemaOrgId = dyoBook.getLong("org.id");
            schemaBooktypeId = dyoBook.getLong("bookstype.id");
            schemaBookId = schemeBookID;
        }
        HashMap temIdCache = new HashMap(8);
        allOrgId.stream().forEach(v -> temIdCache.put(v, this.getPreesionTemplateFormOrgId((Long)v)));
        HashMap<SingleSplitAcctBook, Set<Long>> copyAcctBookData = new HashMap<SingleSplitAcctBook, Set<Long>>(acctBookWithOperBillGroup);
        if (copyAcctBookData.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5f53\u524d\u7ec4\u7ec7\u4e0b\u6838\u7b97\u4f53\u7cfb\u7684\u8bb0\u8d26\u8303\u56f4\u3002", (String)"GenerateVoucherProcess_21", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        HashMap<SingleSplitAcctBook, Set<Long>> copyBakData = new HashMap<SingleSplitAcctBook, Set<Long>>(acctBookWithOperBillGroup.size());
        acctBookWithOperBillGroup.clear();
        for (Map.Entry cab : copyAcctBookData.entrySet()) {
            SingleSplitAcctBook sab = (SingleSplitAcctBook)cab.getKey();
            Set ids = (Set)cab.getValue();
            HashSet temId = new HashSet((Collection)temIdCache.get(sab.getAcctOrgID()));
            if (this.defScheme != null && !schemaOrgId.equals(sab.getAcctOrgID())) continue;
            for (VchTemplateMainData vtm : vchTemData) {
                if (!temId.contains(vtm.getTemId()) || !sab.getBizOrgField().equals(vtm.getBizOrgField())) continue;
                HashSet<Object> currBookTypeIdCol = new HashSet(8);
                if (this.defScheme != null) {
                    for (Long btId : vtm.getBookTypeIds()) {
                        String string;
                        Long bookId;
                        if (!schemaBooktypeId.equals(btId) || !schemaBookId.equals(bookId = (Long)bookIdCache.get(string = "" + sab.getAcctOrgID() + btId))) continue;
                        currBookTypeIdCol.add(btId);
                    }
                    if (currBookTypeIdCol.isEmpty()) {
                        continue;
                    }
                } else if (sab.getBookTypeID() != 0L) {
                    if (!vtm.getBookTypeIds().contains(sab.getBookTypeID())) continue;
                    currBookTypeIdCol.add(sab.getBookTypeID());
                } else {
                    currBookTypeIdCol = new HashSet<Long>(vtm.getBookTypeIds());
                }
                HashSet<Long> currTemSid = new HashSet<Long>(vtm.getMatchSourcebillid());
                currTemSid.retainAll(ids);
                if (currTemSid.isEmpty()) continue;
                for (Long l : currBookTypeIdCol) {
                    String currKey = "" + sab.getAcctOrgID() + l;
                    Long bookid = (Long)bookIdCache.get(currKey);
                    if (bookid == null) continue;
                    AcctBook ab = new AcctBook(sab.getAcctOrgID(), l.longValue(), bookid.longValue(), sab.getBizOrgID(), sab.getBizOrgField());
                    SingleSplitAcctBook ssab = new SingleSplitAcctBook(ab, sab.getOper(), vtm.getTemId(), vtm.getVchTemplate());
                    if (copyBakData.containsKey(ssab)) {
                        currTemSid.addAll((Collection)copyBakData.get(ssab));
                    }
                    copyBakData.put(ssab, currTemSid);
                }
            }
        }
        int cindex = copyBakData.size();
        if (cindex == 0) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7b26\u5408\u6761\u4ef6\u6a21\u677f\u5339\u914d\u8d26\u7c3f\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u6a21\u677f\u914d\u7f6e\u5bf9\u5e94\u7684\u8d26\u7c3f\u4e0d\u5b58\u5728\u6216\u8005\u7b26\u5408\u6761\u4ef6\u6a21\u677f\u4e0d\u5b58\u5728\u3002", (String)"GenerateVoucherProcess_16", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        logger.info("--DAP--acctBookWithOperBillGroup2222:" + cindex);
        acctBookWithOperBillGroup.putAll(this.sortAndDiplicateData(copyBakData));
        int aindex = acctBookWithOperBillGroup.size();
        if (cindex > 0 && aindex == 0) {
            return ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7b26\u5408\u6761\u4ef6\u7684\u51ed\u8bc1\u6a21\u677f\u4e2d\uff0c\u6240\u6709\u59d4\u6258\u6838\u7b97\u8d26\u7c3f\u4e0b\u90fd\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"GenerateVoucherProcess_15", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        return null;
    }

    private Map<SingleSplitAcctBook, Set<Long>> sortAndDiplicateData(Map<SingleSplitAcctBook, Set<Long>> acctBookWithOperBillGroup) {
        if (this.openalltemplate) {
            return acctBookWithOperBillGroup;
        }
        HashMap<SingleSplitAcctBook, Set<Long>> result = new HashMap<SingleSplitAcctBook, Set<Long>>(8);
        if (this.multiDap && !this.ignoreTemplateUnique) {
            HashMap<String, Set> hasGenVoucherVchtemplate = new HashMap<String, Set>(8);
            Throwable throwable = null;
            try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.service.GenerateVoucherProcess.sortAndDiplicateData", (String)"ai_daptracker", (String)"vchtemplateid,sourcebillid,org,org.id,booktype,booktype.id,reoper", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", this.billids), new QFilter("billtype", "=", (Object)this.billTypeKey)}, null);){
                for (Row row : queryDataSet) {
                    String key = row.getLong("vchtemplateid") + "" + row.getLong("org.id") + "" + row.getLong("booktype.id") + row.getString("reoper");
                    Set list = hasGenVoucherVchtemplate.computeIfAbsent(key, v -> new HashSet());
                    list.add(row.getLong("sourcebillid"));
                }
            }
            catch (Throwable iterator) {
                Throwable throwable2 = iterator;
                throw iterator;
            }
            for (Map.Entry<Object, Set<Long>> entry : acctBookWithOperBillGroup.entrySet()) {
                SingleSplitAcctBook row = (SingleSplitAcctBook)entry.getKey();
                String key = row.getVchtemplateId() + "" + row.getAcctOrgID() + "" + row.getBookTypeID() + row.getOper();
                Set hasBuildVchIds = (Set)hasGenVoucherVchtemplate.get(key);
                if (hasBuildVchIds == null) continue;
                entry.getValue().removeAll(hasBuildVchIds);
            }
        }
        HashMap<String, Map> MultiGroupAcctBookData = new HashMap<String, Map>(8);
        for (Map.Entry<SingleSplitAcctBook, Set<Long>> entry : acctBookWithOperBillGroup.entrySet()) {
            String key = entry.getKey().toQuickGroupString();
            Map map = MultiGroupAcctBookData.computeIfAbsent(key, v -> new HashMap(8));
            map.put(entry.getKey(), entry.getValue());
        }
        for (Map map : MultiGroupAcctBookData.values()) {
            result.putAll(GenerateVoucherProcess.sortAndDiplicate(map));
        }
        return result;
    }

    private List<Long> getPreesionTemplateFormOrgId(Long orgId) {
        Object value;
        Boolean ec = this.eventClass != 0L;
        ArrayList<Long> templateid = new ArrayList<Long>(16);
        if (ec.booleanValue()) {
            List templateids = EventVchTemplateUtil.getTemplate((Long)orgId, (String)"ai_vchtemplate");
            templateid.addAll(templateids);
        }
        if ((value = BaseDataServiceHelper.getBaseDataIdInFilter((String)"ai_vchtemplate", (Long)orgId).getValue()) != null) {
            Collection cc = (Collection)value;
            templateid.addAll(cc);
        }
        return templateid;
    }

    private static Map<SingleSplitAcctBook, Set<Long>> sortAndDiplicate(Map<SingleSplitAcctBook, Set<Long>> MultiGroupAcctBook) {
        List sortVchDyC;
        QFilter f3;
        DynamicObject loadSingle;
        DynamicObject porg;
        if (MultiGroupAcctBook.isEmpty()) {
            return MultiGroupAcctBook;
        }
        HashMap<SingleSplitAcctBook, Set<Long>> result = new HashMap<SingleSplitAcctBook, Set<Long>>(8);
        List sortVchDyCol = MultiGroupAcctBook.entrySet().stream().map(v -> new SortTemplateDy(((SingleSplitAcctBook)v.getKey()).getVchtemplate().getCreateOrgId(), ((SingleSplitAcctBook)v.getKey()).getVchtemplate().getModifyDate(), ((SingleSplitAcctBook)v.getKey()).getVchtemplate(), (Set)v.getValue(), (SingleSplitAcctBook)v.getKey())).collect(Collectors.toList());
        Long parentOrgId = MultiGroupAcctBook.keySet().iterator().next().getAcctOrgID();
        HashSet<Long> hasSortIds = new HashSet<Long>(16);
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        do {
            Long currOrg = parentOrgId;
            List hasSortDy = sortVchDyCol.stream().filter(f -> currOrg.equals(f.getOrgId())).sorted(Comparator.comparing(SortTemplateDy::getModifyTime)).collect(Collectors.toList());
            if (hasSortDy.isEmpty()) continue;
            for (int i = hasSortDy.size() - 1; i >= 0; --i) {
                SortTemplateDy templateDy = (SortTemplateDy)hasSortDy.get(i);
                HashSet<Long> tids = new HashSet<Long>(templateDy.getIds());
                tids.removeAll(hasSortIds);
                if (!tids.isEmpty()) {
                    result.put(templateDy.getSacctbook(), tids);
                }
                hasSortIds.addAll(tids);
                MultiGroupAcctBook.remove(templateDy.getSacctbook());
            }
        } while ((parentOrgId = Long.valueOf((porg = (loadSingle = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"parent", (QFilter[])new QFilter[]{f2, f3 = new QFilter("org", "=", (Object)parentOrgId)})) != null ? loadSingle.getDynamicObject("parent") : null) != null ? porg.getLong("id") : 0L)) != 0L && !MultiGroupAcctBook.isEmpty());
        if (!MultiGroupAcctBook.isEmpty() && !(sortVchDyC = MultiGroupAcctBook.entrySet().stream().map(v -> new SortTemplateDy(((SingleSplitAcctBook)v.getKey()).getVchtemplate().getCreateOrgId(), ((SingleSplitAcctBook)v.getKey()).getVchtemplate().getModifyDate(), ((SingleSplitAcctBook)v.getKey()).getVchtemplate(), (Set)v.getValue(), (SingleSplitAcctBook)v.getKey())).collect(Collectors.toList()).stream().sorted(Comparator.comparing(SortTemplateDy::getModifyTime)).collect(Collectors.toList())).isEmpty()) {
            for (int i = sortVchDyC.size() - 1; i >= 0; --i) {
                SortTemplateDy templateDy = (SortTemplateDy)sortVchDyC.get(i);
                HashSet<Long> tids = new HashSet<Long>(templateDy.getIds());
                tids.removeAll(hasSortIds);
                if (!tids.isEmpty()) {
                    result.put(templateDy.getSacctbook(), tids);
                }
                hasSortIds.addAll(tids);
                MultiGroupAcctBook.remove(templateDy.getSacctbook());
            }
        }
        return result;
    }

    private List<BuildVchScheme> splitScheme(BuildVchScheme schema) {
        ArrayList<BuildVchScheme> list = new ArrayList<BuildVchScheme>(schema.getSelectedBooks().size() + 1);
        list.add(schema);
        List books = schema.getSelectedBooks();
        if (books.size() == 1) {
            return list;
        }
        HashSet<SelectedAcctBook> toRemove = new HashSet<SelectedAcctBook>(books.size());
        for (SelectedAcctBook book : books) {
            toRemove.add(book);
            BuildVchScheme schemeNew = new BuildVchScheme();
            schemeNew.setPreBuild(this.preBuild);
            schemeNew.setBuildBizvoucherFromMidle(this.buildBizvoucherFromMidle);
            schemeNew.setTransId(UUID.randomUUID().toString());
            schemeNew.setBatchCacheId(schema.getBatchCacheId());
            schemeNew.getSelectedBooks().add(book);
            schemeNew.setOnTimeOperateKey(schema.getOnTimeOperateKey());
            schemeNew.setAcctOrg2acctOrgCache(schema.getAcctOrg2acctOrgCache());
            schemeNew.setBizBook2AcctBookCache(schema.getBizBook2AcctBookCache());
            schemeNew.setOpr(schema.getOpr());
            schemeNew.setBuildType(schema.getBuildType());
            schemeNew.setReoper(schema.getReoper());
            schemeNew.setBilltypeAndCustomkey(schema.getBilltypeAndCustomkey());
            schemeNew.setCurr_succIds_cacheKey(schema.getCurr_succIds_cacheKey());
            list.add(schemeNew);
        }
        schema.getSelectedBooks().removeAll(toRemove);
        return list;
    }
}

