/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.dap.MutexRequireUtil;
import kd.fi.ai.exception.DapException;
import kd.fi.ai.mservice.builder.buildresult.GLVoucher;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntryGroupKey;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.builder.buildresult.IVoucherEntry;
import kd.fi.ai.mservice.builder.singlebillaction.UnionGLVoucherHelper;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.bd.service.voucher.TempVoucherService;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.dao.BaseFlexFieldDao;
import kd.fi.v2.fah.models.flex.FlexFieldCfg;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.mapping.impl.MappingStructureMeta;

public class BuildVoucherUtils {
    private static Log logger = LogFactory.getLog(BuildVoucherUtils.class);

    public static Map<GLVoucherEntryGroupKey, GLVoucherEntry> rebuildEntryGroupKey(GLVoucher glVoucher, UnionGLVoucherHelper unionHelper) {
        HashMap<GLVoucherEntryGroupKey, GLVoucherEntry> groupRows = new HashMap<GLVoucherEntryGroupKey, GLVoucherEntry>(glVoucher.getEntryRows().size());
        ArrayList entryRows = new ArrayList(glVoucher.getEntryRows());
        glVoucher.getEntryRows().clear();
        for (GLVoucherEntry row : entryRows) {
            GLVoucherEntryGroupKey groupKey = unionHelper.CreateEntryGroupKey((IVoucher<?>)glVoucher, (IVoucherEntry)row);
            if (groupRows.containsKey(groupKey)) {
                unionHelper.MergeVchEntryRow((IVoucher<?>)glVoucher, (IVoucherEntry)groupRows.get(groupKey), (IVoucherEntry)row);
                continue;
            }
            groupRows.put(groupKey, row);
            glVoucher.getEntryRows().add(row);
        }
        return groupRows;
    }

    public static void rebackCurrTaskBuildVoucherData(Set<Long> billids, Date start, String billtype) {
        HashSet<Long> bizvids = new HashSet<Long>(16);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.util.BuildVoucherUtils", (String)"ai_bizvoucher", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billids), new QFilter("sourcebill", "=", (Object)billtype), new QFilter("createtime", ">=", (Object)start)}, null);){
            for (Row row : queryDataSet) {
                bizvids.add(row.getLong("id"));
            }
        }
        HashSet<Long> vids = new HashSet<Long>(16);
        HashSet<Long> dapids = new HashSet<Long>(16);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.util.BuildVoucherUtils", (String)"ai_daptracker", (String)"id,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billids), new QFilter("billtype", "=", (Object)billtype), new QFilter("createdate", ">=", (Object)start)}, null);){
            for (Row row : queryDataSet) {
                dapids.add(row.getLong("id"));
                vids.add(row.getLong("voucherid"));
            }
        }
        var7_9 = null;
        try (TXHandle xc = TX.requiresNew();){
            try {
                List splitSet;
                if (!vids.isEmpty()) {
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)"gl_voucher", (Object[])vids.toArray(), (OperateOption)BuildVoucherUtils.createDeleteVoucherOpt());
                    int size = operationResult.getSuccessPkIds().size();
                    if (!operationResult.isSuccess()) {
                        List successPkIds = operationResult.getSuccessPkIds();
                        if (successPkIds != null && !successPkIds.isEmpty()) {
                            for (Object successPkId : successPkIds) {
                                vids.remove(successPkId);
                            }
                        }
                        if (!vids.isEmpty()) {
                            size = DeleteServiceHelper.delete((String)"gl_voucher", (QFilter[])new QFilter("id", "in", vids).toArray());
                            TempVoucherService.deleteByIds((Long[])vids.toArray(new Long[0]));
                            List splitSet2 = DapBuildVoucherCommonUtil.splitSet(vids, (int)1000);
                            for (Set ids : splitSet2) {
                                BuildVoucherUtils.batchExcuteDelDataFromVid(ids);
                            }
                        }
                    }
                }
                if (!bizvids.isEmpty()) {
                    splitSet = DapBuildVoucherCommonUtil.splitSet(bizvids, (int)1000);
                    for (Set ids : splitSet) {
                        BuildVoucherUtils.batchExcuteDelData(ids, 1);
                    }
                }
                if (!dapids.isEmpty()) {
                    splitSet = DapBuildVoucherCommonUtil.splitSet(dapids, (int)1000);
                    for (Set ids : splitSet) {
                        BuildVoucherUtils.batchExcuteDelData(ids, 2);
                    }
                }
            }
            catch (Throwable t) {
                throw new DapException("rebackCurrTaskBuildVoucherData is error:sids:" + billids + ";billtype:" + billtype + ";start:" + start, t);
            }
        }
        catch (Throwable throwable) {
            var7_9 = throwable;
            throw throwable;
        }
    }

    public static void rebackCurrTaskBizVoucherData(Set<Long> billids, Date start, String billtype) {
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.util.BuildVoucherUtils", (String)"ai_daptracker", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billids), new QFilter("billtype", "=", (Object)billtype), new QFilter("createdate", ">=", (Object)start)}, null);){
            for (Row row : queryDataSet) {
                billids.remove(row.getLong("sourcebillid"));
            }
        }
        if (!billids.isEmpty()) {
            HashSet<Long> bizvids = new HashSet<Long>(16);
            DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.util.BuildVoucherUtils", (String)"ai_bizvoucher", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billids), new QFilter("sourcebill", "=", (Object)billtype), new QFilter("createtime", ">=", (Object)start)}, null);
            Object object = null;
            try {
                for (Row row : queryDataSet) {
                    bizvids.add(row.getLong("id"));
                }
            }
            catch (Throwable iterator) {
                object = iterator;
                throw iterator;
            }
            finally {
                if (queryDataSet != null) {
                    if (object != null) {
                        try {
                            queryDataSet.close();
                        }
                        catch (Throwable iterator) {
                            ((Throwable)object).addSuppressed(iterator);
                        }
                    } else {
                        queryDataSet.close();
                    }
                }
            }
            if (!bizvids.isEmpty()) {
                List splitSet = DapBuildVoucherCommonUtil.splitSet(bizvids, (int)1000);
                for (Set ids : splitSet) {
                    BuildVoucherUtils.batchExcuteDelData(ids, 1);
                }
            }
        }
    }

    private static void batchExcuteDelData(Set<Long> ids, int type) {
        String joinIds;
        if (ids.isEmpty()) {
            return;
        }
        if (type == 1) {
            joinIds = QFilterBuilder.buildSQLParamHolder((int)ids.size());
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucherentry where fid in " + joinIds), (Object[])ids.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucher where fid in " + joinIds), (Object[])ids.toArray());
        }
        if (type == 2) {
            joinIds = QFilterBuilder.buildSQLParamHolder((int)ids.size());
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptrackerentry where fid in " + joinIds), (Object[])ids.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptracker where fid in " + joinIds), (Object[])ids.toArray());
        }
    }

    private static void batchExcuteDelDataFromVid(Set<Long> vids) {
        if (vids.isEmpty()) {
            return;
        }
        String joinIds = QFilterBuilder.buildSQLParamHolder((int)vids.size());
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucherentry where fid in (select fid from t_ai_bizvoucher where fglvoucherid in " + joinIds + ")"), (Object[])vids.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_bizvoucher where fglvoucherid in " + joinIds), (Object[])vids.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptrackerentry where fid in (select fid from t_ai_daptracker where fvoucherid in " + joinIds + ")"), (Object[])vids.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)("delete from t_ai_daptracker where fvoucherid in " + joinIds), (Object[])vids.toArray());
    }

    public static Map<Long, Set<Long>> batchRequireLockData_mutext(ISingleTaskContext taskContext, Map<Object, List<Long>> secondBillId, Map<String, Set<Long>> multiRelationGroupMap) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(secondBillId.size());
        if (multiRelationGroupMap.isEmpty()) {
            return result;
        }
        Iterator<Map.Entry<Object, List<Long>>> reiterator = secondBillId.entrySet().iterator();
        HashMap netGroupRebillMap = new HashMap(16);
        while (reiterator.hasNext()) {
            Map.Entry<Object, List<Long>> billAndRebill = reiterator.next();
            List<Long> reIds = billAndRebill.getValue();
            reIds.stream().forEach(v -> {
                List collect = multiRelationGroupMap.entrySet().stream().filter(c -> ((Set)c.getValue()).contains(v)).map(Map.Entry::getKey).collect(Collectors.toList());
                for (String billType : collect) {
                    netGroupRebillMap.computeIfAbsent(billType, b -> new ArrayList(16)).add(v);
                }
            });
        }
        HashSet<Long> getLockSuccessBillIds = new HashSet<Long>(16);
        for (Map.Entry next : netGroupRebillMap.entrySet()) {
            String billtype = (String)next.getKey();
            List ids = (List)next.getValue();
            if (taskContext.getShowInfo().booleanValue()) {
                logger.info("--DAP--batchTryLockData:begin------oldIds:" + ids + ";billtype:" + billtype);
            }
            Set<Long> lockId = MutexRequireUtil.requireMutexBatch(billtype, new HashSet<Long>(ids));
            getLockSuccessBillIds.addAll(lockId);
            taskContext.getReBillLockFormMutexL().addAll(lockId);
            if (!taskContext.getShowInfo().booleanValue()) continue;
            logger.info("--DAP--batchTryLockData:end------getLockIds:" + lockId);
        }
        for (Map.Entry<Object, List<Long>> row : secondBillId.entrySet()) {
            Object mainId = row.getKey();
            Set ids = row.getValue().stream().filter(getLockSuccessBillIds::contains).collect(Collectors.toSet());
            getLockSuccessBillIds.removeAll(ids);
            result.put(Long.parseLong(mainId.toString()), ids);
        }
        return result;
    }

    public static Map<Long, FlexFieldCfg> getInputFlexProp(Long flexMappingId) {
        HashMap<Long, FlexFieldCfg> result = new HashMap<Long, FlexFieldCfg>();
        if (flexMappingId == 0L) {
            return result;
        }
        String key = "BuildVoucherUtils_getInputFlexProp" + flexMappingId;
        if (ThreadCache.exists((Object)key)) {
            return (Map)ThreadCache.get((Object)key);
        }
        DynamicObject valmapdata = BusinessDataServiceHelper.loadSingleFromCache((Object)flexMappingId, (String)"fah_valmap_typenew");
        if (valmapdata != null) {
            MappingStructureMeta mappingStructureMeta = (MappingStructureMeta)BaseFlexFieldDao.loadFlexFieldGrpCfgByMappingType((QFilter)new QFilter("id", "=", (Object)valmapdata.getLong("struc.id")));
            FlexFieldGrpCfg FlexFieldGrpCfg2 = mappingStructureMeta.getInputParamMeta();
            for (FlexFieldCfg data : FlexFieldGrpCfg2) {
                result.put((Long)data.getId(), data);
            }
            ThreadCache.put((Object)key, result);
        }
        return result;
    }

    public static OperateOption createDeleteVoucherOpt() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isTcc", "true");
        operateOption.setVariableValue("mechanism", "true");
        operateOption.setVariableValue("ishasright", String.valueOf(true));
        return operateOption;
    }
}

