/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.context;

import kd.fi.ai.Currency;
import kd.fi.ai.ExchangeRate;
import kd.fi.v2.fah.models.xla.XLAAccount;
import kd.fi.v2.fah.models.xla.XLAAccountBook;
import kd.fi.v2.fah.models.xla.XLACashFlowItem;
import org.apache.commons.collections4.map.LRUMap;

public class HotSpotDataContext {
    private static final HotSpotDataContext hsDataContext = new HotSpotDataContext();
    private LRUMap<String, ExchangeRate> rateCacheMap = new LRUMap(100);
    private LRUMap<Long, XLAAccountBook> acctBookCacheMap = new LRUMap(3000);
    private LRUMap<Long, XLAAccount> accountCacheMap = new LRUMap(5000);
    private LRUMap<Long, XLACashFlowItem> cashflowCacheMap = new LRUMap(2000);
    private LRUMap<Long, Currency> currencyCacheMap = new LRUMap(100);

    private HotSpotDataContext() {
    }

    public static HotSpotDataContext getInstance() {
        return hsDataContext;
    }

    public void clear() {
        this.accountCacheMap.clear();
        this.acctBookCacheMap.clear();
        this.cashflowCacheMap.clear();
        this.currencyCacheMap.clear();
        this.rateCacheMap.clear();
    }

    public LRUMap<String, ExchangeRate> getRateCacheMap() {
        return this.rateCacheMap;
    }

    public LRUMap<Long, XLAAccountBook> getAcctBookCacheMap() {
        return this.acctBookCacheMap;
    }

    public LRUMap<Long, XLAAccount> getAccountCacheMap() {
        return this.accountCacheMap;
    }

    public LRUMap<Long, XLACashFlowItem> getCashflowCacheMap() {
        return this.cashflowCacheMap;
    }

    public LRUMap<Long, Currency> getCurrencyCacheMap() {
        return this.currencyCacheMap;
    }
}

