/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.util.DebugTrace;
import kd.fi.v2.fah.cache.cacheservice.XLARuleThreadCache;
import kd.fi.v2.fah.cache.threadcache.EvtRuleThreadCache;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.event.BizDataStatusEnum;
import kd.fi.v2.fah.constant.enums.task.BackgroundTaskTypeEnum;
import kd.fi.v2.fah.datasource.WriteMemorySpaceHelper;
import kd.fi.v2.fah.dim.service.DimValueSaveService;
import kd.fi.v2.fah.event.mservice.util.BuildEventBizDataUtil;
import kd.fi.v2.fah.job.FahJobContext;
import kd.fi.v2.fah.log.FahBgTaskLogger;
import kd.fi.v2.fah.meta.BizDataSimpleTableMeta;
import kd.fi.v2.fah.meta.SimpleTableMeta;
import kd.fi.v2.fah.models.bizdims.EventRuleLineCfgGroup;
import kd.fi.v2.fah.models.event.eventrule.BizDimGrpItemDTO;
import kd.fi.v2.fah.models.event.eventrule.BizDimGrpTypeCfgDTO;
import kd.fi.v2.fah.models.event.eventrule.BizDimTypeCustomCfgDTO;
import kd.fi.v2.fah.models.event.eventrule.EventRuleLineCfg;
import kd.fi.v2.fah.models.event.eventrule.EventRuleModelCfg;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.models.xla.AutoSetValueHandle;
import kd.fi.v2.fah.sqlbuilder.IAddSqlColumn;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.tables.impl.SimpleTableColStorage;
import kd.fi.v2.fah.storage.tables.impl.SimpleTableManager;
import kd.fi.v2.fah.utils.OperationLogUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class BuildEventBizDataServiceImpl3 {
    private static final Log logger = LogFactory.getLog(BuildEventBizDataServiceImpl3.class);
    private static final String CREATE_BIZ_DATA_GROUP_BY_ORG = "createBizDataGroupByOrg";
    private static final String CERATE_BIZ_DATA_BATCH_SIZE = "fah.evt.createBizDataBatchSize";
    private static final String DEFAULT_BATCH_SIZE = "2000";
    private static final Long defaultValue = 0L;
    private final OperationResult opResult;
    private final boolean groupByOrg;
    private final String dataTypeIsNull;
    private final String dataTypeNotMatch;
    private final String bigDecimalOverLength;
    private long transId;
    private final SimpleTableManager<BizDataSimpleTableMeta> simpleTableManager;
    private final DimValueSaveService saveService;
    private final int createBizDataBatchSize;
    private int maxDimCnt;
    private Map<Long, Tuple<String, Boolean>> eventNumAndBizDataStatusMap;

    public BuildEventBizDataServiceImpl3(OperationResult opResult) {
        this.opResult = opResult;
        this.groupByOrg = "1".equals(SysParamConfig.getFromDB((String)CREATE_BIZ_DATA_GROUP_BY_ORG));
        this.simpleTableManager = new SimpleTableManager(this::saveDimValue);
        this.dataTypeIsNull = ResManager.loadKDString((String)"\u5355\u636e\u4e0a\u5bf9\u5e94\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7ef4\u5ea6\u503c\u3002", (String)"BuildEventBizDataServiceImpl2_1", (String)"fi-ai-mservice", (Object[])new Object[0]);
        this.dataTypeNotMatch = ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u4fdd\u53d6\u503c\u5b57\u6bb5\u4e2d\u914d\u7f6e\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0e\u4e1a\u52a1\u7ef4\u5ea6\u6570\u636e\u7c7b\u578b\u4e00\u81f4\u3002", (String)"BuildEventBizDataServiceImpl2_2", (String)"fi-ai-mservice", (Object[])new Object[0]);
        this.bigDecimalOverLength = ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u4fdd\u53d6\u503c\u5b57\u6bb5\u4e2d\u914d\u7f6e\u7684\u5b57\u6bb5\u7c7b\u578b\u4e0e\u4e1a\u52a1\u7ef4\u5ea6\u6570\u636e\u7c7b\u578b\u4e00\u81f4\uff0c\u6570\u503c\u7c7b\u578b\u957f\u5ea6\u548c\u7cbe\u5ea6\u7b26\u5408decimal(23, 10)\u3002", (String)"BuildEventBizDataServiceImpl2_3", (String)"fi-ai-mservice", (Object[])new Object[0]);
        this.saveService = new DimValueSaveService();
        this.createBizDataBatchSize = Integer.parseInt(Optional.ofNullable(SysParamConfig.getFromDB((String)CERATE_BIZ_DATA_BATCH_SIZE)).orElse(DEFAULT_BATCH_SIZE));
    }

    public void buildEventBizDimData(Collection<Long> eventIds) {
        if (CollectionUtils.isEmpty(eventIds)) {
            return;
        }
        this.eventNumAndBizDataStatusMap = new HashMap<Long, Tuple<String, Boolean>>(eventIds.size());
        this.transId = System.currentTimeMillis();
        FahJobContext fahJobContext = new FahJobContext();
        fahJobContext.setFahBgTaskLogger(FahBgTaskLogger.create((BackgroundTaskTypeEnum)BackgroundTaskTypeEnum.Common_Create_EventLine));
        fahJobContext.addStartLog("fah_event_line", eventIds.size());
        try {
            this.buildEventBizData(eventIds);
        }
        catch (Exception e) {
            String traceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            fahJobContext.getFahBgTaskLogger().addDetailEntryErr("buildEventData_buildEventBizData err:" + traceMessage);
            throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u4e1a\u52a1\u7ef4\u5ea6\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"BuildEventBizDataServiceImpl2_4", (String)"fi-ai-mservice", (Object[])new Object[0]));
        }
        finally {
            fahJobContext.addEndLog();
        }
    }

    private void buildEventBizData(Collection<Long> eventIds) {
        if (CollectionUtils.isEmpty(eventIds)) {
            return;
        }
        String opName = ResManager.loadKDString((String)"\u521b\u5efa\u4e1a\u52a1\u7ef4\u5ea6", (String)"BuildEventBizDataServiceImpl2_5", (String)"fi-ai-mservice", (Object[])new Object[0]);
        OperationLogUtils.addLog((String)"fah_event", (String)opName, (String)opName);
        Map<GroupKey, List<Long>> eventIdGroups = this.groupEventIds(this.groupByOrg, eventIds);
        for (Map.Entry<GroupKey, List<Long>> eventIdGroup : eventIdGroups.entrySet()) {
            this.dealSingleEventGroup(eventIdGroup.getKey(), eventIdGroup.getValue());
        }
        this.simpleTableManager.saveTables();
        long start = System.currentTimeMillis();
        this.updateEventBizDataStatus();
        long end = System.currentTimeMillis();
        logger.info("buildEventData_cost_updateEventBizDataStatus: " + (end - start) + " ms; size: " + eventIds.size());
        BuildEventBizDataUtil.createMessage(this.opResult, this.eventNumAndBizDataStatusMap);
    }

    private void updateEventBizDataStatus() {
        try (TXHandle h = TX.required();){
            try {
                BuildEventBizDataUtil.activateDimValAndUpdateStatus1(this.eventNumAndBizDataStatusMap, this.transId, this.maxDimCnt);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void dealSingleEventGroup(GroupKey groupKey, List<Long> eventIds) {
        EventRuleModelCfg ruleModelCfg = EvtRuleThreadCache.getEventRuleModelCfgCached((Long)groupKey.getGenRuleId());
        Collection<EventRuleLineCfgGroup> genLineRuleEntryGroups = this.groupGenLineRuleByEntry(ruleModelCfg);
        HashMap<Long, EventRuleLineCfgGroup> eventLineRuleIdMap = new HashMap<Long, EventRuleLineCfgGroup>(ruleModelCfg.getEventRuleLineCfgs().size());
        for (EventRuleLineCfgGroup lineCfgGroup : genLineRuleEntryGroups) {
            for (Long genEvtLineRuleId : lineCfgGroup.getEventRuleLineCfgIds()) {
                eventLineRuleIdMap.put(genEvtLineRuleId, lineCfgGroup);
            }
        }
        HashMap<EventRuleLineCfgGroup, List> eventDataGroupByLineCfgGroup = new HashMap<EventRuleLineCfgGroup, List>(8);
        DataSet dataSet = this.queryEventDataSet(eventIds);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row evtLineRow = dataSet.next();
                Long evtLineRuleId = evtLineRow.getLong("fsrclineruleid");
                EventDataInfo eventDataInfo = new EventDataInfo();
                eventDataInfo.setEventId(evtLineRow.getLong("fid"));
                eventDataInfo.setEventLineId(evtLineRow.getLong("fentryid"));
                eventDataInfo.setOrgId(evtLineRow.getLong("forgid"));
                eventDataInfo.setSrcBillId(evtLineRow.getLong("fsrc_billid"));
                eventDataInfo.setSrcBillEntryId(evtLineRow.getLong("fsrcbillentryid"));
                eventDataInfo.setGenEvtLineRuleId(evtLineRuleId);
                EventRuleLineCfgGroup eventRuleLineCfgGroup = (EventRuleLineCfgGroup)eventLineRuleIdMap.get(evtLineRuleId);
                eventDataGroupByLineCfgGroup.computeIfAbsent(eventRuleLineCfgGroup, k -> new LinkedList()).add(eventDataInfo);
                this.checkEventDataGroupBatchSize(eventRuleLineCfgGroup, (List)eventDataGroupByLineCfgGroup.get(eventRuleLineCfgGroup));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        for (Map.Entry eventDataGroupByLineCfgGroupEntry : eventDataGroupByLineCfgGroup.entrySet()) {
            if (((List)eventDataGroupByLineCfgGroupEntry.getValue()).isEmpty()) continue;
            this.dealSingleLineCfgGroup((EventRuleLineCfgGroup)eventDataGroupByLineCfgGroupEntry.getKey(), (List)eventDataGroupByLineCfgGroupEntry.getValue());
            ((List)eventDataGroupByLineCfgGroupEntry.getValue()).clear();
        }
    }

    private void checkEventDataGroupBatchSize(EventRuleLineCfgGroup eventRuleLineCfgGroup, List<EventDataInfo> eventDataInfoList) {
        if (eventDataInfoList.size() >= this.createBizDataBatchSize) {
            this.dealSingleLineCfgGroup(eventRuleLineCfgGroup, eventDataInfoList);
            eventDataInfoList.clear();
        }
    }

    private void dealSingleLineCfgGroup(EventRuleLineCfgGroup eventRuleLineCfgGroup, List<EventDataInfo> eventDataInfoList) {
        HashMap<Long, List> eventDataInfoMap = new HashMap<Long, List>();
        for (EventDataInfo eventDataInfo : eventDataInfoList) {
            eventDataInfoMap.computeIfAbsent(eventDataInfo.getSrcBillEntryId(), k -> new LinkedList()).add(eventDataInfo);
        }
        eventRuleLineCfgGroup.setFieldAliasInfoByAuto();
        BaseMutableArrayMapStorage fieldAliasInfos = eventRuleLineCfgGroup.getFieldAliasInfos();
        try (DataSet dataSet = this.queryBillData(eventRuleLineCfgGroup, eventDataInfoList);){
            while (dataSet.hasNext()) {
                Row srcBillDataRow = dataSet.next();
                Object[] spaceData = WriteMemorySpaceHelper.writeDataToSpace((Row)srcBillDataRow, (BaseMutableArrayMapStorage)fieldAliasInfos);
                Long srcBillEntryId = srcBillDataRow.getLong(((FieldAliasInfo)fieldAliasInfos.get((Object)eventRuleLineCfgGroup.getEntryPkField())).getAlias());
                List subEventDataInfoList = (List)eventDataInfoMap.get(srcBillEntryId);
                for (EventDataInfo eventDataInfo : subEventDataInfoList) {
                    this.dealSingleEventLine(eventDataInfo, eventRuleLineCfgGroup, spaceData, (BaseMutableArrayMapStorage<String, FieldAliasInfo>)fieldAliasInfos);
                }
            }
        }
    }

    private void dealSingleEventLine(EventDataInfo eventDataInfo, EventRuleLineCfgGroup eventRuleLineCfgGroup, Object[] spaceData, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        Long genEvtLineRuleId = eventDataInfo.getGenEvtLineRuleId();
        EventRuleLineCfg eventRuleLineCfg = eventRuleLineCfgGroup.getEventRuleLineCfg(genEvtLineRuleId);
        Long dimGrpTypeId = eventRuleLineCfg.getBizDimGrpGetValueCfgs().getDimGrpTypeId();
        if (eventRuleLineCfg.getBizDimGrpGetValueCfgs().size() == 0) {
            return;
        }
        BizDimGrpTypeCfgDTO dimGrpTypeCfg = XLARuleThreadCache.getBizDimGrpTypeCfgCached((Long)dimGrpTypeId);
        if (null == dimGrpTypeCfg) {
            if (DebugTrace.enable()) {
                logger.info("not found dimGrpTypeCfg, dimGrpTypeId:{}", (Object)dimGrpTypeId);
            }
            return;
        }
        if (!dimGrpTypeCfg.getEnable().booleanValue() && DebugTrace.enable()) {
            logger.info("dimGrpTypeCfg disable, dimGrpTypeId:{}", (Object)dimGrpTypeId);
        }
        BizDataSimpleTableMeta bizDataSimpleTableMeta = BuildEventBizDataUtil.getBizDataSimpleTableMeta(dimGrpTypeCfg, this.transId);
        SimpleTableColStorage storage = this.simpleTableManager.getSimpleTableStorage((SimpleTableMeta)bizDataSimpleTableMeta);
        Object[] bizDataArr = new Object[bizDataSimpleTableMeta.getColumnCnt()];
        bizDataArr[BizDataSimpleTableMeta.batchIdFieldIndex] = eventDataInfo.getEventId();
        bizDataArr[BizDataSimpleTableMeta.evtLineIdFieldIndex] = eventDataInfo.getEventLineId();
        int i = bizDataSimpleTableMeta.getColumnCnt(IAddSqlColumn.ColumnGrpType.FixPosColumn);
        int notNullDimCnt = 0;
        this.maxDimCnt = dimGrpTypeCfg.size() > this.maxDimCnt ? dimGrpTypeCfg.size() : this.maxDimCnt;
        LinkedHashMap<Long, String> errorMsgMap = new LinkedHashMap<Long, String>();
        boolean eventLineBizStatus = true;
        BizDimTypeCustomCfgDTO bizDimTypeCusCfg = BuildEventBizDataUtil.getBizDimTypeCusCfg(dimGrpTypeCfg, eventDataInfo.getOrgId());
        Map handleMap = (Map)eventRuleLineCfgGroup.getFieldHandle().get(genEvtLineRuleId);
        for (BizDimGrpItemDTO dimGrpItemDTO : dimGrpTypeCfg) {
            Long dimInnerId = dimGrpItemDTO.getDimInnerId();
            String fieldFullNumAlias = eventRuleLineCfgGroup.getFieldFullNumAlias(genEvtLineRuleId, dimInnerId);
            AutoSetValueHandle autoSetValueHandle = (AutoSetValueHandle)handleMap.get(dimInnerId);
            boolean enabledValue = bizDimTypeCusCfg.getDimEnabledValue(dimGrpItemDTO.getSeq());
            if (enabledValue && (StringUtils.isNotEmpty((String)fieldFullNumAlias) || null != autoSetValueHandle)) {
                boolean requiredValue = bizDimTypeCusCfg.getDimRequiredValue(dimGrpItemDTO.getSeq());
                Object bizValue = autoSetValueHandle.getValue(spaceData, fieldAliasInfos);
                DataValueTypeEnum dataType = dimGrpItemDTO.getDimDataType();
                CheckValueResult checkValueResult = this.checkValue(bizValue, requiredValue, dataType);
                bizDataArr[i] = checkValueResult.value;
                if (checkValueResult.isCheckFailed) {
                    errorMsgMap.put(dimInnerId, checkValueResult.msg);
                }
                if (checkValueResult.valueNotNull) {
                    ++notNullDimCnt;
                }
            } else {
                bizDataArr[i] = defaultValue;
            }
            ++i;
        }
        bizDataArr[BizDataSimpleTableMeta.notNullDimCntFieldIndex] = notNullDimCnt;
        if (errorMsgMap.isEmpty()) {
            bizDataArr[BizDataSimpleTableMeta.statusFieldIndex] = BizDataStatusEnum.SUCCESS.getCode();
            bizDataArr[BizDataSimpleTableMeta.errMsgFieldIndex] = null;
        } else {
            eventLineBizStatus = false;
            bizDataArr[BizDataSimpleTableMeta.statusFieldIndex] = BizDataStatusEnum.FAIL.getCode();
            bizDataArr[BizDataSimpleTableMeta.errMsgFieldIndex] = JSON.toJSONString(errorMsgMap);
        }
        storage.addEx(bizDataArr);
        if (storage.size() >= this.createBizDataBatchSize) {
            this.simpleTableManager.saveTable((SimpleTableMeta)bizDataSimpleTableMeta, storage);
            storage.clear();
        }
        Tuple<String, Boolean> evtNumAndBizDataStatus = this.eventNumAndBizDataStatusMap.get(eventDataInfo.getEventId());
        Boolean lastEventLineBizStatus = (Boolean)this.eventNumAndBizDataStatusMap.get((Object)eventDataInfo.getEventId()).item2;
        eventLineBizStatus = lastEventLineBizStatus == null ? eventLineBizStatus : lastEventLineBizStatus != false && eventLineBizStatus;
        this.eventNumAndBizDataStatusMap.put(eventDataInfo.getEventId(), (Tuple<String, Boolean>)Tuple.create((Object)evtNumAndBizDataStatus.item1, (Object)eventLineBizStatus));
    }

    private CheckValueResult checkValue(Object bizValue, boolean requiredValue, DataValueTypeEnum dataType) {
        CheckValueResult checkValueResult = new CheckValueResult();
        switch (dataType) {
            case Date: {
                if (null == bizValue) {
                    if (requiredValue) {
                        checkValueResult.isCheckFailed = true;
                        checkValueResult.msg = this.dataTypeIsNull;
                        checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                        break;
                    }
                    checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                    break;
                }
                if (bizValue instanceof Date) {
                    checkValueResult.value = bizValue;
                    checkValueResult.valueNotNull = true;
                    break;
                }
                checkValueResult.isCheckFailed = true;
                checkValueResult.msg = this.dataTypeNotMatch;
                checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                break;
            }
            case Decimal: {
                if (null == bizValue) {
                    if (requiredValue) {
                        checkValueResult.isCheckFailed = true;
                        checkValueResult.msg = this.dataTypeIsNull;
                        checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                        break;
                    }
                    checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                    break;
                }
                if (bizValue instanceof Number) {
                    BigDecimal bigDecimalValue = new BigDecimal(bizValue.toString());
                    if (bigDecimalValue.precision() <= 23 && bigDecimalValue.scale() <= 10 && bigDecimalValue.precision() - bigDecimalValue.scale() <= 13) {
                        checkValueResult.value = bigDecimalValue;
                        checkValueResult.valueNotNull = true;
                        break;
                    }
                    checkValueResult.isCheckFailed = true;
                    checkValueResult.msg = this.bigDecimalOverLength;
                    checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                    break;
                }
                checkValueResult.isCheckFailed = true;
                checkValueResult.msg = this.dataTypeNotMatch;
                checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                break;
            }
            case BaseProp: 
            case AssistProp: {
                if (null == bizValue) {
                    if (requiredValue) {
                        checkValueResult.isCheckFailed = true;
                        checkValueResult.msg = this.dataTypeIsNull;
                        checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                        break;
                    }
                    checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                    break;
                }
                if (bizValue instanceof Long || bizValue instanceof Integer) {
                    if (bizValue instanceof Long && 0L == (Long)bizValue || bizValue instanceof Integer && 0 == (Integer)bizValue) {
                        if (requiredValue) {
                            checkValueResult.isCheckFailed = true;
                            checkValueResult.msg = this.dataTypeIsNull;
                            checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                            break;
                        }
                        checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                        break;
                    }
                    checkValueResult.value = bizValue;
                    checkValueResult.valueNotNull = true;
                    break;
                }
                checkValueResult.isCheckFailed = true;
                checkValueResult.msg = this.dataTypeNotMatch;
                checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                break;
            }
            case String: {
                if (StringUtils.isEmpty((Object)bizValue)) {
                    if (requiredValue) {
                        checkValueResult.isCheckFailed = true;
                        checkValueResult.msg = this.dataTypeIsNull;
                        checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                        break;
                    }
                    checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                    break;
                }
                if (bizValue instanceof String) {
                    checkValueResult.value = bizValue;
                    checkValueResult.valueNotNull = true;
                    break;
                }
                checkValueResult.isCheckFailed = true;
                checkValueResult.msg = this.dataTypeNotMatch;
                checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                break;
            }
            case Bool: {
                if (null == bizValue) {
                    if (requiredValue) {
                        checkValueResult.isCheckFailed = true;
                        checkValueResult.msg = this.dataTypeIsNull;
                        checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                        break;
                    }
                    checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                    break;
                }
                if (bizValue instanceof Boolean) {
                    if (((Boolean)bizValue).booleanValue()) {
                        checkValueResult.value = 1L;
                    } else {
                        checkValueResult.value = -1L;
                    }
                    checkValueResult.valueNotNull = true;
                    break;
                }
                checkValueResult.isCheckFailed = true;
                checkValueResult.msg = this.dataTypeNotMatch;
                checkValueResult.value = BuildEventBizDataServiceImpl3.defaultValue;
                break;
            }
            default: {
                throw new RuntimeException("not support data type:" + dataType);
            }
        }
        return checkValueResult;
    }

    private void saveDimValue(BizDataSimpleTableMeta bizDataSimpleTableMeta, SimpleTableColStorage storage) {
        if (null == storage || storage.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                long start = System.currentTimeMillis();
                this.saveService.saveDimValue(bizDataSimpleTableMeta, storage);
                long end = System.currentTimeMillis();
                logger.info("buildEventData_cost_saveDimValue: " + (end - start) + " ms; size: " + storage.size());
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private DataSet queryBillData(EventRuleLineCfgGroup eventRuleLineCfgGroup, List<EventDataInfo> eventDataInfoList) {
        HashSet<Long> srcBillIds = new HashSet<Long>(eventDataInfoList.size());
        HashSet<Long> srcBillEntryIds = new HashSet<Long>(eventDataInfoList.size());
        for (EventDataInfo eventDataInfo : eventDataInfoList) {
            srcBillIds.add(eventDataInfo.srcBillId);
            srcBillEntryIds.add(eventDataInfo.srcBillEntryId);
        }
        String entityName = eventRuleLineCfgGroup.getEntityName();
        String orderBy = eventRuleLineCfgGroup.getOrderBy();
        LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
        qFilters.add(new QFilter(eventRuleLineCfgGroup.getPkField(), "in", srcBillIds));
        if (!Objects.equals(entityName, eventRuleLineCfgGroup.getEntryEntityName())) {
            qFilters.add(new QFilter(eventRuleLineCfgGroup.getEntryPkField(), "in", srcBillEntryIds));
        }
        String selector = eventRuleLineCfgGroup.getSqlPrefix();
        return QueryServiceHelper.queryDataSet((String)"BuildEventBizDataService.queryBillData", (String)entityName, (String)selector, (QFilter[])qFilters.toArray(new QFilter[0]), (String)orderBy);
    }

    private DataSet queryEventDataSet(List<Long> eventIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fid,a.forgid,a.fruleid,a.fsrc_billid,b.fentryid,b.fsrcbillentryid,b.fsrclineruleid from t_fah_event_header a, t_fah_event_line b , t_fah_evtline_gen_rule c where a.fid=b.fid", new Object[0]);
        sqlBuilder.append("and b.fsrclineruleid = c.fentryid and c.fdimgrptypeid != 0", new Object[0]);
        sqlBuilder.appendIn("and a.fid", eventIds.toArray());
        sqlBuilder.appendIn("and b.fid", eventIds.toArray());
        sqlBuilder.append("order by a.fid, b.fentryid", new Object[0]);
        return DB.queryDataSet((String)"getEventDataSet", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
    }

    private Map<GroupKey, List<Long>> groupEventIds(boolean groupByOrg, Collection<Long> eventIds) {
        HashMap<GroupKey, List<Long>> eventIdGroups = new HashMap<GroupKey, List<Long>>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, forgid,fruleid,fnumber from t_fah_event_header where", new Object[0]);
        sqlBuilder.appendIn("fid", eventIds.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)"groupEventIds", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long evtId = row.getLong("fid");
                Long genRuleId = row.getLong("fruleid");
                String evtNo = row.getString("fnumber");
                Long orgId = groupByOrg ? row.getLong("forgid") : 0L;
                eventIdGroups.computeIfAbsent(GroupKey.of(genRuleId, orgId), k -> new LinkedList()).add(evtId);
                this.eventNumAndBizDataStatusMap.put(evtId, (Tuple<String, Boolean>)Tuple.create((Object)evtNo, null));
            }
        }
        return eventIdGroups;
    }

    private Collection<EventRuleLineCfgGroup> groupGenLineRuleByEntry(EventRuleModelCfg ruleModelCfg) {
        HashMap<String, EventRuleLineCfgGroup> entryGroupMap = new HashMap<String, EventRuleLineCfgGroup>(4);
        String srcBillType = ruleModelCfg.getSourcePage();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)srcBillType);
        for (EventRuleLineCfg eventRuleLineCfg : ruleModelCfg.getEventRuleLineCfgs()) {
            String amountFieldNumber = eventRuleLineCfg.fetchAmountNumber();
            String currBillTypeAmountFieldShortNumber = amountFieldNumber.contains(".") ? amountFieldNumber.substring(0, amountFieldNumber.indexOf(".")) : amountFieldNumber;
            IDataEntityProperty property = dataEntityType.findProperty(currBillTypeAmountFieldShortNumber);
            String entryEntityName = property.getParent().getName();
            entryGroupMap.computeIfAbsent(entryEntityName, k -> new EventRuleLineCfgGroup(srcBillType, entryEntityName)).addLineCfg(eventRuleLineCfg);
        }
        return entryGroupMap.values();
    }

    public int buildEventBizDimDataByGrp(Long requestId, Long partitionGrpCode) {
        Collection<Long> evtIds = BuildEventBizDataUtil.queryEvtIdsByGrp(requestId, partitionGrpCode);
        this.eventNumAndBizDataStatusMap = new HashMap<Long, Tuple<String, Boolean>>(evtIds.size());
        this.transId = requestId;
        this.buildEventBizData(evtIds);
        return evtIds.size();
    }

    private static class CheckValueResult {
        private boolean isCheckFailed;
        private String msg;
        private Object value;
        private boolean valueNotNull;

        private CheckValueResult() {
        }
    }

    private static class EventDataInfo {
        private Long eventId;
        private Long eventLineId;
        private Long orgId;
        private Long srcBillId;
        private Long srcBillEntryId;
        private Long genEvtLineRuleId;

        private EventDataInfo() {
        }

        public Long getEventId() {
            return this.eventId;
        }

        public void setEventId(Long eventId) {
            this.eventId = eventId;
        }

        public Long getEventLineId() {
            return this.eventLineId;
        }

        public void setEventLineId(Long eventLineId) {
            this.eventLineId = eventLineId;
        }

        public Long getOrgId() {
            return this.orgId;
        }

        public void setOrgId(Long orgId) {
            this.orgId = orgId;
        }

        public Long getSrcBillId() {
            return this.srcBillId;
        }

        public void setSrcBillId(Long srcBillId) {
            this.srcBillId = srcBillId;
        }

        public Long getSrcBillEntryId() {
            return this.srcBillEntryId;
        }

        public void setSrcBillEntryId(Long srcBillEntryId) {
            this.srcBillEntryId = srcBillEntryId;
        }

        public Long getGenEvtLineRuleId() {
            return this.genEvtLineRuleId;
        }

        public void setGenEvtLineRuleId(Long genEvtLineRuleId) {
            this.genEvtLineRuleId = genEvtLineRuleId;
        }
    }

    private static class GroupKey {
        private final Long genRuleId;
        private final Long orgId;

        public GroupKey(Long genRuleId, Long orgId) {
            this.genRuleId = genRuleId;
            this.orgId = orgId;
        }

        public static GroupKey of(Long genRuleId, Long orgId) {
            return new GroupKey(genRuleId, orgId);
        }

        public Long getGenRuleId() {
            return this.genRuleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupKey groupKey = (GroupKey)o;
            return Objects.equals(this.genRuleId, groupKey.genRuleId) && Objects.equals(this.orgId, groupKey.orgId);
        }

        public int hashCode() {
            return Objects.hash(this.genRuleId, this.orgId);
        }

        public Long getOrgId() {
            return this.orgId;
        }
    }
}

