/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.cacheservice.XLARuleThreadCache;
import kd.fi.v2.fah.cache.threadcache.EvtRuleThreadCache;
import kd.fi.v2.fah.constant.enums.event.BillDataProcessErrorCategoryEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventGenOprEnum;
import kd.fi.v2.fah.dao.event.FahEventRuleDao;
import kd.fi.v2.fah.dao.event.context.BuildEvtContext;
import kd.fi.v2.fah.event.EventGenerateParam;
import kd.fi.v2.fah.event.EvtEntryInfo;
import kd.fi.v2.fah.event.EvtHeadInfo;
import kd.fi.v2.fah.event.FahEvtTaskParam;
import kd.fi.v2.fah.event.mservice.service.IBuildEvtDataService;
import kd.fi.v2.fah.getvaluehandle.GetValueHandleFactory;
import kd.fi.v2.fah.getvaluehandle.IGetValueHandle;
import kd.fi.v2.fah.job.FahJobContext;
import kd.fi.v2.fah.job.IFahJobContext;
import kd.fi.v2.fah.log.FahBgTaskLogger;
import kd.fi.v2.fah.models.event.eventrule.DynamicExtractFieldValueSetData;
import kd.fi.v2.fah.models.event.eventrule.EventRuleLineCfg;
import kd.fi.v2.fah.models.event.eventrule.EventRuleLineGroup;
import kd.fi.v2.fah.models.event.eventrule.EventRuleModelCfg;
import kd.fi.v2.fah.models.xla.XLARuleModelConfig;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.util.BuildEvtDataUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class BuildEvtDataServiceImpl3
implements IBuildEvtDataService {
    private static final Log logger = LogFactory.getLog(BuildEvtDataServiceImpl3.class);
    private final int headSaveBatchSize;
    private final int lineSaveBatchSize;
    private final long requestId;
    private final FahEventGenOprEnum eventGenOprEnum;
    private BiConsumer<FahEvtTaskParam, List<Long>> buildEvtLineByTaskAndEvtHeadIds;

    public BuildEvtDataServiceImpl3(long requestId, FahEventGenOprEnum eventGenOprEnum) {
        this.requestId = requestId;
        this.eventGenOprEnum = eventGenOprEnum;
        this.headSaveBatchSize = Integer.parseInt(SysParamConfig.get((String)"fah.evt.headSaveBatchSize", (String)"2000"));
        this.lineSaveBatchSize = Integer.parseInt(SysParamConfig.get((String)"fah.evt.lineSaveBatchSize", (String)SysParamConfig.get((String)"fah.evt.headSaveBatchSize", (String)"2000")));
    }

    @Override
    public void buildEvtData(EventGenerateParam eventGenerateParam, IFahJobContext fahJobContext) {
        EventRuleModelCfg ruleModelCfg = EvtRuleThreadCache.getEventRuleModelCfgCached((Long)eventGenerateParam.getRuleId());
        String msg = this.checkEventRuleLegal(ruleModelCfg, eventGenerateParam, fahJobContext);
        if (null != msg) {
            BuildEvtDataUtil.saveFailBills((long)this.requestId, (String)eventGenerateParam.getBillType(), (long)eventGenerateParam.getDispatchId(), (int)0, (Collection)eventGenerateParam.getBillIds(), (String)msg, (BillDataProcessErrorCategoryEnum)BillDataProcessErrorCategoryEnum.EVT_HEAD_HAS_FAILED);
            fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("%s BillType: %s, BillIds: %s", msg, eventGenerateParam.getBillType(), FahBgTaskLogger.logSizeOrDetail((Collection)eventGenerateParam.getBillIds())));
            return;
        }
        BuildEvtContext buildEvtContext = new BuildEvtContext();
        buildEvtContext.setBigEntrySizeConfig(fahJobContext.getBigEntrySizeConfig());
        buildEvtContext.setFisPreview(fahJobContext.getFisPreview());
        buildEvtContext.setRequestId(fahJobContext.getRequestId());
        buildEvtContext.setPartitionGrpCode(fahJobContext.getPartitionGrpCode());
        buildEvtContext.setBillType(eventGenerateParam.getBillType());
        buildEvtContext.setSrcSysType(eventGenerateParam.getSrcSysType());
        buildEvtContext.setSrcSysId(eventGenerateParam.getSrcSysId());
        buildEvtContext.setBillIds(eventGenerateParam.getBillIds());
        buildEvtContext.setDispatchId(eventGenerateParam.getDispatchId());
        buildEvtContext.setRuleModelCfg(ruleModelCfg);
        buildEvtContext.setFahJobContext(fahJobContext);
        buildEvtContext.setSourceEntry(eventGenerateParam.getSourceEntry());
        buildEvtContext.setSourceEntryIds(new ArrayList(eventGenerateParam.getBillEntryIds()));
        Date createTime = new Date();
        buildEvtContext.setCreateTime(createTime);
        buildEvtContext.setEvtHeadInfoMap(new HashMap(eventGenerateParam.getBillEntryIds().size()));
        BuildEvtDataUtil.initEvtHeadFields((BuildEvtContext)buildEvtContext);
        try (DataSet dataset = BuildEvtDataUtil.getHeadDataset((BuildEvtContext)buildEvtContext, (BaseMutableArrayMapStorage)ruleModelCfg.getFieldAliasInfos());){
            while (dataset.hasNext()) {
                boolean isAlreadyBuildHead;
                Row currRow = dataset.next();
                Long srcBillEntryId = currRow.getLong(buildEvtContext.getSrcBillPkColumnName());
                buildEvtContext.setCurrRowBillId(srcBillEntryId);
                if (null == srcBillEntryId || 0L == srcBillEntryId || buildEvtContext.getRepeatBillIds().contains(srcBillEntryId) || (isAlreadyBuildHead = this.checkMemEvtHead(buildEvtContext))) continue;
                EvtHeadInfo evtHeadInfo = BuildEvtDataUtil.genEvtHeadInfo((Long)srcBillEntryId, (BuildEvtContext)buildEvtContext);
                BuildEvtDataUtil.buildEvtHead((BuildEvtContext)buildEvtContext, (Row)currRow, (EvtHeadInfo)evtHeadInfo);
                int headSize = buildEvtContext.getHeadBuilder().getSqlParamBuffer().moveToNextParamRow();
                if (headSize >= this.headSaveBatchSize) {
                    List evtHeadIds = BuildEvtDataUtil.saveEventDataHeader((BuildEvtContext)buildEvtContext);
                    this.createEvtLine(evtHeadIds, eventGenerateParam.getFahEvtTaskParam());
                }
                buildEvtContext.setLastRowBillId(srcBillEntryId);
            }
            buildEvtContext.setFinish(true);
            List evtHeadIds = BuildEvtDataUtil.saveEventDataHeader((BuildEvtContext)buildEvtContext);
            this.createEvtLine(evtHeadIds, eventGenerateParam.getFahEvtTaskParam());
        }
        catch (Exception e) {
            fahJobContext.getFahBgTaskLogger().addDetailEntry(String.format("buildEventData_buildEvtData err: %s", e.getMessage()));
            logger.error("buildEventData_buildEvtData, requestId: {}", (Object)this.requestId, (Object)e);
            throw e;
        }
    }

    private void createEvtLine(List<Long> evtHeadIds, FahEvtTaskParam fahEvtTaskParam) {
        if (null == this.buildEvtLineByTaskAndEvtHeadIds) {
            return;
        }
        if (CollectionUtils.isEmpty(evtHeadIds)) {
            return;
        }
        this.buildEvtLineByTaskAndEvtHeadIds.accept(fahEvtTaskParam, evtHeadIds);
    }

    private String checkEventRuleLegal(EventRuleModelCfg ruleModelCfg, EventGenerateParam eventInfo, IFahJobContext fahJobContext) {
        if (null == ruleModelCfg || null == ruleModelCfg.getEnable() || !ruleModelCfg.getEnable().booleanValue()) {
            return ResManager.loadKDString((String)"\u4e8b\u4ef6\u89c4\u5219\u672a\u914d\u7f6e\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BuildEvtDataServiceImpl2_01", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        if (!this.checkEvtClass(ruleModelCfg.getEventClassId())) {
            return ResManager.loadKDString((String)"\u4e8b\u4ef6\u89c4\u5219\u4e2d\u4e1a\u52a1\u5927\u7c7b\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BuildEvtDataServiceImpl2_02", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        if (!this.checkEvtType(ruleModelCfg.getEventTypeId())) {
            return ResManager.loadKDString((String)"\u4e8b\u4ef6\u89c4\u5219\u4e2d\u4e1a\u52a1\u5c0f\u7c7b\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BuildEvtDataServiceImpl2_03", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        XLARuleModelConfig xlaRuleModelConfig = XLARuleThreadCache.getXLARuleModelConfigCached((Long)((Long)ruleModelCfg.getId()));
        if (null == xlaRuleModelConfig || null == xlaRuleModelConfig.getId() || null == xlaRuleModelConfig.getEnable() || !xlaRuleModelConfig.getEnable().booleanValue()) {
            return ResManager.loadKDString((String)"\u6838\u7b97\u89c4\u5219\u672a\u914d\u7f6e\u6216\u88ab\u7981\u7528\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BuildEvtDataServiceImpl2_04", (String)"fi-ai-mservice", (Object[])new Object[0]);
        }
        if (!xlaRuleModelConfig.getCompleteLine().booleanValue()) {
            return String.format(ResManager.loadKDString((String)"\u6838\u7b97\u89c4\u5219%s\u672a\u914d\u7f6e\u5b8c\u6574\uff0c\u5b58\u5728\u90e8\u5206\u4e8b\u4ef6\u884c\u672a\u914d\u7f6e\u6838\u7b97\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BuildEvtDataServiceImpl2_05", (String)"fi-ai-mservice", (Object[])new Object[0]), xlaRuleModelConfig.getNumber());
        }
        return null;
    }

    private boolean checkEvtType(Long eventTypeId) {
        LinkedList<Long> list = new LinkedList<Long>();
        list.add(eventTypeId);
        Map enableMap = FahEventRuleDao.getEvtDataEnable(list, (String)"t_fah_biz_type");
        return (Boolean)enableMap.get(eventTypeId);
    }

    private boolean checkEvtClass(Long eventClassId) {
        LinkedList<Long> list = new LinkedList<Long>();
        list.add(eventClassId);
        Map enableMap = FahEventRuleDao.getEvtDataEnable(list, (String)"t_fah_biz_class");
        return (Boolean)enableMap.get(eventClassId);
    }

    @Override
    public Collection<Long> buildEvtLineByRequest(Collection<Long> evtHeadIds, Long requestId, FahJobContext fahJobContext) {
        LinkedList<Long> successEvtHeadIds = new LinkedList<Long>();
        this.deleteEvtLineAndTmp(evtHeadIds);
        fahJobContext.addDetailEntry("fah_event_line", evtHeadIds.size());
        try {
            Map<String, Map<Long, List<EvtEntryInfo>>> group = BuildEvtDataServiceImpl3.getEvtEntryInfoGroup(evtHeadIds);
            for (Map.Entry<String, Map<Long, List<EvtEntryInfo>>> entry : group.entrySet()) {
                String billType = entry.getKey();
                Map<Long, List<EvtEntryInfo>> map = entry.getValue();
                for (Map.Entry<Long, List<EvtEntryInfo>> ruleEntry : map.entrySet()) {
                    List<Long> subEventList = this.buildEvtLineData(billType, ruleEntry.getKey(), ruleEntry.getValue(), fahJobContext);
                    successEvtHeadIds.addAll(subEventList);
                }
            }
        }
        catch (Exception e) {
            fahJobContext.getFahBgTaskLogger().addDetailEntryErr("buildEventData_buildEvtLineByRequest err:" + e.getMessage());
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        return successEvtHeadIds;
    }

    private static Map<String, Map<Long, List<EvtEntryInfo>>> getEvtEntryInfoGroup(Collection<Long> evtHeadIds) {
        HashMap<String, Map<Long, List<EvtEntryInfo>>> group = new HashMap<String, Map<Long, List<EvtEntryInfo>>>(8);
        try (DataSet evtHeads = FahEventRuleDao.queryEvtHeads(evtHeadIds);){
            while (evtHeads.hasNext()) {
                Row row = evtHeads.next();
                group.computeIfAbsent(row.getString("fsrc_billtype"), k -> new HashMap()).computeIfAbsent(row.getLong("fruleid"), k1 -> new LinkedList()).add(new EvtEntryInfo(row.getLong("fid"), row.getLong("fsrc_billid"), row.getString("fsourceentry"), row.getLong("fsourceentryid")));
            }
        }
        return group;
    }

    private void deleteEvtLineAndTmp(Collection<Long> evtHeadIds) {
        try (TXHandle h = TX.requiresNew();){
            try {
                FahEventRuleDao.deleteEvtLineAndErr(evtHeadIds);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public List<Long> buildEvtLineData(String billType, Long ruleId, List<EvtEntryInfo> evtEntryInfoList, FahJobContext fahJobContext) throws Exception {
        EntityType entityType;
        boolean isError = false;
        Exception exception = null;
        EventRuleModelCfg ruleModelCfg = EvtRuleThreadCache.getEventRuleModelCfgCached((Long)ruleId);
        List lineTypeIdList = ruleModelCfg.getEventRuleLineCfgs().stream().map(EventRuleLineCfg::getEventLineTypeId).collect(Collectors.toList());
        Map lineTypeEnableMap = FahEventRuleDao.getEvtDataEnable(lineTypeIdList, (String)"t_fah_evt_linetype");
        BuildEvtContext buildEvtContext = new BuildEvtContext();
        buildEvtContext.setBillType(billType);
        buildEvtContext.setRequestId(fahJobContext.getRequestId());
        buildEvtContext.setPartitionGrpCode(fahJobContext.getPartitionGrpCode());
        buildEvtContext.setBigEntrySizeConfig(fahJobContext.getBigEntrySizeConfig());
        buildEvtContext.setBillIds((Collection)evtEntryInfoList.stream().map(EvtEntryInfo::getBillId).collect(Collectors.toList()));
        buildEvtContext.setSourceEntry(ruleModelCfg.getSourceEntry());
        buildEvtContext.setSourceEntryIds(evtEntryInfoList.stream().map(EvtEntryInfo::getSourceEntryId).collect(Collectors.toList()));
        buildEvtContext.setLineTypeEnableMap(lineTypeEnableMap);
        buildEvtContext.setEvtHeadInfoMap(this.genEvtHeadInfoMap(evtEntryInfoList));
        buildEvtContext.setRuleModelCfg(ruleModelCfg);
        buildEvtContext.setSingleLineGroup(ruleModelCfg.getEventRuleLineGroups().size() == 1);
        buildEvtContext.setFahJobContext((IFahJobContext)fahJobContext);
        BaseInsertSqlBuilder lineTmpBuilder = buildEvtContext.getLineTmpBuilder();
        ISqlParamBuffer lineTmpParamBuffer = lineTmpBuilder.getSqlParamBuffer();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        String sourceEntry = ruleModelCfg.getSourceEntry();
        String pkName = billType.equals(sourceEntry) ? "srcbill_pk" : ((entityType = (EntityType)dataEntityType.getAllEntities().get(sourceEntry)) instanceof SubEntryType ? "srcbill_subentrypk" : "srcbill_entrypk");
        LinkedHashMap<Long, PairTuple> getValueHandleMap = new LinkedHashMap<Long, PairTuple>();
        for (EventRuleLineGroup eventRuleLineGroup : ruleModelCfg.getEventRuleLineGroups()) {
            buildEvtContext.setCurrRowBillId(null);
            LinkedList<EventRuleLineCfg> lineCfgList = new LinkedList<EventRuleLineCfg>();
            LinkedList<EventRuleLineCfg> lineCfgNotFoundAmountFieldList = new LinkedList<EventRuleLineCfg>();
            HashMap<Long, Set> notFoundAmountBillIdsMap = new HashMap<Long, Set>(8);
            for (EventRuleLineCfg lineCfg : eventRuleLineGroup.getEventRuleLineCfgs()) {
                String amountNumber;
                if (lineCfg.getEnable() == null || !lineCfg.getEnable().booleanValue() || !StringUtils.isNotEmpty((String)(amountNumber = lineCfg.fetchAmountNumber()))) continue;
                String[] amountNumberArr = amountNumber.split("\\.");
                IDataEntityProperty property = dataEntityType.findProperty(amountNumberArr[0]);
                if (property == null || StringUtils.isEmpty((String)property.getAlias())) {
                    lineCfgNotFoundAmountFieldList.add(lineCfg);
                    continue;
                }
                lineCfgList.add(lineCfg);
                DynamicExtractFieldValueSetData amountCfg = lineCfg.getAmountCfg();
                DynamicExtractFieldValueSetData currencyCfg = lineCfg.getCurrencyCfg();
                IGetValueHandle amountHandle = null == amountCfg ? null : GetValueHandleFactory.getGetValueHandle((DynamicExtractFieldValueSetData)amountCfg);
                IGetValueHandle currencyHandle = null == currencyCfg ? null : GetValueHandleFactory.getGetValueHandle((DynamicExtractFieldValueSetData)currencyCfg);
                getValueHandleMap.put(lineCfg.getId(), new PairTuple((Object)amountHandle, (Object)currencyHandle));
            }
            if (lineCfgList.isEmpty()) {
                for (Long billId : buildEvtContext.getSourceEntryIds()) {
                    for (EventRuleLineCfg lineCfg : lineCfgNotFoundAmountFieldList) {
                        if (!notFoundAmountBillIdsMap.computeIfAbsent(lineCfg.getId(), k -> new HashSet(8)).add(billId)) continue;
                        BuildEvtDataUtil.addNotFoundAmountFailRow((BuildEvtContext)buildEvtContext, (Long)billId, (EventRuleLineCfg)lineCfg);
                        int lineErrSize = lineTmpParamBuffer.moveToNextParamRow();
                        if (lineErrSize < this.lineSaveBatchSize) continue;
                        BuildEvtDataUtil.saveEventDataLine((BuildEvtContext)buildEvtContext);
                    }
                }
                continue;
            }
            BaseMutableArrayMapStorage fieldAliasInfos = BuildEvtDataUtil.filterAmountFields(lineCfgNotFoundAmountFieldList, (BaseMutableArrayMapStorage)eventRuleLineGroup.getFieldAliasInfos());
            try {
                DataSet dataset = BuildEvtDataUtil.getLineDataset((BuildEvtContext)buildEvtContext, (Iterable)fieldAliasInfos, (String)eventRuleLineGroup.getOrderBy());
                Object object = null;
                try {
                    while (dataset.hasNext()) {
                        Row currRow = dataset.next();
                        Long srcBillEntryId = currRow.getLong(pkName);
                        if (null == srcBillEntryId || 0L == srcBillEntryId) continue;
                        buildEvtContext.setCurrRowBillId(srcBillEntryId);
                        for (EventRuleLineCfg lineCfg : lineCfgNotFoundAmountFieldList) {
                            if (!notFoundAmountBillIdsMap.computeIfAbsent(lineCfg.getId(), k -> new HashSet(8)).add(srcBillEntryId)) continue;
                            BuildEvtDataUtil.addNotFoundAmountFailRow((BuildEvtContext)buildEvtContext, (Long)srcBillEntryId, (EventRuleLineCfg)lineCfg);
                            int lineErrSize = lineTmpParamBuffer.moveToNextParamRow();
                            if (lineErrSize < this.lineSaveBatchSize) continue;
                            BuildEvtDataUtil.saveEventDataLine((BuildEvtContext)buildEvtContext);
                        }
                        for (EventRuleLineCfg lineCfg : lineCfgList) {
                            int lineSize;
                            boolean isAlreadyBuildLine;
                            Long currRowSrcBillEntryId;
                            if (lineCfg.getEnable() == null || !lineCfg.getEnable().booleanValue() || null == (currRowSrcBillEntryId = currRow.getLong(lineCfg.fetchAmountPKAlias())) || 0L == currRowSrcBillEntryId || (isAlreadyBuildLine = this.checkMemEvtLine(buildEvtContext, lineCfg, currRowSrcBillEntryId))) continue;
                            PairTuple lineResult = BuildEvtDataUtil.buildEvtLine((BuildEvtContext)buildEvtContext, (Row)currRow, (EventRuleLineCfg)lineCfg, (BaseMutableArrayMapStorage)fieldAliasInfos, getValueHandleMap);
                            EvtHeadInfo evtHeadInfo = (EvtHeadInfo)buildEvtContext.getEvtHeadInfoMap().get(srcBillEntryId);
                            evtHeadInfo.addTotalEvtLineCnt();
                            if (((Boolean)lineResult.getKey()).booleanValue()) {
                                evtHeadInfo.addErrEvtLineCnt();
                            }
                            if ((lineSize = lineTmpParamBuffer.moveToNextParamRow()) < this.lineSaveBatchSize) continue;
                            BuildEvtDataUtil.saveEventDataLine((BuildEvtContext)buildEvtContext);
                        }
                        buildEvtContext.setLastRowBillId(srcBillEntryId);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (dataset == null) continue;
                    if (object != null) {
                        try {
                            dataset.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        continue;
                    }
                    dataset.close();
                }
            }
            catch (Exception e) {
                isError = true;
                exception = e;
                break;
            }
        }
        if (isError) {
            BuildEvtDataUtil.saveEventDataLine((BuildEvtContext)buildEvtContext);
            throw exception;
        }
        buildEvtContext.setFinish(true);
        BuildEvtDataUtil.saveEventDataLine((BuildEvtContext)buildEvtContext);
        LinkedList<Long> successBillIds = new LinkedList<Long>();
        for (Map.Entry entry : buildEvtContext.getEvtHeadInfoMap().entrySet()) {
            if (((EvtHeadInfo)entry.getValue()).getErrEvtLineCnt() != 0 || !((EvtHeadInfo)entry.getValue()).isEvtLineStatusFlushDBFlag()) continue;
            successBillIds.add(((EvtHeadInfo)entry.getValue()).getEvtHeadId());
        }
        return successBillIds;
    }

    private boolean checkMemEvtHead(BuildEvtContext buildEvtContext) {
        return BuildEvtDataUtil.checkLastBillFinished((BuildEvtContext)buildEvtContext);
    }

    private Map<Long, EvtHeadInfo> genEvtHeadInfoMap(List<EvtEntryInfo> ruleEntry) {
        HashMap<Long, EvtHeadInfo> evtHeadIdsMap = new HashMap<Long, EvtHeadInfo>(ruleEntry.size());
        for (EvtEntryInfo billEventId : ruleEntry) {
            EvtHeadInfo evtHeadInfo = new EvtHeadInfo();
            evtHeadInfo.setBillId(billEventId.getSourceEntryId());
            evtHeadInfo.setEvtHeadId(billEventId.getEvtPkId());
            evtHeadIdsMap.put(billEventId.getSourceEntryId(), evtHeadInfo);
        }
        return evtHeadIdsMap;
    }

    private boolean checkMemEvtLine(BuildEvtContext buildEvtContext, EventRuleLineCfg lineCfg, Long currRowSrcBillEntryId) {
        Long lastRowSrcBillEntryId = (Long)buildEvtContext.getLastRowSrcBillEntryIdMap().get(lineCfg.getId());
        if (!Objects.equals(lastRowSrcBillEntryId, currRowSrcBillEntryId)) {
            buildEvtContext.getLastRowSrcBillEntryIdMap().put(lineCfg.getId(), currRowSrcBillEntryId);
            return false;
        }
        return true;
    }

    public void setExecuteFunctions(BiConsumer<FahEvtTaskParam, List<Long>> buildEvtLineByTaskAndEvtHeadIds) {
        this.buildEvtLineByTaskAndEvtHeadIds = buildEvtLineByTaskAndEvtHeadIds;
    }
}

