/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.service;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.BiConsumer;
import kd.bos.logging.Log;
import kd.bos.logging.logback.LogbackFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.service.IBuildXLAAndGLService;
import kd.fi.bd.util.data.IDataValueUtil;
import kd.fi.v2.fah.cache.common.SimpleDataDistributeCacheService;
import kd.fi.v2.fah.event.job.JobManagerCenter3;
import kd.fi.v2.fah.log.FahPoaFeatureMonitor;
import kd.fi.v2.fah.task.FahDataProcessTaskFactory;
import kd.fi.v2.fah.task.common.AbstractCommonDataWorkTask;
import kd.fi.v2.fah.task.common.IFahDataWorkTask;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;
import kd.fi.v2.fah.task.maintask.AbstractProcessBillTypeDataRootTask;
import kd.fi.v2.fah.task.maintask.SubmitProcessBillDataRequestTask;
import kd.fi.v2.fah.task.params.input.IProcessBillDataTaskInputParam;
import kd.fi.v2.fah.task.params.input.ProcessBillDataRootTaskInputParam;
import kd.fi.v2.fah.task.params.input.SubmitProcessBillDataRequestTaskInputParam;
import kd.fi.v2.fah.task.result.FahSimpleTaskResult;
import kd.fi.v2.fah.util.EventGenTaskUtils;
import kd.fi.v2.fah.utils.DateValueUtils;
import kd.fi.v2.fah.utils.FahSerializeHelper;

public class BuildXLAAndGLServiceImpl
implements IBuildXLAAndGLService,
ITaskStatusChangeListener {
    private static final Log log = LogbackFactory.getLog(BuildXLAAndGLServiceImpl.class);
    private static final FahDataProcessTaskFactory factory = FahDataProcessTaskFactory.getInstance();
    private static final SimpleDataDistributeCacheService cacheService = SimpleDataDistributeCacheService.getInstance();

    public BuildXLAAndGLServiceImpl() {
        this((msgTmplate, param) -> {
            if (log.isInfoEnabled()) {
                log.info(String.format(msgTmplate, param));
            }
        });
    }

    protected BuildXLAAndGLServiceImpl(BiConsumer<String, Object[]> logOutput) {
    }

    public String buildXLAAndGL(String billType, Collection<Long> billIds, String paramStr) {
        Exception fatalException;
        SubmitProcessBillDataRequestTaskInputParam inputParam;
        Long requestId_cache;
        HashMap<String, Object> executionResultMap;
        block5: {
            executionResultMap = new HashMap<String, Object>(8);
            requestId_cache = null;
            inputParam = this.parseInputParam(billType, billIds, paramStr);
            if (inputParam == null) {
                return null;
            }
            SubmitProcessBillDataRequestTask submitTask = (SubmitProcessBillDataRequestTask)factory.buildTaskInstance((IProcessBillDataTaskInputParam)inputParam, (ITaskStatusChangeListener)this);
            if (submitTask == null) {
                return this.buildServiceResultValue(inputParam, null, executionResultMap, requestId_cache);
            }
            fatalException = null;
            try {
                FahSimpleTaskResult taskResult = (FahSimpleTaskResult)submitTask.call();
                requestId_cache = taskResult.getRequestId();
                inputParam.setRequestId(requestId_cache.longValue());
                ProcessBillDataRootTaskInputParam rootTaskInputParam = new ProcessBillDataRootTaskInputParam(inputParam);
                AbstractProcessBillTypeDataRootTask rootTask = (AbstractProcessBillTypeDataRootTask)factory.buildTaskInstance((IProcessBillDataTaskInputParam)rootTaskInputParam, (ITaskStatusChangeListener)this);
                if (rootTask == null) {
                    return this.buildServiceResultValue(inputParam, null, executionResultMap, requestId_cache);
                }
                HashMap<String, Object> jobParamMap = new HashMap<String, Object>();
                HashMap<String, String> innerParamMap = new HashMap<String, String>();
                String taskType = submitTask.getTaskType();
                innerParamMap.put("buildeventmode", taskType);
                innerParamMap.put("fispreview", (String)inputParam.getSrcOperationParamMap().get("isPreview"));
                innerParamMap.put("taskid", requestId_cache.toString());
                jobParamMap.put("option", innerParamMap);
                new JobManagerCenter3(jobParamMap).buildEvtV3(billType, billIds);
                Object object = rootTask.call();
            }
            catch (Exception fatalError) {
                fatalException = fatalError;
                String traceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)fatalError);
                log.info(traceMessage);
                executionResultMap.put("errorMsg", fatalError.getMessage());
                if (null == requestId_cache) break block5;
                EventGenTaskUtils.updateFahRequestTask((Long)requestId_cache, (String)traceMessage);
            }
        }
        this.poaFeatureMonitor_output(billType, billIds.size());
        return this.buildServiceResultValue(inputParam, fatalException, executionResultMap, requestId_cache);
    }

    protected String buildServiceResultValue(SubmitProcessBillDataRequestTaskInputParam inputParam, Throwable exception, Map<String, Object> executionResultMap, Long requestId_cache) {
        executionResultMap.put("requestId", requestId_cache);
        return FahSerializeHelper.toJsonString(executionResultMap);
    }

    protected SubmitProcessBillDataRequestTaskInputParam parseInputParam(String billType, Collection<Long> billIds, String paramStr) {
        SubmitProcessBillDataRequestTaskInputParam inputParam = new SubmitProcessBillDataRequestTaskInputParam();
        inputParam.setBillType(billType);
        inputParam.setSrcIds(billIds);
        if (paramStr != null) {
            try {
                Map paramMap = (Map)FahSerializeHelper.fromJsonString((String)paramStr, Map.class);
                inputParam.setSrcOperationParamMap(paramMap);
                String includeTaskGrp = (String)paramMap.get("includeTaskGrp");
                FahTaskGrpTypeEnum[][] taskGrps = FahTaskGrpTypeEnum.parseTaskTypes((String)includeTaskGrp);
                if (taskGrps.length == 0) {
                    return null;
                }
                inputParam.setExecuteTaskGrp(taskGrps);
                LinkedList<String> billTypes = new LinkedList<String>();
                billTypes.add(billType);
                inputParam.setBillTypes(billTypes);
                String submitOrgs = (String)paramMap.get("orgs");
                if (null != submitOrgs) {
                    inputParam.setOrgIds((Collection)FahSerializeHelper.fromJsonString((String)submitOrgs, Collection.class));
                }
                String startDateStr = (String)paramMap.get("startDate");
                String endDateStr = (String)paramMap.get("endDate");
                if (null != startDateStr && null != endDateStr) {
                    Date[] queryDateRangeArr = new Date[]{IDataValueUtil.getDate((String)startDateStr), IDataValueUtil.getDate((String)endDateStr)};
                    inputParam.setQueryDateRange(queryDateRangeArr);
                }
                String billStatus = (String)paramMap.get("billstatus");
                inputParam.setBillStatus(billStatus);
                inputParam.setPreviewMode(IDataValueUtil.getBoolean(paramMap.get("isPreview")).booleanValue());
            }
            catch (Exception ex) {
                this.onException(null, 0, String.format("Error on parse Input Parameter: billType=%s, billIds is empty, paramStr=%s", billType, paramStr), paramStr, ex);
            }
        }
        return inputParam;
    }

    public void beforeTaskStart(IFahDataWorkTask srcWorkTask) {
    }

    public boolean onException(IFahDataWorkTask srcWorkTask, int batchSeqNo, String errorMsg, Object errorDataParam, Throwable ex) {
        return true;
    }

    public boolean onBatchCompleted(IFahDataWorkTask srcWorkTask, int batchSeqNo, Object batchResult, boolean withError) {
        if (srcWorkTask instanceof AbstractCommonDataWorkTask) {
            AbstractCommonDataWorkTask abstractCommonDataWorkTask = (AbstractCommonDataWorkTask)srcWorkTask;
        }
        return true;
    }

    public boolean onPartitionGrpCompleted(IFahDataWorkTask srcWorkTask) {
        return true;
    }

    public void afterTaskCompleted(IFahDataWorkTask srcWorkTask, Object taskResult, boolean withError) {
    }

    private void poaFeatureMonitor_output(String billType, int dataCount) {
        HashMap<String, String> varMap = new HashMap<String, String>(8);
        varMap.put("API", "buildXLAAndGL");
        long cost = DateValueUtils.cost();
        FahPoaFeatureMonitor.output((Log)log, (String)"EAH-2023-ZT01-TX03", (int)dataCount, (Long)cost, (String)billType, varMap);
    }
}

