/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.service.IBuildXLADataService;
import kd.fi.v2.fah.cache.cacheservice.XLARuleThreadCache;
import kd.fi.v2.fah.constant.enums.event.FahEventGenOprEnum;
import kd.fi.v2.fah.dao.BaseFlexFieldDao;
import kd.fi.v2.fah.dao.FahGenerateXLADataDao;
import kd.fi.v2.fah.datasource.QueryDataSourceFactory;
import kd.fi.v2.fah.datasource.WriteMemorySpaceHelper;
import kd.fi.v2.fah.event.mservice.context.SingleXLATaskContext;
import kd.fi.v2.fah.event.mservice.context.XLADataContext;
import kd.fi.v2.fah.event.mservice.service.GenerateXLASingleTask;
import kd.fi.v2.fah.event.mservice.util.BuildXLADataUtil;
import kd.fi.v2.fah.event.mservice.util.XLABusinessDataCheckUtil;
import kd.fi.v2.fah.models.xla.GenerateXLAErrorCode;
import kd.fi.v2.fah.models.xla.XLARuleModelConfig;
import kd.fi.v2.fah.models.xla.XLARuleSourceDataGroup;
import kd.fi.v2.fah.services.dto.SingleGenXLADataSource;
import kd.fi.v2.fah.sqlbuilder.CreateSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.task.context.BuildVoucherReportInfoContext;

public class BuildXLADataServiceImpl
implements IBuildXLADataService {
    private static final Log logger = LogFactory.getLog(BuildXLADataServiceImpl.class);
    private final Long requestId;
    private final Boolean isPreview;
    private final FahEventGenOprEnum eventGenOprEnum;

    public BuildXLADataServiceImpl(Long requestId, Boolean isPreview, FahEventGenOprEnum eventGenOprEnum) {
        this.requestId = requestId;
        this.isPreview = isPreview;
        this.eventGenOprEnum = eventGenOprEnum;
    }

    public Collection<Long> generateXLAData(String billEntityName, Long ruleId, Set<Long> billIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (StringUtils.isBlank((CharSequence)billEntityName) || ruleId == 0L || billIds.isEmpty()) {
            return result;
        }
        BuildVoucherReportInfoContext reportContext = new BuildVoucherReportInfoContext(this.requestId, billEntityName, BuildVoucherReportInfoContext.ReportBuildType.GENXLAVOUCHER);
        XLARuleModelConfig xlaRuleModel = XLARuleThreadCache.getXLARuleModelConfigCached((Long)ruleId);
        if (xlaRuleModel.getXlaRuleSourceDataGroup().isEmpty()) {
            reportContext.genBatchErrorMessage(billIds, GenerateXLAErrorCode.RULE_ERROR);
            reportContext.taskToEnd();
            return result;
        }
        SingleGenXLADataSource singleGenXLADataSource = FahGenerateXLADataDao.splitEventData(billIds).stream().filter(f -> billEntityName.equals(f.getBillEntityName()) && Objects.equals(ruleId, f.getRuleId())).findFirst().get();
        singleGenXLADataSource.setAcctRuleId((Long)xlaRuleModel.getId());
        if (!singleGenXLADataSource.getHasErrorEventIds().isEmpty()) {
            reportContext.genBatchErrorMessage(singleGenXLADataSource.getHasErrorEventIds(), GenerateXLAErrorCode.EVENTID_ERROR);
            reportContext.taskToEnd();
            return result;
        }
        singleGenXLADataSource.initEventLineData();
        XLADataContext currContext = new XLADataContext(singleGenXLADataSource, reportContext);
        BaseInsertSqlBuilder xlaHeadData = CreateSqlBuilder.createXLAHead();
        BaseInsertSqlBuilder xlaLineData = CreateSqlBuilder.createXLALine();
        List xlaRuleSourceDataGroup = xlaRuleModel.getXlaRuleSourceDataGroup();
        for (XLARuleSourceDataGroup ruleGroup : xlaRuleSourceDataGroup) {
            BaseMutableArrayMapStorage fieldAliasInfos = ruleGroup.getFieldAliasInfos();
            ArrayList<Object[]> space = new ArrayList<Object[]>(1000);
            String selector = ruleGroup.getSqlPrefix();
            String orderBy = ruleGroup.getKey().getOrderField();
            List pkIds = singleGenXLADataSource.getSrcIds().stream().collect(Collectors.toList());
            try {
                DataSet queryDataFromSelector = QueryDataSourceFactory.getQueryDataSource((String)billEntityName).queryDataFromSelector(pkIds, selector, orderBy, -1);
                Throwable throwable = null;
                try {
                    Iterator iterator = queryDataFromSelector.iterator();
                    while (iterator.hasNext()) {
                        space.add(WriteMemorySpaceHelper.writeDataToSpace((Row)((Row)iterator.next()), (BaseMutableArrayMapStorage)fieldAliasInfos));
                        if (space.size() != 1000 && iterator.hasNext()) continue;
                        SingleXLATaskContext context = new SingleXLATaskContext(this.requestId, this.isPreview, currContext, ruleGroup, space, xlaHeadData, xlaLineData);
                        new GenerateXLASingleTask(context).generateXLAData();
                        this.xlaDataProcessing(context);
                        space.clear();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (queryDataFromSelector == null) continue;
                    if (throwable != null) {
                        try {
                            queryDataFromSelector.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    queryDataFromSelector.close();
                }
            }
            catch (Exception e) {
                String err = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error("--BuildXLADataServiceImpl--Exception: {}", (Object)err);
                reportContext.genStackErrorMessage(e);
                xlaLineData.clearSqlParamData();
                xlaHeadData.clearSqlParamData();
                throw e;
            }
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                XLABusinessDataCheckUtil.XLADataProcessing(currContext, xlaHeadData, xlaLineData);
                HashSet<Long> succIds = new HashSet<Long>(billIds.size());
                HashSet<Long> xlaSuccIds = new HashSet<Long>(billIds.size());
                HashSet<Long> failIds = new HashSet<Long>(billIds.size());
                XLABusinessDataCheckUtil.genBuildXLAResult(xlaHeadData, xlaLineData, currContext.getReportContext(), succIds, failIds, xlaSuccIds);
                BuildXLADataUtil.doUpdateEventStatus(succIds, failIds, reportContext);
                result.addAll(succIds);
                BuildXLADataUtil.generateXLANumber(xlaHeadData, currContext, xlaSuccIds);
                BaseFlexFieldDao.doInsert((IInsertSqlBuilder)xlaLineData);
                BaseFlexFieldDao.doInsert((IInsertSqlBuilder)xlaHeadData);
            }
            catch (Exception e) {
                h.markRollback();
                reportContext.genStackErrorMessage(e);
                logger.error("--BuildXLADataServiceImpl--Exception: {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
        }
        reportContext.taskToEnd();
        return result;
    }

    private void xlaDataProcessing(SingleXLATaskContext context) {
        BaseInsertSqlBuilder xlaLineData = context.getXLALineData();
        if (xlaLineData.getSqlParamRowCnt() > 100000) {
            XLABusinessDataCheckUtil.checkAndUpdateXLAData(context);
            BaseFlexFieldDao.doInsert((IInsertSqlBuilder)xlaLineData);
            xlaLineData.clearSqlParamData();
        }
    }

    public Collection<Long> generateXLAData(Collection<Long> billIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        List splitEventData = FahGenerateXLADataDao.splitEventData(billIds);
        for (SingleGenXLADataSource sg : splitEventData) {
            Collection<Long> data = this.generateXLAData(sg.getBillEntityName(), sg.getRuleId(), sg.getEventIds());
            result.addAll(data);
        }
        return result;
    }
}

