/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.service;

import java.util.List;
import kd.fi.v2.fah.event.mservice.context.SingleXLATaskContext;
import kd.fi.v2.fah.event.mservice.util.BuildXLADataUtil;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.models.xla.XLARuleAcctPurpGroup;
import kd.fi.v2.fah.models.xla.XLARuleLineConfig;

public class GenerateXLASingleTask {
    private SingleXLATaskContext schema;

    public GenerateXLASingleTask(SingleXLATaskContext schema) {
        this.schema = schema;
    }

    public void generateXLAData() {
        boolean checkSchema = this.checkSchema();
        if (!checkSchema) {
            return;
        }
        List<XLARuleAcctPurpGroup> xlaRuleAcctPurpGroup = this.schema.getXlaRuleAcctPurpGroup();
        for (XLARuleAcctPurpGroup apGroup : xlaRuleAcctPurpGroup) {
            List xlaRuleLineCol = apGroup.getXlaRuleLineCol();
            xlaRuleLineCol.stream().forEach(xrf -> xrf.getFieldHandle().stream().filter(fi -> fi.getGetValueHandle().isBatchGetValue()).forEach(fach -> fach.batchExecute(this.schema.getValues(), this.schema.getFieldAliasInfos())));
            for (Object[] data : this.schema.getValues()) {
                Long srcId = (Long)data[((FieldAliasInfo)this.schema.getFieldAliasInfos().get((Object)this.schema.getMainEntityKey().getMainKey())).getReadPos()];
                Long srcEntryId = (Long)data[((FieldAliasInfo)this.schema.getFieldAliasInfos().get((Object)this.schema.getMainEntityKey().getMainEntryKey())).getReadPos()];
                Long srcEnteryId_real = 0L;
                if (this.schema.getMainEntityKey().getSubEntryKey() != null) {
                    srcEnteryId_real = (Long)data[((FieldAliasInfo)this.schema.getFieldAliasInfos().get((Object)this.schema.getMainEntityKey().getEntryKey())).getReadPos()];
                }
                BuildXLADataUtil.generateXLAHead(srcId, srcEntryId, this.schema.getXlaContext(), this.schema.getXLAHeadData(), apGroup, data, this.schema.getFieldAliasInfos(), this.schema.getIsPreview(), this.schema.getRequestId());
                for (XLARuleLineConfig ruleLine : xlaRuleLineCol) {
                    BuildXLADataUtil.generateXLALine(srcId, srcEntryId, srcEnteryId_real, this.schema.getXlaContext(), this.schema.getXLALineData(), ruleLine, data, this.schema.getFieldAliasInfos(), apGroup.getAcctPurposeId());
                }
            }
        }
    }

    private boolean checkSchema() {
        if (this.schema == null) {
            return false;
        }
        return this.schema.getValues().size() != 0 && this.schema.getXLAHeadData() != null && this.schema.getXLALineData() != null && !this.schema.getXlaRuleAcctPurpGroup().isEmpty() && !this.schema.getFieldAliasInfos().isEmpty();
    }
}

