/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.logback.LogbackFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.service.IReverseGLAndAcctJEService;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.enums.event.BillDataProcessErrorCategoryEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventGenOprEnum;
import kd.fi.v2.fah.dao.engine.reverse.ReverseBillDataTaskDaoImpl;
import kd.fi.v2.fah.task.FahDataProcessTaskFactory;
import kd.fi.v2.fah.task.common.IFahDataWorkTask;
import kd.fi.v2.fah.task.common.ITaskStatusChangeListener;
import kd.fi.v2.fah.task.enums.FahTaskGrpTypeEnum;
import kd.fi.v2.fah.task.maintask.ProcessReverseDataRootTask;
import kd.fi.v2.fah.task.maintask.SubmitProcessBillDataRequestTask;
import kd.fi.v2.fah.task.params.input.IProcessBillDataTaskInputParam;
import kd.fi.v2.fah.task.params.input.ReverseBillDataRootTaskInputParam;
import kd.fi.v2.fah.task.params.input.SubmitProcessBillDataRequestTaskInputParam;
import kd.fi.v2.fah.task.result.FahSimpleTaskResult;
import kd.fi.v2.fah.util.BuildEvtDataUtil;
import kd.fi.v2.fah.util.EventGenTaskUtils;
import kd.fi.v2.fah.utils.FahSerializeHelper;

public class ReverseGLAndAcctJEServiceImpl
implements IReverseGLAndAcctJEService,
ITaskStatusChangeListener {
    private static final Log log = LogbackFactory.getLog(ReverseGLAndAcctJEServiceImpl.class);
    private static final FahDataProcessTaskFactory factory = FahDataProcessTaskFactory.getInstance();

    public String reverseGLAndAcctJE(String billType, Collection<Long> ids, String paramStr) {
        SubmitProcessBillDataRequestTaskInputParam inputParam;
        Long requestId_cache;
        HashMap<String, Object> executionResultMap;
        block8: {
            log.info("xxx reverse start :{}", (Object)paramStr);
            executionResultMap = new HashMap<String, Object>(8);
            requestId_cache = null;
            inputParam = this.parseInputParam(billType, ids, paramStr);
            if (inputParam == null) {
                return null;
            }
            SubmitProcessBillDataRequestTask submitTask = (SubmitProcessBillDataRequestTask)factory.buildTaskInstance((IProcessBillDataTaskInputParam)inputParam, (ITaskStatusChangeListener)this);
            if (submitTask == null) {
                return this.buildServiceResultValue(inputParam, null, executionResultMap, requestId_cache);
            }
            boolean isBillProcessing = false;
            try {
                FahSimpleTaskResult taskResult = (FahSimpleTaskResult)submitTask.call();
                requestId_cache = taskResult.getRequestId();
                inputParam.setRequestId(requestId_cache.longValue());
                BuildEvtDataUtil.updateFahRequestTaskStatusToRunning((Long)requestId_cache);
                this.checkReverseGlAndAcctData(billType, ids, requestId_cache);
                isBillProcessing = true;
                ReverseBillDataRootTaskInputParam rootTaskInputParam = new ReverseBillDataRootTaskInputParam(inputParam);
                ProcessReverseDataRootTask rootTask = (ProcessReverseDataRootTask)factory.buildTaskInstance((IProcessBillDataTaskInputParam)rootTaskInputParam, (ITaskStatusChangeListener)this);
                if (rootTask == null) {
                    return this.buildServiceResultValue(inputParam, null, executionResultMap, requestId_cache);
                }
                List<PairTuple<String, Exception>> rootTaskErrors = ReverseGLAndAcctJEServiceImpl.getTaskErrors(rootTask);
                rootTask.call();
                if (!rootTaskErrors.isEmpty()) {
                    int errorIndex = 1;
                    StringBuilder builder = new StringBuilder();
                    for (PairTuple<String, Exception> error : rootTaskErrors) {
                        builder.append(String.format(" ----------------------- Error [%d] ----------------------- ", errorIndex));
                        builder.append('\n').append(ExceptionUtils.getExceptionStackTraceMessage((Exception)((Exception)error.getValue())));
                        builder.append('\n');
                        ++errorIndex;
                    }
                    String traceMessage = builder.toString();
                    builder.setLength(0);
                    ReverseBillDataTaskDaoImpl.reBackCurrentTaskData((Long)requestId_cache);
                    BuildEvtDataUtil.writeBackBillVchStatus((long)requestId_cache, (boolean)false, null, (FahEventGenOprEnum)FahEventGenOprEnum.REVERSE_GL_XLA_EVENT, null);
                    EventGenTaskUtils.updateFahRequestTask((Long)requestId_cache, (String)traceMessage);
                    executionResultMap.put("errorMsg", traceMessage);
                } else {
                    BuildEvtDataUtil.updateFahRequestFinal((long)requestId_cache, (int)ids.size());
                    BuildEvtDataUtil.updateFahRequestTaskStatusToBizDataEnd((Long)requestId_cache);
                }
            }
            catch (Exception fatalError) {
                String traceMessage = ExceptionUtils.getExceptionStackTraceMessage((Exception)fatalError);
                log.info(traceMessage);
                executionResultMap.put("errorMsg", fatalError.getMessage());
                if (null == requestId_cache) break block8;
                ReverseBillDataTaskDaoImpl.reBackCurrentTaskData((Long)requestId_cache);
                EventGenTaskUtils.updateFahRequestTask((Long)requestId_cache, (String)traceMessage);
                if (!isBillProcessing) break block8;
                BuildEvtDataUtil.writeBackBillVchStatus((long)requestId_cache, (boolean)false, null, (FahEventGenOprEnum)FahEventGenOprEnum.REVERSE_GL_XLA_EVENT, null);
            }
        }
        return this.buildServiceResultValue(inputParam, null, executionResultMap, requestId_cache);
    }

    private static List<PairTuple<String, Exception>> getTaskErrors(ProcessReverseDataRootTask rootTask) {
        final LinkedList<PairTuple<String, Exception>> rootTaskErrors = new LinkedList<PairTuple<String, Exception>>();
        rootTask.setTaskStatusChangeListener(new ITaskStatusChangeListener(){

            public void beforeTaskStart(IFahDataWorkTask srcWorkTask) {
            }

            public boolean onException(IFahDataWorkTask srcWorkTask, int batchSeqNo, String errorMsg, Object errorDataParam, Throwable ex) {
                rootTaskErrors.add(new PairTuple((Object)errorMsg, (Object)new Exception(ex)));
                return false;
            }

            public boolean onBatchCompleted(IFahDataWorkTask srcWorkTask, int batchSeqNo, Object batchResult, boolean withError) {
                return true;
            }

            public boolean onPartitionGrpCompleted(IFahDataWorkTask srcWorkTask) {
                return true;
            }

            public void afterTaskCompleted(IFahDataWorkTask srcWorkTask, Object taskResult, boolean withError) {
            }
        });
        return rootTaskErrors;
    }

    protected void checkReverseGlAndAcctData(String billType, Collection<Long> ids, Long requestId) {
        Map checkBillIdsMap = ReverseBillDataTaskDaoImpl.getCheckBillIds(new HashSet<Long>(ids), (Long)requestId);
        Set errorBillIds = (Set)checkBillIdsMap.get("ERROR");
        if (!errorBillIds.isEmpty()) {
            HashMap<BillDataProcessErrorCategoryEnum, Set> skipBillIdsMap = new HashMap<BillDataProcessErrorCategoryEnum, Set>(1);
            skipBillIdsMap.put(BillDataProcessErrorCategoryEnum.BILL_NOT_SATISFIED_REVERSE, errorBillIds);
            BuildEvtDataUtil.saveSkipBills((long)requestId, (String)billType, skipBillIdsMap);
        }
        Set validateRevBillIds = (Set)checkBillIdsMap.get("SUCCESS");
        BuildEvtDataUtil.updateBillVchStatusProcessing((String)billType, (Collection)validateRevBillIds);
    }

    protected SubmitProcessBillDataRequestTaskInputParam parseInputParam(String billType, Collection<Long> billIds, String paramStr) {
        SubmitProcessBillDataRequestTaskInputParam inputParam = new SubmitProcessBillDataRequestTaskInputParam();
        inputParam.setBillType(billType);
        inputParam.setSrcIds(billIds);
        LinkedList<String> billTypes = new LinkedList<String>();
        billTypes.add(billType);
        inputParam.setBillTypes(billTypes);
        if (paramStr != null) {
            FahTaskGrpTypeEnum[][] taskGrps = FahTaskGrpTypeEnum.parseTaskTypes((String)paramStr);
            if (taskGrps.length == 0) {
                return null;
            }
            inputParam.setExecuteTaskGrp(taskGrps);
        }
        return inputParam;
    }

    protected String buildServiceResultValue(SubmitProcessBillDataRequestTaskInputParam inputParam, Throwable exception, Map<String, Object> executionResultMap, Long requestId_cache) {
        executionResultMap.put("requestId", requestId_cache);
        return FahSerializeHelper.toJsonString(executionResultMap);
    }

    public void beforeTaskStart(IFahDataWorkTask srcWorkTask) {
    }

    public boolean onException(IFahDataWorkTask srcWorkTask, int batchSeqNo, String errorMsg, Object errorDataParam, Throwable ex) {
        return false;
    }

    public boolean onBatchCompleted(IFahDataWorkTask srcWorkTask, int batchSeqNo, Object batchResult, boolean withError) {
        return false;
    }

    public boolean onPartitionGrpCompleted(IFahDataWorkTask srcWorkTask) {
        return false;
    }

    public void afterTaskCompleted(IFahDataWorkTask srcWorkTask, Object taskResult, boolean withError) {
    }
}

