/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.event.mservice.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.ai.Currency;
import kd.fi.v2.fah.constant.enums.event.FahEventHeadStatusEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventStageEnum;
import kd.fi.v2.fah.constant.enums.xla.FahXLAHeadField;
import kd.fi.v2.fah.constant.enums.xla.FahXLALineField;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;
import kd.fi.v2.fah.dao.FahCheckXLADataDao;
import kd.fi.v2.fah.dao.FahGenerateXLADataDao;
import kd.fi.v2.fah.event.mservice.context.XLADataContext;
import kd.fi.v2.fah.event.mservice.util.XLABusinessDataCheckUtil;
import kd.fi.v2.fah.models.event.eventrule.FieldAliasInfo;
import kd.fi.v2.fah.models.xla.GenerateXLAErrorCode;
import kd.fi.v2.fah.models.xla.XLAAccountBook;
import kd.fi.v2.fah.models.xla.XLANumberSrcModel;
import kd.fi.v2.fah.models.xla.XLAPeriod;
import kd.fi.v2.fah.models.xla.XLARuleAcctPurpGroup;
import kd.fi.v2.fah.models.xla.XLARuleLineConfig;
import kd.fi.v2.fah.services.dto.SingleGenXLADataSource;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.storage.impl.SupplementaryField;
import kd.fi.v2.fah.task.context.BuildVoucherReportInfoContext;
import kd.fi.v2.fah.util.BuildEvtDataUtil;

public class BuildXLADataUtil {
    public static void generateXLAHead(Long srcId, Long srcEntryId, XLADataContext xlaContext, BaseInsertSqlBuilder XLAHeadData, XLARuleAcctPurpGroup apGroup, Object[] data, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos, Boolean isPreview, Long requestId) {
        Long accountPurposeId;
        if (srcId == 0L || srcEntryId == 0L) {
            return;
        }
        SingleGenXLADataSource singleGenXLADataSource = xlaContext.getSingleGenXLADataSource();
        Set eventIds = singleGenXLADataSource.getGenEventIds(srcId, srcEntryId, accountPurposeId = apGroup.getAcctPurposeId());
        if (eventIds.isEmpty()) {
            return;
        }
        if (!XLABusinessDataCheckUtil.checkAcctPurpData(accountPurposeId, xlaContext.getReportContext(), eventIds).booleanValue()) {
            eventIds.stream().filter(f -> !xlaContext.getEventErrorHeadIds().contains(f)).forEach(eId -> BuildXLADataUtil.generateErrorXLAHeadData(singleGenXLADataSource, srcId, xlaContext, XLAHeadData, data, eId, GenerateXLAErrorCode.XLA_ACCTPURP_ERROR_STATUS, apGroup, fieldAliasInfos, isPreview, requestId));
            xlaContext.getEventErrorHeadIds().addAll(eventIds);
            return;
        }
        for (Long eventId : eventIds) {
            Collection xlaBook;
            Object[] eventData = (Object[])singleGenXLADataSource.getSupData().get(eventId);
            Long bizOrgId = (Long)eventData[1];
            if (!XLABusinessDataCheckUtil.checkOrgData(bizOrgId, xlaContext.getReportContext(), eventId)) {
                BuildXLADataUtil.generateErrorXLAHeadData(singleGenXLADataSource, srcId, xlaContext, XLAHeadData, data, eventId, GenerateXLAErrorCode.XLA_ACCTORG_ERROR_NOTACCOUNTORG, apGroup, fieldAliasInfos, isPreview, requestId);
                continue;
            }
            String key = bizOrgId + "-" + accountPurposeId;
            if (xlaContext.getOrgAndAcctBookMap().containsKey(key)) {
                xlaBook = xlaContext.getOrgAndAcctBookMap().get(key);
            } else {
                xlaBook = apGroup.getAcctBookHandle().getValue(bizOrgId, accountPurposeId);
                xlaContext.putOrgAndAcctBookMap(key, xlaBook);
            }
            if (xlaBook.isEmpty()) {
                xlaContext.getReportContext().genErrorMessage(eventId, GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_RULE);
                BuildXLADataUtil.generateErrorXLAHeadData(singleGenXLADataSource, srcId, xlaContext, XLAHeadData, data, eventId, GenerateXLAErrorCode.XLA_ACCTBOOK_ERROR_RULE, apGroup, fieldAliasInfos, isPreview, requestId);
                continue;
            }
            for (XLAAccountBook acctBook : xlaBook) {
                String XLAHeadKey = xlaContext.createKey(eventId, accountPurposeId, acctBook.getId());
                if (xlaContext.getXlaHeadIdMap().containsKey(XLAHeadKey)) continue;
                Long XLAHeadId = BuildXLADataUtil.getXLAHeaderId();
                ISqlParamBuffer sqlParamBuffer = XLAHeadData.getSqlParamBuffer();
                sqlParamBuffer.set(FahXLAHeadField.FID.getIndex(), (Object)XLAHeadId);
                sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"0");
                sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)"");
                sqlParamBuffer.set(FahXLAHeadField.FSRC_BILLID.getIndex(), (Object)srcId);
                sqlParamBuffer.set(FahXLAHeadField.FSRC_BILLNO.getIndex(), data[0]);
                sqlParamBuffer.set(FahXLAHeadField.FSRC_BILLTYPE.getIndex(), (Object)singleGenXLADataSource.getBillEntityName());
                sqlParamBuffer.set(FahXLAHeadField.FSRC_SYSID.getIndex(), (Object)singleGenXLADataSource.getSysId());
                sqlParamBuffer.set(FahXLAHeadField.FSRC_SYSTYPE.getIndex(), (Object)singleGenXLADataSource.getSysType());
                sqlParamBuffer.set(FahXLAHeadField.FSRCEVENTID.getIndex(), (Object)eventId);
                sqlParamBuffer.set(FahXLAHeadField.FACCTRULEID.getIndex(), (Object)singleGenXLADataSource.getAcctRuleId());
                sqlParamBuffer.set(FahXLAHeadField.FACCTRULEVERSIONID.getIndex(), (Object)singleGenXLADataSource.getRuleVersion());
                Date now = TimeServiceHelper.now();
                sqlParamBuffer.set(FahXLAHeadField.FCREATETIME.getIndex(), (Object)now);
                sqlParamBuffer.set(FahXLAHeadField.FREVERSESTATUS.getIndex(), (Object)"0");
                sqlParamBuffer.set(FahXLAHeadField.FRELATEID.getIndex(), (Object)0L);
                sqlParamBuffer.set(FahXLAHeadField.FLOC_DEBITAMT.getIndex(), (Object)new BigDecimal(0));
                sqlParamBuffer.set(FahXLAHeadField.FLOC_CREDITAMT.getIndex(), (Object)new BigDecimal(0));
                apGroup.getFieldHandle().stream().forEach(f -> f.execute(data, fieldAliasInfos, sqlParamBuffer));
                sqlParamBuffer.set(FahXLAHeadField.FACCTPURPOSEID.getIndex(), (Object)accountPurposeId);
                sqlParamBuffer.set(FahXLAHeadField.FPERIODID.getIndex(), (Object)0L);
                sqlParamBuffer.set(FahXLAHeadField.FREQUESTID.getIndex(), (Object)requestId);
                sqlParamBuffer.set(FahXLAHeadField.FACCTPURPOSEVERSION.getIndex(), (Object)0);
                sqlParamBuffer.set(FahXLAHeadField.FISPREVIEW.getIndex(), (Object)isPreview);
                sqlParamBuffer.set(FahXLAHeadField.FMERGERULEID.getIndex(), (Object)apGroup.getGroupmergeruleId());
                sqlParamBuffer.set(FahXLAHeadField.FNUMBER.getIndex(), (Object)"");
                sqlParamBuffer.set(FahXLAHeadField.FMERGEGRPKEY.getIndex(), (Object)BuildXLADataUtil.genMergeKey(apGroup.getBillMergeField(), data, fieldAliasInfos));
                if (!XLABusinessDataCheckUtil.checkCreator(sqlParamBuffer, xlaContext.getReportContext(), eventId)) {
                    sqlParamBuffer.set(FahXLAHeadField.FCREATORID.getIndex(), (Object)0L);
                    xlaContext.putXlaHeadIdMap(XLAHeadKey, XLAHeadId);
                    xlaContext.addXlaErrorHeadIds(XLAHeadId);
                }
                sqlParamBuffer.set(FahXLAHeadField.FBOOKTYPEID.getIndex(), (Object)acctBook.getBookTypeId());
                sqlParamBuffer.set(FahXLAHeadField.FBOOKID.getIndex(), (Object)acctBook.getId());
                sqlParamBuffer.set(FahXLAHeadField.FORGID.getIndex(), (Object)acctBook.getOrgId());
                sqlParamBuffer.set(FahXLAHeadField.FLOC_CURRENCYID.getIndex(), (Object)acctBook.getCurrencyId());
                if (!XLABusinessDataCheckUtil.checkAcctBook(acctBook, sqlParamBuffer, xlaContext.getReportContext(), eventId).booleanValue()) {
                    xlaContext.putXlaHeadIdMap(XLAHeadKey, XLAHeadId);
                    xlaContext.addXlaErrorHeadIds(XLAHeadId);
                    sqlParamBuffer.moveToNextParamRow();
                    continue;
                }
                Date bizDate = (Date)eventData[2];
                Date bookedDate = (Date)eventData[3];
                XLAPeriod period = FahGenerateXLADataDao.getPeriod((Date)bookedDate, (long)acctBook.getPeriodTypeId(), (Long)acctBook.getCurrPeriodId());
                if (!XLABusinessDataCheckUtil.checkPeriodAndDate(bizDate, bookedDate, period, sqlParamBuffer, xlaContext.getReportContext(), eventId)) {
                    xlaContext.putXlaHeadIdMap(XLAHeadKey, XLAHeadId);
                    xlaContext.addXlaErrorHeadIds(XLAHeadId);
                    sqlParamBuffer.moveToNextParamRow();
                    continue;
                }
                sqlParamBuffer.set(FahXLAHeadField.FPERIODID.getIndex(), (Object)period.getId());
                sqlParamBuffer.set(FahXLAHeadField.FBIZDATE.getIndex(), (Object)bizDate);
                sqlParamBuffer.set(FahXLAHeadField.FBOOKEDDATE.getIndex(), (Object)bookedDate);
                Object pre_voucherType = apGroup.getVoucherType().getValue(data, fieldAliasInfos);
                if (!XLABusinessDataCheckUtil.checkVoucherType(pre_voucherType, sqlParamBuffer, acctBook.getOrgId(), xlaContext.getReportContext(), eventId)) {
                    xlaContext.putXlaHeadIdMap(XLAHeadKey, XLAHeadId);
                    xlaContext.addXlaErrorHeadIds(XLAHeadId);
                    sqlParamBuffer.moveToNextParamRow();
                    continue;
                }
                xlaContext.putXlaHeadIdMap(XLAHeadKey, XLAHeadId);
                sqlParamBuffer.moveToNextParamRow();
            }
        }
        singleGenXLADataSource.hasBuildXLAHeadData(srcId, srcEntryId, accountPurposeId);
    }

    private static Long getXLAHeaderId() {
        return DB.genLongId((String)"t_fah_ae_headers_tmp");
    }

    public static void generateXLALine(Long srcId, Long srcEntryId, Long srcEnteryId_real, XLADataContext xlaContext, BaseInsertSqlBuilder xlaLineData, XLARuleLineConfig ruleLine, Object[] data, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos, Long accountPurposeId) {
        if (srcId == 0L || srcEntryId == 0L) {
            return;
        }
        SingleGenXLADataSource singleGenXLADataSource = xlaContext.getSingleGenXLADataSource();
        Set eventIds = singleGenXLADataSource.getEventIds(srcId, srcEntryId);
        if (eventIds.isEmpty()) {
            return;
        }
        for (Long eventId : eventIds) {
            Object[] eventData = (Object[])singleGenXLADataSource.getSupData().get(eventId);
            Long bizOrgId = (Long)eventData[1];
            Collection<XLAAccountBook> accountBooks = xlaContext.getOrgAndAcctBookMap().get(bizOrgId + "-" + accountPurposeId);
            List eventLineData = singleGenXLADataSource.getEventLineData(eventId);
            List eventLineData_currRule = eventLineData.stream().filter(f -> ruleLine.getEventLineId().equals(f[1])).collect(Collectors.toList());
            if (accountBooks == null || accountBooks.isEmpty()) {
                return;
            }
            for (XLAAccountBook acctBook : accountBooks) {
                Object localCredit;
                Object localDebit;
                Long acctBookId = acctBook.getId();
                Object[] sup_param = singleGenXLADataSource.getCurrNeedBuildLine(eventLineData_currRule, srcId, srcEntryId, srcEnteryId_real, accountPurposeId, eventId, acctBookId);
                if (sup_param == null || sup_param.length < 1) continue;
                Long mainEntryId = Long.parseLong(sup_param[0].toString());
                Long lineTypeId = Long.parseLong(sup_param[5].toString());
                Long oriCurrencyId = Long.parseLong(sup_param[3].toString());
                ISqlParamBuffer sqlParamBuffer = xlaLineData.getSqlParamBuffer();
                SupplementaryField sf = new SupplementaryField(acctBook.getOrgId(), (Date)((Object[])singleGenXLADataSource.getSupData().get(eventId))[3], acctBook.getAccountTableId());
                Long headId = xlaContext.getXlaHeadIdMap().get(xlaContext.createKey(eventId, accountPurposeId, acctBookId));
                if (null == headId || headId == 0L || xlaContext.getXlaErrorHeadIds().contains(headId)) continue;
                sqlParamBuffer.set(FahXLALineField.FID.getWriteIndex(), (Object)headId);
                sqlParamBuffer.set(FahXLALineField.FSEQ.getWriteIndex(), (Object)ruleLine.getSeq());
                ruleLine.getFieldHandle().forEach(f -> f.getGetValueHandle().preSupData(sf));
                ruleLine.getFieldHandle().forEach(f -> f.execute(data, fieldAliasInfos, sqlParamBuffer));
                sqlParamBuffer.set(FahXLALineField.FAMOUNTREVERSE.getWriteIndex(), (Object)ruleLine.getAmountReverse());
                BigDecimal ori_amount = ObjectConverterFactory.getBigDecimal((Object)sup_param[2]);
                if (ruleLine.getAmountReverse().booleanValue()) {
                    ori_amount = ori_amount.negate();
                }
                if (ruleLine.getDc().equals("DR")) {
                    sqlParamBuffer.set(FahXLALineField.FORI_CREDIT.getWriteIndex(), (Object)new BigDecimal(0));
                    sqlParamBuffer.set(FahXLALineField.FORI_DEBIT.getWriteIndex(), (Object)ori_amount);
                    sqlParamBuffer.set(FahXLALineField.FLOCAL_CREDIT.getWriteIndex(), (Object)new BigDecimal(0));
                    sqlParamBuffer.set(FahXLALineField.FENTRYDC.getWriteIndex(), (Object)"1");
                    if (ruleLine.getAmountReverse().booleanValue()) {
                        BigDecimal local_debit = ObjectConverterFactory.getBigDecimal((Object)sqlParamBuffer.get(FahXLALineField.FLOCAL_DEBIT.getWriteIndex()));
                        sqlParamBuffer.set(FahXLALineField.FLOCAL_DEBIT.getWriteIndex(), (Object)local_debit.negate());
                    }
                } else {
                    sqlParamBuffer.set(FahXLALineField.FORI_CREDIT.getWriteIndex(), (Object)ori_amount);
                    sqlParamBuffer.set(FahXLALineField.FORI_DEBIT.getWriteIndex(), (Object)new BigDecimal(0));
                    sqlParamBuffer.set(FahXLALineField.FLOCAL_DEBIT.getWriteIndex(), (Object)new BigDecimal(0));
                    sqlParamBuffer.set(FahXLALineField.FENTRYDC.getWriteIndex(), (Object)"-1");
                    if (ruleLine.getAmountReverse().booleanValue()) {
                        BigDecimal local_credit = ObjectConverterFactory.getBigDecimal((Object)sqlParamBuffer.get(FahXLALineField.FLOCAL_CREDIT.getWriteIndex()));
                        sqlParamBuffer.set(FahXLALineField.FLOCAL_CREDIT.getWriteIndex(), (Object)local_credit.negate());
                    }
                }
                sqlParamBuffer.set(FahXLALineField.FNEEDMERGE.getWriteIndex(), (Object)ruleLine.getIsNeedMerge());
                sqlParamBuffer.set(FahXLALineField.FSOURCEENTRY.getWriteIndex(), ((Object[])singleGenXLADataSource.getSupData().get(eventId))[5]);
                sqlParamBuffer.set(FahXLALineField.FSRC_EVENTLINEID.getWriteIndex(), sup_param[4]);
                sqlParamBuffer.set(FahXLALineField.FSRC_BILLENTRYID.getWriteIndex(), (Object)mainEntryId);
                sqlParamBuffer.set(FahXLALineField.FLINETYPEID.getWriteIndex(), sup_param[5]);
                sqlParamBuffer.set(FahXLALineField.FMAINCF_AMOUNT.getWriteIndex(), (Object)new BigDecimal(0));
                sqlParamBuffer.set(FahXLALineField.FSUPCF_AMOUNT.getWriteIndex(), (Object)new BigDecimal(0));
                sqlParamBuffer.set(FahXLALineField.FISERROR.getWriteIndex(), (Object)"0");
                sqlParamBuffer.set(FahXLALineField.FERRORMESSAGE.getWriteIndex(), (Object)"");
                singleGenXLADataSource.hasBuildXLALineData(srcId, mainEntryId, accountPurposeId, eventId, acctBookId, lineTypeId);
                Object[] currLine = sqlParamBuffer.getCurrentRow();
                Object currency = currLine[FahXLALineField.FCURRENCYID.getReadIndex()];
                if (!acctBook.getCurrencyId().equals(currency)) {
                    currLine[FahXLALineField.FISERROR.getReadIndex()] = "1";
                    currLine[FahXLALineField.FERRORMESSAGE.getReadIndex()] = GenerateXLAErrorCode.XLA_LINE_LOCALCURRENCY_ERROR.getErrorMessage();
                }
                if (!BuildEvtDataUtil.checkAmountWithCurrency((Object)(localDebit = currLine[FahXLALineField.FLOCAL_DEBIT.getReadIndex()]), (Object)currency)) {
                    Currency currencyInfo = FahCheckXLADataDao.getCurrencyFromThreadCache((Long)((Long)currency));
                    currLine[FahXLALineField.FISERROR.getReadIndex()] = "1";
                    currLine[FahXLALineField.FERRORMESSAGE.getReadIndex()] = String.format(ResManager.loadKDString((String)"\u5e01\u79cd\u7cbe\u5ea6\uff1a%1$s\uff0c\u501f\u65b9\uff08\u672c\u4f4d\u5e01\uff09\u91d1\u989d\uff1a%2$s\uff0c\u4e0d\u6ee1\u8db3\u5e01\u79cd\u7cbe\u5ea6\u3002", (String)"BuildXLADataUtil_01", (String)"fi-ai-mservice", (Object[])new Object[0]), currencyInfo.getAmtprecision(), localDebit);
                }
                if (!BuildEvtDataUtil.checkAmountWithCurrency((Object)(localCredit = currLine[FahXLALineField.FLOCAL_CREDIT.getReadIndex()]), (Object)currency)) {
                    Currency currencyInfo = FahCheckXLADataDao.getCurrencyFromThreadCache((Long)((Long)currency));
                    currLine[FahXLALineField.FISERROR.getReadIndex()] = "1";
                    currLine[FahXLALineField.FERRORMESSAGE.getReadIndex()] = String.format(ResManager.loadKDString((String)"\u5e01\u79cd\u7cbe\u5ea6\uff1a%1$s\uff0c\u8d37\u65b9\uff08\u672c\u4f4d\u5e01\uff09\u91d1\u989d\uff1a%2$s\uff0c\u4e0d\u6ee1\u8db3\u5e01\u79cd\u7cbe\u5ea6\u3002", (String)"BuildXLADataUtil_02", (String)"fi-ai-mservice", (Object[])new Object[0]), currencyInfo.getAmtprecision(), localCredit);
                }
                currLine[FahXLALineField.FCURRENCYID.getReadIndex()] = oriCurrencyId;
                sqlParamBuffer.moveToNextParamRow();
            }
        }
    }

    private static String genMergeKey(List<String> fields, Object[] data, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos) {
        if (fields.isEmpty()) {
            return "";
        }
        fields.stream().collect(Collectors.toList()).sort(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        StringBuilder sbd = new StringBuilder();
        for (String field : fields) {
            Object value = data[((FieldAliasInfo)fieldAliasInfos.get((Object)field)).getReadPos()];
            if (value == null) continue;
            sbd.append(value);
        }
        return sbd.toString();
    }

    public static void doUpdateEventStatus(Set<Long> succIds, Set<Long> failIds, BuildVoucherReportInfoContext reportContext) {
        if (succIds != null && !succIds.isEmpty()) {
            BuildEvtDataUtil.batchUpdateHeadStatus(succIds, (FahEventStageEnum)FahEventStageEnum.CREATING_SL, (FahEventHeadStatusEnum)FahEventHeadStatusEnum.TEMPORARY_STORAGE);
        }
        if (failIds != null && !failIds.isEmpty()) {
            BuildEvtDataUtil.batchUpdateHeadStatus(failIds, (FahEventStageEnum)FahEventStageEnum.CREATING_SL, (FahEventHeadStatusEnum)FahEventHeadStatusEnum.FAIL);
            reportContext.genBatchErrorMessage(failIds, GenerateXLAErrorCode.COMMON_ERROR);
        }
    }

    private static void generateErrorXLAHeadData(SingleGenXLADataSource singleGenXLADataSource, Long srcId, XLADataContext xlaContext, BaseInsertSqlBuilder XLAHeadData, Object[] data, Long eventId, GenerateXLAErrorCode xlaError, XLARuleAcctPurpGroup apGroup, BaseMutableArrayMapStorage<String, FieldAliasInfo> fieldAliasInfos, Boolean isPreview, Long requestId) {
        Long XLAHeadId = BuildXLADataUtil.getXLAHeaderId();
        ISqlParamBuffer sqlParamBuffer = XLAHeadData.getSqlParamBuffer();
        sqlParamBuffer.set(FahXLAHeadField.FID.getIndex(), (Object)XLAHeadId);
        sqlParamBuffer.set(FahXLAHeadField.FISERROR.getIndex(), (Object)"1");
        sqlParamBuffer.set(FahXLAHeadField.FERRORMESSAGE.getIndex(), (Object)xlaError.getErrorMessage());
        sqlParamBuffer.set(FahXLAHeadField.FSRC_BILLID.getIndex(), (Object)srcId);
        sqlParamBuffer.set(FahXLAHeadField.FSRC_BILLNO.getIndex(), data[0]);
        sqlParamBuffer.set(FahXLAHeadField.FSRC_BILLTYPE.getIndex(), (Object)singleGenXLADataSource.getBillEntityName());
        sqlParamBuffer.set(FahXLAHeadField.FSRC_SYSID.getIndex(), (Object)singleGenXLADataSource.getSysId());
        sqlParamBuffer.set(FahXLAHeadField.FSRC_SYSTYPE.getIndex(), (Object)singleGenXLADataSource.getSysType());
        sqlParamBuffer.set(FahXLAHeadField.FSRCEVENTID.getIndex(), (Object)eventId);
        sqlParamBuffer.set(FahXLAHeadField.FACCTRULEID.getIndex(), (Object)singleGenXLADataSource.getAcctRuleId());
        sqlParamBuffer.set(FahXLAHeadField.FACCTRULEVERSIONID.getIndex(), (Object)singleGenXLADataSource.getRuleVersion());
        Date now = TimeServiceHelper.now();
        sqlParamBuffer.set(FahXLAHeadField.FCREATETIME.getIndex(), (Object)now);
        sqlParamBuffer.set(FahXLAHeadField.FREVERSESTATUS.getIndex(), (Object)"0");
        sqlParamBuffer.set(FahXLAHeadField.FRELATEID.getIndex(), (Object)0L);
        sqlParamBuffer.set(FahXLAHeadField.FLOC_DEBITAMT.getIndex(), (Object)new BigDecimal(0));
        sqlParamBuffer.set(FahXLAHeadField.FLOC_CREDITAMT.getIndex(), (Object)new BigDecimal(0));
        apGroup.getFieldHandle().stream().forEach(f -> f.execute(data, fieldAliasInfos, sqlParamBuffer));
        sqlParamBuffer.set(FahXLAHeadField.FACCTPURPOSEID.getIndex(), (Object)0L);
        sqlParamBuffer.set(FahXLAHeadField.FPERIODID.getIndex(), (Object)0L);
        sqlParamBuffer.set(FahXLAHeadField.FREQUESTID.getIndex(), (Object)requestId);
        sqlParamBuffer.set(FahXLAHeadField.FACCTPURPOSEVERSION.getIndex(), (Object)0);
        sqlParamBuffer.set(FahXLAHeadField.FISPREVIEW.getIndex(), (Object)isPreview);
        sqlParamBuffer.set(FahXLAHeadField.FMERGERULEID.getIndex(), (Object)apGroup.getGroupmergeruleId());
        sqlParamBuffer.set(FahXLAHeadField.FNUMBER.getIndex(), (Object)"");
        sqlParamBuffer.set(FahXLAHeadField.FMERGEGRPKEY.getIndex(), (Object)"");
        sqlParamBuffer.set(FahXLAHeadField.FBOOKTYPEID.getIndex(), (Object)0L);
        sqlParamBuffer.set(FahXLAHeadField.FBOOKID.getIndex(), (Object)0L);
        sqlParamBuffer.set(FahXLAHeadField.FORGID.getIndex(), (Object)0L);
        sqlParamBuffer.set(FahXLAHeadField.FLOC_CURRENCYID.getIndex(), (Object)0L);
        xlaContext.addXlaErrorHeadIds(XLAHeadId);
        sqlParamBuffer.moveToNextParamRow();
    }

    public static void generateXLANumber(BaseInsertSqlBuilder xlaHeadData, XLADataContext currContext, Set<Long> succIds) {
        List sqlParams_head = xlaHeadData.getSqlParams();
        HashMap orgIdAndNumberCache = new HashMap(16);
        HashMap acctPurpIdAndNumberCache = new HashMap(16);
        HashMap periodIdAndNumberCache = new HashMap(16);
        HashMap<Long, ThreeTuple> groupNumber = new HashMap<Long, ThreeTuple>(succIds.size());
        for (Object param_head : sqlParams_head) {
            Long l = Long.parseLong(param_head[FahXLAHeadField.FID.getIndex()].toString());
            if (!succIds.contains(l)) continue;
            Long orgId = Long.parseLong(param_head[FahXLAHeadField.FORGID.getIndex()].toString());
            Long acctprupId = Long.parseLong(param_head[FahXLAHeadField.FACCTPURPOSEID.getIndex()].toString());
            Long periodId = Long.parseLong(param_head[FahXLAHeadField.FPERIODID.getIndex()].toString());
            groupNumber.put(l, new ThreeTuple((Object)orgId, (Object)acctprupId, (Object)periodId));
            orgIdAndNumberCache.put(orgId, null);
            acctPurpIdAndNumberCache.put(acctprupId, null);
            periodIdAndNumberCache.put(periodId, null);
        }
        FahGenerateXLADataDao.loadBaseDataNumebr(orgIdAndNumberCache, (String)"bos_org");
        FahGenerateXLADataDao.loadBaseDataNumebr(acctPurpIdAndNumberCache, (String)"fah_evt_accountpurpose");
        FahGenerateXLADataDao.loadBaseDataNumebr(periodIdAndNumberCache, (String)"bd_period");
        HashMap<XLANumberSrcModel, Set> mapCache = new HashMap<XLANumberSrcModel, Set>(16);
        for (Map.Entry entry : groupNumber.entrySet()) {
            Long key = (Long)entry.getKey();
            ThreeTuple value = (ThreeTuple)entry.getValue();
            String orgnum = (String)orgIdAndNumberCache.get(value.item1);
            String acctpurpnum = (String)acctPurpIdAndNumberCache.get(value.item2);
            String periodnum = (String)periodIdAndNumberCache.get(value.item3);
            XLANumberSrcModel model = new XLANumberSrcModel(orgnum, acctpurpnum, periodnum);
            mapCache.computeIfAbsent(model, v -> new HashSet()).add(key);
        }
        HashMap numberCache = new HashMap(16);
        for (Map.Entry entries : mapCache.entrySet()) {
            XLANumberSrcModel key = (XLANumberSrcModel)entries.getKey();
            int size = ((Set)entries.getValue()).size();
            List numbers = FahGenerateXLADataDao.generateXLANumber((XLANumberSrcModel)key, (int)size);
            Set value = (Set)entries.getValue();
            int numSeq = 0;
            for (Long v2 : value) {
                numberCache.put(v2, numbers.get(numSeq++));
            }
        }
        for (Object[] param_head : sqlParams_head) {
            Long headId = Long.parseLong(param_head[FahXLAHeadField.FID.getIndex()].toString());
            if (!succIds.contains(headId)) continue;
            param_head[FahXLAHeadField.FNUMBER.getIndex()] = numberCache.get(headId) == null ? "" : numberCache.get(headId);
        }
    }
}

