/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.voucherprocess.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.util.BigdecimalUtil;
import kd.fi.v2.fah.cache.cacheservice.XLARuleThreadCache;
import kd.fi.v2.fah.dao.BaseFlexFieldDao;
import kd.fi.v2.fah.dao.FahGenerateVoucherDataDao;
import kd.fi.v2.fah.dao.FahGroupMergeDataDao;
import kd.fi.v2.fah.event.mservice.context.GroupMergeDataContext;
import kd.fi.v2.fah.models.context.FahVoucherTrackerContext;
import kd.fi.v2.fah.models.groupmerge.FahVoucherEntryGroupKey;
import kd.fi.v2.fah.models.groupmerge.FahVoucherGroupKey;
import kd.fi.v2.fah.models.groupmerge.GroupAndMergeRuleModel;
import kd.fi.v2.fah.models.voucher.FahGLVoucher;
import kd.fi.v2.fah.models.voucher.FahGLVoucherEntry;
import kd.fi.v2.fah.models.voucher.XLAVoucher;
import kd.fi.v2.fah.models.voucher.XLAVoucherEntry;
import kd.fi.v2.fah.sqlbuilder.CreateSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.task.context.BuildVoucherReportInfoContext;
import kd.fi.v2.fah.util.FahGroupMergeModelUtil;
import kd.fi.v2.fah.voucherprocess.service.IVoucherDataMergeService;
import kd.fi.v2.fah.voucherprocess.service.SingleVoucherMergeTashService;
import kd.fi.v2.fah.voucherprocess.util.VoucherDataProcessUtil;

public class VoucherDataMergeServiceImpl
implements IVoucherDataMergeService {
    private static final Log logger = LogFactory.getLog(VoucherDataMergeServiceImpl.class);
    private final Boolean isBigEntry;
    private final Boolean isReverse;
    private final Long mergeId;
    private final FahVoucherTrackerContext tracker;
    private final List<Long> xlaIds;
    private final BuildVoucherReportInfoContext reportContext;

    public VoucherDataMergeServiceImpl(Boolean isBigEntry, Long mergeId, FahVoucherTrackerContext tracker, List<Long> xlaIds, BuildVoucherReportInfoContext reportContext, boolean isReverse) {
        this.isBigEntry = isBigEntry;
        this.mergeId = mergeId;
        this.tracker = tracker;
        this.xlaIds = xlaIds;
        this.reportContext = reportContext;
        this.isReverse = isReverse;
    }

    @Override
    public Boolean doMerge() {
        logger.info("----FAH----VoucherDataMergeServiceImpl----isBigEntry:" + this.isBigEntry + ";mergeId:" + this.mergeId + ";xlaIds:" + this.xlaIds);
        Boolean result = true;
        if (this.xlaIds.isEmpty()) {
            return result;
        }
        GroupMergeDataContext context = new GroupMergeDataContext(this.xlaIds, this.tracker, this.reportContext);
        try {
            List dataSource = FahGenerateVoucherDataDao.loadXLAData(this.xlaIds, (Boolean)(this.isBigEntry == false ? 1 : 0));
            ArrayList<FahGLVoucher> voucherResult = new ArrayList<FahGLVoucher>();
            ArrayList preSaveEntryId = new ArrayList();
            GroupAndMergeRuleModel groupMergeRuleModel = this.getMergeRuleModel(this.mergeId, this.isReverse);
            HashMap<FahVoucherGroupKey, List> groupVoucherMap = new HashMap<FahVoucherGroupKey, List>(dataSource.size());
            for (XLAVoucher xLAVoucher : dataSource) {
                FahVoucherGroupKey key = new FahVoucherGroupKey(groupMergeRuleModel, xLAVoucher);
                groupVoucherMap.computeIfAbsent(key, v -> new ArrayList()).add(xLAVoucher);
            }
            for (Map.Entry entry : groupVoucherMap.entrySet()) {
                List mergeData = (List)entry.getValue();
                FahGLVoucher fahGLVoucher = new SingleVoucherMergeTashService(mergeData, groupMergeRuleModel, context).doMerge();
                fahGLVoucher.setGrpKeyHashCode(Long.valueOf(Long.parseLong(String.valueOf(((FahVoucherGroupKey)entry.getKey()).hashCode()))));
                if (fahGLVoucher == null) continue;
                voucherResult.add(fahGLVoucher);
            }
            if (this.isBigEntry.booleanValue()) {
                Long lastEntryId = 0L;
                FahGLVoucher fahGLVoucher = (FahGLVoucher)voucherResult.get(0);
                ArrayList<FahGLVoucherEntry> entryRows = new ArrayList<FahGLVoucherEntry>(16);
                int seq = 1;
                do {
                    ArrayList currEntryRows = new ArrayList(50000);
                    lastEntryId = FahGenerateVoucherDataDao.loadXLADataEntry(this.xlaIds, (boolean)true, currEntryRows, (int)50000, (Long)lastEntryId);
                    currEntryRows.stream().forEach(f -> {
                        f.setOrgId(Long.valueOf(fahGLVoucher.getOrgId()));
                        f.setPeriodId(Long.valueOf(fahGLVoucher.getPeriodId()));
                    });
                    HashMap<FahVoucherEntryGroupKey, List> groupEntryMap = new HashMap<FahVoucherEntryGroupKey, List>(16);
                    for (XLAVoucherEntry xLAVoucherEntry : currEntryRows) {
                        FahVoucherEntryGroupKey key = new FahVoucherEntryGroupKey(groupMergeRuleModel, xLAVoucherEntry);
                        groupEntryMap.computeIfAbsent(key, v -> new ArrayList()).add(xLAVoucherEntry);
                    }
                    for (Map.Entry entry : groupEntryMap.entrySet()) {
                        List mergeData = (List)entry.getValue();
                        FahGLVoucherEntry entry2 = VoucherDataProcessUtil.mergeFahVoucherEntry(mergeData, fahGLVoucher, groupMergeRuleModel, context);
                        entry2.setGrpKeyHash(Long.valueOf(Long.parseLong(String.valueOf(((FahVoucherEntryGroupKey)entry.getKey()).hashCode()))));
                        entry2.setSeq(seq++);
                        if (BigdecimalUtil.isEquals((BigDecimal)entry2.getLocalCredit().add(entry2.getLocalDebit()), (BigDecimal)BigDecimal.ZERO) && BigdecimalUtil.isEquals((BigDecimal)entry2.getQty(), (BigDecimal)BigDecimal.ZERO)) {
                            if (groupMergeRuleModel != null && !groupMergeRuleModel.getIsClearZeroAmount().booleanValue()) {
                                entryRows.add(entry2);
                                continue;
                            }
                            --seq;
                            continue;
                        }
                        entryRows.add(entry2);
                    }
                    if (entryRows.size() <= 100000) continue;
                    this.preEntryMergeData(entryRows);
                    preSaveEntryId.addAll(entryRows.stream().map(FahGLVoucherEntry::getEntryId).collect(Collectors.toList()));
                    entryRows.clear();
                } while (lastEntryId != 0L);
                fahGLVoucher.setEntryRows(entryRows);
            }
            Throwable throwable = null;
            try (TXHandle h = TX.requiresNew();){
                try {
                    result = this.mergeDataToInterfaceTable(voucherResult, context);
                }
                catch (Exception e) {
                    this.reportContext.genStackErrorMessage(e);
                    logger.error("----FAH----GenMergeGLVoucherDataServiceImpl--Exception: {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    if (!preSaveEntryId.isEmpty()) {
                        try (TXHandle tx = TX.requiresNew();){
                            try {
                                FahGroupMergeDataDao.deletePreData(preSaveEntryId);
                            }
                            catch (Exception exp) {
                                this.reportContext.genStackErrorMessage(exp);
                                logger.error("----FAH----GenMergeGLVoucherDataServiceImpl--PreDataException: {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)exp));
                            }
                        }
                    }
                    h.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            this.reportContext.genStackErrorMessage(e);
            logger.error("----FAH----GenMergeGLVoucherDataServiceImpl--Exception: {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
        return result;
    }

    private void preEntryMergeData(List<FahGLVoucherEntry> entryRows) {
        BaseInsertSqlBuilder FahVoucherLine = CreateSqlBuilder.createFahVoucherLine();
        entryRows.stream().forEach(f -> f.appendVoucherData(FahVoucherLine));
        BaseFlexFieldDao.doInsert((IInsertSqlBuilder)FahVoucherLine);
    }

    private Boolean mergeDataToInterfaceTable(List<FahGLVoucher> voucherResult, GroupMergeDataContext context) {
        if (voucherResult.isEmpty()) {
            return true;
        }
        BaseInsertSqlBuilder fahVoucherHeadSqlBuilder = CreateSqlBuilder.createFahVoucherHead();
        BaseInsertSqlBuilder fahVoucherLineSqlBuilder = CreateSqlBuilder.createFahVoucherLine();
        for (FahGLVoucher voucher : voucherResult) {
            voucher.appendVoucherData(fahVoucherHeadSqlBuilder, this.tracker.getRequestId());
            voucher.getEntryRows().stream().forEach(f -> f.appendVoucherData(fahVoucherLineSqlBuilder));
        }
        BaseFlexFieldDao.doInsert((IInsertSqlBuilder)fahVoucherHeadSqlBuilder);
        BaseFlexFieldDao.doInsert((IInsertSqlBuilder)fahVoucherLineSqlBuilder);
        return true;
    }

    private GroupAndMergeRuleModel getMergeRuleModel(long mergeRuleId, boolean isReverse) {
        GroupAndMergeRuleModel groupMergeRuleModel = isReverse ? FahGroupMergeModelUtil.getNullGroupAndMergeRuleModel() : (0L == mergeRuleId ? FahGroupMergeModelUtil.getNullGroupAndMergeRuleModel() : XLARuleThreadCache.getGroupAndMergeRuleModelCached((Long)mergeRuleId));
        return groupMergeRuleModel;
    }
}

