/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.voucherprocess.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.v2.fah.cache.cacheservice.XLARuleThreadCache;
import kd.fi.v2.fah.dao.FahGroupMergeDataDao;
import kd.fi.v2.fah.event.mservice.context.GroupMergeDataContext;
import kd.fi.v2.fah.models.context.FahVoucherTrackerContext;
import kd.fi.v2.fah.models.groupmerge.FahVoucherEntryGroupKey;
import kd.fi.v2.fah.models.groupmerge.FahVoucherGroupKey;
import kd.fi.v2.fah.models.groupmerge.GroupAndMergeRuleModel;
import kd.fi.v2.fah.models.groupmerge.RebuildFieldHandle;
import kd.fi.v2.fah.models.voucher.FahGLVoucher;
import kd.fi.v2.fah.models.voucher.FahGLVoucherEntry;
import kd.fi.v2.fah.sqlbuilder.CreateSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.task.context.BuildVoucherReportInfoContext;
import kd.fi.v2.fah.voucherprocess.service.IVoucherDataMergeService;
import kd.fi.v2.fah.voucherprocess.util.VoucherDataProcessUtil;

public class VoucherDataSecondMergeServiceImpl
implements IVoucherDataMergeService {
    private static final Log logger = LogFactory.getLog(VoucherDataSecondMergeServiceImpl.class);
    private FahVoucherTrackerContext tracker;
    private BuildVoucherReportInfoContext reportContext;

    public VoucherDataSecondMergeServiceImpl(FahVoucherTrackerContext tracker, BuildVoucherReportInfoContext reportContext) {
        this.tracker = tracker;
        this.reportContext = reportContext;
    }

    @Override
    public Boolean doMerge() {
        logger.info("----FAH----VoucherDataSecondMergeServiceImpl--MergeIdAndVoucherIdMap:" + this.tracker.getMergeIdAndVoucherIdMap());
        for (Map.Entry data : this.tracker.getMergeIdAndVoucherIdMap().entrySet()) {
            this.mergeOneRuleModelData((Long)data.getKey(), (List)data.getValue());
        }
        return true;
    }

    private void mergeOneRuleModelData(Long mergeId, List<Long> fahVoucherIds) {
        HashMap<Long, Object[]> headKeyValueCache = new HashMap<Long, Object[]>(fahVoucherIds.size());
        try {
            GroupAndMergeRuleModel model = XLARuleThreadCache.getGroupAndMergeRuleModelCached((Long)mergeId);
            if (model == null) {
                return;
            }
            List fahVoucher = FahGroupMergeDataDao.loadFahVoucherHead(fahVoucherIds, headKeyValueCache);
            HashMap<FahVoucherGroupKey, List> groupVoucherData = new HashMap<FahVoucherGroupKey, List>(16);
            for (FahGLVoucher vch : fahVoucher) {
                FahVoucherGroupKey groupKey = new FahVoucherGroupKey(model, vch);
                groupVoucherData.computeIfAbsent(groupKey, v -> new ArrayList()).add(vch);
            }
            ArrayList<Object[]> update_params = new ArrayList<Object[]>(groupVoucherData.size());
            HashMap<Long, List<Long>> needMergeIds = new HashMap<Long, List<Long>>(8);
            for (List currBatch : groupVoucherData.values()) {
                if (currBatch.size() == 1) continue;
                Object[] mergeResult = this.doMerge(currBatch, model);
                needMergeIds.put(Long.parseLong(mergeResult[6].toString()), currBatch.stream().map(FahGLVoucher::getId).collect(Collectors.toList()));
                update_params.add(mergeResult);
            }
            BaseInsertSqlBuilder FahVoucherLine = CreateSqlBuilder.createFahVoucherLine();
            HashSet<Long> delete_Ids = new HashSet<Long>(8);
            ArrayList<Object[]> updateEntryParam = new ArrayList<Object[]>();
            this.doMergeEntry(model, needMergeIds, FahVoucherLine, delete_Ids, updateEntryParam, headKeyValueCache);
            FahGroupMergeDataDao.updateBatchData((BaseInsertSqlBuilder)FahVoucherLine, delete_Ids, update_params, updateEntryParam);
        }
        catch (Exception e) {
            this.reportContext.genStackErrorMessage(e);
            logger.error("----FAH----VoucherDataSecondMergeServiceImpl--Exception: {}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
    }

    private void doMergeEntry(GroupAndMergeRuleModel model, Map<Long, List<Long>> needMergeIds, BaseInsertSqlBuilder fahVoucherLine, Set<Long> delete_Ids, List<Object[]> updateParam, Map<Long, Object[]> headKeyValueCache) {
        if (needMergeIds.isEmpty()) {
            return;
        }
        Map entrySize = FahGroupMergeDataDao.getIntertableEntrySize(needMergeIds);
        List<List<Long>> batchTask = VoucherDataProcessUtil.intelligentBatchTask(entrySize, needMergeIds, 50000, updateParam);
        HashMap srcVchIdAndMergeVchIdMap = new HashMap(16);
        needMergeIds.entrySet().stream().forEach(f -> {
            for (Long v : (List)f.getValue()) {
                srcVchIdAndMergeVchIdMap.put(v, f.getKey());
            }
        });
        GroupMergeDataContext context = new GroupMergeDataContext(srcVchIdAndMergeVchIdMap.keySet().stream().collect(Collectors.toList()), this.tracker, this.reportContext);
        context.setHeadKeyValueCache(headKeyValueCache);
        for (List<Long> currBatch : batchTask) {
            List voucherEntry = FahGroupMergeDataDao.loadFahVoucherEntry(currBatch);
            HashMap groupEntryMap = new HashMap(16);
            voucherEntry.stream().forEach(f -> groupEntryMap.computeIfAbsent(new FahVoucherEntryGroupKey(model, f), v -> new ArrayList()).add(f));
            for (List data : groupEntryMap.values()) {
                Long mergeId = (Long)srcVchIdAndMergeVchIdMap.get(((FahGLVoucherEntry)data.get(0)).getId());
                FahGLVoucherEntry fahVoucherEntry = VoucherDataProcessUtil.mergeFahVoucherEntry(data, model, context, mergeId);
                fahVoucherEntry.appendVoucherData(fahVoucherLine);
                delete_Ids.add(mergeId);
            }
            if (fahVoucherLine.getSqlParamBuffer().size() <= 100000) continue;
            FahGroupMergeDataDao.updateBatchData((BaseInsertSqlBuilder)fahVoucherLine, delete_Ids, new ArrayList(), updateParam);
            delete_Ids.clear();
            updateParam.clear();
            fahVoucherLine.getSqlParamBuffer().clear();
        }
    }

    private Object[] doMerge(List<FahGLVoucher> currBatch, GroupAndMergeRuleModel model) {
        BigDecimal creditSum = new BigDecimal(0);
        BigDecimal debitSum = new BigDecimal(0);
        RebuildFieldHandle handle = new RebuildFieldHandle(model.getParam());
        HashSet newIds = new HashSet();
        for (FahGLVoucher data : currBatch) {
            creditSum = creditSum.add(data.getCreditlocamount());
            debitSum = debitSum.add(data.getDebitlocamount());
            handle.rebuildCreator(data.getCreatorId(), new Object[0]);
            handle.rebuildAttment(data.getAttachment(), new Object[]{data.getSourceBillId(), null});
            handle.rebuildBookedDate(data.getBookedDate(), new Object[]{data.getPeriodId()});
            handle.rebuildBizDate(data.getBizDate(), new Object[]{data.getPeriodId()});
            Set currIds = (Set)this.tracker.getVoucherIdAndXlaIdMap().get(data.getId());
            newIds.addAll(currIds);
            this.tracker.getVoucherIdAndXlaIdMap().remove(data.getId());
        }
        Long vid = currBatch.get(0).getId();
        Long creator = handle.isRebuildCreator() != false ? handle.getCreatorId() : currBatch.get(0).getCreatorId();
        int attachment = handle.isRebuildattment() != false ? handle.getAttachment() : currBatch.get(0).getAttachment();
        Date bookedDate = handle.isRebuildBookedDate() != false ? handle.getBookedDate() : currBatch.get(0).getBookedDate();
        Date bizDate = handle.isRebuildBizDate() != false ? handle.getBizDate() : currBatch.get(0).getBizDate();
        Object[] param = new Object[]{debitSum, creditSum, creator, attachment, bookedDate, bizDate, vid};
        this.tracker.getVoucherIdAndXlaIdMap().put(vid, newIds);
        return param;
    }
}

