/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.cache.cacheservice;

import java.util.HashMap;
import java.util.Map;
import kd.bos.entity.cache.AppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bd.cache.cacheservice.AbstractDataCacheService;
import kd.fi.bd.cache.cacheservice.IDataCacheEntry;
import kd.fi.bd.cache.cacheservice.IDataCacheService;
import kd.fi.bd.cache.cacheservice.IDataDistributeCache;
import kd.fi.v2.fah.cache.cacheservice.BizDimGrpTypeCfgDTOCacheService;
import kd.fi.v2.fah.cache.cacheservice.EventDisSchCfgCacheService;
import kd.fi.v2.fah.cache.cacheservice.EventDispatchCfgCacheService;
import kd.fi.v2.fah.cache.cacheservice.GroupMergeRuleModelCacheService;
import kd.fi.v2.fah.cache.cacheservice.XLARuleModelConfigCacheService;

public class FAHBusinessDataCacheMgr {
    private static final FAHBusinessDataCacheMgr dataCache = new FAHBusinessDataCacheMgr();
    protected IDataCacheEntry distributeCahce = new CacheEntry("fah");
    private static final int Default_Cache_Experied_Time = 120;
    protected int experiedTime = 120;
    protected Map<Class, IDataCacheService> cacheServiceInstanceMap = new HashMap<Class, IDataCacheService>(1);

    public static FAHBusinessDataCacheMgr getInstance() {
        return dataCache;
    }

    private void initCacheMgr() {
        this.registerCacheService(XLARuleModelConfigCacheService.class);
        this.registerCacheService(BizDimGrpTypeCfgDTOCacheService.class);
        this.registerCacheService(GroupMergeRuleModelCacheService.class);
        this.registerCacheService(EventDispatchCfgCacheService.class);
        this.registerCacheService(EventDisSchCfgCacheService.class);
    }

    public FAHBusinessDataCacheMgr() {
        this.initCacheMgr();
    }

    protected void registerCacheService(IDataCacheService cacheServiceInstance) {
        if (cacheServiceInstance == null) {
            return;
        }
        this.cacheServiceInstanceMap.put(cacheServiceInstance.getClass(), cacheServiceInstance);
    }

    protected void registerCacheService(Class<? extends AbstractDataCacheService> cacheServiceInstanceClassType) {
        if (cacheServiceInstanceClassType == null) {
            return;
        }
        try {
            this.cacheServiceInstanceMap.put(cacheServiceInstanceClassType, (IDataCacheService)cacheServiceInstanceClassType.getConstructor(IDataCacheEntry.class, Integer.TYPE).newInstance(this.distributeCahce, this.experiedTime));
        }
        catch (Exception ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.toString()), new Object[0]);
        }
    }

    public <T extends IDataCacheService> T getDataCacheService(Class<T> classType) {
        return (T)this.cacheServiceInstanceMap.get(classType);
    }

    public XLARuleModelConfigCacheService getXLARuleModelConfigCacheService() {
        return this.getDataCacheService(XLARuleModelConfigCacheService.class);
    }

    public EventDispatchCfgCacheService getEventDispatchCfgCacheService() {
        return this.getDataCacheService(EventDispatchCfgCacheService.class);
    }

    public EventDisSchCfgCacheService getEventDisSchCfgCacheService() {
        return this.getDataCacheService(EventDisSchCfgCacheService.class);
    }

    static class CacheEntry
    extends IDataDistributeCache {
        public CacheEntry(String name) {
            super(AppCache.get((String)name));
        }
    }
}

