/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DimValBooleanEnum;
import kd.fi.v2.fah.constant.enums.DimValEnum;
import kd.fi.v2.fah.converters.basedata.IDConvertNumberHelper;
import kd.fi.v2.fah.dim.service.DimGroupInfoQueryService;
import kd.fi.v2.fah.task.FahTaskStatusPushService;

public class BizDimDao {
    private static final String FIDVALUE = "fidvalue";
    private static final String FDIMVALUE = "fDimValue";
    private static final String INSERT_BATCH_SQL = "insert into t_fah_dim_query_batch (fbatchid, fquerydimcnt, fcreatedt) values (?,?,?)";
    private static final String INSERT_QUERY_PARAM_SQL = "insert into %s (fbatchid, fdimtype, fdimvalue) values (?,?,?)";
    private static final String INSERT_TEMP_DATA_SQL = "insert into t_fah_dim_query_data (fbatchid, fDimGrpId) values (?,?)";
    private static final String DEL_TEMP_DATA_SQL = "delete FROM t_fah_dim_query_data where fbatchid=?";
    private static final String QUERY_ID_TABLE = "t_fah_dim_query_id";
    private static final String QUERY_TXT_TABLE = "t_fah_dim_query_txt";
    private static final String QUERY_DT_TABLE = "t_fah_dim_query_dt";
    private static final String QUERY_AMT_TABLE = "t_fah_dim_query_amt";
    public static final String QUERY_BIZ_DIM = "select te.fentryid evtlineid from t_fah_event_header tr join t_fah_event_line te on tr.fid = te.fid ";
    public static final String QUERY_BIZ_DIM_WITH_AE = "select tr.fnumber,tr.forgid,tr.fcreatetime,tr.fid eventid,tr.fsrc_billno,tr.fsrc_billid,tr.fevtclassid,tr.fevttypeid,te.fentryid evtlineid,te.flinetypeid,te.fsrcbillentryid,te.fdimgrpvalid,th.fbooktypeid,th.forgid org,th.fperiodid,tl.faccountid,tl.fassgrpid from t_fah_event_header tr join t_fah_event_line te on tr.fid = te.fid left join t_fah_ae_headers th on tr.fid = th.fsrceventid left join t_fah_ae_lines tl on th.fid = tl.fid ";
    private static final ThreadLocal<SimpleDateFormat> YYYY_MM_DD = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    private static final ThreadLocal<SimpleDateFormat> YYYY_MM = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM"));

    public static void queryBizDimDateSet(IDataModel model, long batchId) {
        DynamicObjectCollection headEventLineTypeCol;
        Object[] headEventLineTypeIds;
        DynamicObjectCollection headEventTypeCol;
        Object[] headEventTypeIds;
        DynamicObjectCollection headEventClassCol;
        Object[] headEventClassIds;
        DynamicObject currency;
        Date endDate;
        Date startDate;
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append(QUERY_BIZ_DIM, new Object[0]);
        boolean addBizDimFilter = false;
        DynamicObjectCollection asstactTypeEntry = model.getEntryEntity("asstacttypeentry");
        if (!asstactTypeEntry.isEmpty()) {
            int dimCount = 0;
            HashMap<String, List<Object[]>> asstsMap = new HashMap<String, List<Object[]>>(asstactTypeEntry.size());
            block24: for (DynamicObject asstact : asstactTypeEntry) {
                String dataType = asstact.getString("asstacttype.datatype");
                long asstactType = asstact.getLong("asstacttype.id");
                String valuejson = asstact.getString("valuejson");
                if (null == dataType || !StringUtils.isNotEmpty((CharSequence)valuejson)) continue;
                ++dimCount;
                List valueList = (List)SerializationUtils.deSerializeFromBase64((String)valuejson);
                if (valueList.isEmpty()) continue;
                switch (dataType) {
                    case "1": 
                    case "2": {
                        for (Object val : valueList) {
                            asstsMap.computeIfAbsent(QUERY_ID_TABLE, k -> new LinkedList()).add(new Object[]{batchId, asstactType, val});
                        }
                        continue block24;
                    }
                    case "3": {
                        for (Object val : valueList) {
                            asstsMap.computeIfAbsent(QUERY_TXT_TABLE, k -> new LinkedList()).add(new Object[]{batchId, asstactType, val});
                        }
                        continue block24;
                    }
                    case "4": {
                        --dimCount;
                        break;
                    }
                    case "5": {
                        for (Object val : valueList) {
                            asstsMap.computeIfAbsent(QUERY_AMT_TABLE, k -> new LinkedList()).add(new Object[]{batchId, asstactType, val});
                        }
                        continue block24;
                    }
                    case "6": {
                        for (Object val : valueList) {
                            asstsMap.computeIfAbsent(QUERY_DT_TABLE, k -> new LinkedList()).add(new Object[]{batchId, asstactType, val});
                        }
                        continue block24;
                    }
                }
            }
            boolean bl = addBizDimFilter = dimCount > 0;
            if (addBizDimFilter) {
                boolean existsData = BizDimDao.invokeQueryService(batchId, dimCount, asstsMap);
                if (existsData) {
                    sqlBuilder.append(" join t_fah_dim_query_data ta on te.fdimgrpvalid = ta.fdimgrpid where ", new Object[0]).append("ta.fbatchid=?", new Object[]{batchId}).append(" and ", new Object[0]);
                } else {
                    BizDimDao.updateTaskStatus(batchId, null);
                    return;
                }
            }
        }
        if (!addBizDimFilter) {
            sqlBuilder.append(" where", new Object[0]);
        }
        sqlBuilder.append(" te.fdimgrpvalid !=0", new Object[0]);
        sqlBuilder.append(" and tr.fstatus = ?", new Object[]{"4"});
        DynamicObjectCollection headOrg = (DynamicObjectCollection)model.getValue("headorg");
        Object[] orgIds = BizDimDao.getMulBaseDataIds(headOrg);
        if (orgIds.length > 0) {
            sqlBuilder.appendIn(" and tr.forgid", orgIds);
        }
        if (null != (startDate = (Date)model.getValue("daterange_startdate"))) {
            sqlBuilder.append(" and tr.fcreatetime >= ?", new Object[]{startDate});
        }
        if (null != (endDate = (Date)model.getValue("daterange_enddate"))) {
            sqlBuilder.append(" and tr.fcreatetime <= ?", new Object[]{endDate});
        }
        if (null != (currency = (DynamicObject)model.getValue("currency"))) {
            sqlBuilder.append(" and te.fcurrencyid=?", new Object[]{currency.getLong("id")});
        }
        if ((headEventClassIds = BizDimDao.getMulBaseDataIds(headEventClassCol = (DynamicObjectCollection)model.getValue("headeventclass"))).length > 0) {
            sqlBuilder.appendIn(" and tr.fevtclassid", headEventClassIds);
        }
        if ((headEventTypeIds = BizDimDao.getMulBaseDataIds(headEventTypeCol = (DynamicObjectCollection)model.getValue("headeventtype"))).length > 0) {
            sqlBuilder.appendIn(" and tr.fevttypeid", headEventTypeIds);
        }
        if ((headEventLineTypeIds = BizDimDao.getMulBaseDataIds(headEventLineTypeCol = (DynamicObjectCollection)model.getValue("headeventlinetype"))).length > 0) {
            sqlBuilder.appendIn(" and te.flinetypeid", headEventLineTypeIds);
        }
        try (DataSet dataSet = DB.queryDataSet((String)BizDimDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            ArrayList<Long> ids = new ArrayList<Long>(100);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ids.add(row.getLong("evtlineid"));
            }
            BizDimDao.updateTaskStatus(batchId, ids);
        }
        if (addBizDimFilter) {
            BizDimDao.deleteDimQueryData(batchId);
        }
    }

    private static void updateTaskStatus(long batchId, List<Long> ids) {
        FahTaskStatusPushService fahTaskStatusPushService = new FahTaskStatusPushService("FahBizDataQuery", batchId);
        HashMap<String, Object> msgMap = new HashMap<String, Object>(2);
        msgMap.put("ids", ids);
        msgMap.put("msg", ThreadCache.get((Object)"FahBizDataQuery_msg"));
        fahTaskStatusPushService.updateStatus(99, SerializationUtils.serializeToBase64(msgMap));
    }

    private static boolean invokeQueryService(long batchId, int dimCount, Map<String, List<Object[]>> asstsMap) {
        boolean existsData = false;
        DB.execute((DBRoute)FAHCommonConstant.AI, (String)INSERT_BATCH_SQL, (Object[])new Object[]{batchId, dimCount, new Date()});
        for (Map.Entry<String, List<Object[]>> entry : asstsMap.entrySet()) {
            for (Object[] param : entry.getValue()) {
                DB.execute((DBRoute)FAHCommonConstant.AI, (String)String.format(INSERT_QUERY_PARAM_SQL, entry.getKey()), (Object[])param);
            }
        }
        try {
            DimGroupInfoQueryService queryService = new DimGroupInfoQueryService();
            Set<Long> dimGrpIds = queryService.queryDimGroupIdSet(batchId);
            if (!dimGrpIds.isEmpty()) {
                ArrayList<Object[]> dataParams = new ArrayList<Object[]>(dimGrpIds.size());
                for (Long dimGrpId : dimGrpIds) {
                    dataParams.add(new Object[]{batchId, dimGrpId});
                }
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)INSERT_TEMP_DATA_SQL, dataParams);
                existsData = true;
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6\u67e5\u8be2\u5931\u8d25:%s\u3002", (String)"BizDimDao_0", (String)"fi-ai-business", (Object[])new Object[0]), e.getMessage()));
        }
        return existsData;
    }

    private static Object[] getMulBaseDataIds(DynamicObjectCollection baseDataCollection) {
        return baseDataCollection.stream().map(v -> v.getLong("fbasedataid.id")).toArray();
    }

    public static Map<Long, Map<String, String>> queryDimData(List<Long> dimGrpValIds) {
        if (dimGrpValIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Map<String, String>> resultInfo = new HashMap<Long, Map<String, String>>(dimGrpValIds.size());
        HashSet<Long> assistIds = new HashSet<Long>();
        Map<Long, List<Object[]>> dimMap = BizDimDao.queryDimInfo(dimGrpValIds, assistIds);
        Optional<List> optional = dimMap.values().stream().max(Comparator.comparingInt(List::size));
        if (optional.isPresent()) {
            int size = optional.get().size();
            HashMap<String, Set> basePropIdMap = new HashMap<String, Set>();
            HashMap<Long, Set> assistPropIdMap = new HashMap<Long, Set>();
            HashSet<Long> textSet = new HashSet<Long>();
            HashSet<Long> amountSet = new HashSet<Long>();
            HashSet<Long> dateSet = new HashSet<Long>();
            try (DataSet valDataSet = BizDimDao.queryDimGrpValues(dimGrpValIds, size);
                 DataSet valDataSetCopy = valDataSet.copy();){
                for (Row row : valDataSetCopy) {
                    Long dimGrpTypeId = row.getLong("fdimgrptypeid");
                    List<Object[]> dimInfos = dimMap.get(dimGrpTypeId);
                    if (null == dimInfos) continue;
                    block49: for (int i = 0; i < dimInfos.size(); ++i) {
                        String dataType;
                        Long valId = row.getLong(FIDVALUE + (i + 1));
                        Object[] assistInfo = dimInfos.get(i);
                        switch (dataType = (String)assistInfo[0]) {
                            case "1": {
                                basePropIdMap.computeIfAbsent((String)assistInfo[1], v -> new HashSet()).add(valId);
                                continue block49;
                            }
                            case "2": {
                                assistPropIdMap.computeIfAbsent((Long)assistInfo[1], v -> new HashSet()).add(valId);
                                continue block49;
                            }
                            case "3": {
                                textSet.add(valId);
                                continue block49;
                            }
                            case "5": {
                                amountSet.add(valId);
                                continue block49;
                            }
                            case "6": {
                                dateSet.add(valId);
                                continue block49;
                            }
                        }
                    }
                }
                Map<Long, Object> txtData = BizDimDao.queryDimVal(textSet, DimValEnum.DIM_VAL_TXT);
                Map<Long, Object> amountData = BizDimDao.queryDimVal(amountSet, DimValEnum.DIM_VAL_AMT);
                Map<Long, Object> dateData = BizDimDao.queryDimVal(dateSet, DimValEnum.DIM_VAL_DT);
                HashMap basePropMap = new HashMap(basePropIdMap.size());
                HashMap assistPropMap = new HashMap(assistPropIdMap.size());
                for (Map.Entry entry : basePropIdMap.entrySet()) {
                    Map baseProp = IDConvertNumberHelper.queryBaseDataNumberAndName((String)((String)entry.getKey()), (Set)((Set)entry.getValue()), null);
                    basePropMap.put(entry.getKey(), baseProp);
                }
                for (Map.Entry entry : assistPropIdMap.entrySet()) {
                    Map assistProp = IDConvertNumberHelper.queryAssistantInfo((Long)((Long)entry.getKey()), (Set)((Set)entry.getValue()), null);
                    assistPropMap.put(entry.getKey(), assistProp);
                }
                for (Row row : valDataSet) {
                    Long dimGrpTypeId = row.getLong("fdimgrptypeid");
                    List<Object[]> dimInfos = dimMap.get(dimGrpTypeId);
                    if (null == dimInfos) continue;
                    for (int i = 0; i < dimInfos.size(); ++i) {
                        String dataType;
                        Object dimValDesc = null;
                        Long valId = row.getLong(FIDVALUE + (i + 1));
                        Object[] assistInfo = dimInfos.get(i);
                        switch (dataType = (String)assistInfo[0]) {
                            case "1": {
                                Map baseProp = (Map)basePropMap.get((String)assistInfo[1]);
                                if (null == baseProp) break;
                                dimValDesc = baseProp.get(valId);
                                break;
                            }
                            case "2": {
                                Map assistProp = (Map)assistPropMap.get((Long)assistInfo[1]);
                                if (null == assistProp) break;
                                dimValDesc = assistProp.get(valId);
                                break;
                            }
                            case "3": {
                                dimValDesc = txtData.get(valId);
                                break;
                            }
                            case "4": {
                                dimValDesc = DimValBooleanEnum.getDescByCode((Long)valId);
                                break;
                            }
                            case "5": {
                                BigDecimal val = (BigDecimal)amountData.get(valId);
                                if (null == val) break;
                                dimValDesc = val.setScale((int)((Integer)assistInfo[1]), RoundingMode.HALF_UP);
                                break;
                            }
                            case "6": {
                                Date dVal = (Date)dateData.get(valId);
                                if (null == dVal) break;
                                if ("2".equals(assistInfo[1])) {
                                    dimValDesc = YYYY_MM.get().format(dVal);
                                    break;
                                }
                                dimValDesc = YYYY_MM_DD.get().format(dVal);
                                break;
                            }
                        }
                        if (null == dimValDesc) continue;
                        resultInfo.computeIfAbsent(row.getLong("fid"), t -> new HashMap()).put((String)assistInfo[2], String.valueOf(dimValDesc));
                    }
                }
            }
        }
        return resultInfo;
    }

    private static Map<Long, List<Object[]>> queryDimInfo(List<Long> dimGrpValIds, Set<Long> assistIds) {
        HashMap<Long, List<Object[]>> dimMap = new HashMap<Long, List<Object[]>>();
        try (DataSet dimDataSet = BizDimDao.queryDimInfoDataSet(dimGrpValIds);){
            for (Row row : dimDataSet) {
                String dataType = row.getString("fdatatype");
                Object dataInfo = null;
                switch (dataType) {
                    case "1": {
                        dataInfo = row.getString("fvaluesource");
                        break;
                    }
                    case "2": {
                        dataInfo = row.getLong("fassistanttype");
                        break;
                    }
                    case "5": {
                        dataInfo = row.getInteger("fpercision");
                        break;
                    }
                    case "6": {
                        dataInfo = row.getString("fdateformat");
                        break;
                    }
                }
                Long assistid = row.getLong("assistid");
                dimMap.computeIfAbsent(row.getLong("fid"), r -> new ArrayList()).add(new Object[]{dataType, dataInfo, row.getString("fnumber").toLowerCase()});
                assistIds.add(assistid);
            }
        }
        return dimMap;
    }

    private static DataSet queryDimGrpValues(List<Long> dimGrpValIds, int size) {
        StringBuilder columBuilder = new StringBuilder();
        for (int i = 1; i <= size; ++i) {
            columBuilder.append(FIDVALUE).append(i).append(",");
        }
        columBuilder.deleteCharAt(columBuilder.length() - 1);
        SqlBuilder sqlBuilder = new SqlBuilder().append("select fid,fdimgrptypeid,", new Object[0]).append(columBuilder.toString(), new Object[0]).append(" from t_fah_dimgrp_values where ", new Object[0]).appendIn("fid", dimGrpValIds.toArray());
        return DB.queryDataSet((String)BizDimDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
    }

    public static Map<Long, String> queryAssTact(Set<Long> assistIds) {
        return QueryServiceHelper.query((String)"ai_asstacttype", (String)"id,name", (QFilter[])new QFilter("id", "in", assistIds).toArray()).stream().collect(Collectors.toMap(t -> t.getLong("id"), t -> t.getString("name"), (key1, key2) -> key2));
    }

    private static DataSet queryDimInfoDataSet(List<Long> dimGrpValIds) {
        SqlBuilder sqlBuilder = new SqlBuilder().append("select te.fid fid,en.fseq fseq,asst.fnumber fnumber,asst.fdatatype fdatatype,asst.fvaluesource fvaluesource,asst.fassistanttype fassistanttype,asst.fpercision fpercision,asst.fdateformat fdateformat,asst.fid assistid from t_fah_dimgrp_type te join t_fah_dimgrp_type_en en on te.fid=en.fid join t_ai_asstacttype asst on en.fbizdimtypeid = asst.fid where ", new Object[0]).append("te.fid in (select distinct fdimgrptypeid from t_fah_dimgrp_values where ", new Object[0]).appendIn("fid", dimGrpValIds.toArray()).append(") ", new Object[0]).append("and en.fcustgrpid=0 order by en.fid,en.fseq", new Object[0]);
        return DB.queryDataSet((String)BizDimDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
    }

    /*
     * Unable to fully structure code
     */
    private static Map<Long, Object> queryDimVal(Set<Long> dimValIds, DimValEnum dimValEnum) {
        if (dimValIds.isEmpty() || null == dimValEnum) {
            return Collections.emptyMap();
        }
        sql = new SqlBuilder();
        sql.append("select fid,fDimValue from ", new Object[0]).append(dimValEnum.getTableName(), new Object[0]);
        sql.appendIn(" where fid", dimValIds.toArray());
        result = new HashMap<Long, Object>();
        switch (1.$SwitchMap$kd$fi$v2$fah$constant$enums$DimValEnum[dimValEnum.ordinal()]) {
            case 1: {
                dataSet = DB.queryDataSet((String)BizDimDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
                var5_7 = null;
                for (Row row : dataSet) {
                    result.put(row.getLong("fid"), row.getString("fDimValue"));
                }
                if (dataSet == null) break;
                if (var5_7 == null) ** GOTO lbl26
                try {
                    dataSet.close();
                }
                catch (Throwable var6_11) {
                    var5_7.addSuppressed(var6_11);
                }
                break;
lbl26:
                // 1 sources

                dataSet.close();
                break;
                catch (Throwable var6_12) {
                    try {
                        var5_7 = var6_12;
                        throw var6_12;
                    }
                    catch (Throwable var8_22) {
                        if (dataSet != null) {
                            if (var5_7 != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable var9_23) {
                                    var5_7.addSuppressed(var9_23);
                                }
                            } else {
                                dataSet.close();
                            }
                        }
                        throw var8_22;
                    }
                }
            }
            case 2: {
                dataSet = DB.queryDataSet((String)BizDimDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
                var5_8 = null;
                for (Row row : dataSet) {
                    result.put(row.getLong("fid"), row.getDate("fDimValue"));
                }
                if (dataSet == null) break;
                if (var5_8 == null) ** GOTO lbl59
                try {
                    dataSet.close();
                }
                catch (Throwable var6_14) {
                    var5_8.addSuppressed(var6_14);
                }
                break;
lbl59:
                // 1 sources

                dataSet.close();
                break;
                catch (Throwable var6_15) {
                    try {
                        var5_8 = var6_15;
                        throw var6_15;
                    }
                    catch (Throwable var10_24) {
                        if (dataSet != null) {
                            if (var5_8 != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable var11_25) {
                                    var5_8.addSuppressed(var11_25);
                                }
                            } else {
                                dataSet.close();
                            }
                        }
                        throw var10_24;
                    }
                }
            }
            case 3: {
                dataSet = DB.queryDataSet((String)BizDimDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
                var5_9 = null;
                for (Row row : dataSet) {
                    result.put(row.getLong("fid"), row.getBigDecimal("fDimValue"));
                }
                if (dataSet == null) break;
                if (var5_9 == null) ** GOTO lbl92
                try {
                    dataSet.close();
                }
                catch (Throwable var6_17) {
                    var5_9.addSuppressed(var6_17);
                }
                break;
lbl92:
                // 1 sources

                dataSet.close();
                break;
                catch (Throwable var6_18) {
                    try {
                        var5_9 = var6_18;
                        throw var6_18;
                    }
                    catch (Throwable var12_26) {
                        if (dataSet != null) {
                            if (var5_9 != null) {
                                try {
                                    dataSet.close();
                                }
                                catch (Throwable var13_27) {
                                    var5_9.addSuppressed(var13_27);
                                }
                            } else {
                                dataSet.close();
                            }
                        }
                        throw var12_26;
                    }
                }
            }
        }
        return result;
    }

    public static void insertQueryHistory(Long transId, Date startdata, Date enddata, String queryplaninfo) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("INSERT INTO t_fah_temp_trans (ftransid, ftranstype, fcreatedt, fcompleteddt,fqueryplaninfo)", new Object[0]);
        sqlBuilder.append("VALUES (?", new Object[]{transId}).append(", 99, ?", new Object[]{startdata}).append(", ?", new Object[]{enddata}).append(",?", new Object[]{queryplaninfo == null ? "" : queryplaninfo}).append(")", new Object[0]);
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
    }

    public static DataSet getQueryHistory() {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT ftransid,fcreatedt,fcompleteddt,fQueryPlanInfo FROM t_fah_temp_trans", new Object[0]);
        return DB.queryDataSet((String)BizDimDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
    }

    public static void deleteHistory(Set<Long> ids) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete FROM t_fah_temp_trans", new Object[0]).appendIn("where ftransid", ids.toArray());
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);
        BizDimDao.deleteDimQueryParamData(ids);
    }

    public static void deleteDimQueryParamData(Set<Long> ids) {
        LinkedList<SqlBuilder> sqlList = new LinkedList<SqlBuilder>();
        sqlList.add(new SqlBuilder().append("delete FROM t_fah_dim_query_batch", new Object[0]).appendIn("where fbatchid", ids.toArray()));
        sqlList.add(new SqlBuilder().append("delete FROM ", new Object[0]).append(QUERY_ID_TABLE, new Object[0]).appendIn("where fbatchid", ids.toArray()));
        sqlList.add(new SqlBuilder().append("delete FROM ", new Object[0]).append(QUERY_TXT_TABLE, new Object[0]).appendIn("where fbatchid", ids.toArray()));
        sqlList.add(new SqlBuilder().append("delete FROM ", new Object[0]).append(QUERY_DT_TABLE, new Object[0]).appendIn("where fbatchid", ids.toArray()));
        sqlList.add(new SqlBuilder().append("delete FROM ", new Object[0]).append(QUERY_AMT_TABLE, new Object[0]).appendIn("where fbatchid", ids.toArray()));
        for (SqlBuilder sql : sqlList) {
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
        }
    }

    public static void deleteDimQueryData(Long batchId) {
        DB.execute((DBRoute)FAHCommonConstant.AI, (String)DEL_TEMP_DATA_SQL, (Object[])new Object[]{batchId});
    }
}

