/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.v2.fah.constant.FAHCommonConstant;

public class FahAiTrackerDao {
    private static final Log logger = LogFactory.getLog(FahAiTrackerDao.class);

    public static Map<Long, Set<Long>> getVoucherIdAndBillIdsByTracker(String billType, Collection<Long> billIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select FSOURCEBILLID fSrcBillId, FVOUCHERID fGlVchId from t_ai_daptracker where", new Object[0]);
        sql.appendIn(" FSOURCEBILLID ", billIds.toArray());
        sql.append(" and fbilltype =?", new Object[]{billType});
        sql.append(" union all", new Object[0]);
        sql.append(" select FSRC_BILLID fSrcBillId, FGL_HEADER_ID fGlVchId from t_fah_evt_tracker where", new Object[0]);
        sql.appendIn(" fsrc_billid ", billIds.toArray());
        sql.append(" and fsrc_billtype =?", new Object[]{billType});
        HashMap<Long, Set<Long>> fahAndAiTrackerMap = new HashMap<Long, Set<Long>>();
        try (DataSet dataSet = DB.queryDataSet((String)"DapVoucherUtil.getVoucherIdAndBillIdsByTracker", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                fahAndAiTrackerMap.computeIfAbsent(row.getLong("fSrcBillId"), k -> new HashSet()).add(row.getLong("fGlVchId"));
            }
        }
        return fahAndAiTrackerMap;
    }

    public static Map<String, Set<Long>> getBillTypeAndIdsByVoucherId(Long voucherId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fbilltype fbilltype, fsourcebillid fSrcBillId, FVOUCHERID fGlVchId from t_ai_daptracker where", new Object[0]);
        sql.append(" FVOUCHERID =?", new Object[]{voucherId});
        sql.append(" union all", new Object[0]);
        sql.append(" select fsrc_billtype fbilltype, FSRC_BILLID fSrcBillId, FGL_HEADER_ID fGlVchId from t_fah_evt_tracker where", new Object[0]);
        sql.append(" FGL_HEADER_ID =?", new Object[]{voucherId});
        HashMap<String, Set<Long>> billTypeAndBillIdMap = new HashMap<String, Set<Long>>();
        try (DataSet dataSet = DB.queryDataSet((String)"DapVoucherUtil.getVoucherIdByFahAndAiTracker", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billTypeAndBillIdMap.computeIfAbsent(row.getString("fbilltype"), k -> new HashSet()).add(row.getLong("fSrcBillId"));
            }
        }
        return billTypeAndBillIdMap;
    }

    public static Map<String, Set<Long>> getBillTypeAndIdsByVoucherIdSet(Collection<Long> vchIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fbilltype fbilltype, fsourcebillid fSrcBillId from t_ai_daptracker where", new Object[0]);
        sql.appendIn(" FVOUCHERID ", vchIds.toArray());
        sql.append(" union all", new Object[0]);
        sql.append(" select fsrc_billtype fbilltype, FSRC_BILLID fSrcBillId from t_fah_evt_tracker where", new Object[0]);
        sql.appendIn(" FGL_HEADER_ID ", vchIds.toArray());
        HashMap<String, Set<Long>> billTypeAndBillIdMap = new HashMap<String, Set<Long>>();
        try (DataSet dataSet = DB.queryDataSet((String)"DapVoucherUtil.getBillTypeAndIdsByVoucherIdSet", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billTypeAndBillIdMap.computeIfAbsent(row.getString("fbilltype"), k -> new HashSet()).add(row.getLong("fSrcBillId"));
            }
        }
        return billTypeAndBillIdMap;
    }

    public static Map<String, List<Long[]>> getBillToVchRelationDtoByVchIDSet(String billType, Collection<Long> vchIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fbilltype fbilltype, fsourcebillid fSrcBillId, FVOUCHERID fGlVchId from t_ai_daptracker where", new Object[0]);
        sql.appendIn(" FVOUCHERID ", vchIds.toArray());
        if (StringUtils.isNotEmpty((CharSequence)billType)) {
            sql.append(" and fbilltype =?", new Object[]{billType});
        }
        sql.append(" union all", new Object[0]);
        sql.append(" select fsrc_billtype fbilltype, FSRC_BILLID fSrcBillId, FGL_HEADER_ID fGlVchId from t_fah_evt_tracker where", new Object[0]);
        sql.appendIn(" FGL_HEADER_ID ", vchIds.toArray());
        if (StringUtils.isNotEmpty((CharSequence)billType)) {
            sql.append(" and fsrc_billtype =?", new Object[]{billType});
        }
        HashMap<String, List<Long[]>> billTInfoMap = new HashMap<String, List<Long[]>>();
        try (DataSet dataSet = DB.queryDataSet((String)"DapVoucherUtil.getBillToVchRelationDtoByVchIDSet", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billTInfoMap.computeIfAbsent(row.getString("fbilltype"), k -> new ArrayList()).add(new Long[]{row.getLong("fSrcBillId"), row.getLong("fGlVchId")});
            }
        }
        return billTInfoMap;
    }

    public static Map<String, List<Long[]>> getBillToVchReDtoByBillTypeAndIds(String billType, Collection<Long> billIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fbilltype fbilltype, fsourcebillid fSrcBillId, FVOUCHERID fGlVchId from t_ai_daptracker where", new Object[0]);
        sql.appendIn(" FSOURCEBILLID ", billIds.toArray());
        if (StringUtils.isNotEmpty((CharSequence)billType)) {
            sql.append(" and fbilltype =?", new Object[]{billType});
        }
        sql.append(" union all", new Object[0]);
        sql.append(" select fsrc_billtype fbilltype, FSRC_BILLID fSrcBillId, FGL_HEADER_ID fGlVchId from t_fah_evt_tracker where", new Object[0]);
        sql.appendIn(" fsrc_billid ", billIds.toArray());
        if (StringUtils.isNotEmpty((CharSequence)billType)) {
            sql.append(" and fsrc_billtype =?", new Object[]{billType});
        }
        HashMap<String, List<Long[]>> billTInfoMap = new HashMap<String, List<Long[]>>();
        try (DataSet dataSet = DB.queryDataSet((String)"DapVoucherUtil.getBillToVchReDtoByBillTypeAndIds", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billTInfoMap.computeIfAbsent(row.getString("fbilltype"), k -> new ArrayList()).add(new Long[]{row.getLong("fSrcBillId"), row.getLong("fGlVchId")});
            }
        }
        return billTInfoMap;
    }

    public static void deleteDapTrackerAndBizVch(Long orgId, Collection<Long> voucherIds) {
        String bizSubSql = "delete from t_ai_bizvouchersubentry where fentryid in (select fentryid from t_ai_bizvoucherentry where fid in (select fid from t_ai_bizvoucher where %1$s ))";
        String bizEntrySql = "delete from t_ai_bizvoucherentry where fid in (select fid from t_ai_bizvoucher where %1$s )";
        String bizBizSql = "delete from t_ai_bizvoucher where %1$s ";
        String traEntrySql = "delete from t_ai_daptrackerentry where fid in (select fid from t_ai_daptracker where %1$s )";
        String traSql = "delete from t_ai_daptracker where %1$s ";
        ArrayList<Object[]> params = new ArrayList<Object[]>(voucherIds.size());
        String columnName = "fglvoucherid = ?";
        String colTraName = "fvoucherid = ?";
        if (null == orgId) {
            for (Long voucherId : voucherIds) {
                params.add(new Object[]{voucherId});
            }
        } else {
            columnName = "forgid = ? and fglvoucherid = ?";
            colTraName = "forgid = ? and fvoucherid = ?";
            for (Long voucherId : voucherIds) {
                params.add(new Object[]{orgId, voucherId});
            }
        }
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)String.format(bizSubSql, columnName), params);
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)String.format(bizEntrySql, columnName), params);
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)String.format(bizBizSql, columnName), params);
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)String.format(traEntrySql, colTraName), params);
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)String.format(traSql, colTraName), params);
        logger.info("FahAiTrackerDao.deleteDapTrackerAndBizVch end......");
    }

    public static void updateBizVchAndTrackerByVchId(List<Object[]> dapParams) {
        String bizVoucherSql = "update t_ai_bizvoucher set fperiodid = ?,fbookeddate = ?,fbizdate = ? where fglvoucherid = ?";
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)bizVoucherSql, dapParams);
        ArrayList<Object[]> trackerList = new ArrayList<Object[]>(dapParams.size());
        for (Object[] param : dapParams) {
            trackerList.add(new Object[]{param[0], param[3]});
        }
        String dapSql = "update t_ai_daptracker set fperiodid = ? where fvoucherid = ?";
        DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)dapSql, trackerList);
        logger.info("FahAiTrackerDao.updateBizVchAndTrackerByVchId end......");
    }
}

