/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.models.voucher.XLAVoucher;
import kd.fi.v2.fah.models.voucher.XLAVoucherEntry;

public class FahGenerateVoucherDataDao {
    public static void getXLAHeaderId(Set<Long> eventIds, List<Object[]> xlaHeadId, List<Object[]> xlaUpdateHead, List<Object[]> xlaUpdateLine, Map<Long, Long> headIdAndEventIdMap, Map<Long, String> xlaHeadIdAndGLVoucherNo) {
        if (eventIds.isEmpty()) {
            return;
        }
        String id_str = QFilterBuilder.buildSQLParamHolder((int)eventIds.size());
        HashMap<String, String> billNameAndsys = new HashMap<String, String>(8);
        String sql = "select fid,forgid,fperiodid,fsrceventid,fsrc_billtype from t_fah_ae_headers hdr where hdr.fsrceventid in " + id_str + " and not exists( select 1 from t_fah_evt_tracker tracker where tracker.fxla_header_id = hdr.fid )";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateVoucherDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])eventIds.toArray());){
            for (Row row : queryDataSet) {
                Long id = row.getLong(0);
                Long orgId = row.getLong(1);
                Long periodId = row.getLong(2);
                Long eventId = row.getLong(3);
                String bizappByNum = FahGenerateVoucherDataDao.getBizappByNum(row.getString(4), billNameAndsys);
                xlaHeadId.add(new Object[]{id});
                xlaUpdateHead.add(new Object[]{xlaHeadIdAndGLVoucherNo.get(id), "A", "4", bizappByNum, "", "1", "1", id});
                xlaUpdateLine.add(new Object[]{"1", orgId, periodId, id});
                headIdAndEventIdMap.put(id, eventId);
            }
        }
    }

    public static String getBizappByNum(String billName, Map<String, String> billNameAndsys) {
        String result = null;
        if (StringUtils.isBlank((CharSequence)billName)) {
            return result;
        }
        if (billNameAndsys.containsKey(billName)) {
            return billNameAndsys.get(billName);
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billName);
        String appId = dataEntityType.getAppId();
        QFilter bizappidQfilter = new QFilter("number", "=", (Object)appId);
        DynamicObjectCollection bizappObj = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{bizappidQfilter});
        result = bizappObj == null || bizappObj.size() == 0 ? null : ((DynamicObject)bizappObj.get(0)).getString("id");
        billNameAndsys.put(billName, result);
        return result;
    }

    public static Set<Long> getXLAHeaderId(Set<Long> eventIds) {
        HashSet<Long> result = new HashSet<Long>(eventIds.size());
        if (eventIds.isEmpty()) {
            return result;
        }
        String id_str = QFilterBuilder.buildSQLParamHolder((int)eventIds.size());
        String sql = "select fid from t_fah_ae_headers where fsrceventid in " + id_str;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateVoucherDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])eventIds.toArray());){
            for (Row row : queryDataSet) {
                Long id = row.getLong("fid");
                result.add(id);
            }
        }
        return result;
    }

    public static Map<Long, String> preGenGLVoucherBillno(Set<Long> eventIds) {
        HashMap<Long, String> result = new HashMap<Long, String>(eventIds.size());
        if (eventIds.isEmpty()) {
            return result;
        }
        String id_str = QFilterBuilder.buildSQLParamHolder((int)eventIds.size());
        String sql = "select fid from t_fah_ae_headers where fsrceventid in " + id_str + " and fid not in (select fid from t_gl_voucher)";
        HashSet<Long> headIds = new HashSet<Long>(eventIds.size());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateVoucherDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])eventIds.toArray());){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Long headId = ((Row)iterator.next()).getLong("fid");
                headIds.add(headId);
            }
        }
        Map xlaDataMap = BusinessDataServiceHelper.loadFromCache((String)"fah_subledger", (QFilter[])new QFilter("id", "in", headIds).toArray());
        if (xlaDataMap == null || xlaDataMap.isEmpty()) {
            return result;
        }
        ArrayList<DynamicObject> glVouchers = new ArrayList<DynamicObject>(xlaDataMap.size());
        for (DynamicObject xla : xlaDataMap.values()) {
            DynamicObject voucherObj = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
            voucherObj.set("bizdate", xla.get("bizdate"));
            voucherObj.set("bookeddate", xla.get("bookeddate"));
            voucherObj.set("org", xla.get("org"));
            voucherObj.set("period", xla.get("period"));
            voucherObj.set("sourcetype", (Object)"4");
            voucherObj.set("booktype", xla.get("booktype"));
            voucherObj.set("vouchertype", xla.get("vouchertype"));
            voucherObj.set("billstatus", (Object)"A");
            voucherObj.set("id", xla.get("id"));
            glVouchers.add(voucherObj);
        }
        return FahGenerateVoucherDataDao.genVoucherno(glVouchers);
    }

    public static Map<Long, String> genVoucherno(List<DynamicObject> glVouchers) {
        HashMap<Long, String> result = new HashMap<Long, String>(glVouchers.size());
        if (glVouchers.isEmpty()) {
            return result;
        }
        HashMap<Long, List> orgMap = new HashMap<Long, List>();
        for (DynamicObject obj : glVouchers) {
            long orgId = obj.getLong("org.id");
            orgMap.computeIfAbsent(orgId, p -> new ArrayList()).add(obj);
        }
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"gl_voucher");
        ICodeRuleService crservice = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        obj.set("billstatus", (Object)"A");
        for (Map.Entry entry : orgMap.entrySet()) {
            obj.set("org", entry.getKey());
            CodeRuleInfo codeRule = crservice.getCodeRule("gl_voucher", obj, String.valueOf(entry.getKey()));
            List list = (List)entry.getValue();
            if (null == codeRule) continue;
            List codeRuleEntry = codeRule.getRuleEntry();
            HashMap<String, String> bizField = new HashMap<String, String>(4);
            HashMap<String, SimpleDateFormat> dateFormat = new HashMap<String, SimpleDateFormat>(4);
            for (CodeRuleEntryInfo entryInfo : codeRuleEntry) {
                if (entryInfo.getAttributeType().equals("2")) {
                    bizField.put(entryInfo.getValueAtribute(), entryInfo.getAttributeType());
                    dateFormat.put(entryInfo.getValueAtribute(), new SimpleDateFormat(entryInfo.getFormat()));
                }
                if (!entryInfo.getAttributeType().equals("8")) continue;
                bizField.put(entryInfo.getValueAtribute(), entryInfo.getAttributeType());
            }
            FahGenerateVoucherDataDao.setVoucherNumber("gl_voucher", list, result, bizField, dateFormat, crservice);
        }
        return result;
    }

    private static void setVoucherNumber(String string, List<DynamicObject> dataentity, Map<Long, String> result, Map<String, String> bizField, Map<String, SimpleDateFormat> dateFormat, ICodeRuleService crservice) {
        if (dataentity.isEmpty()) {
            return;
        }
        HashMap keyMap = new HashMap();
        for (DynamicObject dynamicObject : dataentity) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : bizField.entrySet()) {
                String field = entry.getKey();
                if ("2".equals(entry.getValue())) {
                    if (null == dynamicObject.getDate(field)) {
                        sb.append("-");
                        continue;
                    }
                    sb.append(dateFormat.get(field).format(dynamicObject.getDate(field))).append("-");
                    continue;
                }
                if (!bizField.get(field).equals("8")) continue;
                sb.append(dynamicObject.getString(field)).append("-");
            }
            String key_cache = "key_cache";
            if (sb.length() > 0) {
                key_cache = sb.substring(0, sb.length() - 1);
            }
            if (keyMap.get(key_cache) == null) {
                ArrayList<DynamicObject> subList = new ArrayList<DynamicObject>();
                subList.add(dynamicObject);
                keyMap.put(key_cache, subList);
                continue;
            }
            ((List)keyMap.get(key_cache)).add(dynamicObject);
        }
        for (Map.Entry entry : keyMap.entrySet()) {
            List subList = (List)entry.getValue();
            DynamicObject subObj = (DynamicObject)subList.get(0);
            subObj.set("billstatus", (Object)"A");
            String[] billNo = crservice.getBatchNumber("gl_voucher", subObj, subObj.getString("org.id"), subList.size());
            int i = 0;
            for (DynamicObject ext : subList) {
                Long id = ext.getLong("id");
                result.put(id, billNo[i]);
                ++i;
            }
        }
    }

    public static List<XLAVoucher> loadXLAData(List<Long> ids, Boolean includeEntry) {
        Map<Object, Object> xlaIdLineMap;
        ArrayList<XLAVoucher> result = new ArrayList<XLAVoucher>();
        if (ids.isEmpty()) {
            return result;
        }
        String id_str = QFilterBuilder.buildSQLParamHolder((int)ids.size());
        ArrayList<XLAVoucherEntry> entryRows = new ArrayList<XLAVoucherEntry>(ids.size());
        if (includeEntry.booleanValue()) {
            FahGenerateVoucherDataDao.loadXLADataEntry(ids, false, entryRows, 1000000, 0L);
            xlaIdLineMap = entryRows.stream().collect(Collectors.groupingBy(XLAVoucherEntry::getId));
        } else {
            xlaIdLineMap = Collections.emptyMap();
        }
        String sql = "select fid,fbooktypeid,fbookid,forgid,fperiodid,ftypeid,fdescription,fbizdate,fbookeddate,fsrc_systype,fsrc_sysid,fsrc_billtype,fsrc_billid,fsrc_billno,fattachments,floc_debitamt,floc_creditamt,floc_currencyid,fsrceventid,facctruleid,facctruleversion,fcreatorid,fcreatetime,frequestid,fvoucherstatus,fmergegrpkey,freversestatus,frelateid,facctpurposeid,fmergeruleid from t_fah_ae_headers where fid in " + id_str;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateVoucherDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])ids.toArray());){
            for (Row row : queryDataSet) {
                XLAVoucher voucher = new XLAVoucher();
                long vid = row.getLong("fid");
                voucher.setId(vid);
                voucher.setBookTypeId(row.getLong("fbooktypeid"));
                voucher.setBookId(row.getLong("fbookid"));
                voucher.setOrgId(row.getLong("forgid"));
                voucher.setPeriodId(row.getLong("fperiodid"));
                voucher.setVchTypeId(row.getLong("ftypeid"));
                voucher.setDescription(row.getString("fdescription"));
                voucher.setBizDate(row.getDate("fbizdate"));
                voucher.setBookedDate(row.getDate("fbookeddate"));
                voucher.setSourceSysId(row.getLong("fsrc_sysid"));
                voucher.setSourceType(row.getLong("fsrc_systype"));
                voucher.setSourceBillType(row.getString("fsrc_billtype"));
                voucher.setSourceBillId(row.getLong("fsrc_billid"));
                voucher.setSourceBillNo(row.getString("fsrc_billno"));
                voucher.setAttachment(row.getInteger("fattachments"));
                voucher.setLocalCurrencyId(row.getLong("floc_currencyid"));
                voucher.setCreditlocamount(row.getBigDecimal("floc_creditamt"));
                voucher.setDebitlocamount(row.getBigDecimal("floc_debitamt"));
                voucher.setSrcEventId(row.getLong("fsrceventid"));
                Long acctruleid = row.getLong("facctruleid");
                voucher.setAcctRuleId(acctruleid);
                voucher.setAcctRuleVersion(row.getInteger("facctruleversion"));
                voucher.setCreatorId(row.getLong("fcreatorid"));
                voucher.setCreateTime(row.getDate("fcreatetime"));
                voucher.setBillMergeField(row.getString("fmergegrpkey"));
                voucher.setMergeRuleId(row.getLong("fmergeruleid"));
                voucher.setAcctPurposeId(row.getLong("facctpurposeid"));
                voucher.setRequestId(row.getLong("frequestid"));
                if (includeEntry.booleanValue()) {
                    List entrys = (List)xlaIdLineMap.get(vid);
                    if (null != entrys) {
                        for (XLAVoucherEntry entry : entrys) {
                            entry.setOrgId(row.getLong("forgid"));
                            entry.setPeriodId(row.getLong("fperiodid"));
                            entry.setSrcBillno(row.getString("fsrc_billno"));
                            entry.setLocalCurrencyId(row.getLong("floc_currencyid"));
                        }
                    }
                    voucher.setEntryRows(entrys);
                }
                result.add(voucher);
            }
        }
        return result;
    }

    public static Long loadXLADataEntry(List<Long> ids, boolean isBigEntry, List<XLAVoucherEntry> xlaEntry, int maxSize, Long lastEntryId) {
        Long result = 0L;
        if (ids.isEmpty()) {
            return result;
        }
        boolean startQuery = !isBigEntry;
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fentryid,fid,fseq,faccountid,fcurrencyid,fmeasureunitid,fassgrpid,fori_debit,fori_credit,", new Object[0]).append("flocal_debit,flocal_credit,flocal_exchangerate,fquantity,fprice,fdescription,fmaincf_itemid,", new Object[0]).append("fmaincf_amount,fsupcf_itemid,fsupcf_amount,fexpire_date,fbusinessnum,fsrc_eventlineid,", new Object[0]).append("fsrc_billentryid,fmaincf_assgrpid,flinetypeid,fentrydc,fneedmerge,fsourceentry from t_fah_ae_lines where ", new Object[0]).appendIn(" fid ", ids.toArray()).append(" order by fentryid", new Object[0]);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateVoucherDataDao", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sql);){
            for (Row row : queryDataSet) {
                Long entryId = row.getLong("fentryid");
                if (isBigEntry && xlaEntry.size() > maxSize) {
                    result = entryId;
                    break;
                }
                if (!startQuery && (lastEntryId.equals(entryId) || lastEntryId == 0L)) {
                    startQuery = true;
                }
                if (!startQuery) continue;
                XLAVoucherEntry voucherEntry = new XLAVoucherEntry();
                voucherEntry.setId(row.getLong("fid"));
                voucherEntry.setEntryId(entryId);
                voucherEntry.setSeq(row.getInteger("fseq"));
                voucherEntry.setAccountId(row.getLong("faccountid"));
                voucherEntry.setOriCurrencyId(row.getLong("fcurrencyid"));
                voucherEntry.setUnitId(row.getLong("fmeasureunitid"));
                voucherEntry.setAssgrpId(row.getLong("fassgrpid"));
                voucherEntry.setOriDebit(row.getBigDecimal("fori_debit"));
                voucherEntry.setOriCredit(row.getBigDecimal("fori_credit"));
                voucherEntry.setLocalDebit(row.getBigDecimal("flocal_debit"));
                voucherEntry.setLocalCredit(row.getBigDecimal("flocal_credit"));
                voucherEntry.setLocalExchangeRate(row.getBigDecimal("flocal_exchangerate"));
                voucherEntry.setQty(row.getBigDecimal("fquantity"));
                voucherEntry.setPrice(row.getBigDecimal("fprice"));
                voucherEntry.setDescription(row.getString("fdescription"));
                voucherEntry.setMaincfitemID(row.getLong("fmaincf_itemid"));
                voucherEntry.setMaincfamount(row.getBigDecimal("fmaincf_amount"));
                voucherEntry.setMaincfassgrp(row.getLong("fmaincf_assgrpid"));
                voucherEntry.setSupcfitemID(row.getLong("fsupcf_itemid"));
                voucherEntry.setSupcfamount(row.getBigDecimal("fsupcf_amount"));
                voucherEntry.setExpireDate(row.getDate("fexpire_date"));
                voucherEntry.setBusinessnum(row.getString("fbusinessnum"));
                voucherEntry.setSrcEventLineId(row.getLong("fsrc_eventlineid"));
                voucherEntry.setSrcBillEntryId(row.getLong("fsrc_billentryid"));
                voucherEntry.setLineTypeId(row.getLong("flinetypeid"));
                voucherEntry.setDcDirectory(row.getInteger("fentrydc"));
                voucherEntry.setNeedMerge(row.getBoolean("fneedmerge"));
                voucherEntry.setSrcEntry(row.getString("fsourceentry"));
                xlaEntry.add(voucherEntry);
            }
        }
        return result;
    }
}

