/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.event.FahEventHeadStatusEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventStageEnum;
import kd.fi.v2.fah.models.xla.PeriodsKey;
import kd.fi.v2.fah.models.xla.XLAAccountBook;
import kd.fi.v2.fah.models.xla.XLANumberSrcModel;
import kd.fi.v2.fah.models.xla.XLAPeriod;
import kd.fi.v2.fah.services.dto.SingleGenXLADataSource;

public class FahGenerateXLADataDao {
    private static final String FULL_COVERAGE_HEADER = "insert into t_fah_ae_headers(fid,fbooktypeid,fbookid,forgid,fperiodid,ftypeid,fdescription,fbizdate,fbookeddate,fsrc_systype,fsrc_sysid,fsrc_billtype,fsrc_billid,fsrc_billno,fattachments,floc_debitamt,floc_creditamt,floc_currencyid,fsrceventid,facctruleid,facctruleversion,facctpurposeid,facctpurposeversion,fcreatorid,fcreatetime,frequestid,fmergegrpkey,frelateid,freversestatus,fmergeruleid,fnumber) select fid,fbooktypeid,fbookid,forgid,fperiodid,ftypeid,fdescription,fbizdate,fbookeddate,fsrc_systype,fsrc_sysid,fsrc_billtype,fsrc_billid,fsrc_billno,fattachments,floc_debitamt,floc_creditamt,floc_currencyid,fsrceventid,facctruleid,facctruleversion,facctpurposeid,facctpurposeversion,fcreatorid,fcreatetime,frequestid,fmergegrpkey,frelateid,freversestatus,fmergeruleid,fnumber from t_fah_ae_headers_tmp where fid = ?";
    private static final String FULL_COVERAGE_LINE = "insert into t_fah_ae_lines(fid,fentryid,fseq,faccountid,fcurrencyid,fmeasureunitid,fassgrpid,fori_debit,fori_credit,flocal_debit,flocal_credit,flocal_exchangerate,fquantity,fprice,fdescription,fmaincf_itemid,fmaincf_amount,fsupcf_itemid,fsupcf_amount,fexpire_date,fbusinessnum,fsrc_eventlineid,fsourceentry,fsrc_billentryid,fmaincf_assgrpid,flinetypeid,fentrydc,fneedmerge) select fid,fentryid,fseq,faccountid,fcurrencyid,fmeasureunitid,fassgrpid,fori_debit,fori_credit,flocal_debit,flocal_credit,flocal_exchangerate,fquantity,fprice,fdescription,fmaincf_itemid,fmaincf_amount,fsupcf_itemid,fsupcf_amount,fexpire_date,fbusinessnum,fsrc_eventlineid,fsourceentry,fsrc_billentryid,fmaincf_assgrpid,flinetypeid,fentrydc,fneedmerge from t_fah_ae_lines_tmp where fid = ?";

    public static List<SingleGenXLADataSource> splitEventData(Collection<Long> billIds) {
        ArrayList<SingleGenXLADataSource> result = new ArrayList<SingleGenXLADataSource>();
        if (billIds == null || billIds.isEmpty()) {
            return result;
        }
        HashMap<String, SingleGenXLADataSource> resultMap = new HashMap<String, SingleGenXLADataSource>();
        String ids_str = QFilterBuilder.buildSQLParamHolder((int)billIds.size());
        String sql = "select fid, fsrc_systype, fsrc_sysid, fsrc_billtype, fsrc_billid, fruleid, fruleversion, fcreatestatus,fcreatestage, forgid, fbizdate, fbookeddate, fsourceentry, fsourceentryid from t_fah_event_header where fstatus = '4' and fid in " + ids_str;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateXLADataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])billIds.toArray());){
            for (Row row : queryDataSet) {
                String billEntity = row.getString("fsrc_billtype");
                Long ruleId = row.getLong("fruleid");
                SingleGenXLADataSource currSource = resultMap.computeIfAbsent(billEntity + "-" + ruleId, v -> {
                    SingleGenXLADataSource singleGenXLADataSource = new SingleGenXLADataSource(billEntity, ruleId);
                    singleGenXLADataSource.setRuleVersion(row.getInteger("fruleversion"));
                    singleGenXLADataSource.setSysId(row.getLong("fsrc_sysid"));
                    singleGenXLADataSource.setSysType(row.getLong("fsrc_systype"));
                    return singleGenXLADataSource;
                });
                String status = row.getString("fcreatestatus");
                String stage = row.getString("fcreatestage");
                if (FahEventHeadStatusEnum.TEMPORARY_STORAGE.getStatus().equals(status) && FahEventStageEnum.CREATING_EVENT_LINE.getStage().equals(stage)) {
                    Long eventId = row.getLong("fid");
                    Object srcId = row.get("fsrc_billid");
                    currSource.addEventId(eventId);
                    currSource.addSrcId(srcId);
                    Long sourceEntryId = row.getLong("fsourceentryid");
                    Object[] supData = new Object[]{srcId, row.getLong("forgid"), row.get("fbizdate"), row.get("fbookeddate"), sourceEntryId, row.getString("fsourceentry")};
                    currSource.setCurrEventRuleOrgIsHead(srcId.equals(sourceEntryId));
                    currSource.putSupData(eventId, supData);
                    continue;
                }
                currSource.addHasErrorEventIds(row.getLong("fid"));
            }
        }
        result = new ArrayList(resultMap.values());
        return result;
    }

    public static XLAPeriod getPeriod(Date date, long periodType, Long curPeriodId) {
        List pcol;
        XLAPeriod result = null;
        DynamicObjectCollection periods = FahGenerateXLADataDao.queryPeriodsFromThreadCache(date, periodType);
        if (periods == null || periods.isEmpty()) {
            return result;
        }
        DynamicObject period = null;
        if (periods.size() > 1 && !(pcol = periods.stream().filter(fv -> fv.get("id").equals(curPeriodId)).collect(Collectors.toList())).isEmpty()) {
            period = (DynamicObject)pcol.get(0);
        }
        if (period == null) {
            period = (DynamicObject)periods.get(0);
        }
        result = new XLAPeriod(Long.valueOf(period.getLong("id")), period.getDate("begindate"), period.getDate("enddate"), period.getBoolean("isadjustperiod"), Long.valueOf(periodType));
        return result;
    }

    private static DynamicObjectCollection queryPeriodsFromThreadCache(Date date, long periodType) {
        Map xLAPeriodInCache = (Map)ThreadCache.get((Object)"FahGenerateXLADataDao.queryPeriodsFromThreadCache", HashMap::new);
        return xLAPeriodInCache.computeIfAbsent(PeriodsKey.of((Date)date, (long)periodType), k -> {
            QFilter f = new QFilter("beginDate", "<=", (Object)date);
            QFilter g = new QFilter("enddate", ">=", (Object)date);
            QFilter t = new QFilter("periodtype", "=", (Object)periodType);
            return QueryServiceHelper.query((String)"bd_period", (String)"id,begindate,enddate,isadjustperiod", (QFilter[])new QFilter[]{f, g, t});
        });
    }

    public static XLAPeriod getPeriodFromThreadCache(long periodId) {
        Map xLAPeriodInCache = (Map)ThreadCache.get((Object)"FahGenerateXLADataDao.getPeriodFromThreadCache2", HashMap::new);
        return xLAPeriodInCache.computeIfAbsent(periodId, k -> FahGenerateXLADataDao.getPeriod(periodId));
    }

    public static XLAPeriod getPeriod(long periodId) {
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"id,begindate,enddate,isadjustperiod,periodtype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)periodId)});
        if (period == null) {
            return null;
        }
        return new XLAPeriod(Long.valueOf(period.getLong("id")), period.getDate("begindate"), period.getDate("enddate"), period.getBoolean("isadjustperiod"), Long.valueOf(period.getLong("periodtype")));
    }

    public static XLAAccountBook getAcctBook(Long bookId) {
        XLAAccountBook result = null;
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.v2.fah.getvaluehandle.AccountSystemGetValueServiceImpl", (String)"gl_accountbook", (String)"org.id,id,bookstype.id,accountingsys.id,basecurrency.id,accounttable.id,periodtype.id,exratetable.id,curperiod.id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)bookId)}, null);){
            for (Row row : queryDataSet) {
                result = new XLAAccountBook(row.getLong("id"), row.getLong("org.id"), row.getLong("basecurrency.id"), row.getLong("bookstype.id"), row.getLong("accounttable.id"), row.getLong("periodtype.id"), row.getLong("exratetable.id"), row.getLong("curperiod.id"));
            }
        }
        return result;
    }

    public static void getEventLineData(Map<Long, List<Object[]>> eventLineData, Set<Long> eventIds) {
        if (eventIds.isEmpty()) {
            return;
        }
        String ids_str = QFilterBuilder.buildSQLParamHolder((int)eventIds.size());
        String sql = "select fid, fsrcbillentryid, fsrclineruleid, famount, fcurrencyid,fentryid,flinetypeid from t_fah_event_line where fid in " + ids_str;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateXLADataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])eventIds.toArray());){
            for (Row row : queryDataSet) {
                Long eventId = row.getLong("fid");
                List lineData = eventLineData.computeIfAbsent(eventId, v -> new ArrayList());
                Object[] value = new Object[]{row.getLong("fsrcbillentryid"), row.getLong("fsrclineruleid"), row.get("famount"), row.getLong("fcurrencyid"), row.getLong("fentryid"), row.getLong("flinetypeid")};
                lineData.add(value);
            }
        }
    }

    public static Long getMappingRuleByOrg(Long mappingGroupId, Long orgId) {
        Long result = 0L;
        if (mappingGroupId == 0L || orgId == 0L) {
            return result;
        }
        String sql = "select a.fid as id from t_fah_valmap_type a left join t_fah_valmap_type_org b on a.fid  = b.fmaptypeid where b.fownorgid = ? and a.fgroupid = ? ";
        Object[] param = new Object[]{orgId, mappingGroupId};
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateXLADataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])param);){
            Iterator iterator = queryDataSet.iterator();
            if (iterator.hasNext()) {
                result = ((Row)iterator.next()).getLong("id");
            }
        }
        return result;
    }

    public static Set<Long> generateGLVoucherpreCheck(Set<Long> eventIds, OperationResult result) {
        Throwable throwable;
        DataSet queryDataSet;
        HashSet<Long> ids = new HashSet<Long>();
        if (eventIds.isEmpty()) {
            return ids;
        }
        result.setBillCount(eventIds.size());
        HashMap<Long, String> billNoMap = new HashMap<Long, String>(eventIds.size());
        List splitSet = DapBuildVoucherCommonUtil.splitSet(eventIds, (int)2000);
        for (Set billIds : splitSet) {
            String selector = "fid,fsubledgerstatus,fnumber";
            queryDataSet = FahGenerateXLADataDao.getEventDataSet(billIds, selector);
            throwable = null;
            try {
                for (Row row : queryDataSet) {
                    Object status = row.get("fsubledgerstatus");
                    Long id = row.getLong("fid");
                    String biilno = row.getString("fnumber");
                    billNoMap.put(id, biilno);
                    if ("2".equals(status)) {
                        ids.add(id);
                        continue;
                    }
                    result.setSuccess(false);
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setLevel(ErrorLevel.Warning);
                    errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\uff1a\u5f53\u524d\u4e8b\u4ef6\u5c1a\u672a\u5b8c\u5168\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u6570\u636e\uff0c\u4e0d\u80fd\u751f\u6210\u603b\u8d26\u51ed\u8bc1\u3002", (String)"FahGenerateXLADataDao_2", (String)"fi-ai-business", (Object[])new Object[0]), biilno));
                    errorInfo.setTitle(ResManager.loadKDString((String)"\u521b\u5efa\u603b\u8d26\u51ed\u8bc1", (String)"FahGenerateXLADataDao_3", (String)"fi-ai-business", (Object[])new Object[0]));
                    errorInfo.setPkValue((Object)id);
                    result.addErrorInfo(errorInfo);
                    result.setShowMessage(true);
                }
            }
            catch (Throwable iterator) {
                throwable = iterator;
                throw iterator;
            }
            finally {
                if (queryDataSet == null) continue;
                if (throwable != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable iterator) {
                        throwable.addSuppressed(iterator);
                    }
                    continue;
                }
                queryDataSet.close();
            }
        }
        List splitSetTwo = DapBuildVoucherCommonUtil.splitSet(ids, (int)2000);
        for (Set billIds : splitSetTwo) {
            queryDataSet = FahGenerateXLADataDao.getGLDataSet(billIds);
            throwable = null;
            try {
                for (Row row : queryDataSet) {
                    Long id = row.getLong("id");
                    result.setSuccess(false);
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setLevel(ErrorLevel.Warning);
                    errorInfo.setMessage(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\uff1a\u5f53\u524d\u4e8b\u4ef6\u5df2\u751f\u6210\u603b\u8d26\u51ed\u8bc1\uff0c\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"FahGenerateXLADataDao_4", (String)"fi-ai-business", (Object[])new Object[0]), billNoMap.get(id)));
                    errorInfo.setTitle(ResManager.loadKDString((String)"\u521b\u5efa\u603b\u8d26\u51ed\u8bc1", (String)"FahGenerateXLADataDao_3", (String)"fi-ai-business", (Object[])new Object[0]));
                    errorInfo.setPkValue((Object)id);
                    result.addErrorInfo(errorInfo);
                    result.setShowMessage(true);
                    ids.remove(id);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (queryDataSet == null) continue;
                if (throwable != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                queryDataSet.close();
            }
        }
        result.setBillNos(billNoMap);
        return ids;
    }

    private static DataSet getEventDataSet(Set<Long> eventIds, String selector) {
        String ids_str = QFilterBuilder.buildSQLParamHolder((int)eventIds.size());
        String sql = "select " + selector + " from t_fah_event_header where fstatus = '4' and fid in (" + ids_str + ")";
        return DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateXLADataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])eventIds.toArray());
    }

    private static DataSet getGLDataSet(Set<Long> glIds) {
        String ids_str = QFilterBuilder.buildSQLParamHolder((int)glIds.size());
        String sql = "select distinct b.fsrceventid as id from t_gl_voucher a left join t_fah_ae_headers b on a.fid = b.fid where b.fsrceventid in (" + ids_str + ") and b.fstatus = '4'";
        return DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateXLADataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])glIds.toArray());
    }

    public static Set<Long> getXlaIdsByEventIds(List<Object> eventIds, boolean isFormal) {
        String idsStr = QFilterBuilder.buildSQLParamHolder((int)eventIds.size());
        String tableName = isFormal ? "t_fah_ae_headers" : "t_fah_ae_headers_tmp";
        String sql = String.format("select fid from %s where fSrcEventId in (%s)", tableName, idsStr);
        return (Set)DB.query((DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])eventIds.toArray(), r -> {
            LinkedHashSet<Long> ids = new LinkedHashSet<Long>(eventIds.size());
            while (r.next()) {
                ids.add(r.getLong("fid"));
            }
            return ids;
        });
    }

    /*
     * Exception decompiling
     */
    public static void fullCoverageFormal(Long requestId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static DataSet queryBillSourceData(String tableName, Long tableId, Long id) {
        String sql = "select fid,ftbillid,fttableid,ftid,fsbillid,fstableid,fsid from " + tableName + " where fttableid = " + tableId + " and ftid = " + id;
        return DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateXLADataDao", (DBRoute)FAHCommonConstant.FI, (String)sql);
    }

    public static void loadBaseDataNumebr(Map<Long, String> idAndNumberCache, String baseDataName) {
        if (idAndNumberCache.isEmpty() || StringUtils.isBlank((CharSequence)baseDataName)) {
            return;
        }
        String number = (String)DapBuildVoucherCommonUtil.getBaseDataProp((String)baseDataName).get("number");
        if (StringUtils.isBlank((CharSequence)number)) {
            return;
        }
        DynamicObjectCollection datas = QueryServiceHelper.query((String)baseDataName, (String)(number + ",id"), (QFilter[])new QFilter[]{new QFilter("id", "in", idAndNumberCache.keySet())});
        for (DynamicObject data : datas) {
            long id = data.getLong("id");
            String num = data.getString(number);
            idAndNumberCache.put(id, num);
        }
    }

    public static synchronized List<String> generateXLANumber(XLANumberSrcModel model, int size) {
        ArrayList<String> result = new ArrayList<String>(size);
        int startSeq = 0;
        Long currId = 0L;
        Boolean isUpdate = false;
        String sql = "select fseq,fid from t_fah_acct_seq where forgnum = ? and facctpurpnum = ? and fperiodnum = ?";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateXLADataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])model.getParam());){
            Iterator iterator = queryDataSet.iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                currId = row.getLong("fid");
                startSeq = row.getInteger("fseq");
                isUpdate = true;
            }
        }
        String numberStart = model.genNumberStart();
        for (int i = 1; i <= size; ++i) {
            NumberFormat nf = NumberFormat.getInstance();
            nf.setGroupingUsed(false);
            nf.setMinimumIntegerDigits(8);
            String format = nf.format(startSeq + i);
            result.add(numberStart + format);
        }
        if (isUpdate.booleanValue()) {
            String updateSql = "update t_fah_acct_seq set fseq = ?,fmodifytime = ? where fid = ?";
            Object[] param = new Object[]{startSeq + size, new Date(), currId};
            DB.execute((DBRoute)FAHCommonConstant.FI, (String)updateSql, (Object[])param);
        } else {
            String insertSql = "insert into t_fah_acct_seq(fid,fseq,forgnum,facctpurpnum,fperiodnum,fmodifytime) values (?,?,?,?,?,?)";
            long newId = DB.genLongId((String)"t_fah_acct_seq");
            Object[] param = new Object[]{newId, startSeq + size, model.getOrgnum(), model.getAcctpurpnum(), model.getPeriodnum(), new Date()};
            DB.execute((DBRoute)FAHCommonConstant.FI, (String)insertSql, (Object[])param);
        }
        return result;
    }
}

