/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.constant.enums.event.EventReverseStatusEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventHeadStatusEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventStageEnum;
import kd.fi.v2.fah.constant.enums.event.VchValueSetSelectEnum;
import kd.fi.v2.fah.constant.enums.event.VchValueSetTypeEnum;
import kd.fi.v2.fah.constant.enums.xla.FahEvtTrackerHead;
import kd.fi.v2.fah.constant.enums.xla.FahEvtTrackerLine;
import kd.fi.v2.fah.dao.BaseFlexFieldDao;
import kd.fi.v2.fah.models.context.GLTaskVoucherPushContext;
import kd.fi.v2.fah.models.context.ITaskVoucherPushContext;
import kd.fi.v2.fah.models.groupmerge.CustomMergeFieldConfig;
import kd.fi.v2.fah.models.groupmerge.ReBuildFieldConfig;
import kd.fi.v2.fah.models.voucher.FahGLVoucher;
import kd.fi.v2.fah.models.voucher.FahGLVoucherEntry;
import kd.fi.v2.fah.sqlbuilder.IInsertSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

public class FahGroupMergeDataDao {
    public static DynamicObject queryGroupMergeHead(Long id) {
        String selectFields = "id,number,name,group,bookdatesummary,bizdatesummary,creatorsummary,billnosummary,customfieldsummary,exchangerate,unitprice,dc,passtogl,summarytype,description,customfieldop,customfielden";
        DynamicObject result = QueryServiceHelper.queryOne((String)"fah_groupmerge", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)id).toArray());
        return result;
    }

    public static List<CustomMergeFieldConfig> queryBillMergeField(Long id) {
        ArrayList<CustomMergeFieldConfig> result = new ArrayList<CustomMergeFieldConfig>(8);
        String sql = "select fsrcbilltype,fcustomfield,fcustomfielddesc from t_fah_xla_merge_custflds where fid = " + id;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql);){
            for (Row row : queryDataSet) {
                String billtype = row.getString("fsrcbilltype");
                String fieldcol = row.getString("fcustomfield");
                String fieldDesc = row.getString("fcustomfielddesc");
                if (StringUtils.isBlank((CharSequence)fieldcol)) continue;
                CustomMergeFieldConfig fieldConfig = new CustomMergeFieldConfig();
                fieldConfig.setSrcBillType(billtype);
                fieldConfig.setCustomField(fieldcol);
                fieldConfig.setCustomFieldDesc(fieldDesc);
                result.add(fieldConfig);
            }
        }
        return result;
    }

    public static ReBuildFieldConfig[] queryRebuildField(Long id) {
        ReBuildFieldConfig[] result = new ReBuildFieldConfig[4];
        String sql = "select fsrcfieldkey,ffieldset,ffieldsetval,ffieldsettype,fsrcfieldenable,fdatatype from t_fah_xla_vch_rewrtrule where fid = " + id + " order by fseq";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql);){
            for (Row row : queryDataSet) {
                String fsrcfieldkey = row.getString("fsrcfieldkey");
                String fieldsettype = row.getString("ffieldsettype");
                String fieldsetval = row.getString("ffieldsetval");
                String fieldset = row.getString("ffieldset");
                ReBuildFieldConfig rc = new ReBuildFieldConfig(VchValueSetTypeEnum.getEnum((String)fieldsettype), "0".equals(fieldsettype) ? VchValueSetSelectEnum.FIRST : VchValueSetSelectEnum.getEnum((String)fieldsetval), DataValueTypeEnum.getEnum((String)row.getString("fdatatype")), fsrcfieldkey, row.getBoolean("fsrcfieldenable"), fieldsetval, fieldset);
                switch (fsrcfieldkey) {
                    case "creator": {
                        result[0] = rc;
                        break;
                    }
                    case "attachment": {
                        result[1] = rc;
                        break;
                    }
                    case "bookdate": {
                        result[2] = rc;
                        break;
                    }
                    case "bizdate": {
                        result[3] = rc;
                    }
                }
            }
        }
        return result;
    }

    public static boolean queryAndCheckOneToOneMerge(Set<Long> srcIds) {
        if (srcIds.isEmpty()) {
            return true;
        }
        SqlBuilder querySql = new SqlBuilder();
        querySql.append("select fid from t_fah_event_header where ", new Object[0]).appendIn(" fsrc_billid ", srcIds.toArray()).append("and fstatus = ?", new Object[]{"4"});
        ArrayList<Long> eventIds = new ArrayList<Long>(srcIds.size());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)querySql);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                eventIds.add(((Row)iterator.next()).getLong("fid"));
            }
        }
        if (srcIds.size() != eventIds.size()) {
            return false;
        }
        querySql = new SqlBuilder();
        querySql.append("select count(fid) as sumsize from t_fah_ae_headers where ", new Object[0]).appendIn(" fsrceventid ", eventIds.toArray()).append("and fstatus = ?", new Object[]{"4"});
        int xlaSize = 0;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)querySql);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                xlaSize = ((Row)iterator.next()).getInteger("sumsize");
            }
        }
        return eventIds.size() == xlaSize;
    }

    public static void notPushVoucherStatus(List<Long> npVoucherIds, Map<Long, Set<Long>> voucherIdAndXlaIdMap) {
        ArrayList notPushVoucherIds = new ArrayList(npVoucherIds.size());
        npVoucherIds.stream().forEach(f -> notPushVoucherIds.addAll((Collection)voucherIdAndXlaIdMap.get(f)));
        String sql = "update t_fah_ae_headers set fvoucherstatus =  ? where fid = ?";
        String sql_event = "update t_fah_event_header set fcreatestage = '" + FahEventStageEnum.CREATING_SL.getStage() + "',fcreatestatus =  ? where fid = ?";
        ArrayList params = new ArrayList(notPushVoucherIds.size());
        ArrayList<Object[]> params_event = new ArrayList<Object[]>(notPushVoucherIds.size());
        if (!notPushVoucherIds.isEmpty()) {
            notPushVoucherIds.stream().forEach(f -> params.add(new Object[]{"2", f}));
            String id_str = StringUtils.join((Object[])notPushVoucherIds.toArray(), (String)",");
            String querySql = "select fid,fsrceventid from t_fah_ae_headers where fid in (" + id_str + ") and fstatus = '4'";
            try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (String)querySql);){
                Iterator iterator = queryDataSet.iterator();
                while (iterator.hasNext()) {
                    params_event.add(new Object[]{FahEventHeadStatusEnum.SUCCESS.getStatus(), ((Row)iterator.next()).getLong("fsrceventid")});
                }
            }
        }
        try (TXHandle h = TX.required();){
            try {
                if (!params.isEmpty()) {
                    DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)sql, params);
                }
                if (!params_event.isEmpty()) {
                    DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)sql_event, params_event);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void changeXLAStatus(List<Long> sXLAVoucherIds, List<Long> eXLAVoucherIds, Map<Long, Set<Long>> voucherIdAndXlaIdMap) {
        ArrayList succXLAVoucherIds = new ArrayList(sXLAVoucherIds.size());
        ArrayList errorXLAVoucherIds = new ArrayList(eXLAVoucherIds.size());
        sXLAVoucherIds.stream().forEach(f -> succXLAVoucherIds.addAll((Collection)voucherIdAndXlaIdMap.get(f)));
        eXLAVoucherIds.stream().forEach(f -> errorXLAVoucherIds.addAll((Collection)voucherIdAndXlaIdMap.get(f)));
        String sql = "update t_fah_ae_headers set fvoucherstatus =  ? where fid = ?";
        ArrayList params = new ArrayList(succXLAVoucherIds.size() + errorXLAVoucherIds.size());
        if (!succXLAVoucherIds.isEmpty()) {
            succXLAVoucherIds.stream().forEach(f -> params.add(new Object[]{"1", f}));
        }
        if (!errorXLAVoucherIds.isEmpty()) {
            errorXLAVoucherIds.stream().forEach(f -> params.add(new Object[]{"9", f}));
        }
        try (TXHandle h = TX.required();){
            try {
                if (!params.isEmpty()) {
                    DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)sql, params);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void changeEventStatus(List<Long> sXLAVoucherIds, List<Long> eXLAVoucherIds, Map<Long, Set<Long>> voucherIdAndXlaIdMap) {
        SqlBuilder sbd;
        List splitbatch;
        ArrayList succXLAVoucherIds = new ArrayList(sXLAVoucherIds.size());
        ArrayList errorXLAVoucherIds = new ArrayList(eXLAVoucherIds.size());
        sXLAVoucherIds.stream().forEach(f -> succXLAVoucherIds.addAll((Collection)voucherIdAndXlaIdMap.get(f)));
        eXLAVoucherIds.stream().forEach(f -> errorXLAVoucherIds.addAll((Collection)voucherIdAndXlaIdMap.get(f)));
        ArrayList<Object[]> params_succ = new ArrayList<Object[]>(succXLAVoucherIds.size());
        ArrayList<Object[]> params_error = new ArrayList<Object[]>(errorXLAVoucherIds.size());
        if (!succXLAVoucherIds.isEmpty()) {
            splitbatch = DapBuildVoucherCommonUtil.splitbatch(succXLAVoucherIds, (int)2000);
            for (List data : splitbatch) {
                sbd = new SqlBuilder();
                sbd.append("select fid,fsrceventid from t_fah_ae_headers where ", new Object[0]).appendIn("fid", data.toArray()).append("and fstatus = ?", new Object[]{"4"});
                FahGroupMergeDataDao.queryEventId(sbd, params_succ, FahEventHeadStatusEnum.SUCCESS.getStatus());
            }
        }
        if (!errorXLAVoucherIds.isEmpty()) {
            splitbatch = DapBuildVoucherCommonUtil.splitbatch(errorXLAVoucherIds, (int)2000);
            for (List data : splitbatch) {
                sbd = new SqlBuilder();
                sbd.append("select fid,fsrceventid from t_fah_ae_headers where ", new Object[0]).appendIn("fid", data.toArray()).append("and fstatus = ?", new Object[]{"4"});
                FahGroupMergeDataDao.queryEventId(sbd, params_error, FahEventHeadStatusEnum.FAIL.getStatus());
            }
        }
        String sql = "update t_fah_event_header set fcreatestage = '" + FahEventStageEnum.CREATING_GL.getStage() + "',fcreatestatus =  ? where fid = ?";
        try (TXHandle h = TX.requiresNew();){
            try {
                if (!params_succ.isEmpty()) {
                    DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)sql, params_succ);
                }
                if (!params_error.isEmpty()) {
                    DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)sql, params_error);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private static void queryEventId(SqlBuilder sbd, List<Object[]> params_succ, String status) {
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sbd);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                params_succ.add(new Object[]{status, ((Row)iterator.next()).getLong("fsrceventid")});
            }
        }
    }

    public static void loadFahVoucherIFData(ITaskVoucherPushContext context, int MaxSize) {
        if (context.getNextBatchIds().isEmpty()) {
            return;
        }
        ArrayList<FahGLVoucherEntry> entrys = new ArrayList<FahGLVoucherEntry>(16);
        boolean startMonitorData = false;
        long currMonitorId = 0L;
        SqlBuilder sql_line = new SqlBuilder();
        sql_line.append("select fid,fentryid,faccountid,fcurrencyid,flocalexchangerate,fmeasureunitid,", new Object[0]).append("fassgrpid,foriginaldebit,foriginalcredit,flocaldebit,flocalcredit,fquantity,fprice,fseq,", new Object[0]).append("fdescription,fentrydc,fmaincfitemid,fmaincfassgrpid,fsuppcfitemid,fsuppcfamount,fmaincfamount,", new Object[0]).append("fexpiredate,fbusinessnum,forgid,fperiodid,fgrpkeyhash,flinetypeid,fismerge from t_fah_voucherentry_if where ", new Object[0]).appendIn(" fid ", context.getNextBatchIds().toArray()).append(" order by fid", new Object[0]);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sql_line);){
            for (Row row : queryDataSet) {
                FahGLVoucherEntry entry = new FahGLVoucherEntry();
                long id = row.getLong("fid");
                if (startMonitorData && currMonitorId != id) {
                    break;
                }
                entry.setId(id);
                entry.setEntryId(row.getLong("fentryid"));
                entry.setAccountId(row.getLong("faccountid"));
                entry.setOriCurrencyId(row.getLong("fcurrencyid"));
                entry.setLocalExchangeRate(row.getBigDecimal("flocalexchangerate"));
                entry.setUnitId(row.getLong("fmeasureunitid"));
                entry.setAssgrpId(row.getLong("fassgrpid"));
                entry.setOriCredit(row.getBigDecimal("foriginalcredit"));
                entry.setOriDebit(row.getBigDecimal("foriginaldebit"));
                entry.setLocalCredit(row.getBigDecimal("flocalcredit"));
                entry.setLocalDebit(row.getBigDecimal("flocaldebit"));
                entry.setQty(row.getBigDecimal("fquantity"));
                entry.setPrice(row.getBigDecimal("fprice"));
                entry.setSeq(row.getInteger("fseq"));
                entry.setDescription(row.getString("fdescription"));
                entry.setDcDirectory(row.getInteger("fentrydc"));
                entry.setMaincfitemID(row.getLong("fmaincfitemid"));
                entry.setMaincfamount(row.getBigDecimal("fmaincfamount"));
                entry.setSupcfamount(row.getBigDecimal("fsuppcfamount"));
                entry.setSupcfitemID(row.getLong("fsuppcfitemid"));
                entry.setMaincfassgrp(row.getLong("fmaincfassgrpid"));
                entry.setExpireDate(row.getDate("fexpiredate"));
                entry.setBusinessNum(row.getString("fbusinessnum"));
                entry.setForgid(row.getLong("forgid"));
                entry.setFperiodid(row.getLong("fperiodid"));
                entry.setGrpKeyHash(row.getLong("fgrpkeyhash"));
                entry.setLineTypeId(row.getLong("flinetypeid"));
                entry.setMerge(row.getBoolean("fismerge"));
                entrys.add(entry);
                if (entrys.size() <= MaxSize) continue;
                startMonitorData = true;
                currMonitorId = id;
            }
        }
        SqlBuilder sql_head = new SqlBuilder();
        sql_head.append("select fid,fnumber,fbooktypeid,fbookid,forgid,fperiodid,ftypeid,fbillstatus,fdescription,fbizdate,", new Object[0]).append("fbookeddate,fcreatorid,fcreatetime,fsourcetype,fsourcesys,fattachments,fsourcebilltype,", new Object[0]).append("fsourcebillid,fvdescription,fdebitlocamount,fcreditlocamount,floccurrency,fmergegrpkey,frequestid,fgrpkeyhash,fsourcebillno from t_fah_voucher_if where ", new Object[0]).appendIn(" fid ", context.getNextBatchIds().toArray()).append("and fstatus = ?", new Object[]{"4"}).append(" order by fid", new Object[0]);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sql_head);){
            for (Row row : queryDataSet) {
                FahGLVoucher voucher = new FahGLVoucher();
                long id = row.getLong("fid");
                voucher.setId(id);
                voucher.setNumber(row.getString("fnumber"));
                voucher.setBooktypeId(row.getLong("fbooktypeid"));
                voucher.setBookId(row.getLong("fbookid"));
                voucher.setOrgId(row.getLong("forgid"));
                voucher.setPeriodId(row.getLong("fperiodid"));
                voucher.setVchTypeId(row.getLong("ftypeid"));
                voucher.setBillStatus(row.getString("fbillstatus"));
                voucher.setDescription(row.getString("fdescription"));
                voucher.setBizDate(row.getDate("fbizdate"));
                voucher.setBookedDate(row.getDate("fbookeddate"));
                voucher.setCreateTime(row.getDate("fcreatetime"));
                voucher.setCreatorId(row.getLong("fcreatorid"));
                voucher.setModifierId(row.getLong("fcreatorid"));
                voucher.setModifyTime(row.getDate("fcreatetime"));
                voucher.setSourceSys(row.getString("fsourcesys"));
                voucher.setSourceType(row.getString("fsourcetype"));
                voucher.setSourceBill(row.getString("fsourcebilltype"));
                voucher.setSourceBillId(row.getLong("fsourcebillid"));
                voucher.setAttachment(row.getInteger("fattachments"));
                voucher.setVdescription(row.getString("fvdescription"));
                voucher.setDebitlocamount(row.getBigDecimal("fdebitlocamount"));
                voucher.setCreditlocamount(row.getBigDecimal("fcreditlocamount"));
                voucher.setLocalcur(row.getLong("floccurrency"));
                voucher.setMergeKey(row.getString("fmergegrpkey"));
                voucher.setRequestId(row.getLong("frequestid"));
                voucher.setGrpKeyHashCode(row.getLong("fgrpkeyhash"));
                voucher.setSourcebillno(row.getString("fsourcebillno"));
                List<FahGLVoucherEntry> entrycol = entrys.stream().filter(f -> f.getId() == id).collect(Collectors.toList());
                for (FahGLVoucherEntry entry : entrycol) {
                    entry.setForgid(row.getLong("forgid"));
                    entry.setFperiodid(row.getLong("fperiodid"));
                }
                voucher.setEntryRows(entrycol);
                context.getCurrBatchSrcVoucher().add(voucher);
                if (!startMonitorData || currMonitorId != id) continue;
                break;
            }
        }
    }

    public static Map<Long, Tuple<List<Long>, List<List<Long>>>> queryXLABaseInfo(List<Long> xlaIds, int maxSize, List<Long> bigEntryIds) {
        HashMap<Long, Tuple<List<Long>, List<List<Long>>>> result = new HashMap<Long, Tuple<List<Long>, List<List<Long>>>>();
        if (xlaIds.isEmpty()) {
            return result;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select a.fevtlinecnt as cnt,b.fmergeruleid as ruleid,b.fid as id from t_fah_event_header a ", new Object[0]);
        sqlBuilder.append("right join t_fah_ae_headers b on a.fid = b.fsrceventid ", new Object[0]);
        sqlBuilder.appendIn("where b.fid ", xlaIds.toArray());
        sqlBuilder.append(" and a.fstatus = ?", new Object[]{"4"});
        sqlBuilder.append(" and b.fstatus = ?", new Object[]{"4"});
        sqlBuilder.append("order by b.fmergeruleid", new Object[0]);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sqlBuilder);){
            while (queryDataSet.hasNext()) {
                Row row = queryDataSet.next();
                int count = row.getInteger("cnt");
                Long ruleId = row.getLong("ruleid");
                Long id = row.getLong("id");
                Tuple data = result.computeIfAbsent(ruleId, v -> new Tuple(new ArrayList(), new ArrayList()));
                if (count > maxSize) {
                    ArrayList<Long> bigData = new ArrayList<Long>(1);
                    bigData.add(id);
                    bigEntryIds.add(id);
                    ((List)data.item2).add(bigData);
                    continue;
                }
                ((List)data.item1).add(id);
            }
        }
        return result;
    }

    public static List<Long> getCurrRequestXLAData(Long requestId, Boolean isGroupMerge, EventReverseStatusEnum reverseStatusEnum) {
        ArrayList<Long> result = new ArrayList<Long>();
        String sql = "select fstatus from t_fah_request_task where fid = " + requestId;
        Boolean hasFail = false;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGenerateXLADataDao", (DBRoute)FAHCommonConstant.FI, (String)sql);){
            for (Row row : queryDataSet) {
                String fstatus = row.getString("fstatus");
                hasFail = TaskStatusEnum.FAILURE.getStringValue().equals(fstatus);
            }
        }
        if (hasFail.booleanValue()) {
            return result;
        }
        String excludeTable = "2".equals(reverseStatusEnum.getCode()) ? "t_fah_task_skip_bills" : "t_fah_task_fail_bills";
        sql = isGroupMerge != false ? "select fid from t_fah_ae_headers where frequestid = ? and fstatus = '4' and fsrc_billid not in (select fsrcbillid from " + excludeTable + " where frequestid = ?)" : "select fid from t_fah_ae_headers_tmp where frequestid = ? and fstatus = '4' and fsrc_billid not in (select fsrcbillid from " + excludeTable + " where frequestid = ?)";
        Object[] param = new Object[]{requestId, requestId};
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])param);){
            while (queryDataSet.hasNext()) {
                Long xlaId = queryDataSet.next().getLong("fid");
                result.add(xlaId);
            }
        }
        return result;
    }

    public static void deletePreData(List<Long> preSaveEntryId) {
        String id_str = QFilterBuilder.buildSQLParamHolder((int)preSaveEntryId.size());
        String sql = "delete from t_fah_voucherentry_if where fentryid in (" + id_str + ")";
        DB.execute((DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])preSaveEntryId.toArray());
    }

    public static List<FahGLVoucher> loadFahVoucherHead(List<Long> voucherIds, Map<Long, Object[]> headKeyValueCache) {
        ArrayList<FahGLVoucher> result = new ArrayList<FahGLVoucher>();
        SqlBuilder sql_head = new SqlBuilder();
        sql_head.append("select fid,fnumber,fbooktypeid,fbookid,forgid,fperiodid,ftypeid,fbillstatus,fdescription,fbizdate,", new Object[0]).append("fbookeddate,fcreatorid,fcreatetime,fsourcetype,fsourcesys,fattachments,fsourcebilltype,", new Object[0]).append("fsourcebillid,fvdescription,fdebitlocamount,fcreditlocamount,floccurrency,fmergegrpkey,frequestid,fgrpkeyhash,fsourcebillno from t_fah_voucher_if where ", new Object[0]).appendIn(" fid ", voucherIds.toArray()).append("and  fstatus = ?", new Object[]{"4"}).append(" order by fid", new Object[0]);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sql_head);){
            for (Row row : queryDataSet) {
                FahGLVoucher voucher = new FahGLVoucher();
                long id = row.getLong("fid");
                voucher.setId(id);
                voucher.setNumber(row.getString("fnumber"));
                voucher.setBooktypeId(row.getLong("fbooktypeid"));
                voucher.setBookId(row.getLong("fbookid"));
                voucher.setOrgId(row.getLong("forgid"));
                voucher.setPeriodId(row.getLong("fperiodid"));
                voucher.setVchTypeId(row.getLong("ftypeid"));
                voucher.setBillStatus(row.getString("fbillstatus"));
                voucher.setDescription(row.getString("fdescription"));
                voucher.setBizDate(row.getDate("fbizdate"));
                voucher.setBookedDate(row.getDate("fbookeddate"));
                voucher.setCreateTime(row.getDate("fcreatetime"));
                voucher.setCreatorId(row.getLong("fcreatorid"));
                voucher.setModifierId(row.getLong("fcreatorid"));
                voucher.setModifyTime(row.getDate("fcreatetime"));
                voucher.setSourceSys(row.getString("fsourcesys"));
                voucher.setSourceType(row.getString("fsourcetype"));
                voucher.setSourceBill(row.getString("fsourcebilltype"));
                voucher.setSourceBillId(row.getLong("fsourcebillid"));
                voucher.setAttachment(row.getInteger("fattachments"));
                voucher.setVdescription(row.getString("fvdescription"));
                voucher.setDebitlocamount(row.getBigDecimal("fdebitlocamount"));
                voucher.setCreditlocamount(row.getBigDecimal("fcreditlocamount"));
                voucher.setLocalcur(row.getLong("floccurrency"));
                voucher.setMergeKey(row.getString("fmergegrpkey"));
                voucher.setRequestId(row.getLong("frequestid"));
                voucher.setGrpKeyHashCode(row.getLong("fgrpkeyhash"));
                voucher.setSourcebillno(row.getString("fsourcebillno"));
                result.add(voucher);
                headKeyValueCache.put(id, new Object[]{row.getLong("forgid"), row.getLong("floccurrency"), row.getLong("fbookid"), row.getDate("fbookeddate")});
            }
        }
        return result;
    }

    public static Object[] getFahHeadKeyValueInfo(Long id) {
        Object[] result = new Object[4];
        String sql_head = "select fid,fbookid,forgid,fbookeddate,floccurrency from t_fah_voucher_if where fstatus = '4' and fid = " + id;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql_head);){
            for (Row row : queryDataSet) {
                result = new Object[]{row.getLong("forgid"), row.getLong("floccurrency"), row.getLong("fbookid"), row.getDate("fbookeddate")};
            }
        }
        return result;
    }

    public static Map<Long, Integer> getIntertableEntrySize(Map<Long, List<Long>> needMergeIds) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>(16);
        ArrayList allIds = new ArrayList();
        needMergeIds.values().stream().forEach(f -> allIds.addAll(f));
        String id_str = QFilterBuilder.buildSQLParamHolder((int)allIds.size());
        String sql = "select fid,count(fentryid) as cnt from t_fah_voucherentry_if where fid in (" + id_str + ") group by fid";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])allIds.toArray());){
            for (Row row : queryDataSet) {
                result.put(row.getLong("fid"), row.getInteger("cnt"));
            }
        }
        return result;
    }

    public static List<FahGLVoucherEntry> loadFahVoucherEntry(List<Long> currBatch) {
        ArrayList<FahGLVoucherEntry> result = new ArrayList<FahGLVoucherEntry>();
        SqlBuilder sql_line = new SqlBuilder();
        sql_line.append("select fid,fentryid,faccountid,fcurrencyid,flocalexchangerate,fmeasureunitid,", new Object[0]).append("fassgrpid,foriginaldebit,foriginalcredit,flocaldebit,flocalcredit,fquantity,fprice,fseq,", new Object[0]).append("fdescription,fentrydc,fmaincfitemid,fmaincfassgrpid,fsuppcfitemid,fsuppcfamount,fmaincfamount,", new Object[0]).append("fexpiredate,fbusinessnum,forgid,fperiodid,fgrpkeyhash,flinetypeid,fismerge from t_fah_voucherentry_if where ", new Object[0]).appendIn(" fid ", currBatch.toArray()).append(" order by fid", new Object[0]);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sql_line);){
            for (Row row : queryDataSet) {
                FahGLVoucherEntry entry = new FahGLVoucherEntry();
                long id = row.getLong("fid");
                entry.setId(id);
                entry.setEntryId(row.getLong("fentryid"));
                entry.setAccountId(row.getLong("faccountid"));
                entry.setOriCurrencyId(row.getLong("fcurrencyid"));
                entry.setLocalExchangeRate(row.getBigDecimal("flocalexchangerate"));
                entry.setUnitId(row.getLong("fmeasureunitid"));
                entry.setAssgrpId(row.getLong("fassgrpid"));
                entry.setOriCredit(row.getBigDecimal("foriginalcredit"));
                entry.setOriDebit(row.getBigDecimal("foriginaldebit"));
                entry.setLocalCredit(row.getBigDecimal("flocalcredit"));
                entry.setLocalDebit(row.getBigDecimal("flocaldebit"));
                entry.setQty(row.getBigDecimal("fquantity"));
                entry.setPrice(row.getBigDecimal("fprice"));
                entry.setSeq(row.getInteger("fseq"));
                entry.setDescription(row.getString("fdescription"));
                entry.setDcDirectory(row.getInteger("fentrydc"));
                entry.setMaincfitemID(row.getLong("fmaincfitemid"));
                entry.setMaincfamount(row.getBigDecimal("fmaincfamount"));
                entry.setSupcfamount(row.getBigDecimal("fsuppcfamount"));
                entry.setSupcfitemID(row.getLong("fsuppcfitemid"));
                entry.setMaincfassgrp(row.getLong("fmaincfassgrpid"));
                entry.setExpireDate(row.getDate("fexpiredate"));
                entry.setBusinessNum(row.getString("fbusinessnum"));
                entry.setForgid(row.getLong("forgid"));
                entry.setFperiodid(row.getLong("fperiodid"));
                entry.setGrpKeyHash(row.getLong("fgrpkeyhash"));
                entry.setLineTypeId(row.getLong("flinetypeid"));
                entry.setMerge(row.getBoolean("fismerge"));
                result.add(entry);
            }
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public static void updateBatchData(BaseInsertSqlBuilder fahVoucherLine, Set<Long> delete_Ids, List<Object[]> update_params, List<Object[]> updateEntryParam) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void createEvtTracker(BaseInsertSqlBuilder trackerHead, BaseInsertSqlBuilder trackerLine, Set<Long> successXLAIds, GLTaskVoucherPushContext glContext, boolean isPostToGL) {
        if (successXLAIds.isEmpty()) {
            return;
        }
        int index = trackerLine.getSqlParamRowCnt();
        Long lastXLAId = 0L;
        Long lastGlId = 0L;
        Map<Long, Long> srcXlaIdToMergedVchIdMap = glContext.getTracker().buildXlaIdToMergedVchIdMap();
        Map<Long, Long> srcXlaEntryIdToMergedVchEntryIdMap = glContext.getTracker().buildXlaEntryIdToMergedVchEntryIdMap();
        String id_str = QFilterBuilder.buildSQLParamHolder((int)successXLAIds.size());
        String sql = "select a.fid as xlaid, a.fsrc_billtype as srcbilltype, a.fsrc_billid as srcbillid, a.fsrceventid as srceventid, b.fentryid as xlaentryid, b.fsrc_billentryid as srcbillentryid  from t_fah_ae_headers a left join t_fah_ae_lines b on a.fid = b.fid where a.fstatus = '4' and a.fid in " + id_str + " order by a.fid";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])successXLAIds.toArray());){
            for (Row row : queryDataSet) {
                Long xlaId = row.getLong(0);
                String billType = row.getString(1);
                Long billId = row.getLong(2);
                Long eventId = row.getLong(3);
                Long xlaEntryId = row.getLong(4);
                Long srcbillentryid = row.getLong(5);
                if (index > glContext.getPreSaveMaxSize() && !xlaId.equals(lastXLAId)) {
                    FahGroupMergeDataDao.saveTrackerData(trackerHead, trackerLine);
                    trackerHead.clearSqlParamData();
                    trackerLine.clearSqlParamData();
                    index = 0;
                }
                ISqlParamBuffer paramBuffer_head = trackerHead.getSqlParamBuffer();
                ISqlParamBuffer paramBuffer_line = trackerLine.getSqlParamBuffer();
                if (!xlaId.equals(lastXLAId)) {
                    lastGlId = srcXlaIdToMergedVchIdMap.get(xlaId);
                    paramBuffer_head.set(FahEvtTrackerHead.FSRCBILLID.getWriteIndex(), (Object)billId);
                    paramBuffer_head.set(FahEvtTrackerHead.FSRCBILLTYPE.getWriteIndex(), (Object)billType);
                    paramBuffer_head.set(FahEvtTrackerHead.FXLAHEADERID.getWriteIndex(), (Object)xlaId);
                    paramBuffer_head.set(FahEvtTrackerHead.FGLHEADERID.getWriteIndex(), (Object)lastGlId);
                    paramBuffer_head.set(FahEvtTrackerHead.FREVERSEFLAG.getWriteIndex(), (Object)glContext.getReverseStatusEnum().getCode());
                    paramBuffer_head.set(FahEvtTrackerHead.FSRCSYSTYPE.getWriteIndex(), (Object)FahGroupMergeDataDao.getSysTypeAndPostGL(billType, isPostToGL));
                    paramBuffer_head.set(FahEvtTrackerHead.FREQUESTID.getWriteIndex(), (Object)glContext.getTracker().getRequestId());
                    paramBuffer_head.moveToNextParamRow();
                }
                Long glEntryId = srcXlaEntryIdToMergedVchEntryIdMap.get(xlaEntryId);
                paramBuffer_line.set(FahEvtTrackerLine.FSRCBILLTYPE.getWriteIndex(), (Object)billType);
                paramBuffer_line.set(FahEvtTrackerLine.FSRCBILLID.getWriteIndex(), (Object)billId);
                paramBuffer_line.set(FahEvtTrackerLine.FSRCBILLENTRYID.getWriteIndex(), (Object)srcbillentryid);
                paramBuffer_line.set(FahEvtTrackerLine.FREVERSEFLAG.getWriteIndex(), (Object)glContext.getReverseStatusEnum().getCode());
                paramBuffer_line.set(FahEvtTrackerLine.FREQUESTID.getWriteIndex(), (Object)glContext.getTracker().getRequestId());
                paramBuffer_line.set(FahEvtTrackerLine.FXLAHEADERID.getWriteIndex(), (Object)xlaId);
                paramBuffer_line.set(FahEvtTrackerLine.FXLALINEID.getWriteIndex(), (Object)xlaEntryId);
                paramBuffer_line.set(FahEvtTrackerLine.FGLHEADERID.getWriteIndex(), (Object)lastGlId);
                paramBuffer_line.set(FahEvtTrackerLine.FGLLINEID.getWriteIndex(), (Object)glEntryId);
                paramBuffer_line.moveToNextParamRow();
                lastXLAId = xlaId;
                ++index;
            }
        }
    }

    private static String getSysTypeAndPostGL(String billType, boolean isPostToGL) {
        String sysTypeAndPostGL = isPostToGL ? (billType.startsWith("fah_e_") ? "1" : "0") : (billType.startsWith("fah_e_") ? "9" : "8");
        return sysTypeAndPostGL;
    }

    public static void saveTrackerData(BaseInsertSqlBuilder trackerHead, BaseInsertSqlBuilder trackerLine) {
        BaseFlexFieldDao.doInsert((IInsertSqlBuilder)trackerHead);
        BaseFlexFieldDao.doInsert((IInsertSqlBuilder)trackerLine);
    }

    public static Boolean checkContext(GLTaskVoucherPushContext context) {
        if (context == null || context.getNextBatchIds().isEmpty()) {
            return false;
        }
        ArrayList<Long> ids = new ArrayList<Long>(context.getNextBatchIds().size());
        String id_str = QFilterBuilder.buildSQLParamHolder((int)context.getNextBatchIds().size());
        String sql = "select fid from t_fah_voucher_if where fstatus = '4' and fid in " + id_str;
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.FahGroupMergeDataDao", (DBRoute)FAHCommonConstant.FI, (String)sql, (Object[])context.getNextBatchIds().toArray());){
            for (Row row : queryDataSet) {
                Long hasVoucherId = row.getLong("fid");
                ids.add(hasVoucherId);
            }
        }
        context.getNextBatchIds().clear();
        context.getNextBatchIds().addAll(ids);
        if (context.getNextBatchIds().isEmpty()) {
            return false;
        }
        return true;
    }
}

