/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.ImportLogStatusEnum;
import kd.fi.v2.fah.models.flex.IFlexFieldMeta;
import kd.fi.v2.fah.util.FahUploadDataValUtil;

public class FahImportLogDao {
    public static void saveImportLog(Object batchId, String sourceType, Long dataTypeId, Map<String, Object> fields, List<String> errors) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("batchid", "=", batchId));
        qFilters.add(new QFilter("sourcetype", "=", (Object)sourceType));
        qFilters.add(new QFilter("datatypeid", "=", (Object)dataTypeId));
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"fah_flex_importlog", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (null == obj) {
            obj = BusinessDataServiceHelper.newDynamicObject((String)"fah_flex_importlog");
            obj.set("batchid", batchId);
            obj.set("status", (Object)ImportLogStatusEnum.PROCESSING.getCode());
            obj.set("createdate", (Object)new Date());
            obj.set("sourcetype", (Object)sourceType);
            obj.set("datatypeid", (Object)dataTypeId);
            obj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        } else if (null != fields) {
            for (Map.Entry<String, Object> entry : fields.entrySet()) {
                obj.set(entry.getKey(), entry.getValue());
            }
        }
        if (null != errors && !errors.isEmpty()) {
            DynamicObjectCollection entryEntity = obj.getDynamicObjectCollection("entryentity");
            int rowCount = entryEntity.getRowCount();
            for (String errorInfo : errors) {
                DynamicObject row = entryEntity.addNew();
                row.set("seq", (Object)(++rowCount));
                row.set("errorinfo", (Object)errorInfo);
            }
        }
        OperationServiceHelper.executeOperate((String)"save", (String)"fah_flex_importlog", (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)OperateOption.create());
    }

    public static String queryImportLog(Long batchId) {
        DynamicObject[] dynamic = BusinessDataServiceHelper.load((String)"fah_flex_importlog", (String)"status", (QFilter[])new QFilter("batchid", "=", (Object)batchId).toArray(), (String)"createdate desc", (int)1);
        if (null == dynamic || dynamic.length < 1) {
            return null;
        }
        return dynamic[0].getString("status");
    }

    public static Long genGlobalLongId() {
        return DB.genGlobalLongId();
    }

    public static Map<IFlexFieldMeta, Set<String>> findNotValueSet(Map<IFlexFieldMeta, Set<String>> valueMap) {
        LinkedHashMap<IFlexFieldMeta, Set<String>> notFindNumberMap = new LinkedHashMap<IFlexFieldMeta, Set<String>>();
        for (Map.Entry<IFlexFieldMeta, Set<String>> entry : valueMap.entrySet()) {
            Set<String> valueSetMap = FahImportLogDao.getValueMap(entry);
            if (valueSetMap.isEmpty()) continue;
            notFindNumberMap.put(entry.getKey(), valueSetMap);
        }
        return notFindNumberMap;
    }

    private static Set<String> getValueMap(Map.Entry<IFlexFieldMeta, Set<String>> entry) {
        HashSet<String> valueSetMap = new HashSet<String>();
        Set<String> value = entry.getValue();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date time = cal.getTime();
        SqlBuilder enBuilder = new SqlBuilder();
        enBuilder.append("select fnumber", new Object[0]).append(" from t_fah_flex_valueset where ", new Object[0]);
        enBuilder.append(" fvaluesettypeid = ?", new Object[]{entry.getKey().getRefTypeId()});
        enBuilder.append(" and fenable = ?", new Object[]{"1"});
        enBuilder.append(" and fexpiredate >= ?", new Object[]{time});
        enBuilder.append(" and feffectdate <= ?", new Object[]{time});
        enBuilder.appendIn(" and fnumber", value.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)FahUploadDataValUtil.class.getName(), (DBRoute)FAHCommonConstant.FI, (SqlBuilder)enBuilder);){
            for (Row row : queryDataSet) {
                valueSetMap.add(row.getString("fnumber"));
            }
        }
        if (value.size() == valueSetMap.size()) {
            return Collections.EMPTY_SET;
        }
        value.removeAll(valueSetMap);
        return value;
    }
}

