/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;

public class GenResultDao {
    public static Map<String, Object> getStatistic(Long requestId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT ftaskno,fcreatorid,fExcuteStartTime,fExcuteEndTime,frequestbillcnt,ffailbillcnt,fnogenevtcnt,fmsg_tag,fstatus,fbuildBizDimGrpTaskStatus", new Object[0]);
        sqlBuilder.append("FROM t_fah_request_task", new Object[0]).append(" where fid=?", new Object[]{requestId});
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"GenResultDao.getStatistic()", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                data.put("creater", row.getLong("fcreatorid"));
                data.put("starttime", row.getDate("fExcuteStartTime"));
                data.put("endtime", row.getDate("fExcuteEndTime"));
                int count = row.getInteger("frequestbillcnt");
                int failcount = row.getInteger("ffailbillcnt");
                data.put("count", count);
                data.put("successcount", count - failcount);
                data.put("failcount", failcount);
                data.put("nogenevtcnt", row.getInteger("fnogenevtcnt"));
                data.put("exception", row.getString("fmsg_tag"));
                data.put("status", row.getString("fstatus"));
                data.put("buildBizDimGrpTaskStatus", row.getString("fbuildBizDimGrpTaskStatus"));
                data.put("taskno", row.getString("ftaskno"));
            }
        }
        return data;
    }

    public static List<Map<String, Object>> getFailureReason(Long requestId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT fmsg_code,count(fmsg_code) errorcount  FROM (  ", new Object[0]);
        sqlBuilder.append("SELECT  DISTINCT fbilltype ,fsrcbillid ,fmsg_code FROM t_fah_task_fail_bills", new Object[0]);
        sqlBuilder.append("where frequestid =?", new Object[]{requestId}).append(" ) AS fail", new Object[0]).append("GROUP BY fmsg_code", new Object[0]);
        sqlBuilder.append("union SELECT  fmsg_code,count(fmsg_code) errorcount FROM (", new Object[0]);
        sqlBuilder.append("SELECT DISTINCT batch.fbilltype ,en.fsrcbillid, en.fmsg_code fmsg_code FROM t_fah_task_skip_bills en ", new Object[0]);
        sqlBuilder.append(" inner join  t_fah_task_batch batch on batch.frequestid =en.frequestid where batch.frequestid = ?", new Object[]{requestId});
        sqlBuilder.append(" and en.fmsg_code <> '0'", new Object[0]);
        sqlBuilder.append(") AS fail GROUP BY fmsg_code ", new Object[0]).append("ORDER BY fmsg_code", new Object[0]);
        LinkedList<Map<String, Object>> data = new LinkedList<Map<String, Object>>();
        try (DataSet dataSet = DB.queryDataSet((String)"GenResultDao.getFailureReason", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> rowData = new HashMap<String, Object>(2);
                rowData.put("fmsg_code", row.getString("fmsg_code"));
                rowData.put("errorcount", row.getInteger("errorcount"));
                data.add(rowData);
            }
        }
        return data;
    }

    public static List<Map<String, Object>> getSkipMsg(String code, Long requestId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT en.fsrcbillid fbillid,task.fbilltype fbilltype,en.fsrcbillno fbillno,en.fmsg fmsg  FROM  t_fah_task_batch task", new Object[0]);
        sql.append("INNER JOIN t_fah_task_skip_bills en ON en.frequestid  = task.frequestid ", new Object[0]);
        sql.append("WHERE en.fmsg_code =?", new Object[]{code}).append("AND task.frequestid =?", new Object[]{requestId});
        LinkedList<Map<String, Object>> data = new LinkedList<Map<String, Object>>();
        try (DataSet dataSet = DB.queryDataSet((String)"GenResultDao.getSkipMsg", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, String> rowData = new HashMap<String, String>(4);
                rowData.put("billno", row.getString("fbillno"));
                rowData.put("billtype", row.getString("fbilltype"));
                rowData.put("msg", row.getString("fmsg"));
                rowData.put("billid", row.getString("fbillid"));
                data.add(rowData);
            }
        }
        return data;
    }

    public static List<Map<String, Object>> getFailMsg(String code, Long requestId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fail.fsrcbillid fsrcbillid,fail.fbilltype fbilltype,fail.fdispatchid fdispatchid,fail.fmsg fmsg,fail.fsrcbillno fbillno FROM  t_fah_task_fail_bills fail", new Object[0]);
        sql.append("WHERE fail.fmsg_code =?", new Object[]{code}).append("AND fail.frequestid =?", new Object[]{requestId});
        LinkedList<Map<String, Object>> data = new LinkedList<Map<String, Object>>();
        try (DataSet dataSet = DB.queryDataSet((String)"GenResultDao.getFailMsg", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> rowData = new HashMap<String, Object>(4);
                rowData.put("billno", row.getString("fbillno"));
                rowData.put("billtype", row.getString("fbilltype"));
                rowData.put("dispatchrule", row.getLong("fdispatchid"));
                rowData.put("msg", row.getString("fmsg"));
                rowData.put("billid", row.getString("fsrcbillid"));
                data.add(rowData);
            }
        }
        return data;
    }

    public static Set<Long> getEventByRequestId(Long billId, String billtype, Long requestId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_fah_event_header", new Object[0]);
        sql.append("where fsrc_billtype = ?", new Object[]{billtype});
        sql.append("and fsrc_billid = ?", new Object[]{billId});
        sql.append("and frequestid = ?", new Object[]{requestId});
        sql.append("and fstatus = ?", new Object[]{"4"});
        HashSet<Long> eventIds = new HashSet<Long>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"GenResultDao.getEventByRequestId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                eventIds.add(row.getLong("fid"));
            }
        }
        return eventIds;
    }

    public static List<Map<String, Object>> getDataByRequestId(boolean isSkip, String msgCode, Long requestId, int startIndex, int length) {
        SqlBuilder sql = new SqlBuilder();
        if (isSkip) {
            sql.append("SELECT fBillType,fSrcBillId,fSrcBillNo,null as fDispatch,fMsg,fMsg_Code,fSrcBillId ", new Object[0]);
            sql.append("from t_fah_task_skip_bills where fRequestId=?", new Object[]{requestId});
            sql.append("and fmsg_code=?", new Object[]{msgCode});
        } else {
            sql.append("SELECT fail.fBillType fBillType,fail.fSrcBillId fSrcBillId,fail.fSrcBillNo fSrcBillNo,fail.fDispatchId fdispatch", new Object[0]);
            sql.append(",fail.fMsg fMsg,fail.fMsg_Code fMsg_Code,fail.fSrcBillId fSrcBillId from t_fah_task_fail_bills fail ", new Object[0]);
            sql.append(" where fail.fRequestId=?", new Object[]{requestId});
            sql.append("and fail.fmsg_code=?", new Object[]{msgCode});
        }
        LinkedList<Map<String, Object>> data = new LinkedList<Map<String, Object>>();
        try (DataSet dataSet = DB.queryDataSet((String)"GenResultDao.getDataByRequestId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql).limit(startIndex, length);){
            while (dataSet.hasNext()) {
                HashMap<String, Object> rowData = new HashMap<String, Object>(7);
                Row row = dataSet.next();
                rowData.put("billtype", row.getString("fBillType"));
                rowData.put("billno", row.getString("fSrcBillNo"));
                rowData.put("billid", row.getLong("fSrcBillId"));
                rowData.put("dispatch", row.getLong("fDispatch"));
                rowData.put("msgcode", row.getString("fMsg_code"));
                rowData.put("msg", row.getString("fMsg"));
                data.add(rowData);
            }
        }
        return data;
    }

    public static Map<String, Set<String>[]> getEventNumberByRequestId(Long requestId, Set<String> billTypes, Set<Long> billIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fSrc_BillType,fSrc_BillId,fNumber,fid from t_fah_event_header ", new Object[0]);
        sql.append("where frequestid = ? ", new Object[]{requestId});
        sql.appendIn("and fSrc_BillId ", billIds.toArray());
        sql.appendIn("and fSrc_BillType ", billTypes.toArray());
        sql.append("and fstatus = ?", new Object[]{"4"});
        HashMap<String, Set<String>[]> map = new HashMap<String, Set<String>[]>(8);
        try (DataSet dataSet = DB.queryDataSet((String)"GenResultDao.getEventNumberByRequestId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String key = row.getString("fSrc_BillType") + row.getLong("fSrc_BillId");
                Set[] event = (Set[])map.get(key);
                if (event == null) {
                    event = new HashSet[]{new HashSet(), new HashSet()};
                }
                event[0].add(row.getString("fNumber"));
                event[1].add(row.getString("fid"));
                map.put(key, event);
            }
        }
        return map;
    }

    public static int getCount(boolean isSkip, String msgCode, Long requestId) {
        SqlBuilder sql = new SqlBuilder();
        String table = isSkip ? "t_fah_task_skip_bills" : "t_fah_task_fail_bills";
        sql.append("SELECT count(1) datacount from", new Object[0]).append(table, new Object[0]).append(" where fRequestId=?", new Object[]{requestId});
        sql.append("and fmsg_code=?", new Object[]{msgCode});
        int count = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"GenResultDao.getDataByRequestId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            if (dataSet.hasNext()) {
                count = dataSet.next().getInteger("datacount");
            }
        }
        return count;
    }
}

