/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dao.BaseFlexFieldDao;
import kd.fi.v2.fah.models.flex.FlexFieldGrpCfg;
import kd.fi.v2.fah.models.valueset.IValueSetMeta;
import kd.fi.v2.fah.models.valueset.SingleValueSetData;
import kd.fi.v2.fah.models.valueset.ValueSetDataCollection;
import kd.fi.v2.fah.utils.ValueSetUtil;

public class ValueSetDao {
    private static Log logger = LogFactory.getLog(ValueSetDao.class);
    private static final String sql_query_valuesettype_head = "select fid,fdescription,fnumber,fname,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fenable from t_fah_flex_struc_type where fid = ?";
    private static final String sql_query_valuesettype_line = "select fid,fentryid,fseq,fattnum,fattname,fattdatatype,fdescription,fownernum,ffieldusagetype,frefentity,ftextfield,fdescription,fflexfieldnum from t_fah_flex_struc where fid = ?";
    private static final String sql_query_valueset_head = "select fid,fdescription,fnumber,fname,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fenable,fstrucid from t_fah_valueset_type where fid = ?";
    private static final String sql_query_valueset_line = "select fid,fnumber,fname,fdescription,feffectdate,fexpiredate,fenable,fseq,fvaluesettypeid,ftxtattr10,ftxtattr11,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr1,ftxtattr20,ftxtattr12,ftxtattr13,ftxtattr14,ftxtattr15,ftxtattr16,ftxtattr17,ftxtattr18,ftxtattr19 from t_fah_flex_valueset where fvaluesettypeid = ?";

    public static Object queryOneData(Object[] params, queryType qt) {
        ValueSetDataCollection result = null;
        if (queryType.valueset == qt) {
            ValueSetDataCollection query_result = null;
            try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.ValueSetDao", (DBRoute)FAHCommonConstant.FI, (String)sql_query_valueset_head, (Object[])params);){
                for (Row row : queryDataSet) {
                    Long vstypeid = row.getLong("fstrucid");
                    FlexFieldGrpCfg FlexFieldGrpCfg2 = BaseFlexFieldDao.loadFlexFieldGrpCfg(new QFilter("id", "=", (Object)vstypeid), "fah_valueset_type");
                    query_result = new ValueSetDataCollection(row.getLong("fid"), row.getString("fnumber"), row.getString("fname"), (IValueSetMeta)FlexFieldGrpCfg2, null, null, row.getBoolean("fenable").booleanValue());
                    query_result.setCreator(row.getLong("fcreatorid"));
                    query_result.setCreatetime(row.getDate("fcreatetime"));
                }
            }
            if (query_result != null) {
                FlexFieldGrpCfg meta = (FlexFieldGrpCfg)query_result.getMeta();
                String[] setTypeSort = ValueSetUtil.getValueSetTypeSort((FlexFieldGrpCfg)meta);
                try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.ValueSetDao", (DBRoute)FAHCommonConstant.FI, (String)sql_query_valueset_line, (Object[])params);){
                    for (Row row : queryDataSet) {
                        SingleValueSetData query_row = new SingleValueSetData(row.getLong("fid"), row.getString("fnumber"), row.getString("fname"));
                        query_row.setMeta((IValueSetMeta)meta);
                        if (setTypeSort != null) {
                            int length = setTypeSort.length;
                            Object[] values = new Object[length];
                            for (int i = 0; i < length; ++i) {
                                values[i] = row.get(setTypeSort[i]);
                            }
                            query_row.setValues(values);
                        }
                        query_row.setEffectDate(row.getDate("feffectdate"));
                        query_row.setExpireDate(row.getDate("fexpiredate"));
                        query_row.setDescription(row.getString("fdescription"));
                        query_row.setEnable(row.getBoolean("fenable").booleanValue());
                        query_row.setSeq(row.getInteger("fseq").intValue());
                        query_result.getDataCol().add(query_row);
                    }
                }
            }
            result = query_result;
        } else if (queryType.valuesettype == qt) {
            // empty if block
        }
        return result;
    }

    public static boolean insertMappingData(Map<String, List<Object[]>> pre_insert_params_line, Map<String, Object[]> del_params_head, Map<String, List<Object[]>> del_params_line, Map<String, Object[]> insert_params_head, Map<String, List<Object[]>> insert_params_line, String clearTmpSql) {
        boolean result = false;
        try (TXHandle h = TX.required();){
            try {
                List splitbatch;
                Object param;
                String sql;
                if (pre_insert_params_line != null && !pre_insert_params_line.isEmpty()) {
                    for (Map.Entry<String, List<Object[]>> entry : pre_insert_params_line.entrySet()) {
                        sql = entry.getKey();
                        param = entry.getValue();
                        if (sql == null || param == null || param.size() <= 0) continue;
                        splitbatch = DapBuildVoucherCommonUtil.splitbatch((List)param, (int)2000);
                        for (List pms : splitbatch) {
                            ValueSetDao.executeBatchSql(FAHCommonConstant.FI, sql, pms);
                        }
                    }
                }
                if (!del_params_head.isEmpty()) {
                    for (Map.Entry<String, List<Object[]>> entry : del_params_head.entrySet()) {
                        sql = entry.getKey();
                        param = (Object[])entry.getValue();
                        if (sql == null || param == null) continue;
                        ValueSetDao.executeSql(FAHCommonConstant.FI, sql, (Object[])param);
                    }
                }
                if (!del_params_line.isEmpty()) {
                    for (Map.Entry<String, List<Object[]>> entry : del_params_line.entrySet()) {
                        sql = entry.getKey();
                        param = entry.getValue();
                        if (sql == null || param == null || param.size() <= 0) continue;
                        splitbatch = DapBuildVoucherCommonUtil.splitbatch((List)param, (int)2000);
                        for (List pms : splitbatch) {
                            ValueSetDao.executeBatchSql(FAHCommonConstant.FI, sql, pms);
                        }
                    }
                }
                if (!insert_params_head.isEmpty()) {
                    for (Map.Entry<String, List<Object[]>> entry : insert_params_head.entrySet()) {
                        sql = entry.getKey();
                        param = (Object[])entry.getValue();
                        if (sql == null || param == null) continue;
                        ValueSetDao.executeSql(FAHCommonConstant.FI, sql, (Object[])param);
                    }
                }
                if (!insert_params_line.isEmpty()) {
                    for (Map.Entry<String, List<Object[]>> entry : insert_params_line.entrySet()) {
                        sql = entry.getKey();
                        param = entry.getValue();
                        if (sql == null || param == null || param.size() <= 0) continue;
                        splitbatch = DapBuildVoucherCommonUtil.splitbatch((List)param, (int)2000);
                        for (List pms : splitbatch) {
                            ValueSetDao.executeBatchSql(FAHCommonConstant.FI, sql, pms);
                        }
                    }
                }
                if (clearTmpSql != null) {
                    DB.execute((DBRoute)FAHCommonConstant.FI, (String)clearTmpSql);
                }
                result = true;
            }
            catch (Exception e) {
                h.markRollback();
                logger.info("--FAH--insertMappingData:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return result;
    }

    public static boolean insertValueSetData(String headSql, Object[] param, String lineSql, List<Object[]> params, queryType qt) {
        boolean result = false;
        if (queryType.valueset == qt) {
            try (TXHandle h = TX.required();){
                try {
                    DB.execute((DBRoute)FAHCommonConstant.FI, (String)headSql, (Object[])param);
                    if (lineSql != null) {
                        List splitbatch = DapBuildVoucherCommonUtil.splitbatch(params, (int)2000);
                        for (List pms : splitbatch) {
                            ValueSetDao.executeBatchSql(FAHCommonConstant.FI, lineSql, pms);
                        }
                    }
                    result = true;
                }
                catch (Exception e) {
                    h.markRollback();
                    logger.info("--FAH--insertValueSetData:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        } else if (queryType.valuesettype == qt) {
            try (TXHandle h = TX.required();){
                try {
                    DB.execute((DBRoute)FAHCommonConstant.FI, (String)headSql, (Object[])param);
                    if (lineSql != null) {
                        DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)lineSql, params);
                    }
                    result = true;
                }
                catch (Exception e) {
                    h.markRollback();
                    logger.info("--FAH--insertValueSetData:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
        return result;
    }

    private static void executeBatchSql(DBRoute dbRoute, String sql, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)dbRoute, (String)sql, paramsList);
    }

    private static void executeSql(DBRoute dbRoute, String sql, Object[] param) {
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])param);
    }

    public static long[] genLongIds(String tableName, int size) {
        return DB.genLongIds((String)tableName, (int)size);
    }

    public static enum queryType {
        valueset,
        valuesettype;

    }
}

