/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.config.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.util.QFBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.event.DataChangeTypeEnum;
import kd.fi.v2.fah.dao.event.FahRegBillDao;
import kd.fi.v2.fah.event.DispatchFieldInfo;
import kd.fi.v2.fah.event.DispatchZoneFieldSettingInfo;
import kd.fi.v2.fah.event.DispatchZoneInfo;
import kd.fi.v2.fah.models.MappingValueTypeOrg;
import kd.fi.v2.fah.models.event.dispatch.ConditionField;
import kd.fi.v2.fah.models.event.dispatch.EventDispatchRuleData;
import kd.fi.v2.fah.models.event.dispatch.EventDispatchScheme;
import kd.fi.v2.fah.models.event.dispatch.EventDispatchSchemeCollection;
import kd.fi.v2.fah.models.event.dispatch.EventGenRuleGrp;
import kd.fi.v2.fah.models.event.dispatch.ValueZone;
import kd.fi.v2.fah.models.event.dispatch.ZoneLevel;
import kd.fi.v2.fah.storage.impl.BaseMutableArrayMapStorage;
import kd.fi.v2.fah.util.EventDispatchSchemeUtils;
import kd.fi.v2.fah.utils.FahDispatchSchemeUtils;
import kd.fi.v2.fah.utils.FahSerializeHelper;
import kd.fi.v2.fah.utils.StringUtils;

public class FahDispatchRuleDaoImpl {
    private static final Log logger = LogFactory.getLog(FahDispatchRuleDaoImpl.class);
    private static final String algoKey = "kd.fi.v2.fah.dao.config.event.FahDispatchRuleDaoImpl";

    public static void insertTempData(List<DispatchFieldInfo> cfg, Map<DataChangeTypeEnum, List<EventDispatchRuleData>> tempData) {
        if (tempData.isEmpty()) {
            return;
        }
        String insertSql = FahDispatchSchemeUtils.buildFahEventDispatchSchemeSql(cfg, (EventDispatchRuleData)((EventDispatchRuleData)((List)tempData.values().stream().filter(f -> !f.isEmpty()).iterator().next()).get(0)));
        String deleteSql = "delete from t_fah_evt_disp_rule_tmp where fid = ?";
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>(16);
        for (Map.Entry<DataChangeTypeEnum, List<EventDispatchRuleData>> entry : tempData.entrySet()) {
            EventDispatchRuleData data;
            Iterator<EventDispatchRuleData> iterator;
            DataChangeTypeEnum key = entry.getKey();
            Iterator value = entry.getValue();
            if (DataChangeTypeEnum.ADD != key) {
                iterator = value.iterator();
                while (iterator.hasNext()) {
                    data = iterator.next();
                    deleteParams.add(new Object[]{data.getId()});
                }
            }
            iterator = value.iterator();
            while (iterator.hasNext()) {
                data = iterator.next();
                int cfgSize = cfg == null ? 0 : cfg.size();
                int maxSize = data.getBaseTemProps().size() + cfgSize;
                Object[] param = new Object[maxSize];
                int index = 0;
                for (Map.Entry row : data.getBaseTemProps().entrySet()) {
                    param[index] = data.getValue((String)row.getKey());
                    ++index;
                }
                if (data.getInParamKey() != null) {
                    for (Object v : data.getInParamKey()) {
                        param[index] = v;
                        ++index;
                    }
                }
                while (maxSize > index) {
                    param[index] = "";
                    ++index;
                }
                insertParams.add(param);
            }
        }
        try (TXHandle h = TX.required();){
            try {
                List splitbatch;
                if (!deleteParams.isEmpty()) {
                    splitbatch = DapBuildVoucherCommonUtil.splitbatch(deleteParams, (int)2000);
                    for (List pms : splitbatch) {
                        FahDispatchRuleDaoImpl.executeBatchSql(FAHCommonConstant.FI, deleteSql, pms);
                    }
                }
                if (!insertParams.isEmpty()) {
                    splitbatch = DapBuildVoucherCommonUtil.splitbatch(insertParams, (int)2000);
                    for (List pms : splitbatch) {
                        FahDispatchRuleDaoImpl.executeBatchSql(FAHCommonConstant.FI, insertSql, pms);
                    }
                }
            }
            catch (Exception e) {
                h.markRollback();
                String err = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error("--FAH--insertMappingData: {}", (Object)err);
                throw new KDBizException("--FAH--insertMappingData: " + err);
            }
        }
    }

    private static void executeBatchSql(DBRoute dbRoute, String sql, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)dbRoute, (String)sql, paramsList);
    }

    public static void insertDisSchemaData(Long dispatchId, String batchId) {
        String insertSql = "INSERT INTO t_fah_evt_disp_rule (fid,forgid,fvaluezone,fdispgrp,fhashcode,fenable,fneedgenevt,feffectdate,fexpiredate,fserialnumber,fstatus,ftxtattr1,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr10,fdispatchid) select fid,forgid,fvaluezone,fdispgrp,fhashcode,fenable,fneedgenevt,feffectdate,fexpiredate,fserialnumber,fstatus,ftxtattr1,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr10,fdispatchid from t_fah_evt_disp_rule_tmp where fid = ?";
        String deleteSql = "delete from t_fah_evt_disp_rule where fid = ?";
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> deleteTemParams = new ArrayList<Object[]>(16);
        String querySql = "select fid,fchangetype from t_fah_evt_disp_rule_tmp where fdispatchid = " + dispatchId + " and fbatchid = '" + batchId + "'";
        String del_tem = "delete from t_fah_evt_disp_rule_tmp where fid = ?";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.event.FahEvenDispatchSchemeDao", (DBRoute)FAHCommonConstant.FI, (String)querySql);){
            for (Object row : queryDataSet) {
                Object ct = row.get("fchangetype");
                Long id = row.getLong("fid");
                deleteTemParams.add(new Object[]{id});
                if ("A".equals(ct)) {
                    insertParams.add(new Object[]{id});
                }
                if ("U".equals(ct)) {
                    insertParams.add(new Object[]{id});
                    deleteParams.add(new Object[]{id});
                }
                if (!"D".equals(ct)) continue;
                deleteParams.add(new Object[]{id});
            }
        }
        var10_10 = null;
        try (TXHandle h = TX.required();){
            try {
                List splitbatch;
                if (!deleteParams.isEmpty()) {
                    splitbatch = DapBuildVoucherCommonUtil.splitbatch(deleteParams, (int)2000);
                    for (List pms : splitbatch) {
                        FahDispatchRuleDaoImpl.executeBatchSql(FAHCommonConstant.FI, deleteSql, pms);
                    }
                }
                if (!insertParams.isEmpty()) {
                    splitbatch = DapBuildVoucherCommonUtil.splitbatch(insertParams, (int)2000);
                    for (List pms : splitbatch) {
                        FahDispatchRuleDaoImpl.executeBatchSql(FAHCommonConstant.FI, insertSql, pms);
                    }
                }
                if (!deleteTemParams.isEmpty()) {
                    splitbatch = DapBuildVoucherCommonUtil.splitbatch(deleteTemParams, (int)2000);
                    for (List pms : splitbatch) {
                        FahDispatchRuleDaoImpl.executeBatchSql(FAHCommonConstant.FI, del_tem, pms);
                    }
                }
            }
            catch (Exception e) {
                h.markRollback();
                String err = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error("--FAH--insertMappingData: {}", (Object)err);
                throw new KDBizException("--FAH--insertMappingData: " + err);
            }
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
    }

    public static DynamicObjectCollection queryDuplicateRecord(List<MappingValueTypeOrg> orgList, String billNo, Long masterId) {
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"fah_evt_dispatch_scheme", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)billNo)});
        List schemeIds = schemes.stream().filter(o -> masterId.longValue() != o.getLong("masterid")).map(o -> o.getLong("id")).collect(Collectors.toList());
        List orgids = orgList.stream().map(o -> (Long)o.getId()).collect(Collectors.toList());
        return QueryServiceHelper.query((String)"fah_valmap_type_org", (String)"maptype, ownorg.name, ownorg.number", (QFilter[])new QFilter[]{new QFilter("maptype", "in", schemeIds), new QFilter("ownorg", "in", orgids)});
    }

    public static EventDispatchSchemeCollection getEventDispatchSchemeCollection(String billType) {
        String billOrgValueSource = FahRegBillDao.querySrcOrg(billType);
        SqlBuilder sb = new SqlBuilder();
        sb.append("select t.fid,t.fnumber,a.fownorgid,a.fiscustom from t_fah_evt_disp_scheme t  join t_fah_valmap_type_org a on t.fid = a.fmaptypeid and t.fsourcebill = ? and t.fenable = '1'", new Object[]{billType});
        LinkedHashMap<Long, Long> disSchmeMap = new LinkedHashMap<Long, Long>();
        try (DataSet dataset = DB.queryDataSet((String)FahDispatchRuleDaoImpl.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                disSchmeMap.put(row.getLong("fownorgid"), row.getLong("fid"));
            }
        }
        if (null != billOrgValueSource && !disSchmeMap.isEmpty()) {
            EventDispatchSchemeCollection schemeCollection = new EventDispatchSchemeCollection();
            schemeCollection.setBillOrgValueSource(billOrgValueSource);
            schemeCollection.setSrcBillType(billType);
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)billType);
            schemeCollection.setPrimaryKey(entityType.getPrimaryKey().getName());
            schemeCollection.setOrgToDispatchScheme(disSchmeMap);
            return schemeCollection;
        }
        return null;
    }

    public static EventDispatchScheme getEventDispatchScheme(Long dispatchId) {
        EventDispatchScheme scheme = FahDispatchRuleDaoImpl.getDispatchScheme(dispatchId);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)scheme.getSrcBillType());
        scheme.setBillPkField(entityType.getPrimaryKey().getName());
        BillEntityType bnt = (BillEntityType)entityType;
        scheme.setBillNoField(bnt.getBillNo());
        Map<Long, EventGenRuleGrp> evtGenRuleMap = FahDispatchRuleDaoImpl.getEventGenRuleGrpMap(dispatchId);
        Map<String, List<EventDispatchRuleData>> evtRuleDataMap = FahDispatchRuleDaoImpl.getEvtRuleDataMap(dispatchId, scheme.getZoneFieldSettingInfo(), evtGenRuleMap);
        LinkedList<ValueZone> definedValueZones = new LinkedList<ValueZone>();
        if (scheme.getZoneFieldSettingInfo() != null) {
            for (DispatchZoneInfo zoneInfo : scheme.getZoneFieldSettingInfo()) {
                String definedZone = zoneInfo.getZone();
                ValueZone valueZone = new ValueZone();
                valueZone.setEntityName(definedZone);
                valueZone.setZoneLevel(FahDispatchRuleDaoImpl.getZoneLevel(scheme.getSrcBillType(), definedZone, entityType));
                LinkedHashMap<String, String> fieldAliasMap = new LinkedHashMap<String, String>(4);
                List<ConditionField> orgConditionFieldList = FahDispatchRuleDaoImpl.getConditionFieldMap(entityType, zoneInfo, definedZone, fieldAliasMap);
                valueZone.setOrgConditionFieldList(orgConditionFieldList);
                StringBuilder selectBuilder = new StringBuilder();
                StringBuilder orderBuilder = new StringBuilder();
                selectBuilder.append(scheme.getBillPkField()).append(" ").append("fid");
                selectBuilder.append(",").append(scheme.getBillNoField()).append(" ").append(scheme.getBillNoField());
                selectBuilder.append(",").append(scheme.getBillOrgValueSource()).append(" ").append("forgid");
                orderBuilder.append(scheme.getBillPkField());
                if (valueZone.getZoneLevel() == ZoneLevel.ENTRY) {
                    orderBuilder.append(",").append(definedZone).append(".id");
                    selectBuilder.append(",").append(definedZone).append(".id ").append("fentryid");
                } else if (valueZone.getZoneLevel() == ZoneLevel.SUB_ENTRY) {
                    String entryName = ((EntityType)entityType.getAllEntities().get(definedZone)).getParent().getName();
                    orderBuilder.append(",").append(entryName).append(".id");
                    orderBuilder.append(",").append(entryName).append(".").append(definedZone).append(".id ");
                    selectBuilder.append(",").append(entryName).append(".").append(definedZone).append(".id ").append("fdetaild");
                }
                for (Map.Entry entry : fieldAliasMap.entrySet()) {
                    selectBuilder.append(",").append((String)entry.getKey()).append(" ").append((String)entry.getValue());
                }
                valueZone.setSelector(selectBuilder.toString());
                valueZone.setOrderBy(orderBuilder.toString());
                LinkedHashMap<Long, BaseMutableArrayMapStorage> lookupRuleMap = new LinkedHashMap<Long, BaseMutableArrayMapStorage>();
                List<EventDispatchRuleData> list = evtRuleDataMap.get(definedZone);
                if (null != list) {
                    for (EventDispatchRuleData dispatchRuleData : list) {
                        lookupRuleMap.computeIfAbsent(dispatchRuleData.getOrgId(), k -> new BaseMutableArrayMapStorage()).add((Object)dispatchRuleData);
                    }
                }
                valueZone.setLookupRuleMap(lookupRuleMap);
                definedValueZones.add(valueZone);
            }
        }
        scheme.setDefinedValueZones(definedValueZones);
        return scheme;
    }

    public static List<ConditionField> getConditionFieldMap(MainEntityType entityType, DispatchZoneInfo zoneInfo, String definedZone, Map<String, String> fieldAliasMap) {
        LinkedList<ConditionField> orgConditionField = new LinkedList<ConditionField>();
        AtomicInteger index = new AtomicInteger(1);
        int seq = 1;
        if (zoneInfo.getEnable().booleanValue()) {
            for (DispatchFieldInfo fieldInfo : zoneInfo.getFieldSettings()) {
                String valueSource = fieldInfo.getFieldsource();
                String findSource = valueSource.split("\\.")[0];
                IDataEntityProperty property = entityType.findProperty(findSource);
                String fieldFullName = "";
                if (property.getParent() instanceof SubEntryType) {
                    fieldFullName = property.getParent().getParent().getName() + "." + property.getParent().getName() + "." + valueSource;
                } else if (property.getParent() instanceof EntryType) {
                    fieldFullName = property.getParent().getName() + "." + valueSource;
                } else if (property.getParent() instanceof MainEntityType) {
                    fieldFullName = valueSource;
                }
                String alias = fieldAliasMap.computeIfAbsent(fieldFullName, k -> "f" + index.getAndIncrement());
                ConditionField conditionField = new ConditionField(seq++, fieldInfo.getFieldname(), valueSource, alias);
                orgConditionField.add(conditionField);
            }
        }
        return orgConditionField;
    }

    public static ZoneLevel getZoneLevel(String srcBillType, String definedZone, MainEntityType entityType) {
        if (srcBillType.equals(definedZone)) {
            return ZoneLevel.BILL_HEAD;
        }
        EntityType type = (EntityType)entityType.getAllEntities().get(definedZone);
        if (type instanceof SubEntryType) {
            return ZoneLevel.SUB_ENTRY;
        }
        return ZoneLevel.ENTRY;
    }

    public static EventDispatchScheme getDispatchScheme(Long dispatchId) {
        EventDispatchScheme scheme = new EventDispatchScheme();
        SqlBuilder sb = new SqlBuilder();
        sb.append("select t.fid,t.fnumber,t.fsourcebill,t.fcreateorg,t.ffieldsetting from t_fah_evt_disp_scheme t where t.fid = ? and t.fenable = '1'", new Object[]{dispatchId});
        try (DataSet dataset = DB.queryDataSet((String)FahDispatchRuleDaoImpl.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                String billType = row.getString("fsourcebill");
                String billOrgValueSource = FahRegBillDao.querySrcOrg(billType);
                scheme.setSrcBillType(billType);
                scheme.setBillOrgValueSource(billOrgValueSource);
                scheme.setDefaultOrg(row.getLong("fcreateorg"));
                scheme.setId(row.getLong("fid"));
                scheme.setNumber(row.getString("fnumber"));
                String fieldsetting = row.getString("ffieldsetting");
                if (!StringUtils.isNotEmpty((String)fieldsetting)) continue;
                scheme.setZoneFieldSettingInfo((DispatchZoneFieldSettingInfo)FahSerializeHelper.fromJsonString((String)fieldsetting, DispatchZoneFieldSettingInfo.class));
            }
        }
        return scheme;
    }

    public static Map<String, List<EventDispatchRuleData>> getEvtRuleDataMap(Long dispatchId, DispatchZoneFieldSettingInfo zoneFieldSettingInfo, Map<Long, EventGenRuleGrp> evtGenRuleMap) {
        LinkedHashMap<String, List<EventDispatchRuleData>> evtRuleDataMap = new LinkedHashMap<String, List<EventDispatchRuleData>>();
        SqlBuilder evtDispCfgSb = new SqlBuilder();
        evtDispCfgSb.append("select fid,fdispatchid,forgid,fvaluezone,fdispgrp,fhashcode,fenable,fneedgenevt,feffectdate,fexpiredate,fserialnumber,fstatus,ftxtattr1,ftxtattr2,ftxtattr3,ftxtattr4,ftxtattr5,ftxtattr6,ftxtattr7,ftxtattr8,ftxtattr9,ftxtattr10 from t_fah_evt_disp_rule where fdispatchid = ? and fenable = '1' and fstatus = 'C'", new Object[]{dispatchId});
        ArrayList<Long> dirtyDataList = new ArrayList<Long>(8);
        try (DataSet dataset = DB.queryDataSet((String)FahDispatchRuleDaoImpl.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)evtDispCfgSb);){
            while (dataset.hasNext()) {
                EventDispatchRuleData eventRuleData = new EventDispatchRuleData();
                Row row = dataset.next();
                String valueZone = row.getString("fvaluezone");
                eventRuleData.setDispatchId(row.getLong("fdispatchid"));
                eventRuleData.setDispGrp(row.getLong("fdispgrp"));
                eventRuleData.setEffectDate(row.getDate("feffectdate"));
                eventRuleData.setExpireDate(row.getDate("fexpiredate"));
                eventRuleData.setOrgId(row.getLong("forgid"));
                eventRuleData.setNeedGenEvt(row.getString("fneedgenevt"));
                eventRuleData.setEnable(row.getString("fenable"));
                eventRuleData.setStatus(row.getString("fstatus"));
                DispatchZoneInfo zoneInfo = EventDispatchSchemeUtils.findZoneInfoByZone(valueZone, zoneFieldSettingInfo);
                if (null == zoneInfo) {
                    dirtyDataList.add(row.getLong("fid"));
                    continue;
                }
                LinkedList<String> fieldList = new LinkedList<String>();
                if (zoneInfo.getFieldSettings() != null) {
                    for (DispatchFieldInfo fieldInfo : zoneInfo.getFieldSettings()) {
                        fieldList.add(row.getString(fieldInfo.getDbfield()));
                    }
                }
                eventRuleData.setInParamKey(fieldList);
                eventRuleData.setEventGenRuleGrp(evtGenRuleMap.get(row.getLong("fdispgrp")));
                evtRuleDataMap.computeIfAbsent(valueZone, k -> new LinkedList()).add(eventRuleData);
            }
        }
        if (!dirtyDataList.isEmpty()) {
            logger.info("getEvtRuleDataMap has dirty data,[t_fah_evt_disp_rule] dispatchId: {}, dirtyDataList: {}", (Object)dispatchId, dirtyDataList);
        }
        return evtRuleDataMap;
    }

    public static Map<Long, EventGenRuleGrp> getEventGenRuleGrpMap(Long dispatchId) {
        LinkedHashMap<Long, EventGenRuleGrp> evtGenRuleMap = new LinkedHashMap<Long, EventGenRuleGrp>();
        SqlBuilder evtDispEnCfgSb = new SqlBuilder();
        evtDispEnCfgSb.append("select t.fid,t.fnumber,a.fevtgenruleid,a.fseq from t_fah_evt_disp_en t join t_fah_evt_disp_suben a on a.fid = t.fid and t.fdispatchid =? order by a.fentryid,a.fseq", new Object[]{dispatchId});
        try (DataSet dataset = DB.queryDataSet((String)FahDispatchRuleDaoImpl.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)evtDispEnCfgSb);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                EventGenRuleGrp ruleGrp = evtGenRuleMap.computeIfAbsent(row.getLong("fid"), k -> new EventGenRuleGrp());
                ruleGrp.setId(row.getLong("fid"));
                ruleGrp.setNumber(row.getString("fnumber"));
                ruleGrp.setDispatchId(dispatchId);
                List<Long> targeEvtRules = ruleGrp.getTargetEvtGenRules() == null ? new ArrayList() : ruleGrp.getTargetEvtGenRules();
                targeEvtRules.add(row.getLong("fevtgenruleid"));
                ruleGrp.setTargetEvtGenRules(targeEvtRules);
            }
        }
        return evtGenRuleMap;
    }

    public static DataSet queryRepeatedRecordsByHashCode(Long pkId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t2.fid, t2.fOrgId, t2.fValueZone, t2.fhashcode, t2.fserialnumber, t2.feffectdate, t2.fexpiredate, ", new Object[0]);
        sql.append("t2.ftxtattr1,t2.ftxtattr2,t2.ftxtattr3,t2.ftxtattr4,t2.ftxtattr5,t2.ftxtattr6,t2.ftxtattr7,t2.ftxtattr8,t2.ftxtattr9,t2.ftxtattr10 ", new Object[0]);
        sql.append("from t_fah_evt_disp_rule t2 inner join    (select t1.fhashcode, t1.fOrgId, t1.fValueZone        from t_fah_evt_disp_rule t1        where t1.fdispatchid = ? ", new Object[]{pkId}).append("and t1.fhashcode in (select th.fhashcode from t_fah_evt_disp_rule th where th.fstatus = 'A' and th.fdispatchid = ?) ", new Object[]{pkId}).append("group by t1.fhashcode, t1.fOrgId, t1.fValueZone having count(1) > 1 ) tp on t2.fOrgId = tp.fOrgId and t2.fhashcode = tp.fhashcode and t2.fValueZone = tp.fValueZone where t2.fdispatchid = ? ", new Object[]{pkId}).append("order by t2.fOrgId, t2.fValueZone, t2.fhashcode", new Object[0]);
        return DB.queryDataSet((String)"FahEvenDispatchSchemeDao.queryRepeatedRecordsByHashCode", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static void updateEntryCheckStatus(Long pkId, String status, Set<Long> orgSet, String valueZone, Set<Integer> serialNumbers) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("UPDATE t_fah_evt_disp_rule SET fstatus = ? ", new Object[]{status});
        sql.append("WHERE fdispatchid = ? ", new Object[]{pkId});
        sql.append("AND fstatus != ? ", new Object[]{status});
        if (orgSet != null) {
            sql.appendIn("AND forgid", orgSet.toArray());
        }
        if (valueZone != null) {
            sql.append("AND fvaluezone = ? ", new Object[]{valueZone});
        }
        if (serialNumbers != null) {
            sql.appendIn("AND fserialnumber", serialNumbers.toArray());
        }
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static void updateCheckStatus(Long pkId, String checkStatus) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("UPDATE t_fah_evt_disp_scheme SET fcheckstatus = ? ", new Object[]{checkStatus});
        sql.append(", flastchecktime = ? ", new Object[]{new Date()});
        sql.append("WHERE fid = ?", new Object[]{pkId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static List<Object> getUpdateablePKs(List<Object> ids, String enable) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fah_evt_dispatch_scheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)enable), new QFilter("id", "in", ids)});
        return query.stream().map(o -> o.get("id")).collect(Collectors.toList());
    }

    public static void switchEnable(List<Object> ids, String enable) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("update t_fah_evt_disp_scheme set fenable = ? ", new Object[]{enable});
        sb.appendIn("where fid ", ids);
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
    }

    public static List<String> getModelNumberById(List<Object> ids) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fah_evt_dispatch_scheme", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        return query.stream().map(o -> o.getString("number")).collect(Collectors.toList());
    }

    public static void deleteRuleByIds(List<Object> ids) {
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fah_evt_dispatch_scheme"), (Object[])ids.toArray());
    }

    public static Set<Long> querySchemeByUseableOrg(List<Object> orgIds) {
        QFBuilder qb = new QFBuilder();
        qb.add(new QFilter("ownorg", "in", orgIds));
        qb.add(new QFilter("targetbaseprop", "=", (Object)"fah_evt_dispatch_scheme"));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"fah_valmap_type_org", (String)"maptype", (QFilter[])qb.toArray());
        return collection.stream().map(o -> o.getLong("maptype")).collect(Collectors.toSet());
    }

    public static boolean isNumberExist(String number, Long masterId) {
        QFBuilder qb = new QFBuilder();
        qb.add(new QFilter("number", "=", (Object)number));
        qb.add(new QFilter("masterid", "!=", (Object)masterId));
        return QueryServiceHelper.exists((String)"fah_evt_dispatch_scheme", (QFilter[])qb.toArray());
    }

    public static boolean isExistData(Long pkId, Long orgId, String valueZone, String batchId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select count(1) as cnt from t_fah_evt_disp_rule where fDispatchId = ?", new Object[]{pkId});
        if (orgId != null) {
            sql.append(" and forgid = ?", new Object[]{orgId});
        }
        if (valueZone != null) {
            sql.append(" and fvaluezone = ?", new Object[]{valueZone});
        }
        try (DataSet dataSet = DB.queryDataSet((String)"FahEvenDispatchSchemeDao.isExistDataByOrgId", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sql);){
            int count;
            if (dataSet.hasNext() && (count = dataSet.next().getInteger("cnt").intValue()) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        SqlBuilder sql2 = new SqlBuilder();
        sql2.append("select count(1) as cnt from t_fah_evt_disp_rule_tmp where fDispatchId = ?", new Object[]{pkId});
        if (orgId != null) {
            sql2.append(" and forgid = ?", new Object[]{orgId});
        }
        if (valueZone != null) {
            sql2.append(" and fvaluezone = ?", new Object[]{valueZone});
        }
        sql2.append(" and fBatchId = ?", new Object[]{batchId});
        try (DataSet dataSet2 = DB.queryDataSet((String)"FahEvenDispatchSchemeDao.isExistDataByOrgId", (DBRoute)FAHCommonConstant.FI, (SqlBuilder)sql2);){
            int count;
            if (dataSet2.hasNext() && (count = dataSet2.next().getInteger("cnt").intValue()) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public static Map<String, Set<Integer>> queryTimeIllegalTempData(Long pkId, String batchId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fOrgId, fValueZone, fserialnumber from t_fah_evt_disp_rule_tmp where fDispatchId = ? ", new Object[]{pkId});
        sql.append("and fchangetype != 'D' ", new Object[0]);
        sql.append("and feffectdate is not null and fexpiredate is not null ", new Object[0]);
        sql.append("and feffectdate > fexpiredate and fBatchId = ?", new Object[]{batchId});
        sql.append(" order by fOrgId", new Object[0]);
        HashMap<String, Set<Integer>> result = new HashMap<String, Set<Integer>>();
        try (DataSet dataSet = DB.queryDataSet((String)"FahEvenDispatchSchemeDao.queryTimeIllegalTempData", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.computeIfAbsent(row.getLong("fOrgId") + "$" + row.getString("fValueZone"), k -> new HashSet()).add(row.getInteger("fserialnumber"));
            }
        }
        return result;
    }

    public static void deleteDataByDbFields(Long pkId, String zone, Set<String> delDbFieldSet) {
        StringBuilder sqlHead = new StringBuilder();
        sqlHead.append("UPDATE t_fah_evt_disp_rule SET ");
        for (String dbField : delDbFieldSet) {
            sqlHead.append(dbField).append(" = ' ', ");
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append(sqlHead.toString(), new Object[0]);
        sql.append("fstatus = ? ", new Object[]{"A"});
        sql.append("WHERE fDispatchId = ? ", new Object[]{pkId});
        sql.append("AND fValueZone = ?", new Object[]{zone});
        StringBuilder sqlHead2 = new StringBuilder();
        sqlHead2.append("UPDATE t_fah_evt_disp_rule_tmp SET ");
        for (String dbField : delDbFieldSet) {
            sqlHead2.append(dbField).append(" = ' ', ");
        }
        sqlHead2.deleteCharAt(sqlHead2.lastIndexOf(","));
        SqlBuilder sql2 = new SqlBuilder();
        sql2.append(sqlHead2.toString(), new Object[0]);
        sql2.append("WHERE fDispatchId = ? ", new Object[]{pkId});
        sql2.append("AND fValueZone = ?", new Object[]{zone});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql2);
    }

    public static void clearUnreferredSchemeEntryRec(Long pkId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct fdispgrp from t_fah_evt_disp_rule where fdispatchid = ?", new Object[]{pkId});
        LinkedList<Long> schemeEntryPkList = new LinkedList<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"clearUnreferredSchemeEntryRec_query", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                schemeEntryPkList.add(dataSet.next().getLong("fdispgrp"));
            }
        }
        if (!schemeEntryPkList.isEmpty()) {
            QFBuilder qfBuilder = new QFBuilder("id", "not in", schemeEntryPkList);
            qfBuilder.add("dispatchid", "=", (Object)pkId);
            DeleteServiceHelper.delete((String)"fah_evt_disp_en", (QFilter[])qfBuilder.toArray());
        }
    }

    public static Set<String> queryExistBySrcBill(Collection<String> srcBillTypes) {
        HashSet<String> hasSchemeSet = new HashSet<String>();
        QFilter qFilter = new QFilter("group", "in", srcBillTypes);
        try (DataSet rows = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fah_evt_dispatch_scheme", (String)"group", (QFilter[])qFilter.toArray(), null);){
            rows.distinct().forEach(row -> hasSchemeSet.add(row.getString("group")));
        }
        return hasSchemeSet;
    }

    public static void deleteDataByZoneAndDbFields(Long pkId, Set<String> deletedZoneSet, Map<String, Set<String>> deletedDBfield, String batchId) {
        for (String string : deletedZoneSet) {
            EventDispatchSchemeUtils.gengerateDeleteData(pkId, batchId, null, string);
        }
        for (Map.Entry entry : deletedDBfield.entrySet()) {
            FahDispatchRuleDaoImpl.deleteDataByDbFields(pkId, (String)entry.getKey(), (Set)entry.getValue());
        }
    }

    public static DataSet queryDataSet(Long pkId, String batchId, Long orgId, String valueZone, Set<Integer> serialNumSet, DispatchZoneInfo info) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT t1.fId id, t1.fDispatchId dispatchid, t1.fOrgId orgid, t1.fValueZone valuezone, t1.fDispGrp dispgrp, t1.fHashCode hashcode, t1.fEnable enable_en, t1.fneedgenevt need_gen_evt, t1.fEffectDate effectdate, t1.fExpireDate expiredate, t1.fSerialNumber serialnumber, t1.fstatus status", new Object[0]);
        if (info != null && info.getFieldSettings() != null && !info.getFieldSettings().isEmpty()) {
            for (DispatchFieldInfo cfg : info.getFieldSettings()) {
                sql.append(", ", new Object[0]).append(cfg.getDbfield(), new Object[0]).append(" ", new Object[0]).append(cfg.getDbfield(), new Object[0]);
            }
        }
        sql.append(" FROM t_fah_evt_disp_rule t1 where t1.fDispatchId = ?", new Object[]{pkId});
        if (StringUtils.isNotEmpty((String)valueZone)) {
            sql.append(" AND t1.fValueZone = ?", new Object[]{valueZone});
        }
        if (orgId != null) {
            sql.append(" AND t1.fOrgId = ?", new Object[]{orgId});
        }
        if (serialNumSet != null && !serialNumSet.isEmpty()) {
            sql.appendIn(" AND t1.fSerialNumber", serialNumSet.toArray());
        }
        sql.append("AND t1.fId not in ", new Object[0]);
        sql.append("(SELECT tmp.fId FROM t_fah_evt_disp_rule_tmp tmp WHERE tmp.fDispatchId = ?", new Object[]{pkId});
        sql.append(" AND tmp.fValueZone = ?", new Object[]{valueZone});
        sql.append(" AND tmp.fBatchId = ?", new Object[]{batchId});
        if (orgId != null) {
            sql.append(" AND tmp.fOrgId = ?", new Object[]{orgId});
        }
        sql.append(")", new Object[0]);
        sql.append(" UNION ", new Object[0]);
        sql.append("SELECT t2.fId id, t2.fDispatchId dispatchid, t2.fOrgId orgid, t2.fValueZone valuezone, t2.fDispGrp dispgrp, t2.fHashCode hashcode, t2.fEnable enable_en, t2.fneedgenevt need_gen_evt, t2.fEffectDate effectdate, t2.fExpireDate expiredate, t2.fSerialNumber serialnumber, t2.fstatus status", new Object[0]);
        if (info != null && info.getFieldSettings() != null && !info.getFieldSettings().isEmpty()) {
            for (DispatchFieldInfo cfg : info.getFieldSettings()) {
                sql.append(", ", new Object[0]).append(cfg.getDbfield(), new Object[0]).append(" ", new Object[0]).append(cfg.getDbfield(), new Object[0]);
            }
        }
        sql.append(" FROM t_fah_evt_disp_rule_tmp t2 where t2.fDispatchId = ?", new Object[]{pkId});
        sql.append(" AND t2.fBatchId = ?", new Object[]{batchId});
        sql.append(" AND t2.fChangeType != ?", new Object[]{Character.valueOf('D')});
        if (StringUtils.isNotEmpty((String)valueZone)) {
            sql.append(" AND t2.fValueZone = ?", new Object[]{valueZone});
        }
        if (orgId != null) {
            sql.append(" AND t2.fOrgId = ?", new Object[]{orgId});
        }
        if (serialNumSet != null && !serialNumSet.isEmpty()) {
            sql.appendIn(" AND t2.fSerialNumber", serialNumSet.toArray());
        }
        sql.append(" order by orgid, valuezone, serialnumber", new Object[0]);
        return DB.queryDataSet((String)"FahEvenDispatchSchemeDao.queryDataSet", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public static DispatchZoneFieldSettingInfo queryDispatchZoneFieldSettingInfo(Long pkId) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"fah_evt_dispatch_scheme", (String)"fieldsetting", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkId)});
        String fieldsetting = obj.getString("fieldsetting");
        if (StringUtils.isNotEmpty((String)fieldsetting)) {
            return (DispatchZoneFieldSettingInfo)FahSerializeHelper.fromJsonString((String)fieldsetting, DispatchZoneFieldSettingInfo.class);
        }
        return null;
    }
}

