/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.engine.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.cache.meta.BosMetaThreadLocalCacheService;
import kd.fi.v2.fah.dto.upstream.botp.BOTPQueryInParam;
import kd.fi.v2.fah.dto.upstream.botp.BOTPQueryResult;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;
import kd.fi.v2.fah.utils.ICommonDataValueUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class FahQueryUpStreamRecordDaoImpl {
    private static final String FIELD_FTID = "FTId";
    private static final String WHERE_FTID = "FTId = ? ";
    private static final String Query_Entity_Botp_TrackerTable = "SELECT FSId, FSTableId, FTId, FTTableId From %s Where ";
    private final BosMetaThreadLocalCacheService metaCacheService = BosMetaThreadLocalCacheService.getInstance();
    private static final FahQueryUpStreamRecordDaoImpl instance = new FahQueryUpStreamRecordDaoImpl();

    public static FahQueryUpStreamRecordDaoImpl getInstance() {
        return instance;
    }

    public BOTPQueryResult findBotpParentBills(BOTPQueryInParam queryParam) {
        if (queryParam == null) {
            return null;
        }
        long queryMainTableId = queryParam.getQueryEntityMetaTableId();
        Map<Long, String> lookupTargetTabs = queryParam.getLookupTargetEntityTypes();
        boolean matchSingleTarget = lookupTargetTabs.size() == 1;
        Long firstLookupTarget = lookupTargetTabs.keySet().iterator().next();
        boolean continueOnFoundLookupTarget = queryParam.isContinueOnFoundLookupTarget();
        HashMap<Long, Set> queryAllBillIds = new HashMap<Long, Set>(16);
        HashMap<Long, HashSet<Long>> queryBillBuffer = new HashMap<Long, HashSet<Long>>(16);
        queryBillBuffer.put(queryMainTableId, new HashSet<Long>(Arrays.asList(queryParam.getQueryBillIds())));
        HashMap<Long, Set> queryBillBuffer_cache = new HashMap<Long, Set>(16);
        HashMap<Long, List<PairTuple<Long, BFRowId>>> matchedResult = new HashMap<Long, List<PairTuple<Long, BFRowId>>>(queryParam.getQueryBillIds().length);
        HashMap<Long, Long> queryRecIdTrackerMap = new HashMap<Long, Long>(queryParam.getQueryBillIds().length);
        HashMap trackerMapBuf = new HashMap(queryParam.getQueryBillIds().length);
        for (Long id : queryParam.getQueryBillIds()) {
            queryRecIdTrackerMap.put(id, id);
        }
        LinkedList<Long> unmatchedResultIds = new LinkedList<Long>();
        int loopCnt = queryParam.getMaxRecursiveLayerCnt();
        while (!queryBillBuffer.isEmpty() && loopCnt > 0) {
            --loopCnt;
            for (Map.Entry entry : queryBillBuffer.entrySet()) {
                Map<Long, BFRowId> billLinkRows = this.readUpBillBFRows((Long)entry.getKey(), ((Set)entry.getValue()).toArray(new Long[0]));
                if (billLinkRows == null || billLinkRows.isEmpty()) continue;
                for (Map.Entry<Long, BFRowId> en : billLinkRows.entrySet()) {
                    BFRowId parentRow = en.getValue();
                    Long mainTableId = parentRow.getMainTableId();
                    Long billId = parentRow.getEntryId();
                    if (!queryAllBillIds.computeIfAbsent(mainTableId, v -> new HashSet(1)).add(billId)) continue;
                    if (matchSingleTarget ? ICommonDataValueUtil.isEquals((Object)firstLookupTarget, (Object)mainTableId) : lookupTargetTabs.containsKey(mainTableId)) {
                        matchedResult.computeIfAbsent(mainTableId, v -> new LinkedList()).add(new PairTuple(trackerMapBuf.get(billId), (Object)parentRow));
                        if (!continueOnFoundLookupTarget) {
                            continue;
                        }
                    } else {
                        trackerMapBuf.put(parentRow.getEntryId(), queryRecIdTrackerMap.remove(en.getKey()));
                    }
                    queryBillBuffer_cache.computeIfAbsent(mainTableId, v -> new HashSet(1)).add(billId);
                }
            }
            if (!queryRecIdTrackerMap.isEmpty()) {
                unmatchedResultIds.addAll(queryRecIdTrackerMap.values());
                queryRecIdTrackerMap.clear();
            }
            queryRecIdTrackerMap.putAll(trackerMapBuf);
            trackerMapBuf.clear();
            queryBillBuffer.clear();
            queryBillBuffer.putAll(queryBillBuffer_cache);
        }
        return new BOTPQueryResult(queryParam, matchedResult, unmatchedResultIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, BFRowId> readUpBillBFRows(Long targetMainTableId, Long[] targetBillIds) {
        if (targetBillIds == null || targetBillIds.length == 0) {
            return Collections.emptyMap();
        }
        TableDefine mainTableDefine = EntityMetadataCache.loadTableDefine((Long)targetMainTableId);
        if (mainTableDefine == null) {
            throw new IllegalArgumentException("Invalid TableID=" + targetMainTableId);
        }
        String entityNumber = mainTableDefine.getEntityNumber();
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityNumber);
        if (linkSet == null || StringUtils.isBlank((String)linkSet.getTrackerTable())) {
            return Collections.emptyMap();
        }
        SqlBuilder sBuilder = new SqlBuilder();
        sBuilder.append(String.format(Query_Entity_Botp_TrackerTable, linkSet.getTrackerTable()), new Object[0]);
        if (targetBillIds.length == 1) {
            sBuilder.append(WHERE_FTID, new Object[]{targetBillIds[0]});
        } else {
            sBuilder.appendIn(FIELD_FTID, (Object[])targetBillIds);
        }
        ResultSetHandler action = rs -> {
            HashMap<Long, BFRowId> resultMap = new HashMap<Long, BFRowId>(targetBillIds.length);
            while (rs.next()) {
                int idx = 1;
                Long sBillId = rs.getLong(idx++);
                Long sMainTableId = this.metaCacheService.loadMainTableId(Long.valueOf(rs.getLong(idx++)));
                Long tBillId = rs.getLong(idx++);
                Long tMainTableId = this.metaCacheService.loadMainTableId(Long.valueOf(rs.getLong(idx)));
                if (targetMainTableId.longValue() != tMainTableId.longValue()) continue;
                resultMap.put(tBillId, new BFRowId(sMainTableId, sBillId, sMainTableId, sBillId));
            }
            return resultMap;
        };
        MainEntityType mainType = this.metaCacheService.loadMainType(entityNumber);
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)mainType, (Object[])targetBillIds);
        if (ctx != null) {
            try {
                ctx.set();
                Map map = (Map)DB.query((DBRoute)new DBRoute(mainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
                return map;
            }
            finally {
                ctx.close();
            }
        }
        return (Map)DB.query((DBRoute)new DBRoute(mainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
    }

    public int queryRelatedBillRecords(String parentBillType, String parentEntryNum, String parentLinkFieldNum, Object[] childQueryParam, Function<Object[], Boolean> consumer, int top) {
        MainEntityType parentMainEntityType = EntityMetadataCache.getDataEntityType((String)parentBillType);
        LinkedList<String> selectedEntryPks = new LinkedList<String>();
        StringBuilder prefixBuf = new StringBuilder();
        if (StringUtils.isNotEmpty((String)parentEntryNum)) {
            FahEntityMetaHelper.travelAllParentEntity((MainEntityType)parentMainEntityType, (String)parentEntryNum, e -> {
                prefixBuf.append(e.getName()).append('.');
                selectedEntryPks.addFirst(prefixBuf + e.getPrimaryKey().getName());
            });
        }
        String selectField = prefixBuf + parentLinkFieldNum;
        QFilter filter = new QFilter(selectField, "in", Arrays.asList(childQueryParam));
        selectedEntryPks.add(parentMainEntityType.getPrimaryKey().getName());
        selectedEntryPks.addFirst(selectField);
        selectField = StringUtils.collectionToString(selectedEntryPks, (char)',');
        int recordCnt = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"FahQueryUpStreamRecordDao.queryRelatedBillRecords", (String)parentBillType, (String)selectField, (QFilter[])filter.toArray(), null, (int)top);){
            int length = selectedEntryPks.size();
            Object[] rowBuf = new Object[length];
            while (ds.hasNext()) {
                Row row = ds.next();
                for (int i = 0; i < length; ++i) {
                    rowBuf[i] = row.get(i);
                }
                ++recordCnt;
                if (consumer.apply(rowBuf).booleanValue()) continue;
                break;
            }
        }
        return recordCnt;
    }

    public int queryRelatedBillRecords(String parentBillType, String parentEntryNum, String parentLinkFieldNum, Object[] childQueryParam, Function<Object[], Boolean> consumer) {
        return this.queryRelatedBillRecords(parentBillType, parentEntryNum, parentLinkFieldNum, childQueryParam, consumer, -1);
    }
}

