/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.engine.dispatch;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.dao.sys.BaseDaoImpl;
import kd.fi.v2.fah.models.event.dispatch.EventDispatchSchemeCollection;
import kd.fi.v2.fah.utils.FahEntityMetaHelper;

public class FoundBillDispatchRuleDaoImpl
extends BaseDaoImpl {
    public static final FoundBillDispatchRuleDaoImpl instance = new FoundBillDispatchRuleDaoImpl();

    public Map<Long, Map<Long, List<Long>>> getDispatchBillIds(EventDispatchSchemeCollection eventDispatchSchemeCollection, Collection<Long> ids) {
        String select = String.join((CharSequence)",", eventDispatchSchemeCollection.getPrimaryKey(), eventDispatchSchemeCollection.getBillOrgValueSource());
        String mainEntityName = eventDispatchSchemeCollection.getSrcBillType();
        QFilter qFilter = FahEntityMetaHelper.buildPKFilter((String)mainEntityName, ids);
        if (qFilter == null) {
            throw new IllegalArgumentException(String.format("Invalid PK Filter: MainEntity=%s, PKs=%s", mainEntityName, ids));
        }
        if (eventDispatchSchemeCollection.getOrgToDispatchScheme().size() < 5000) {
            qFilter.and(new QFilter(eventDispatchSchemeCollection.getBillOrgValueSource(), "in", eventDispatchSchemeCollection.getOrgToDispatchScheme().keySet()));
        }
        Map orgToDispatchScheme = eventDispatchSchemeCollection.getOrgToDispatchScheme();
        String billOrgValueSource = eventDispatchSchemeCollection.getBillOrgValueSource();
        String primaryKey = eventDispatchSchemeCollection.getPrimaryKey();
        LinkedHashMap<Long, Map<Long, List<Long>>> orgDispatchBillIds = new LinkedHashMap<Long, Map<Long, List<Long>>>();
        this.queryDataSetEx(eventDispatchSchemeCollection.getSrcBillType(), select, qFilter.toArray(), (idx, row) -> {
            Long useOrgId = row.getLong(billOrgValueSource);
            Long dispatchId = (Long)orgToDispatchScheme.get(useOrgId);
            if (null != dispatchId) {
                orgDispatchBillIds.computeIfAbsent(dispatchId, k -> new LinkedHashMap()).computeIfAbsent(useOrgId, k -> new LinkedList()).add(row.getLong(primaryKey));
            }
            return true;
        }, null, -1);
        return orgDispatchBillIds;
    }

    public DataSet getDatasetForDispatch(String billType, String selector, String orderBy, String billPkField, Collection<Long> billIds) {
        return QueryServiceHelper.queryDataSet((String)"kd.fi.v2.fah.event.mservice.util.BuildEvtDataUtil.getDatasetForDispatch", (String)billType, (String)selector, (QFilter[])new QFilter(billPkField, "in", billIds).toArray(), (String)orderBy, (int)-1);
    }
}

