/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.engine.reverse;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.event.EventReverseStatusEnum;
import kd.fi.v2.fah.constant.enums.event.FahEventHeadField;
import kd.fi.v2.fah.constant.enums.event.FahEventLineField;
import kd.fi.v2.fah.constant.enums.xla.FahXLAHeadFormalField;
import kd.fi.v2.fah.constant.enums.xla.FahXLALineFormalField;
import kd.fi.v2.fah.sqlbuilder.CreateSqlBuilder;
import kd.fi.v2.fah.sqlbuilder.ISqlParamBuffer;
import kd.fi.v2.fah.sqlbuilder.impl.BaseInsertSqlBuilder;

public class ReverseBillDataTaskDaoImpl {
    public static Object[] getBillTypeAndBillIds(Long requestId) {
        Object[] billData;
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("Select batch.fBillType BillType, en.fSrcBillId SrcBillId from t_fah_task_batch_en en", new Object[0]);
        sqlBuilder.append("inner join t_fah_task_batch batch on batch.fid = en.fid ", new Object[0]);
        sqlBuilder.append("and batch.fRequestId = ? ", new Object[]{requestId});
        sqlBuilder.append("and en.fSrcBillId not in(select fail.fsrcbillid from t_fah_task_skip_bills fail where fail.frequestid = ? )", new Object[]{requestId});
        HashSet<Long> srcBillIds = new HashSet<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"ReverseBillDataTaskDao.getBillTypeAndBillIds", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            billData = new Object[2];
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billData[0] = row.getString("BillType");
                srcBillIds.add(row.getLong("SrcBillId"));
            }
            billData[1] = srcBillIds;
        }
        return billData;
    }

    public static Map<String, Set<Long>> getFailBillsInfo(Long requestId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("Select fBillType BillType, fSrcBillId SrcBillId from t_fah_task_fail_bills ", new Object[0]);
        sqlBuilder.append("where frequestid = ?", new Object[]{requestId});
        LinkedHashMap<String, Set<Long>> map = new LinkedHashMap<String, Set<Long>>();
        try (DataSet dataSet = DB.queryDataSet((String)"ReverseBillDataTaskDao.getFailBillsInfo", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                map.computeIfAbsent(row.getString("BillType"), k -> new HashSet()).add(row.getLong("SrcBillId"));
            }
        }
        return map;
    }

    public static Map<Long, Long>[] saveReverseEvent(String billType, Set<Long> srcBillIds, Long requestId) {
        BaseInsertSqlBuilder eventHeadBuilder = CreateSqlBuilder.createEventHead();
        ISqlParamBuffer eventHeadSqlParamBuffer = eventHeadBuilder.getSqlParamBuffer();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select ");
        Arrays.stream(FahEventHeadField.values()).forEach(v -> sqlBuilder.append(v.getNumber()).append(','));
        sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
        sqlBuilder.append(" from ").append("t_fah_event_header");
        SqlBuilder sql = new SqlBuilder();
        sql.append(sqlBuilder.toString(), new Object[0]);
        sql.appendIn(" where fsrc_billid  ", srcBillIds.toArray());
        sql.append("and fsrc_billtype =? ", new Object[]{billType});
        sql.append("and freversestatus =? ", new Object[]{EventReverseStatusEnum.DEFAULT.getCode()});
        sql.append("and fstatus =? ", new Object[]{"4"});
        HashMap<Long, Long> eventHeadIdMap = new HashMap<Long, Long>(16);
        try (DataSet eventHeads = DB.queryDataSet((String)"ReverseBillDataTaskDao.saveReverseEvent", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            Long reverseId = null;
            Long eventID = null;
            while (eventHeads.hasNext()) {
                Row eventHead = eventHeads.next();
                eventHeadBuilder.moveToNextParamRow(eventHeadSqlParamBuffer);
                block32: for (FahEventHeadField field : FahEventHeadField.values()) {
                    String fieldNumber = field.getNumber();
                    Object value = eventHead.get(fieldNumber);
                    int index = field.ordinal();
                    switch (field) {
                        case FID: {
                            eventID = (Long)value;
                            reverseId = DB.genLongId((String)"t_fah_event_header");
                            eventHeadIdMap.put((Long)value, reverseId);
                            eventHeadSqlParamBuffer.set(index, (Object)reverseId);
                            continue block32;
                        }
                        case FNUMBER: {
                            eventHeadSqlParamBuffer.set(index, (Object)("R-" + value));
                            continue block32;
                        }
                        case FREVERSESTATUS: {
                            eventHeadSqlParamBuffer.set(index, (Object)EventReverseStatusEnum.REVERSE_EVENT.getCode());
                            continue block32;
                        }
                        case FRELATEID: {
                            eventHeadSqlParamBuffer.set(index, (Object)eventID);
                            continue block32;
                        }
                        case FISPREVIEW: {
                            eventHeadSqlParamBuffer.set(index, (Object)"2");
                            continue block32;
                        }
                        case FREQUESTID: {
                            eventHeadSqlParamBuffer.set(index, (Object)requestId);
                            continue block32;
                        }
                        default: {
                            eventHeadSqlParamBuffer.set(index, value);
                        }
                    }
                }
            }
        }
        eventHeadBuilder.completeAndPack();
        Iterator it = eventHeadBuilder.getSqlParams(3000);
        while (it.hasNext()) {
            ReverseBillDataTaskDaoImpl.insertData(eventHeadBuilder.buildSqlStatement(new Object[0]).toString(), new ArrayList<Object[]>((Collection)it.next()));
        }
        BaseInsertSqlBuilder eventLineBuilder = CreateSqlBuilder.createEventLine();
        ISqlParamBuffer eventLineSqlParamBuffer = eventLineBuilder.getSqlParamBuffer();
        StringBuilder lineSqlBuilder = new StringBuilder();
        lineSqlBuilder.append("select ");
        Arrays.stream(FahEventLineField.values()).forEach(v -> lineSqlBuilder.append(v.getNumber()).append(","));
        lineSqlBuilder.deleteCharAt(lineSqlBuilder.lastIndexOf(","));
        lineSqlBuilder.append(" from ").append("t_fah_event_line");
        SqlBuilder lineSql = new SqlBuilder();
        lineSql.append(lineSqlBuilder.toString(), new Object[0]);
        lineSql.appendIn(" where fid  ", (Object[])eventHeadIdMap.keySet().toArray(new Long[0]));
        HashMap<Long, Long> eventLineIdMap = new HashMap<Long, Long>(16);
        try (DataSet eventLines = DB.queryDataSet((String)"ReverseBillDataTaskDao.saveReverseEvent", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)lineSql);){
            while (eventLines.hasNext()) {
                Row eventLine = eventLines.next();
                eventLineBuilder.moveToNextParamRow(eventLineSqlParamBuffer);
                block35: for (FahEventLineField field : FahEventLineField.values()) {
                    String fieldNumber = field.getNumber();
                    Object value = eventLine.get(fieldNumber);
                    int index = field.ordinal();
                    switch (field) {
                        case FID: {
                            eventLineSqlParamBuffer.set(index, eventHeadIdMap.get(value));
                            continue block35;
                        }
                        case FENTRYID: {
                            Long reverseLineId = DB.genLongId((String)"t_fah_event_line");
                            eventLineIdMap.put((Long)value, reverseLineId);
                            eventLineSqlParamBuffer.set(index, (Object)reverseLineId);
                            continue block35;
                        }
                        case FAMOUNT: {
                            eventLineSqlParamBuffer.set(index, (Object)((BigDecimal)value).negate());
                            continue block35;
                        }
                        default: {
                            eventLineSqlParamBuffer.set(index, value);
                        }
                    }
                }
            }
        }
        eventLineBuilder.completeAndPack();
        Iterator line = eventLineBuilder.getSqlParams(3000);
        while (line.hasNext()) {
            ReverseBillDataTaskDaoImpl.insertData(eventLineBuilder.buildSqlStatement(new Object[0]).toString(), new ArrayList<Object[]>((Collection)line.next()));
        }
        return new Map[]{eventHeadIdMap, eventLineIdMap};
    }

    private static void insertData(String sql, List<Object[]> params) {
        try (TXHandle h = TX.requiresNew();){
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sql, params);
        }
    }

    public static Set<Long> saveReverseXla(String billType, Set<Long> srcBillIds, Map<Long, Long>[] eventDataIdMap, Long requestId) {
        HashSet<Long> xlaHeadIds = new HashSet<Long>();
        BaseInsertSqlBuilder xlaHeadBuilder = CreateSqlBuilder.createXLAFormalHead();
        ISqlParamBuffer xlaHeadSqlParamBuffer = xlaHeadBuilder.getSqlParamBuffer();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select ");
        Arrays.stream(FahXLAHeadFormalField.values()).forEach(v -> sqlBuilder.append(v.getNumber()).append(','));
        sqlBuilder.deleteCharAt(sqlBuilder.lastIndexOf(","));
        sqlBuilder.append(" from ").append("t_fah_ae_headers");
        SqlBuilder sql = new SqlBuilder();
        sql.append(sqlBuilder.toString(), new Object[0]);
        sql.appendIn(" where fsrc_billid  ", srcBillIds.toArray());
        sql.append("and fsrc_billtype =? ", new Object[]{billType});
        sql.append("and freversestatus =? ", new Object[]{EventReverseStatusEnum.DEFAULT.getCode()});
        sql.append("and fstatus =? ", new Object[]{"4"});
        HashMap<Long, Long> xlaHeadIdMap = new HashMap<Long, Long>(16);
        try (DataSet xlaHeads = DB.queryDataSet((String)"ReverseBillDataTaskDao.saveReverseXla", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            Map<Long, Long> eventHeadId = eventDataIdMap[0];
            Long xlaHeadID = null;
            while (xlaHeads.hasNext()) {
                Row xlaHead = xlaHeads.next();
                xlaHeadBuilder.moveToNextParamRow(xlaHeadSqlParamBuffer);
                block34: for (FahXLAHeadFormalField field : FahXLAHeadFormalField.values()) {
                    Object value = xlaHead.get(field.getNumber());
                    int index = field.ordinal();
                    switch (field) {
                        case FID: {
                            xlaHeadID = (Long)value;
                            Long reversexlaHeadId = DB.genLongId((String)"t_fah_ae_headers");
                            xlaHeadIdMap.put(xlaHeadID, reversexlaHeadId);
                            xlaHeadSqlParamBuffer.set(index, (Object)reversexlaHeadId);
                            continue block34;
                        }
                        case FLOC_CREDITAMT: 
                        case FLOC_DEBITAMT: {
                            xlaHeadSqlParamBuffer.set(index, (Object)((BigDecimal)value).negate());
                            continue block34;
                        }
                        case FNUMBER: {
                            xlaHeadSqlParamBuffer.set(index, (Object)("R-" + value));
                            continue block34;
                        }
                        case FSRCEVENTID: {
                            xlaHeadSqlParamBuffer.set(index, (Object)eventHeadId.get(value));
                            continue block34;
                        }
                        case FRELATEID: {
                            xlaHeadSqlParamBuffer.set(index, (Object)xlaHeadID);
                            continue block34;
                        }
                        case FREVERSESTATUS: {
                            xlaHeadSqlParamBuffer.set(index, (Object)EventReverseStatusEnum.REVERSE_EVENT.getCode());
                            continue block34;
                        }
                        case FREQUESTID: {
                            xlaHeadSqlParamBuffer.set(index, (Object)requestId);
                            continue block34;
                        }
                        case FMERGERULEID: {
                            xlaHeadSqlParamBuffer.set(index, (Object)0L);
                            continue block34;
                        }
                        default: {
                            xlaHeadSqlParamBuffer.set(index, value);
                        }
                    }
                }
            }
        }
        xlaHeadBuilder.completeAndPack();
        Iterator it = xlaHeadBuilder.getSqlParams(3000);
        while (it.hasNext()) {
            ReverseBillDataTaskDaoImpl.insertData(xlaHeadBuilder.buildSqlStatement(new Object[0]).toString(), new ArrayList<Object[]>((Collection)it.next()));
        }
        BaseInsertSqlBuilder xlaLineBuilder = CreateSqlBuilder.createXLAFormalLine();
        ISqlParamBuffer xlaLineParamBuffer = xlaLineBuilder.getSqlParamBuffer();
        StringBuilder lineSqlBuilder = new StringBuilder();
        lineSqlBuilder.append("select ");
        Arrays.stream(FahXLALineFormalField.values()).forEach(v -> lineSqlBuilder.append(v.getNumber()).append(","));
        lineSqlBuilder.deleteCharAt(lineSqlBuilder.lastIndexOf(","));
        lineSqlBuilder.append(" from ").append("t_fah_ae_lines");
        SqlBuilder lineSql = new SqlBuilder();
        lineSql.append(lineSqlBuilder.toString(), new Object[0]);
        lineSql.appendIn(" where fid  ", (Object[])xlaHeadIdMap.keySet().toArray(new Long[0]));
        try (DataSet xlaLines = DB.queryDataSet((String)"ReverseBillDataTaskDao.saveReverseXla", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)lineSql);){
            Map<Long, Long> eventLineId = eventDataIdMap[1];
            while (xlaLines.hasNext()) {
                Row xlaLine = xlaLines.next();
                xlaLineBuilder.moveToNextParamRow(xlaLineParamBuffer);
                block37: for (FahXLALineFormalField field : FahXLALineFormalField.values()) {
                    Object value = xlaLine.get(field.getNumber());
                    int index = field.ordinal();
                    switch (field) {
                        case FID: {
                            xlaLineParamBuffer.set(index, xlaHeadIdMap.get(value));
                            continue block37;
                        }
                        case FMAINCF_AMOUNT: 
                        case FSUPCF_AMOUNT: 
                        case FORI_CREDIT: 
                        case FORI_DEBIT: 
                        case FLOCAL_CREDIT: 
                        case FLOCAL_DEBIT: 
                        case FQUANTITY: {
                            xlaLineParamBuffer.set(index, (Object)((BigDecimal)value).negate());
                            continue block37;
                        }
                        case FSRC_EVENTLINEID: {
                            xlaLineParamBuffer.set(index, (Object)eventLineId.get(value));
                            continue block37;
                        }
                        default: {
                            xlaLineParamBuffer.set(index, value);
                        }
                    }
                }
            }
        }
        xlaLineBuilder.completeAndPack();
        Iterator line = xlaLineBuilder.getSqlParams(3000);
        while (line.hasNext()) {
            ReverseBillDataTaskDaoImpl.insertData(xlaLineBuilder.buildSqlStatement(new Object[0]).toString(), new ArrayList<Object[]>((Collection)line.next()));
        }
        return xlaHeadIds;
    }

    public static Map<String, Set<Long>> getCheckBillIds(Set<Long> srcBillIds, Long requestId) {
        HashMap<String, Set<Long>> returnData = new HashMap<String, Set<Long>>(4);
        HashSet<Long> successIDs = new HashSet<Long>(8);
        HashSet<Long> noValidateBillIDs = new HashSet<Long>(srcBillIds);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fsrc_billid, fOrgId, fPeriodId from t_fah_ae_headers h where exists (", new Object[0]);
        sqlBuilder.append(" select 1 from t_fah_evt_tracker tracker", new Object[0]);
        sqlBuilder.append(" inner join (", new Object[0]);
        sqlBuilder.append(" select batch.fBillType, en.fSrcBillId from t_fah_task_batch_en en", new Object[0]);
        sqlBuilder.append(" inner join t_fah_task_batch batch on batch.fid = en.fid", new Object[0]);
        sqlBuilder.append(" and batch.frequestid = ? ", new Object[]{requestId});
        sqlBuilder.append(") res on res.fBillType = tracker.fSrc_BillType and tracker.fSrc_BillId = res.fSrcBillId", new Object[0]);
        sqlBuilder.append(" where tracker.fXLA_Header_Id = h.fid", new Object[0]);
        sqlBuilder.append(" and tracker.fReverseFlag = ? ", new Object[]{EventReverseStatusEnum.DEFAULT.getCode()});
        sqlBuilder.append(" and tracker.fstatus = ? )", new Object[]{"4"});
        sqlBuilder.append(" and h.fstatus = ? ", new Object[]{"4"});
        try (DataSet dataSet = DB.queryDataSet((String)"ReverseBillDataTaskDao.getCheckBillIds", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long billId = row.getLong("fsrc_billid");
                successIDs.add(billId);
            }
            noValidateBillIDs.removeAll(successIDs);
        }
        returnData.put("ERROR", noValidateBillIDs);
        returnData.put("SUCCESS", successIDs);
        return returnData;
    }

    public static void updateTracker(Long requestId, String billType, Set<Long> srcBillIds) {
        try (TXHandle h = TX.requiresNew();){
            ReverseBillDataTaskDaoImpl.updateEvtTracker(billType, srcBillIds);
            ReverseBillDataTaskDaoImpl.updateAeHeaders(requestId, billType, srcBillIds);
            ReverseBillDataTaskDaoImpl.updateEventHeaders(requestId, billType, srcBillIds);
        }
    }

    private static void updateEvtTracker(String billType, Set<Long> srcBillIds) {
        SqlBuilder updateSql = new SqlBuilder();
        updateSql.append("Update t_fah_evt_tracker set fReverseFlag = ?", new Object[]{EventReverseStatusEnum.REVERSED.getCode()});
        updateSql.append("Where fSrc_BillType = ?", new Object[]{billType}).appendIn(" and fSrc_BillId ", srcBillIds.toArray()).append("and fReverseFlag =?", new Object[]{EventReverseStatusEnum.DEFAULT.getCode()}).append("and fstatus =?", new Object[]{"4"});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)updateSql);
        updateSql = new SqlBuilder();
        updateSql.append("Update t_fah_evt_tracker_en set fReverseFlag = ?", new Object[]{EventReverseStatusEnum.REVERSED.getCode()});
        updateSql.append("Where fSrc_BillType = ?", new Object[]{billType}).appendIn(" and fSrc_BillId ", srcBillIds.toArray()).append("and fReverseFlag =?", new Object[]{EventReverseStatusEnum.DEFAULT.getCode()});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)updateSql);
    }

    private static void updateAeHeaders(Long requestId, String billType, Set<Long> srcBillIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fid, frelateid FROM t_fah_ae_headers", new Object[0]);
        sql.append(" where frequestId =?", new Object[]{requestId});
        sql.append(" and fstatus =?", new Object[]{"4"});
        sql.append(" and fsrc_billtype =?", new Object[]{billType}).appendIn(" and fsrc_billid ", srcBillIds.toArray());
        LinkedHashMap<Long, Long> aeHeadersMap = new LinkedHashMap<Long, Long>();
        DataSet dataSet = DB.queryDataSet((String)"ReverseBillDataTaskDao.updateAeHeaders", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                aeHeadersMap.put(row.getLong("fid"), row.getLong("frelateid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        LinkedList<Object[]> paramList = new LinkedList<Object[]>();
        for (Map.Entry entry : aeHeadersMap.entrySet()) {
            paramList.add(new Object[]{EventReverseStatusEnum.REVERSED.getCode(), entry.getKey(), entry.getValue()});
        }
        if (!paramList.isEmpty()) {
            StringBuilder updateSql = new StringBuilder();
            updateSql.append("Update t_fah_ae_headers set freversestatus = ?");
            updateSql.append(", frelateid = ?");
            updateSql.append("Where fid = ?");
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateSql.toString(), paramList);
        }
    }

    private static void updateEventHeaders(Long requestId, String billType, Set<Long> srcBillIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fid, frelateid FROM t_fah_event_header", new Object[0]);
        sql.append(" where frequestId =?", new Object[]{requestId});
        sql.append(" and fsrc_billtype =?", new Object[]{billType}).appendIn(" and fsrc_billid ", srcBillIds.toArray()).append("and fstatus = ?", new Object[]{"4"});
        LinkedHashMap<Long, Long> eventHeadersMap = new LinkedHashMap<Long, Long>();
        DataSet dataSet = DB.queryDataSet((String)"ReverseBillDataTaskDao.updateEventHeaders", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
        Object object = null;
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                eventHeadersMap.put(row.getLong("fid"), row.getLong("frelateid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        LinkedList<Object[]> paramList = new LinkedList<Object[]>();
        for (Map.Entry entry : eventHeadersMap.entrySet()) {
            paramList.add(new Object[]{EventReverseStatusEnum.REVERSED.getCode(), entry.getKey(), "0", entry.getValue()});
        }
        if (!paramList.isEmpty()) {
            StringBuilder upDateSql = new StringBuilder();
            upDateSql.append("Update t_fah_event_header set freversestatus = ?");
            upDateSql.append(",frelateid = ?").append(",fispreview = ?");
            upDateSql.append("Where fid = ?");
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)upDateSql.toString(), paramList);
        }
    }

    public static void rebackCurrTaskXla(Long requestId, String billType, Set<Long> failSet) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT fid,fsrceventid FROM t_fah_ae_headers", new Object[0]);
        sql.append(" where frequestId =?", new Object[]{requestId});
        sql.append(" where fstatus =?", new Object[]{"4"});
        sql.append(" and fsrc_billtype =?", new Object[]{billType}).appendIn(" and fsrc_billid ", failSet.toArray());
        HashSet<Long> xlaHeadIds = new HashSet<Long>();
        HashSet<Long> eventHeadIds = new HashSet<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"ReverseBillDataTaskDao.updateAndInsertTracker", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                xlaHeadIds.add(row.getLong("fid"));
                eventHeadIds.add(row.getLong("fsrceventid"));
            }
        }
        if (!xlaHeadIds.isEmpty() && !eventHeadIds.isEmpty()) {
            SqlBuilder deleteHead = new SqlBuilder();
            deleteHead.appendIn("DELETE  FROM t_fah_ae_headers where fid ", xlaHeadIds.toArray());
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteHead);
            SqlBuilder deleteLine = new SqlBuilder();
            deleteLine.appendIn("DELETE  FROM t_fah_ae_lines where fid ", xlaHeadIds.toArray());
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteLine);
            SqlBuilder deleteEvtHead = new SqlBuilder();
            deleteEvtHead.appendIn("DELETE  FROM t_fah_event_header where fid ", eventHeadIds.toArray());
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteEvtHead);
            SqlBuilder deleteEvtLine = new SqlBuilder();
            deleteEvtLine.appendIn("DELETE  FROM t_fah_event_line where fid ", eventHeadIds.toArray());
            DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteEvtLine);
        }
    }

    public static void reBackCurrentTaskData(Long requestId) {
        SqlBuilder deleteLine = new SqlBuilder();
        deleteLine.append("DELETE  FROM t_fah_ae_lines where fid in (", new Object[0]);
        deleteLine.append("select fid from t_fah_ae_headers where fstatus = '4' and frequestId = ? )", new Object[]{requestId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteLine);
        SqlBuilder deleteHead = new SqlBuilder();
        deleteHead.append("DELETE  FROM t_fah_ae_headers where fstatus = '4' and frequestId = ?", new Object[]{requestId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteHead);
        SqlBuilder deleteEvtLine = new SqlBuilder();
        deleteEvtLine.append("DELETE  FROM t_fah_event_line where fid in (", new Object[0]);
        deleteEvtLine.append("select fid from t_fah_event_header where fstatus = '4' and  frequestId = ? )", new Object[]{requestId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteEvtLine);
        SqlBuilder deleteEvtHead = new SqlBuilder();
        deleteEvtHead.append("DELETE  FROM t_fah_event_header where fstatus = '4' and  frequestId = ?", new Object[]{requestId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)deleteEvtHead);
    }

    public static PairTuple<Map<String, Set<Long>>, Map<String, Set<Long>>> queryFailBillTypeAndBillIdsMap(long requestId, boolean isException) {
        HashMap<String, Set> postGlMap = new HashMap<String, Set>(8);
        HashMap<String, Set> noNeedPostGlMap = new HashMap<String, Set>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fsrc_billtype,fsrc_billid,fgl_header_id,fsrc_systype from t_fah_evt_tracker a ", new Object[0]);
        sqlBuilder.append(" inner join ( ", new Object[0]);
        if (isException) {
            sqlBuilder.append(" select d.fbilltype,c.fsrcbillid from t_fah_task_batch_en c inner join t_fah_task_batch d on c.fid = d.fid ", new Object[0]);
            sqlBuilder.append(" where not exists (select 1 from  t_fah_task_skip_bills e where ", new Object[0]);
            sqlBuilder.append(" e.frequestid = ? ", new Object[]{requestId});
            sqlBuilder.append(" and e.fbilltype = d.fbilltype and e.fsrcbillid = c.fsrcbillid) ", new Object[0]);
            sqlBuilder.append(" and d.frequestid = ? ", new Object[]{requestId});
        } else {
            sqlBuilder.append(" select fbilltype, fsrcbillid from t_fah_task_fail_bills f where ", new Object[0]);
            sqlBuilder.append(" f.frequestid = ? ", new Object[]{requestId});
        }
        sqlBuilder.append(" ) b on a.fSrc_BillType = b.fbilltype and  a.fsrc_billid = b.fsrcbillid ", new Object[0]);
        sqlBuilder.append(" where a.fReverseFlag = ? ", new Object[]{EventReverseStatusEnum.DEFAULT.getCode()});
        sqlBuilder.append(" and a.fstatus = ? ", new Object[]{"4"});
        try (DataSet dataSet = DB.queryDataSet((String)"EventTrackerDao.querySuccessBillTypeAndBillIdsMap", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String billType = row.getString("fsrc_billtype");
                Long billId = row.getLong("fsrc_billid");
                Long vchId = row.getLong("fgl_header_id");
                String srcSysType = row.getString("fsrc_systype");
                if ("0".equals(srcSysType) || "1".equals(srcSysType)) {
                    postGlMap.computeIfAbsent(billType, k -> new HashSet(8)).add(billId);
                    continue;
                }
                noNeedPostGlMap.computeIfAbsent(billType, k -> new HashSet(8)).add(billId);
            }
        }
        return new PairTuple(postGlMap, noNeedPostGlMap);
    }
}

