/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.FAHCommonConstant;

public class EventTrackerDao {
    public static Map<Long, String> queryGLVchByXlaIds(List<Object> xlaIds) {
        if (null == xlaIds || xlaIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> map = new HashMap<Long, String>(xlaIds.size());
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid,fnumber from t_gl_voucher where fid in (select fgl_header_id from t_fah_evt_tracker where ", new Object[0]).append("fstatus = ?", new Object[]{"4"}).appendIn(" and fxla_header_id", xlaIds).append(")", new Object[0]);
        try (DataSet rows = DB.queryDataSet((String)"EventDao.queryGLVchByXlaId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (rows.hasNext()) {
                Row row = rows.next();
                map.put(row.getLong("fid"), row.getString("fnumber"));
            }
        }
        return map;
    }

    public static Long queryGLVchIdByXlaId(Long xlaId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fgl_header_id from t_fah_evt_tracker where ", new Object[0]);
        sql.append("fxla_header_id=?", new Object[]{xlaId});
        sql.append(" and fstatus=?", new Object[]{"4"});
        try (DataSet dataSet = DB.queryDataSet((String)"EventDao.queryGLVchIdByXlaId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            if (dataSet.hasNext()) {
                Long l = dataSet.next().getLong("fgl_header_id");
                return l;
            }
            Long l = null;
            return l;
        }
    }

    public static Map<Long, Long> queryGLHeaderId(Long requestId) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select tracker.fGL_Header_Id fGL_Header_Id,voucher.forgid forgid from ", new Object[0]).append("t_fah_evt_tracker", new Object[0]);
        sqlBuilder.append("tracker inner join T_GL_VOUCHER voucher on voucher.fid=tracker.fGL_Header_Id", new Object[0]).append("where tracker.frequestId=?", new Object[]{requestId});
        HashMap<Long, Long> gLHeaderIds = new HashMap<Long, Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"EventDao.queryGLHeaderId", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                gLHeaderIds.put(row.getLong("fGL_Header_Id"), row.getLong("forgid"));
            }
        }
        return gLHeaderIds;
    }

    public static PairTuple<Map<String, Map<Long, Set<Long>>>, Map<String, Set<Long>>> querySuccessBillTypeAndBillIdsMap(long requestId) {
        HashMap<String, Map> postGlMap = new HashMap<String, Map>(8);
        HashMap<String, Set> noNeedPostGlMap = new HashMap<String, Set>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fsrc_billtype,fsrc_billid,fgl_header_id,fsrc_systype from t_fah_evt_tracker where", new Object[0]);
        sqlBuilder.append("frequestid = ?", new Object[]{requestId});
        sqlBuilder.append(" and fstatus = ?", new Object[]{"4"});
        try (DataSet dataSet = DB.queryDataSet((String)"EventTrackerDao.querySuccessBillTypeAndBillIdsMap", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String billType = row.getString("fsrc_billtype");
                Long billId = row.getLong("fsrc_billid");
                Long vchId = row.getLong("fgl_header_id");
                String srcSysType = row.getString("fsrc_systype");
                if ("0".equals(srcSysType) || "1".equals(srcSysType)) {
                    Map billIdVchIdsMap = postGlMap.computeIfAbsent(billType, k -> new HashMap(8));
                    billIdVchIdsMap.computeIfAbsent(billId, k -> new HashSet(8)).add(vchId);
                    continue;
                }
                noNeedPostGlMap.computeIfAbsent(billType, k -> new HashSet(8)).add(billId);
            }
        }
        return new PairTuple(postGlMap, noNeedPostGlMap);
    }
}

