/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.event;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.EvtRelationEnum;
import kd.fi.v2.fah.constant.enums.ExtractTypeEnum;
import kd.fi.v2.fah.constant.enums.event.BizDataStatusEnum;
import kd.fi.v2.fah.models.event.eventrule.EvtReferenceFieldDto;
import kd.fi.v2.fah.models.event.eventrule.EvtRuleRelationFieldMappingDto;
import kd.fi.v2.fah.models.event.eventrule.EvtRuleRelationPluginDto;
import kd.fi.v2.fah.models.event.eventrule.FahEventTrackerConfig;

public class FahEventRuleDao {
    private static final String INSERT_T_FAH_REFERENCE_FIELD = "INSERT INTO t_fah_reference_field (fid, fname, fseq, fevtruleid, fevtlineid, fevtlinetypeid ,fbilltype, freffieldcfgid) VALUES(?, ?, ?, ?, ?, ?, ?, ?);";
    private static final String COPY_TO_FORMAL_LINE = "INSERT INTO t_fah_event_line (fentryid, fid, fseq, flinetypeid, fsourceentry, fsrcbillentryid, fsrclineruleid, famount, fcurrencyid, fbizlinestatus) select fentryid, fid, fseq, flinetypeid, fsourceentry, fsrcbillentryid, fsrclineruleid, famount, fcurrencyid, '" + BizDataStatusEnum.NO_NEED.getCode() + "' from t_fah_event_line_tmp where fid = ?";

    public static List<Object> queryMatchEventRuleIds(String billType) {
        QFilter qFilter = new QFilter("group", "=", (Object)billType);
        qFilter.and("enable", "=", (Object)"1");
        return QueryServiceHelper.queryPrimaryKeys((String)"fah_evt_gen_rule", (QFilter[])qFilter.toArray(), (String)"modifytime desc", (int)-1);
    }

    public static int[] updateEventHeadStatus(String table, String column, List<Object[]> params) {
        String updateSql = "update " + table + " set " + column + " = ? where fid = ?";
        return DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)updateSql, params);
    }

    public static DataSet getEventData(List<Object> hashCodeList) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fid,fhashcode,fhashcodecomp,fsrc_billtype,fsrc_billid,fpositiveeffestatus,freverseflag,fcustomflag from t_fah_event_header where ", new Object[0]);
        sb.appendIn("fhashcode", hashCodeList);
        sb.append(" and fstatus = ?", new Object[]{"4"});
        return DB.queryDataSet((String)FahEventRuleDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
    }

    public static Map<Long, Boolean> getEvtDataEnable(List<Long> lineTypeIdList, String tableName) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fid,fenable from ", new Object[0]);
        sb.append(tableName, new Object[0]);
        sb.append(" where ", new Object[0]);
        sb.appendIn("fid", lineTypeIdList.toArray());
        HashMap<Long, Boolean> objectHashMap = new HashMap<Long, Boolean>(lineTypeIdList.size());
        try (DataSet dataset = DB.queryDataSet((String)FahEventRuleDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);){
            while (dataset.hasNext()) {
                Row row = dataset.next();
                objectHashMap.put(row.getLong("fid"), row.getBoolean("fenable"));
            }
        }
        return objectHashMap;
    }

    public static DataSet getEventLineData(List<Object> hashCodeList) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select a.fid,a.fentryid,a.fhashcode,a.fhashcodecomp,a.ffieldnumber,a.fsrcbillentryid,a.fcustomflag from t_fah_event_line a where ", new Object[0]);
        sb.appendIn("a.fhashcode", hashCodeList);
        return DB.queryDataSet((String)FahEventRuleDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
    }

    public static DataSet queryEvtHeads(Collection<Long> evtHeadIds) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("select fid,fsrc_billtype,fsrc_billid,fruleid,fsourceentry,fsourceentryid from t_fah_event_header where ", new Object[0]);
        sb.appendIn("fid", evtHeadIds.toArray());
        sb.append("and fstatus = ?", new Object[]{"4"});
        return DB.queryDataSet((String)FahEventRuleDao.class.getName(), (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
    }

    public static void deleteEvtLineAndErr(Collection<Long> evtHeadIds) {
        SqlBuilder sb = new SqlBuilder();
        sb.append("delete from t_fah_event_line where ", new Object[0]);
        sb.appendIn("fid", evtHeadIds.toArray());
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sb);
        SqlBuilder sbErr = new SqlBuilder();
        sbErr.append("delete from t_fah_event_line_tmp where ", new Object[0]);
        sbErr.appendIn("fid", evtHeadIds.toArray());
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sbErr);
    }

    public static void copyDataToFormalLine(List<Object[]> fidList) {
        if (CollectionUtils.isEmpty(fidList)) {
            return;
        }
        DB.executeBatch((DBRoute)FAHCommonConstant.FI, (String)COPY_TO_FORMAL_LINE, fidList);
    }

    public static boolean checkEvtLineWithRelation(Long evtRuleId, Long lineTypeId) {
        if (null != evtRuleId && null != lineTypeId) {
            Map<Long, List<FahEventTrackerConfig>> result = FahEventRuleDao.queryEvtRelationInfo(evtRuleId, lineTypeId);
            return !result.isEmpty();
        }
        return false;
    }

    public static Map<Long, List<FahEventTrackerConfig>> queryEvtRelationInfo(Long evtRuleId, Long lineTypeId) {
        if (null != evtRuleId) {
            DynamicObjectCollection collection;
            QFilter qFilter = new QFilter("id", "=", (Object)evtRuleId);
            if (null != lineTypeId) {
                qFilter.and(new QFilter("evtrule_line.entry_linetype", "=", (Object)lineTypeId));
            }
            if (null != (collection = QueryServiceHelper.query((String)"fah_evt_gen_rule", (String)"id evtrule,evtrule_line.entry_linetype linetype,evtrule_line.relationentity.evtrule_rel evtrule_rel,evtrule_line.relationentity.billtype_rel billtype_rel,evtrule_line.relationentity.relationtype relationtype,evtrule_line.relationentity.relationdetails relationdetails", (QFilter[])qFilter.toArray())) && !collection.isEmpty()) {
                HashMap<Long, List<FahEventTrackerConfig>> result = new HashMap<Long, List<FahEventTrackerConfig>>(collection.size());
                for (DynamicObject row : collection) {
                    String relationDetails;
                    Long evtRule = row.getLong("evtrule");
                    Long lineType = row.getLong("linetype");
                    String billTypeRel = row.getString("billtype_rel");
                    EvtRelationEnum relationType = EvtRelationEnum.getEnum((String)row.getString("relationtype"));
                    if (null == relationType) continue;
                    FahEventTrackerConfig trackerConfig = new FahEventTrackerConfig(lineType, evtRule, billTypeRel, relationType);
                    if (EvtRelationEnum.BILL_FIELD == relationType) {
                        relationDetails = row.getString("relationdetails");
                        if (StringUtils.isNotEmpty((CharSequence)relationDetails)) {
                            EvtRuleRelationFieldMappingDto mappingDto = (EvtRuleRelationFieldMappingDto)JSON.parseObject((String)relationDetails, EvtRuleRelationFieldMappingDto.class);
                            trackerConfig.setFieldMappingDto(mappingDto);
                        }
                    } else if (EvtRelationEnum.PLUGIN == relationType && StringUtils.isNotEmpty((CharSequence)(relationDetails = row.getString("relationdetails")))) {
                        EvtRuleRelationPluginDto pluginDto = (EvtRuleRelationPluginDto)JSON.parseObject((String)relationDetails, EvtRuleRelationPluginDto.class);
                        trackerConfig.setPluginDto(pluginDto);
                    }
                    result.computeIfAbsent(lineType, v -> new ArrayList()).add(trackerConfig);
                }
                return result;
            }
        }
        return Collections.emptyMap();
    }

    public static Map<Long, List<FahEventTrackerConfig>> queryEvtRelationInfo(Long evtRuleId) {
        QFilter qFilter;
        DynamicObjectCollection collection;
        if (null != evtRuleId && null != (collection = QueryServiceHelper.query((String)"fah_evt_gen_rule", (String)"id evtrule,evtrule_line.entry_linetype linetype,evtrule_line.relationentity.evtrule_rel evtrule_rel,evtrule_line.relationentity.billtype_rel billtype_rel,evtrule_line.relationentity.relationtype relationtype,evtrule_line.relationentity.relationdetails relationdetails,evtrule_line.id lineid", (QFilter[])(qFilter = new QFilter("id", "=", (Object)evtRuleId)).toArray())) && !collection.isEmpty()) {
            HashMap<Long, List<FahEventTrackerConfig>> result = new HashMap<Long, List<FahEventTrackerConfig>>(collection.size());
            for (DynamicObject row : collection) {
                String relationDetails;
                Long evtRule = row.getLong("evtrule");
                Long lineType = row.getLong("linetype");
                String billTypeRel = row.getString("billtype_rel");
                Long lineId = row.getLong("lineid");
                EvtRelationEnum relationType = EvtRelationEnum.getEnum((String)row.getString("relationtype"));
                if (null == relationType) continue;
                FahEventTrackerConfig trackerConfig = new FahEventTrackerConfig(lineType, evtRule, billTypeRel, relationType);
                if (EvtRelationEnum.BILL_FIELD == relationType) {
                    relationDetails = row.getString("relationdetails");
                    if (StringUtils.isNotEmpty((CharSequence)relationDetails)) {
                        EvtRuleRelationFieldMappingDto mappingDto = (EvtRuleRelationFieldMappingDto)JSON.parseObject((String)relationDetails, EvtRuleRelationFieldMappingDto.class);
                        trackerConfig.setFieldMappingDto(mappingDto);
                    }
                } else if (EvtRelationEnum.PLUGIN == relationType && StringUtils.isNotEmpty((CharSequence)(relationDetails = row.getString("relationdetails")))) {
                    EvtRuleRelationPluginDto pluginDto = (EvtRuleRelationPluginDto)JSON.parseObject((String)relationDetails, EvtRuleRelationPluginDto.class);
                    trackerConfig.setPluginDto(pluginDto);
                }
                result.computeIfAbsent(lineId, v -> new ArrayList()).add(trackerConfig);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public static EvtReferenceFieldDto queryReferenceFieldById(Long id) {
        if (null != id) {
            String sqlBuilder = "select tr.fid, tr.fname, tr.fevtlineid,tr.fevtruleid, tr.fevtlinetypeid, tr.fseq, tr.fbilltype, tv.foutputdatatype ftype,tv.ftextvalue fvaluesourcedesc,tv.fexpressionvalue fcustomvalue,tv.frefbaseprop,tv.fassistprop,tv.fid fdynextfldvalsetid from t_fah_reference_field tr join t_fah_dynextfld_valset tv on tr.freffieldcfgid = tv.fid WHERE tv.fid=?";
            Object[] params = new Object[]{id};
            try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.event.FahEventRuleDao", (DBRoute)FAHCommonConstant.AI, (String)sqlBuilder, (Object[])params).orderBy(new String[]{"fevtlineid asc", "fseq asc"});){
                if (dataSet.hasNext()) {
                    EvtReferenceFieldDto evtReferenceFieldDto = FahEventRuleDao.converEvtReferenceFieldDto(dataSet.next());
                    return evtReferenceFieldDto;
                }
            }
        }
        return null;
    }

    private static EvtReferenceFieldDto converEvtReferenceFieldDto(Row row) {
        EvtReferenceFieldDto fieldDto = new EvtReferenceFieldDto();
        fieldDto.setId(row.getLong("fid").longValue());
        fieldDto.setDynExtFldValSetId(row.getLong("fdynextfldvalsetid").longValue());
        fieldDto.setFieldName(row.getString("fname"));
        fieldDto.setEvtLineTypeId(row.getLong("fevtlinetypeid").longValue());
        fieldDto.setEvtLineId(row.getLong("fevtlineid").longValue());
        fieldDto.setEvtRuleId(row.getLong("fevtruleid").longValue());
        fieldDto.setSeq(row.getInteger("fseq"));
        fieldDto.setSrcBillType(row.getString("fbilltype"));
        fieldDto.setCustomValue(row.getString("fcustomvalue"));
        return fieldDto;
    }

    public static List<EvtReferenceFieldDto> queryReferenceFieldByEvtRule(Long evtRuleId, Long lineTypeId) {
        if (null != evtRuleId) {
            Object[] params;
            StringBuilder sqlBuilder = new StringBuilder();
            sqlBuilder.append("select tr.fid, tr.fname, tr.fevtlineid,tr.fevtruleid, tr.fevtlinetypeid, tr.fseq, tr.fbilltype, tv.foutputdatatype ftype,tv.ftextvalue fvaluesourcedesc,tv.fexpressionvalue fcustomvalue,tv.frefbaseprop,tv.fassistprop,tv.fid fdynextfldvalsetid from t_fah_reference_field tr join t_fah_dynextfld_valset tv on tr.freffieldcfgid = tv.fid WHERE tr.fevtruleid=?");
            if (null != lineTypeId) {
                sqlBuilder.append("and (tr.fevtlineid =0 or tr.fevtlinetypeid =?)");
                params = new Object[]{evtRuleId, lineTypeId};
            } else {
                params = new Object[]{evtRuleId};
            }
            ArrayList<EvtReferenceFieldDto> result = new ArrayList<EvtReferenceFieldDto>(16);
            try (DataSet dataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.event.FahEventRuleDao", (DBRoute)FAHCommonConstant.AI, (String)sqlBuilder.toString(), (Object[])params).orderBy(new String[]{"fevtlineid asc", "fseq asc"});){
                for (Row row : dataSet) {
                    EvtReferenceFieldDto fieldDto = FahEventRuleDao.converEvtReferenceFieldDto(row);
                    result.add(fieldDto);
                }
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static void saveEvtReferenceFieldData(long evtRuleId, List<EvtReferenceFieldDto> dataList) {
        if (evtRuleId == 0L) {
            return;
        }
        SqlBuilder sql1 = new SqlBuilder();
        sql1.append("DELETE from t_fah_dynextfld_valset where fid in (select freffieldcfgid FROM t_fah_reference_field WHERE fevtruleid =?)", new Object[]{evtRuleId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql1);
        SqlBuilder sql2 = new SqlBuilder();
        sql2.append("DELETE FROM t_fah_reference_field WHERE fevtruleid =?", new Object[]{evtRuleId});
        DB.execute((DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql2);
        if (!dataList.isEmpty()) {
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>(dataList.size());
            ArrayList<DynamicObject> valSetDyns = new ArrayList<DynamicObject>(dataList.size());
            for (int i = 0; i < dataList.size(); ++i) {
                EvtReferenceFieldDto fieldDto = dataList.get(i);
                if (fieldDto.getId() == 0L || fieldDto.getDynExtFldValSetId() == 0L) continue;
                DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fah_dyn_extfld_val");
                obj.set("id", (Object)fieldDto.getDynExtFldValSetId());
                obj.set("branchid", (Object)fieldDto.getDynExtFldValSetId());
                obj.set("dynextfldid", (Object)0L);
                obj.set("ruleid", (Object)0L);
                obj.set("branchseq", (Object)0);
                obj.set("groupseq", (Object)0);
                obj.set("mappinggroupid", (Object)0);
                obj.set("asstactid", (Object)0L);
                obj.set("filterruledata", (Object)" ");
                obj.set("getvaluetype", (Object)String.valueOf(ExtractTypeEnum.REFERENCE_FIELD.getCode()));
                obj.set("expressionvalue", (Object)fieldDto.getCustomValue());
                valSetDyns.add(obj);
                Object[] param = new Object[]{fieldDto.getId(), fieldDto.getFieldName(), fieldDto.getSeq(), evtRuleId, fieldDto.getEvtLineId(), fieldDto.getEvtLineTypeId(), fieldDto.getSrcBillType(), fieldDto.getDynExtFldValSetId()};
                paramsList.add(param);
            }
            SaveServiceHelper.save((DynamicObject[])valSetDyns.toArray(new DynamicObject[0]));
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)INSERT_T_FAH_REFERENCE_FIELD, paramsList);
        }
    }
}

