/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.event;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.util.CollectionUtils;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dto.FahTaskNoEvtBillInfo;

public class FahNoEvtBillsDao {
    private static final String saveNoEvtSql = "INSERT INTO t_fah_task_noevt_bills (fid,frequestid,fbilltype,fsrcbillid,fsrcbillentryid,fsrcbillno,fsrcbillentry,fdispatchid,fdispatchversion,fmsg) VALUES (?,?,?,?,?, ?,?,?,?,?)";

    public static void saveNoEvtBillInfoList(List<FahTaskNoEvtBillInfo> noEvtBillInfoList) {
        if (CollectionUtils.isEmpty(noEvtBillInfoList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(noEvtBillInfoList.size());
        long[] genLongIds = DB.genLongIds((String)"t_fah_task_noevt_bills", (int)noEvtBillInfoList.size());
        int index = 0;
        for (FahTaskNoEvtBillInfo noEvtBillInfo : noEvtBillInfoList) {
            Object[] params = new Object[]{genLongIds[index++], noEvtBillInfo.getRequestId(), noEvtBillInfo.getBillType(), noEvtBillInfo.getSrcBillId(), noEvtBillInfo.getSrcBillEntryId(), noEvtBillInfo.getSrcBillNo(), noEvtBillInfo.getSrcBillEntry(), noEvtBillInfo.getDispatchId(), noEvtBillInfo.getDispatchVersion(), noEvtBillInfo.getMsg()};
            paramsList.add(params);
        }
        try (TXHandle h = TX.requiresNew((String)"saveNoEvtBillInfoList");){
            try {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)saveNoEvtSql, paramsList);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static int queryNoGenEvtCnt(long requestId) {
        SqlBuilder queryNoGenEvtCnt = new SqlBuilder();
        queryNoGenEvtCnt.append("select count(1) cnt from t_fah_task_noevt_bills ", new Object[0]);
        queryNoGenEvtCnt.append(" where frequestid = ? ", new Object[]{requestId});
        int noGenEvtCnt = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"queryNoGenEvtCnt", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)queryNoGenEvtCnt);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                noGenEvtCnt = row.getInteger("cnt");
            }
        }
        return noGenEvtCnt;
    }

    public static FahTaskNoEvtBillInfo queryNoEvtBillInfo(long pk) {
        SqlBuilder queryNoEvtBillInfo = new SqlBuilder();
        queryNoEvtBillInfo.append("select fid,frequestid,fbilltype,fsrcbillid,fsrcbillentryid,fsrcbillno,fsrcbillentry,fdispatchid,fdispatchversion,fmsg from t_fah_task_noevt_bills ", new Object[0]);
        queryNoEvtBillInfo.append(" where fid = ? ", new Object[]{pk});
        try (DataSet dataSet = DB.queryDataSet((String)"queryNoGenEvtCnt", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)queryNoEvtBillInfo);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                FahTaskNoEvtBillInfo noEvtBillInfo = new FahTaskNoEvtBillInfo();
                noEvtBillInfo.setId(row.getLong("fid"));
                noEvtBillInfo.setRequestId(row.getLong("frequestid"));
                String billType = row.getString("fbilltype");
                Long billId = row.getLong("fsrcbillid");
                String billNo = row.getString("fsrcbillno");
                String srcBillEntry = row.getString("fsrcbillentry");
                Long srcBillEntryId = row.getLong("fsrcbillentryid");
                Long dispatchId = row.getLong("fdispatchid");
                Integer dispatchVersion = row.getInteger("fdispatchversion");
                String msg = row.getString("fmsg");
                noEvtBillInfo.setBillInfo(billType, billId, billNo, srcBillEntry, srcBillEntryId);
                noEvtBillInfo.setDispatchIdAndVersion(dispatchId, dispatchVersion.intValue());
                noEvtBillInfo.setMsg(msg);
                FahTaskNoEvtBillInfo fahTaskNoEvtBillInfo = noEvtBillInfo;
                return fahTaskNoEvtBillInfo;
            }
        }
        return null;
    }
}

