/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.task;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.FourTuple;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.fi.bd.util.filter.QFilterBuilder;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

@Deprecated
public class FahBuildvchReportDao {
    private static final Log logger = LogFactory.getLog(FahBuildvchReportDao.class);

    public static boolean updateExceptionInfo(Long requestId, String message, String errorStackMessage) {
        boolean result = false;
        String sql = "update t_fah_request_task set fstatus = ?,fmsg_tag = ?,fmsg = ?, fexcuteendtime = ? where fid = ?";
        Object[] param = new Object[]{TaskStatusEnum.FAILURE.getStringValue(), errorStackMessage, message, new Date(), requestId};
        try (TXHandle h = TX.requiresNew();){
            try {
                result = DB.execute((DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])param);
            }
            catch (Exception e) {
                logger.error("--FAH---FahBuildvchReportDao:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        return result;
    }

    public static Map<Long, FourTuple<Long, Long, String, String>> queryEventFromSrcIds(List<Long> allErrorEventIds) {
        HashMap<Long, FourTuple<Long, Long, String, String>> result = new HashMap<Long, FourTuple<Long, Long, String, String>>(allErrorEventIds.size());
        if (allErrorEventIds.isEmpty()) {
            return result;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fsrc_billid,fid,fsrc_billno,fdispatchid,fsrc_billtype from t_fah_event_header where ", new Object[0]).appendIn("fid", allErrorEventIds.toArray()).append(" and fstatus = ?", new Object[]{"4"});
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.task.FahBuildvchReportDao", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            for (Row row : queryDataSet) {
                Long fsrcBillid = row.getLong("fsrc_billid");
                Long fid = row.getLong("fid");
                Long fdispatchid = row.getLong("fdispatchid");
                String fsrcBillno = row.getString("fsrc_billno");
                String fsrcBilltype = row.getString("fsrc_billtype");
                result.put(fid, (FourTuple<Long, Long, String, String>)new FourTuple((Object)fsrcBillid, (Object)fdispatchid, (Object)fsrcBillno, (Object)fsrcBilltype));
            }
        }
        return result;
    }

    public static Map<Long, FourTuple<Long, Long, String, String>> queryXlaFromSrcIds(List<Long> allErrorXlaIds) {
        HashMap<Long, FourTuple<Long, Long, String, String>> result = new HashMap<Long, FourTuple<Long, Long, String, String>>(allErrorXlaIds.size());
        if (allErrorXlaIds.isEmpty()) {
            return result;
        }
        String ids_str = QFilterBuilder.buildSQLParamHolder((int)allErrorXlaIds.size());
        String sql = "select a.fsrc_billid as billid,a.fid as fid,b.fdispatchid as dispatchid,b.fsrc_billno as billno,b.fsrc_billtype as billtype from t_fah_ae_headers a left join t_fah_event_header b on a.fsrceventid = b.fid where a.fid in " + ids_str + " and a.fstatus = '4' and b.fstatus = '4'";
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.v2.fah.dao.task.FahBuildvchReportDao", (DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])allErrorXlaIds.toArray());){
            for (Row row : queryDataSet) {
                Long fsrcBillid = row.getLong("billid");
                Long dispatchid = row.getLong("dispatchid");
                String billno = row.getString("billno");
                String billtype = row.getString("billtype");
                Long fid = row.getLong("fid");
                result.put(fid, (FourTuple<Long, Long, String, String>)new FourTuple((Object)fsrcBillid, (Object)dispatchid, (Object)billno, (Object)billtype));
            }
        }
        return result;
    }

    public static Map<Long, FourTuple<Long, Long, String, String>> queryVoucherFromSrcIds(List<Long> allErrorVoucherIds) {
        return FahBuildvchReportDao.queryXlaFromSrcIds(allErrorVoucherIds);
    }

    public static void insertErrorInfo(List<Object[]> params) {
        if (params.isEmpty()) {
            return;
        }
        String sql = "insert into t_fah_task_fail_bills(fid, frequestid, fbilltype, fsrcbillid, fmsg, fmsg_code, fdispatchid, fsrcbillno) values (?,?,?,?,?,?,?,?)";
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sql, params);
            }
            catch (Exception e) {
                logger.error("--FAH---FahBuildvchReportDao:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }
}

