/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.dao.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.bd.model.common.PairTuple;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.dto.AbstractBaseDTOCollection;
import kd.fi.v2.fah.dto.RequestTaskBillDto;
import kd.fi.v2.fah.log.FahBgTaskLogger;
import kd.fi.v2.fah.task.status.TaskStatusEnum;

public class FahRequestTaskDaoImpl {
    public static final int Insert_Batch_Size = 3000;
    private static final DynamicObject dummy_request_task_object = BusinessDataServiceHelper.newDynamicObject((String)"fah_request_task");
    static final String sql_t_fah_request_task = "insert into t_fah_request_task(fid, fTaskNo, fTaskType, fQueryStartDate, fQueryEndDate, fRequestBillCnt, fCreateTime, fStatus, fCreatorid) values(?,?,?,?,?,?,?,?,?)";
    static final String sql_t_fah_request_task_bill = "insert into t_fah_request_task_bill (fpkid,fid,fbasedataid) values(?,?,?)";
    static final String sql_t_fah_request_task_org = "insert into t_fah_request_task_org  (fpkid,fid,fbasedataid) values(?,?,?)";
    static final String sql_t_fah_task_batch = "insert into t_fah_task_batch(fid,frequestid,fseqno,fbilltype,freccnt,fstatus) values(?,?,?,?,?,?)";
    static final String sql_t_fah_task_batch_en = "insert into t_fah_task_batch_en(fid,fentryid,fseqno,fsrcbillid) values(?,?,?,?)";
    static final String sql_t_fah_task_fail_bills = "insert into t_fah_task_fail_bills(fid,fRequestId,fBillType,fSrcBillId,fDispatchId,fDispatchVersion,fMsg,fMsg_Code) values(?,?,?,?,?,?,?,?)";

    protected static String getRequestTaskCodeRuleNumber() {
        return CodeRuleServiceHelper.getNumber((CodeRuleInfo)CodeRuleServiceHelper.getCodeRule((String)"fah_request_task", (DynamicObject)dummy_request_task_object, null), (DynamicObject)dummy_request_task_object);
    }

    public static List<Object[]> buildMulBasePropSqlParams(String tableName, Object refOwnerId, Collection<?> baseDataIds) {
        if (null == baseDataIds || baseDataIds.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        int idCnt = baseDataIds.size();
        long[] ids = DB.genLongIds((String)tableName, (int)idCnt);
        ArrayList<Object[]> resultSqlParams = new ArrayList<Object[]>(idCnt);
        int index = 0;
        for (Object srcBaseId : baseDataIds) {
            resultSqlParams.add(new Object[]{ids[index++], refOwnerId, srcBaseId});
        }
        return resultSqlParams;
    }

    public static long insertProcessBillRequestTask(Long requestId, String taskType, int billCnt, Collection<String> srcBillTypes, Collection<Long> orgIds, Date startDate, Date endDate) {
        if (requestId == null) {
            requestId = DB.genLongId((String)"t_fah_request_task");
        }
        List<Object[]> billTypeSqlParams = FahRequestTaskDaoImpl.buildMulBasePropSqlParams("t_fah_request_task_bill", requestId, srcBillTypes);
        List<Object[]> orgIdSqlParams = FahRequestTaskDaoImpl.buildMulBasePropSqlParams("t_fah_request_task_org", requestId, orgIds);
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)FAHCommonConstant.AI, (String)sql_t_fah_request_task, (Object[])new Object[]{requestId, FahRequestTaskDaoImpl.getRequestTaskCodeRuleNumber(), taskType, startDate, endDate, billCnt, new Date(), Character.valueOf('0'), UserServiceHelper.getCurrentUserId()});
            if (!billTypeSqlParams.isEmpty()) {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sql_t_fah_request_task_bill, billTypeSqlParams);
            }
            if (!orgIdSqlParams.isEmpty()) {
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sql_t_fah_request_task_org, orgIdSqlParams);
            }
        }
        return requestId;
    }

    public static long insertProcessBillRequestTask(Long requestId, String taskType, int billCnt) {
        return FahRequestTaskDaoImpl.insertProcessBillRequestTask(requestId, taskType, billCnt, null, null, null, null);
    }

    public static boolean insertProcessBillRequestTaskBatch(long requestId, long taskBatchId, int taskBatchSeq, String billType, Collection<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return false;
        }
        long[] taskBatchEnIds = DB.genLongIds((String)"t_fah_task_batch_en", (int)billIds.size());
        ArrayList<Object[]> taskBatchEnParamsList = new ArrayList<Object[]>(billIds.size());
        int index = 0;
        for (Long billId : billIds) {
            taskBatchEnParamsList.add(new Object[]{taskBatchId, taskBatchEnIds[index], ++index, billId});
        }
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)FAHCommonConstant.AI, (String)sql_t_fah_task_batch, (Object[])new Object[]{taskBatchId, requestId, taskBatchSeq, billType, billIds.size(), Character.valueOf('0')});
            DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sql_t_fah_task_batch_en, taskBatchEnParamsList);
        }
        return true;
    }

    public static int doDTOCollectionInsert(AbstractBaseDTOCollection dtoCollection) {
        Iterator batchIterator = dtoCollection.getSqlParams(3000);
        String sqlStatement = dtoCollection.buildSqlStatement();
        int totalCnt = 0;
        while (batchIterator.hasNext()) {
            List buf = (List)batchIterator.next();
            if (buf == null) continue;
            try (TXHandle h = TX.required();){
                DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sqlStatement, (List)buf);
            }
            totalCnt += buf.size();
        }
        return totalCnt;
    }

    public static void updateFahRequestTaskStatus(Long requestId, String taskStatus) {
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)FAHCommonConstant.AI, (String)"update t_fah_request_task set fstatus = ? where fid = ? ", (Object[])new Object[]{taskStatus, requestId});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static int doInsertTable(String sql, Iterator<List<Object[]>> params) {
        int totalInsertCnt = 0;
        while (params != null && params.hasNext()) {
            List<Object[]> paramBufList = params.next();
            if (paramBufList == null || paramBufList.isEmpty()) continue;
            int[] result = DB.executeBatch((DBRoute)FAHCommonConstant.AI, (String)sql, paramBufList);
            totalInsertCnt += result.length;
        }
        return totalInsertCnt;
    }

    public static Long createNewRequest(Long taskId, Collection<String> srcBillTypes, Collection<Long> orgIds, String operation, int billCnt, Date startDate, Date endDate) {
        Object[] param;
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"fah_request_task");
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)obj.getDataEntityType().getName(), (DynamicObject)obj, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)obj);
        obj.set("id", (Object)taskId);
        obj.set("taskno", (Object)number);
        obj.set("status", (Object)TaskStatusEnum.NEW.getStringValue());
        obj.set("buildbizdimgrptaskstatus", (Object)TaskStatusEnum.NEW.getStringValue());
        obj.set("requestbillcnt", (Object)billCnt);
        obj.set("tasktype", (Object)operation);
        obj.set("queryStartDate", (Object)startDate);
        obj.set("queryEndDate", (Object)endDate);
        obj.set("createtime", (Object)new Date());
        obj.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        Object pkValue = ((DynamicObject)result[0]).getPkValue();
        SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
        if (null != srcBillTypes && !srcBillTypes.isEmpty()) {
            String sql = sql_t_fah_request_task_bill;
            Long[] sequences = (Long[])sReader.getSequences((Object[])new Long[srcBillTypes.size()], "t_fah_request_task_bill", srcBillTypes.size());
            ArrayList<Object[]> params = new ArrayList<Object[]>(srcBillTypes.size());
            int index1 = 0;
            for (String billType : srcBillTypes) {
                param = new Object[]{sequences[index1++], pkValue, billType};
                params.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"ai"), (String)sql, params);
        }
        if (null != orgIds && !orgIds.isEmpty()) {
            String sql2 = "insert into t_fah_request_task_org (fpkid,fid,fbasedataid) values(?,?,?)";
            Long[] sequences2 = (Long[])sReader.getSequences((Object[])new Long[orgIds.size()], "t_fah_request_task_org", orgIds.size());
            ArrayList<Object[]> params2 = new ArrayList<Object[]>(orgIds.size());
            int index2 = 0;
            for (Long orgId : orgIds) {
                param = new Object[]{sequences2[index2++], pkValue, orgId};
                params2.add(param);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"ai"), (String)sql2, params2);
        }
        return (Long)pkValue;
    }

    public static void updateFahRequestTask(Long taskId, String message, boolean isBizDataErr) {
        String msgWithPrefix = FahBgTaskLogger.appendPrefixInfo((String)message);
        String statusField = isBizDataErr ? "fbuildbizdimgrptaskstatus" : "fstatus";
        String updateSql = String.format("update t_fah_request_task set ffailbillcnt=frequestbillcnt, %s = ?, fmsg = ?, fmsg_tag = ?, fexcuteendtime = ? where fid = ? ", statusField);
        try (TXHandle h = TX.requiresNew();){
            try {
                String shortMsg = msgWithPrefix.length() > 255 ? msgWithPrefix.substring(0, 255) : msgWithPrefix;
                DB.execute((DBRoute)DBRoute.of((String)"ai"), (String)updateSql, (Object[])new Object[]{TaskStatusEnum.FAILURE.getStringValue(), shortMsg, msgWithPrefix, new Date(), taskId});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void updateFahRequestTaskStatusToRunning(Long requestId) {
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)FAHCommonConstant.AI, (String)"update t_fah_request_task set fstatus = ?, fexcutestarttime = ? where fid = ? ", (Object[])new Object[]{TaskStatusEnum.PROCESSING.getStringValue(), new Date(), requestId});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void updateFahRequestTaskStatusToBizData(Long requestId, TaskStatusEnum taskStatusEnum) {
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)FAHCommonConstant.AI, (String)"update t_fah_request_task set fbuildbizdimgrptaskstatus = ? where fid = ? ", (Object[])new Object[]{taskStatusEnum.getStringValue(), requestId});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void updateFahRequestFinal(long requestId, int totalBillCnt, int totalFailedBillCnt, int totalEvtBillCnt, int noGenEvtCnt) {
        String taskStatus = TaskStatusEnum.COMPLETED.getStringValue();
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)FAHCommonConstant.AI, (String)"update t_fah_request_task set fstatus = ?,frequestbillcnt = ?,ffailbillcnt = ?,fprocessevtcnt = ?,fnogenevtcnt = ?,fexcuteendtime = ? where fid = ?", (Object[])new Object[]{taskStatus, totalBillCnt, totalFailedBillCnt, totalEvtBillCnt, noGenEvtCnt, new Date(), requestId});
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static Map<String, List<Long>> queryBillInfoByRequestId(Long requestId) {
        String sql = "select tm.fBillType as billtype, te.fSrcBillId as billid from t_fah_task_batch tm join t_fah_task_batch_en te on tm.fid = te.fid where tm.fRequestId = ? order by tm.fSeqNo, te.fSeqNo";
        Object[] param = new Object[]{requestId};
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>(2);
        try (DataSet dataSet = DB.queryDataSet((String)"FahRequestTaskDaoImpl.queryBillInfoByRequestId", (DBRoute)FAHCommonConstant.AI, (String)sql, (Object[])param);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                result.computeIfAbsent(row.getString("billtype"), k -> new ArrayList(16)).add(row.getLong("billid"));
            }
        }
        return result;
    }

    public static List<RequestTaskBillDto> getBillListDisplayInfo(Map<String, PairTuple<String, String>> regInfo, Map<String, List<Long>> billInfo) {
        ArrayList<RequestTaskBillDto> result = new ArrayList<RequestTaskBillDto>(16);
        for (Map.Entry<String, List<Long>> entry : billInfo.entrySet()) {
            DynamicObjectCollection billdata;
            String billType = entry.getKey();
            List<Long> billIds = entry.getValue();
            PairTuple<String, String> pair = regInfo.get(billType);
            String orgField = (String)pair.getKey();
            String dateField = (String)pair.getValue();
            String billNo = DapBuildVoucherCommonUtil.getBillNoFormBill((String)billType);
            if (!FahRequestTaskDaoImpl.isExtData(billType)) {
                billdata = QueryServiceHelper.query((String)billType, (String)("id," + billNo + ",billstatus," + orgField + "," + dateField), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
                for (DynamicObject bill : billdata) {
                    result.add(new RequestTaskBillDto(bill.getLong("id"), bill.getLong(orgField), billType, bill.getString("billstatus"), bill.getString("billno"), bill.getDate(dateField)));
                }
                continue;
            }
            billdata = QueryServiceHelper.query((String)billType, (String)("id,number," + orgField + "," + dateField), (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
            for (DynamicObject bill : billdata) {
                result.add(new RequestTaskBillDto(bill.getLong("id"), bill.getLong(orgField), billType, null, bill.getString("number"), bill.getDate(dateField)));
            }
        }
        return result;
    }

    public static boolean isExtData(String billType) {
        return billType.startsWith("fah_e_");
    }

    public static List<Long> queryTaskByBillNo(String billNo) {
        LinkedList<Long> result = new LinkedList<Long>();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t1.fSrc_BillId as billId from t_fah_event_header t1 where t1.fSrc_BillNo like ?", new Object[]{"%" + billNo + "%"});
        sql.append(" union ", new Object[0]);
        sql.append("select t2.fSrcBillId as billId from t_fah_task_skip_bills t2 where t2.fSrcBillNo like ?", new Object[]{"%" + billNo + "%"});
        sql.append(" union ", new Object[0]);
        sql.append("select t3.fSrcBillId as billId from t_fah_task_fail_bills t3 where t3.fSrcBillNo like ?", new Object[]{"%" + billNo + "%"});
        LinkedList<Long> billIds = new LinkedList<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)"queryTaskByBillNo", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                billIds.add(row.getLong("billId"));
            }
        }
        if (!billIds.isEmpty()) {
            SqlBuilder sql2 = new SqlBuilder();
            sql2.appendIn("select distinct(tm.fRequestId) from t_fah_task_batch tm join t_fah_task_batch_en te on tm.fid = te.fid where te.fSrcBillId", billIds.toArray());
            try (DataSet dataSet = DB.queryDataSet((String)"queryTaskByBillNo2", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql2);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    result.add(row.getLong("fRequestId"));
                }
            }
        }
        return result;
    }

    public static Map<String, Set<Long>> queryFailBillTypeAndBillIdsMap(long requestId) {
        HashMap<String, Set<Long>> failMap = new HashMap<String, Set<Long>>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fbilltype,fsrcbillid from t_fah_task_fail_bills where", new Object[0]);
        sqlBuilder.append("frequestid = ?", new Object[]{requestId});
        try (DataSet dataSet = DB.queryDataSet((String)"FahRequestTaskDaoImpl.queryFailBillTypeAndBillIdsMap", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String billType = row.getString("fbilltype");
                Long billId = row.getLong("fsrcbillid");
                failMap.computeIfAbsent(billType, k -> new HashSet(8)).add(billId);
            }
        }
        return failMap;
    }

    public static Map<String, Set<Long>> queryNeedWriteBackNoEvtBillTypeAndBillIdsMap(long requestId) {
        HashMap<String, Set<Long>> noEvtMap = new HashMap<String, Set<Long>>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select distinct a.fbilltype,a.fsrcbillid from t_fah_task_noevt_bills a where", new Object[0]);
        sqlBuilder.append("a.frequestid = ?", new Object[]{requestId});
        sqlBuilder.append("and not exists (select 1 from t_fah_task_fail_bills b where", new Object[0]);
        sqlBuilder.append("b.frequestid = ?", new Object[]{requestId});
        sqlBuilder.append(" and a.fbilltype =b.fbilltype and a.fsrcbillid =b.fsrcbillid )", new Object[0]);
        sqlBuilder.append("and not exists (select 1 from t_fah_evt_tracker c where", new Object[0]);
        sqlBuilder.append("c.frequestid = ?", new Object[]{requestId});
        sqlBuilder.append(" and c.fstatus = ?", new Object[]{"4"});
        sqlBuilder.append(" and a.fbilltype =c.fsrc_billtype  and a.fsrcbillid =c.fsrc_billid )", new Object[0]);
        try (DataSet dataSet = DB.queryDataSet((String)"FahRequestTaskDaoImpl.queryFailBillTypeAndBillIdsMap", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sqlBuilder);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String billType = row.getString("fbilltype");
                Long billId = row.getLong("fsrcbillid");
                noEvtMap.computeIfAbsent(billType, k -> new HashSet(8)).add(billId);
            }
        }
        return noEvtMap;
    }
}

